/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file CoreBlock_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SCOREMAT_COREBLOCK_BASE_HPP
#define OBJECTS_SCOREMAT_COREBLOCK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlockProperty;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SCOREMAT_EXPORT CCoreBlock_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCoreBlock_Base(void);
    // destructor
    virtual ~CCoreBlock_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TStart;
    typedef int TStop;
    typedef int TMinstart;
    typedef int TMaxstop;
    typedef list< CRef< CBlockProperty > > TProperty;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_start,
        e_stop,
        e_minstart,
        e_maxstop,
        e_property
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// begin of block on query
    /// mandatory
    /// typedef int TStart
    ///  Check whether the Start data member has been assigned a value.
    bool IsSetStart(void) const;
    /// Check whether it is safe or not to call GetStart method.
    bool CanGetStart(void) const;
    void ResetStart(void);
    TStart GetStart(void) const;
    void SetStart(TStart value);
    TStart& SetStart(void);

    /// end of block on query
    /// mandatory
    /// typedef int TStop
    ///  Check whether the Stop data member has been assigned a value.
    bool IsSetStop(void) const;
    /// Check whether it is safe or not to call GetStop method.
    bool CanGetStop(void) const;
    void ResetStop(void);
    TStop GetStop(void) const;
    void SetStop(TStop value);
    TStop& SetStop(void);

    /// optional N-terminal extension
    /// optional
    /// typedef int TMinstart
    ///  Check whether the Minstart data member has been assigned a value.
    bool IsSetMinstart(void) const;
    /// Check whether it is safe or not to call GetMinstart method.
    bool CanGetMinstart(void) const;
    void ResetMinstart(void);
    TMinstart GetMinstart(void) const;
    void SetMinstart(TMinstart value);
    TMinstart& SetMinstart(void);

    /// optional C-terminal extension
    /// optional
    /// typedef int TMaxstop
    ///  Check whether the Maxstop data member has been assigned a value.
    bool IsSetMaxstop(void) const;
    /// Check whether it is safe or not to call GetMaxstop method.
    bool CanGetMaxstop(void) const;
    void ResetMaxstop(void);
    TMaxstop GetMaxstop(void) const;
    void SetMaxstop(TMaxstop value);
    TMaxstop& SetMaxstop(void);

    /// optional
    /// typedef list< CRef< CBlockProperty > > TProperty
    ///  Check whether the Property data member has been assigned a value.
    bool IsSetProperty(void) const;
    /// Check whether it is safe or not to call GetProperty method.
    bool CanGetProperty(void) const;
    void ResetProperty(void);
    const TProperty& GetProperty(void) const;
    TProperty& SetProperty(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCoreBlock_Base(const CCoreBlock_Base&);
    CCoreBlock_Base& operator=(const CCoreBlock_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Start;
    int m_Stop;
    int m_Minstart;
    int m_Maxstop;
    list< CRef< CBlockProperty > > m_Property;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCoreBlock_Base::IsSetStart(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCoreBlock_Base::CanGetStart(void) const
{
    return IsSetStart();
}

inline
void CCoreBlock_Base::ResetStart(void)
{
    m_Start = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCoreBlock_Base::TStart CCoreBlock_Base::GetStart(void) const
{
    if (!CanGetStart()) {
        ThrowUnassigned(0);
    }
    return m_Start;
}

inline
void CCoreBlock_Base::SetStart(CCoreBlock_Base::TStart value)
{
    m_Start = value;
    m_set_State[0] |= 0x3;
}

inline
CCoreBlock_Base::TStart& CCoreBlock_Base::SetStart(void)
{
#ifdef _DEBUG
    if (!IsSetStart()) {
        memset(&m_Start,UnassignedByte(),sizeof(m_Start));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Start;
}

inline
bool CCoreBlock_Base::IsSetStop(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCoreBlock_Base::CanGetStop(void) const
{
    return IsSetStop();
}

inline
void CCoreBlock_Base::ResetStop(void)
{
    m_Stop = 0;
    m_set_State[0] &= ~0xc;
}

inline
CCoreBlock_Base::TStop CCoreBlock_Base::GetStop(void) const
{
    if (!CanGetStop()) {
        ThrowUnassigned(1);
    }
    return m_Stop;
}

inline
void CCoreBlock_Base::SetStop(CCoreBlock_Base::TStop value)
{
    m_Stop = value;
    m_set_State[0] |= 0xc;
}

inline
CCoreBlock_Base::TStop& CCoreBlock_Base::SetStop(void)
{
#ifdef _DEBUG
    if (!IsSetStop()) {
        memset(&m_Stop,UnassignedByte(),sizeof(m_Stop));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Stop;
}

inline
bool CCoreBlock_Base::IsSetMinstart(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCoreBlock_Base::CanGetMinstart(void) const
{
    return IsSetMinstart();
}

inline
void CCoreBlock_Base::ResetMinstart(void)
{
    m_Minstart = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCoreBlock_Base::TMinstart CCoreBlock_Base::GetMinstart(void) const
{
    if (!CanGetMinstart()) {
        ThrowUnassigned(2);
    }
    return m_Minstart;
}

inline
void CCoreBlock_Base::SetMinstart(CCoreBlock_Base::TMinstart value)
{
    m_Minstart = value;
    m_set_State[0] |= 0x30;
}

inline
CCoreBlock_Base::TMinstart& CCoreBlock_Base::SetMinstart(void)
{
#ifdef _DEBUG
    if (!IsSetMinstart()) {
        memset(&m_Minstart,UnassignedByte(),sizeof(m_Minstart));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Minstart;
}

inline
bool CCoreBlock_Base::IsSetMaxstop(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCoreBlock_Base::CanGetMaxstop(void) const
{
    return IsSetMaxstop();
}

inline
void CCoreBlock_Base::ResetMaxstop(void)
{
    m_Maxstop = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CCoreBlock_Base::TMaxstop CCoreBlock_Base::GetMaxstop(void) const
{
    if (!CanGetMaxstop()) {
        ThrowUnassigned(3);
    }
    return m_Maxstop;
}

inline
void CCoreBlock_Base::SetMaxstop(CCoreBlock_Base::TMaxstop value)
{
    m_Maxstop = value;
    m_set_State[0] |= 0xc0;
}

inline
CCoreBlock_Base::TMaxstop& CCoreBlock_Base::SetMaxstop(void)
{
#ifdef _DEBUG
    if (!IsSetMaxstop()) {
        memset(&m_Maxstop,UnassignedByte(),sizeof(m_Maxstop));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Maxstop;
}

inline
bool CCoreBlock_Base::IsSetProperty(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCoreBlock_Base::CanGetProperty(void) const
{
    return true;
}

inline
const CCoreBlock_Base::TProperty& CCoreBlock_Base::GetProperty(void) const
{
    return m_Property;
}

inline
CCoreBlock_Base::TProperty& CCoreBlock_Base::SetProperty(void)
{
    m_set_State[0] |= 0x100;
    return m_Property;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_COREBLOCK_BASE_HPP
