/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_ID_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_ID_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// ID and Version Description Information
class NCBI_PCSUBSTANCE_EXPORT CPC_ID_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_ID_Base(void);
    // destructor
    virtual ~CPC_ID_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TId;
    typedef int TVersion;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_version
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Unique "Global" ID
    ///   Note: Must be greater than "0" or, if invalid, "0"
    /// mandatory
    /// typedef int TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    TId GetId(void) const;
    void SetId(TId value);
    TId& SetId(void);

    /// Incremented when Depositor updates record
    ///   Note: For Internal Use (only?)
    /// mandatory
    /// typedef int TVersion
    ///  Check whether the Version data member has been assigned a value.
    bool IsSetVersion(void) const;
    /// Check whether it is safe or not to call GetVersion method.
    bool CanGetVersion(void) const;
    void ResetVersion(void);
    TVersion GetVersion(void) const;
    void SetVersion(TVersion value);
    TVersion& SetVersion(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_ID_Base(const CPC_ID_Base&);
    CPC_ID_Base& operator=(const CPC_ID_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Id;
    int m_Version;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_ID_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_ID_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CPC_ID_Base::ResetId(void)
{
    m_Id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_ID_Base::TId CPC_ID_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CPC_ID_Base::SetId(CPC_ID_Base::TId value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_ID_Base::TId& CPC_ID_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        memset(&m_Id,UnassignedByte(),sizeof(m_Id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CPC_ID_Base::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_ID_Base::CanGetVersion(void) const
{
    return IsSetVersion();
}

inline
void CPC_ID_Base::ResetVersion(void)
{
    m_Version = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_ID_Base::TVersion CPC_ID_Base::GetVersion(void) const
{
    if (!CanGetVersion()) {
        ThrowUnassigned(1);
    }
    return m_Version;
}

inline
void CPC_ID_Base::SetVersion(CPC_ID_Base::TVersion value)
{
    m_Version = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_ID_Base::TVersion& CPC_ID_Base::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        memset(&m_Version,UnassignedByte(),sizeof(m_Version));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Version;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_ID_BASE_HPP
