/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AtomString_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_ATOMSTRING_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_ATOMSTRING_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Specification of an Association between an Atom Identifier and a String Value
class NCBI_PCSUBSTANCE_EXPORT CPC_AtomString_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AtomString_Base(void);
    // destructor
    virtual ~CPC_AtomString_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TAid;
    typedef string TValue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_aid,
        e_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Atom Identifier for the Value
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TAid
    ///  Check whether the Aid data member has been assigned a value.
    bool IsSetAid(void) const;
    /// Check whether it is safe or not to call GetAid method.
    bool CanGetAid(void) const;
    void ResetAid(void);
    TAid GetAid(void) const;
    void SetAid(TAid value);
    TAid& SetAid(void);

    /// Value Associated to the ID
    /// mandatory
    /// typedef string TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(const TValue& value);
    void SetValue(TValue&& value);
    TValue& SetValue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AtomString_Base(const CPC_AtomString_Base&);
    CPC_AtomString_Base& operator=(const CPC_AtomString_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Aid;
    string m_Value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_AtomString_Base::IsSetAid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_AtomString_Base::CanGetAid(void) const
{
    return IsSetAid();
}

inline
void CPC_AtomString_Base::ResetAid(void)
{
    m_Aid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_AtomString_Base::TAid CPC_AtomString_Base::GetAid(void) const
{
    if (!CanGetAid()) {
        ThrowUnassigned(0);
    }
    return m_Aid;
}

inline
void CPC_AtomString_Base::SetAid(CPC_AtomString_Base::TAid value)
{
    m_Aid = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_AtomString_Base::TAid& CPC_AtomString_Base::SetAid(void)
{
#ifdef _DEBUG
    if (!IsSetAid()) {
        memset(&m_Aid,UnassignedByte(),sizeof(m_Aid));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Aid;
}

inline
bool CPC_AtomString_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_AtomString_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
const CPC_AtomString_Base::TValue& CPC_AtomString_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
void CPC_AtomString_Base::SetValue(const CPC_AtomString_Base::TValue& value)
{
    m_Value = value;
    m_set_State[0] |= 0xc;
}

inline
void CPC_AtomString_Base::SetValue(CPC_AtomString_Base::TValue&& value)
{
    m_Value = std::forward<CPC_AtomString_Base::TValue>(value);
    m_set_State[0] |= 0xc;
}

inline
CPC_AtomString_Base::TValue& CPC_AtomString_Base::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        m_Value = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_ATOMSTRING_BASE_HPP
