/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AssayTargetInfo_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY2_PC_ASSAYTARGETINFO_BASE_HPP
#define OBJECTS_PCASSAY2_PC_ASSAYTARGETINFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBioSource;

#ifndef BEGIN_pcassay2_SCOPE
#  define BEGIN_pcassay2_SCOPE BEGIN_SCOPE(pcassay2)
#  define END_pcassay2_SCOPE END_SCOPE(pcassay2)
#endif
BEGIN_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Molecular target information provides by organization describes the functionality of the target,
/// facilitates the linking between PubChem bioassays, and the linking between target molecule to other NCBI resources
class CPC_AssayTargetInfo_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AssayTargetInfo_Base(void);
    // destructor
    virtual ~CPC_AssayTargetInfo_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// database and identifier of the target molecule
    class C_Mol_id : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Mol_id(void);
        // destructor
        ~C_Mol_id(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,           ///< No variant selected
            e_Gene_id,               ///< target is a NCBI Gene ID
            e_Protein_accession,     ///< target is a NCBI Protein Accession
            e_Nucleotide_accession,  ///< target is a NCBI Nucleotide Accession
            e_Other,                 ///< target is beyond supported type (format = TYPE::RESOURCE::IDENTIFIER)
            e_Tax_id                 ///< target is a NCBI Taxonomy ID
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 6 ///< == e_Tax_id+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef int TGene_id;
        typedef string TProtein_accession;
        typedef string TNucleotide_accession;
        typedef string TOther;
        typedef int TTax_id;
    
        // getters
        // setters
    
        // typedef int TGene_id
        bool IsGene_id(void) const;
        TGene_id GetGene_id(void) const;
        TGene_id& SetGene_id(void);
        void SetGene_id(TGene_id value);
    
        // typedef string TProtein_accession
        bool IsProtein_accession(void) const;
        const TProtein_accession& GetProtein_accession(void) const;
        TProtein_accession& SetProtein_accession(void);
        void SetProtein_accession(const TProtein_accession& value);
    
        // typedef string TNucleotide_accession
        bool IsNucleotide_accession(void) const;
        const TNucleotide_accession& GetNucleotide_accession(void) const;
        TNucleotide_accession& SetNucleotide_accession(void);
        void SetNucleotide_accession(const TNucleotide_accession& value);
    
        // typedef string TOther
        bool IsOther(void) const;
        const TOther& GetOther(void) const;
        TOther& SetOther(void);
        void SetOther(const TOther& value);
    
        // typedef int TTax_id
        bool IsTax_id(void) const;
        TTax_id GetTax_id(void) const;
        TTax_id& SetTax_id(void);
        void SetTax_id(TTax_id value);
    
    
    private:
        // copy constructor and assignment operator
        C_Mol_id(const C_Mol_id& );
        C_Mol_id& operator=(const C_Mol_id& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TGene_id m_Gene_id;
            TTax_id m_Tax_id;
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef CStringUTF8 TName;
    typedef C_Mol_id TMol_id;
    typedef objects::CBioSource TOrganism;
    typedef CStringUTF8 TDescr;
    typedef list< CStringUTF8 > TComment;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_mol_id,
        e_organism,
        e_descr,
        e_comment
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// Molecular name of target
    /// mandatory
    /// typedef CStringUTF8 TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// mandatory
    /// typedef C_Mol_id TMol_id
    ///  Check whether the Mol_id data member has been assigned a value.
    bool IsSetMol_id(void) const;
    /// Check whether it is safe or not to call GetMol_id method.
    bool CanGetMol_id(void) const;
    void ResetMol_id(void);
    const TMol_id& GetMol_id(void) const;
    void SetMol_id(TMol_id& value);
    TMol_id& SetMol_id(void);

    /// Target Organism
    /// optional
    /// typedef objects::CBioSource TOrganism
    ///  Check whether the Organism data member has been assigned a value.
    bool IsSetOrganism(void) const;
    /// Check whether it is safe or not to call GetOrganism method.
    bool CanGetOrganism(void) const;
    void ResetOrganism(void);
    const TOrganism& GetOrganism(void) const;
    void SetOrganism(TOrganism& value);
    TOrganism& SetOrganism(void);

    /// Target Description  (e.g., cellular functionality and location)
    /// optional
    /// typedef CStringUTF8 TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(const TDescr& value);
    void SetDescr(TDescr&& value);
    TDescr& SetDescr(void);

    /// Comments or Additional Information
    /// optional
    /// typedef list< CStringUTF8 > TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    TComment& SetComment(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AssayTargetInfo_Base(const CPC_AssayTargetInfo_Base&);
    CPC_AssayTargetInfo_Base& operator=(const CPC_AssayTargetInfo_Base&);

    // data
    Uint4 m_set_State[1];
    CStringUTF8 m_Name;
    CRef< TMol_id > m_Mol_id;
    CRef< TOrganism > m_Organism;
    CStringUTF8 m_Descr;
    list< CStringUTF8 > m_Comment;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPC_AssayTargetInfo_Base::C_Mol_id::E_Choice CPC_AssayTargetInfo_Base::C_Mol_id::Which(void) const
{
    return m_choice;
}

inline
void CPC_AssayTargetInfo_Base::C_Mol_id::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_AssayTargetInfo_Base::C_Mol_id::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_AssayTargetInfo_Base::C_Mol_id::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_AssayTargetInfo_Base::C_Mol_id::IsGene_id(void) const
{
    return m_choice == e_Gene_id;
}

inline
CPC_AssayTargetInfo_Base::C_Mol_id::TGene_id CPC_AssayTargetInfo_Base::C_Mol_id::GetGene_id(void) const
{
    CheckSelected(e_Gene_id);
    return m_Gene_id;
}

inline
CPC_AssayTargetInfo_Base::C_Mol_id::TGene_id& CPC_AssayTargetInfo_Base::C_Mol_id::SetGene_id(void)
{
    Select(e_Gene_id, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Gene_id;
}

inline
void CPC_AssayTargetInfo_Base::C_Mol_id::SetGene_id(CPC_AssayTargetInfo_Base::C_Mol_id::TGene_id value)
{
    Select(e_Gene_id, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Gene_id = value;
}

inline
bool CPC_AssayTargetInfo_Base::C_Mol_id::IsProtein_accession(void) const
{
    return m_choice == e_Protein_accession;
}

inline
const CPC_AssayTargetInfo_Base::C_Mol_id::TProtein_accession& CPC_AssayTargetInfo_Base::C_Mol_id::GetProtein_accession(void) const
{
    CheckSelected(e_Protein_accession);
    return *m_string;
}

inline
CPC_AssayTargetInfo_Base::C_Mol_id::TProtein_accession& CPC_AssayTargetInfo_Base::C_Mol_id::SetProtein_accession(void)
{
    Select(e_Protein_accession, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_AssayTargetInfo_Base::C_Mol_id::IsNucleotide_accession(void) const
{
    return m_choice == e_Nucleotide_accession;
}

inline
const CPC_AssayTargetInfo_Base::C_Mol_id::TNucleotide_accession& CPC_AssayTargetInfo_Base::C_Mol_id::GetNucleotide_accession(void) const
{
    CheckSelected(e_Nucleotide_accession);
    return *m_string;
}

inline
CPC_AssayTargetInfo_Base::C_Mol_id::TNucleotide_accession& CPC_AssayTargetInfo_Base::C_Mol_id::SetNucleotide_accession(void)
{
    Select(e_Nucleotide_accession, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_AssayTargetInfo_Base::C_Mol_id::IsOther(void) const
{
    return m_choice == e_Other;
}

inline
const CPC_AssayTargetInfo_Base::C_Mol_id::TOther& CPC_AssayTargetInfo_Base::C_Mol_id::GetOther(void) const
{
    CheckSelected(e_Other);
    return *m_string;
}

inline
CPC_AssayTargetInfo_Base::C_Mol_id::TOther& CPC_AssayTargetInfo_Base::C_Mol_id::SetOther(void)
{
    Select(e_Other, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CPC_AssayTargetInfo_Base::C_Mol_id::IsTax_id(void) const
{
    return m_choice == e_Tax_id;
}

inline
CPC_AssayTargetInfo_Base::C_Mol_id::TTax_id CPC_AssayTargetInfo_Base::C_Mol_id::GetTax_id(void) const
{
    CheckSelected(e_Tax_id);
    return m_Tax_id;
}

inline
CPC_AssayTargetInfo_Base::C_Mol_id::TTax_id& CPC_AssayTargetInfo_Base::C_Mol_id::SetTax_id(void)
{
    Select(e_Tax_id, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Tax_id;
}

inline
void CPC_AssayTargetInfo_Base::C_Mol_id::SetTax_id(CPC_AssayTargetInfo_Base::C_Mol_id::TTax_id value)
{
    Select(e_Tax_id, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Tax_id = value;
}

inline
bool CPC_AssayTargetInfo_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_AssayTargetInfo_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CPC_AssayTargetInfo_Base::TName& CPC_AssayTargetInfo_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CPC_AssayTargetInfo_Base::SetName(const CPC_AssayTargetInfo_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CPC_AssayTargetInfo_Base::SetName(CPC_AssayTargetInfo_Base::TName&& value)
{
    m_Name = std::forward<CPC_AssayTargetInfo_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CPC_AssayTargetInfo_Base::TName& CPC_AssayTargetInfo_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CPC_AssayTargetInfo_Base::IsSetMol_id(void) const
{
    return m_Mol_id.NotEmpty();
}

inline
bool CPC_AssayTargetInfo_Base::CanGetMol_id(void) const
{
    return true;
}

inline
const CPC_AssayTargetInfo_Base::TMol_id& CPC_AssayTargetInfo_Base::GetMol_id(void) const
{
    if ( !m_Mol_id ) {
        const_cast<CPC_AssayTargetInfo_Base*>(this)->ResetMol_id();
    }
    return (*m_Mol_id);
}

inline
CPC_AssayTargetInfo_Base::TMol_id& CPC_AssayTargetInfo_Base::SetMol_id(void)
{
    if ( !m_Mol_id ) {
        ResetMol_id();
    }
    return (*m_Mol_id);
}

inline
bool CPC_AssayTargetInfo_Base::IsSetOrganism(void) const
{
    return m_Organism.NotEmpty();
}

inline
bool CPC_AssayTargetInfo_Base::CanGetOrganism(void) const
{
    return IsSetOrganism();
}

inline
const CPC_AssayTargetInfo_Base::TOrganism& CPC_AssayTargetInfo_Base::GetOrganism(void) const
{
    if (!CanGetOrganism()) {
        ThrowUnassigned(2);
    }
    return (*m_Organism);
}

inline
bool CPC_AssayTargetInfo_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_AssayTargetInfo_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CPC_AssayTargetInfo_Base::TDescr& CPC_AssayTargetInfo_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(3);
    }
    return m_Descr;
}

inline
void CPC_AssayTargetInfo_Base::SetDescr(const CPC_AssayTargetInfo_Base::TDescr& value)
{
    m_Descr = value;
    m_set_State[0] |= 0xc0;
}

inline
void CPC_AssayTargetInfo_Base::SetDescr(CPC_AssayTargetInfo_Base::TDescr&& value)
{
    m_Descr = std::forward<CPC_AssayTargetInfo_Base::TDescr>(value);
    m_set_State[0] |= 0xc0;
}

inline
CPC_AssayTargetInfo_Base::TDescr& CPC_AssayTargetInfo_Base::SetDescr(void)
{
#ifdef _DEBUG
    if (!IsSetDescr()) {
        m_Descr = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Descr;
}

inline
bool CPC_AssayTargetInfo_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_AssayTargetInfo_Base::CanGetComment(void) const
{
    return true;
}

inline
const CPC_AssayTargetInfo_Base::TComment& CPC_AssayTargetInfo_Base::GetComment(void) const
{
    return m_Comment;
}

inline
CPC_AssayTargetInfo_Base::TComment& CPC_AssayTargetInfo_Base::SetComment(void)
{
    m_set_State[0] |= 0x100;
    return m_Comment;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY2_PC_ASSAYTARGETINFO_BASE_HPP
