/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSSearchSettings_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSSEARCHSETTINGS_BASE_HPP
#define OBJECTS_OMSSA_MSSEARCHSETTINGS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/omssa/MSEnzymes.hpp>
#include <objects/omssa/MSIonType.hpp>
#include <objects/omssa/MSMod.hpp>
#include <objects/omssa/MSSearchType.hpp>
#include <objects/omssa/MSZdependence.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMSChargeHandle;
class CMSInFile;
class CMSIterativeSettings;
class CMSLibrarySettings;
class CMSModSpecSet;
class CMSOutFile;
class CNameValue;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Generic search settings
class NCBI_OMSSA_EXPORT CMSSearchSettings_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSSearchSettings_Base(void);
    // destructor
    virtual ~CMSSearchSettings_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TPrecursorsearchtype;
    typedef int TProductsearchtype;
    typedef list< int > TIonstosearch;
    typedef double TPeptol;
    typedef double TMsmstol;
    typedef int TZdep;
    typedef double TCutoff;
    typedef double TCutlo;
    typedef double TCuthi;
    typedef double TCutinc;
    typedef int TSinglewin;
    typedef int TDoublewin;
    typedef int TSinglenum;
    typedef int TDoublenum;
    typedef list< int > TFixed;
    typedef list< int > TVariable;
    typedef int TEnzyme;
    typedef int TMissedcleave;
    typedef int THitlistlen;
    typedef string TDb;
    typedef int TTophitnum;
    typedef int TMinhit;
    typedef int TMinspectra;
    typedef int TScale;
    typedef int TMaxmods;
    typedef list< int > TTaxids;
    typedef CMSChargeHandle TChargehandling;
    typedef CMSModSpecSet TUsermods;
    typedef int TPseudocount;
    typedef int TSearchb1;
    typedef int TSearchctermproduct;
    typedef int TMaxproductions;
    typedef int TMinnoenzyme;
    typedef int TMaxnoenzyme;
    typedef double TExactmass;
    typedef int TSettingid;
    typedef CMSIterativeSettings TIterativesettings;
    typedef int TPrecursorcull;
    typedef list< CRef< CMSInFile > > TInfiles;
    typedef list< CRef< CMSOutFile > > TOutfiles;
    typedef int TNocorrelationscore;
    typedef double TProbfollowingion;
    typedef bool TNmethionine;
    typedef double TAutomassadjust;
    typedef double TLomasscutoff;
    typedef CMSLibrarySettings TLibsearchsettings;
    typedef list< int > TNoprolineions;
    typedef bool TReversesearch;
    typedef list< CRef< CNameValue > > TOthersettings;
    typedef int TNumisotopes;
    typedef bool TPepppm;
    typedef bool TMsmsppm;
    typedef int TReportedhitcount;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_precursorsearchtype,
        e_productsearchtype,
        e_ionstosearch,
        e_peptol,
        e_msmstol,
        e_zdep,
        e_cutoff,
        e_cutlo,
        e_cuthi,
        e_cutinc,
        e_singlewin,
        e_doublewin,
        e_singlenum,
        e_doublenum,
        e_fixed,
        e_variable,
        e_enzyme,
        e_missedcleave,
        e_hitlistlen,
        e_db,
        e_tophitnum,
        e_minhit,
        e_minspectra,
        e_scale,
        e_maxmods,
        e_taxids,
        e_chargehandling,
        e_usermods,
        e_pseudocount,
        e_searchb1,
        e_searchctermproduct,
        e_maxproductions,
        e_minnoenzyme,
        e_maxnoenzyme,
        e_exactmass,
        e_settingid,
        e_iterativesettings,
        e_precursorcull,
        e_infiles,
        e_outfiles,
        e_nocorrelationscore,
        e_probfollowingion,
        e_nmethionine,
        e_automassadjust,
        e_lomasscutoff,
        e_libsearchsettings,
        e_noprolineions,
        e_reversesearch,
        e_othersettings,
        e_numisotopes,
        e_pepppm,
        e_msmsppm,
        e_reportedhitcount
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 54> TmemberIndex;

    // getters
    // setters

    /// average or monoisotopic?
    /// mandatory
    /// typedef int TPrecursorsearchtype
    ///  Check whether the Precursorsearchtype data member has been assigned a value.
    bool IsSetPrecursorsearchtype(void) const;
    /// Check whether it is safe or not to call GetPrecursorsearchtype method.
    bool CanGetPrecursorsearchtype(void) const;
    void ResetPrecursorsearchtype(void);
    TPrecursorsearchtype GetPrecursorsearchtype(void) const;
    void SetPrecursorsearchtype(TPrecursorsearchtype value);
    TPrecursorsearchtype& SetPrecursorsearchtype(void);

    /// average or monoisotopic?
    /// mandatory
    /// typedef int TProductsearchtype
    ///  Check whether the Productsearchtype data member has been assigned a value.
    bool IsSetProductsearchtype(void) const;
    /// Check whether it is safe or not to call GetProductsearchtype method.
    bool CanGetProductsearchtype(void) const;
    void ResetProductsearchtype(void);
    TProductsearchtype GetProductsearchtype(void) const;
    void SetProductsearchtype(TProductsearchtype value);
    TProductsearchtype& SetProductsearchtype(void);

    /// which ions to search?
    /// mandatory
    /// typedef list< int > TIonstosearch
    ///  Check whether the Ionstosearch data member has been assigned a value.
    bool IsSetIonstosearch(void) const;
    /// Check whether it is safe or not to call GetIonstosearch method.
    bool CanGetIonstosearch(void) const;
    void ResetIonstosearch(void);
    const TIonstosearch& GetIonstosearch(void) const;
    TIonstosearch& SetIonstosearch(void);

    /// peptide mass tolerance
    /// mandatory
    /// typedef double TPeptol
    ///  Check whether the Peptol data member has been assigned a value.
    bool IsSetPeptol(void) const;
    /// Check whether it is safe or not to call GetPeptol method.
    bool CanGetPeptol(void) const;
    void ResetPeptol(void);
    TPeptol GetPeptol(void) const;
    void SetPeptol(TPeptol value);
    TPeptol& SetPeptol(void);

    /// msms mass tolerance
    /// mandatory
    /// typedef double TMsmstol
    ///  Check whether the Msmstol data member has been assigned a value.
    bool IsSetMsmstol(void) const;
    /// Check whether it is safe or not to call GetMsmstol method.
    bool CanGetMsmstol(void) const;
    void ResetMsmstol(void);
    TMsmstol GetMsmstol(void) const;
    void SetMsmstol(TMsmstol value);
    TMsmstol& SetMsmstol(void);

    /// what is the charge dependence of the mass tolerance?
    /// mandatory
    /// typedef int TZdep
    ///  Check whether the Zdep data member has been assigned a value.
    bool IsSetZdep(void) const;
    /// Check whether it is safe or not to call GetZdep method.
    bool CanGetZdep(void) const;
    void ResetZdep(void);
    TZdep GetZdep(void) const;
    void SetZdep(TZdep value);
    TZdep& SetZdep(void);

    /// evalue cutoff
    /// next 3 fields define intensity fraction below
    /// which peaks will be discard
    /// mandatory
    /// typedef double TCutoff
    ///  Check whether the Cutoff data member has been assigned a value.
    bool IsSetCutoff(void) const;
    /// Check whether it is safe or not to call GetCutoff method.
    bool CanGetCutoff(void) const;
    void ResetCutoff(void);
    TCutoff GetCutoff(void) const;
    void SetCutoff(TCutoff value);
    TCutoff& SetCutoff(void);

    /// the start of the cutoff, fraction of most intense peak
    /// mandatory
    /// typedef double TCutlo
    ///  Check whether the Cutlo data member has been assigned a value.
    bool IsSetCutlo(void) const;
    /// Check whether it is safe or not to call GetCutlo method.
    bool CanGetCutlo(void) const;
    void ResetCutlo(void);
    TCutlo GetCutlo(void) const;
    void SetCutlo(TCutlo value);
    TCutlo& SetCutlo(void);

    /// the end of the cutoff
    /// mandatory
    /// typedef double TCuthi
    ///  Check whether the Cuthi data member has been assigned a value.
    bool IsSetCuthi(void) const;
    /// Check whether it is safe or not to call GetCuthi method.
    bool CanGetCuthi(void) const;
    void ResetCuthi(void);
    TCuthi GetCuthi(void) const;
    void SetCuthi(TCuthi value);
    TCuthi& SetCuthi(void);

    /// the increment of the cutoff
    /// mandatory
    /// typedef double TCutinc
    ///  Check whether the Cutinc data member has been assigned a value.
    bool IsSetCutinc(void) const;
    /// Check whether it is safe or not to call GetCutinc method.
    bool CanGetCutinc(void) const;
    void ResetCutinc(void);
    TCutinc GetCutinc(void) const;
    void SetCutinc(TCutinc value);
    TCutinc& SetCutinc(void);

    /// the size of the single charge filtering window
    /// mandatory
    /// typedef int TSinglewin
    ///  Check whether the Singlewin data member has been assigned a value.
    bool IsSetSinglewin(void) const;
    /// Check whether it is safe or not to call GetSinglewin method.
    bool CanGetSinglewin(void) const;
    void ResetSinglewin(void);
    TSinglewin GetSinglewin(void) const;
    void SetSinglewin(TSinglewin value);
    TSinglewin& SetSinglewin(void);

    /// the size of the double charge filtering window
    /// mandatory
    /// typedef int TDoublewin
    ///  Check whether the Doublewin data member has been assigned a value.
    bool IsSetDoublewin(void) const;
    /// Check whether it is safe or not to call GetDoublewin method.
    bool CanGetDoublewin(void) const;
    void ResetDoublewin(void);
    TDoublewin GetDoublewin(void) const;
    void SetDoublewin(TDoublewin value);
    TDoublewin& SetDoublewin(void);

    /// the number of peaks allowed in the single window
    /// mandatory
    /// typedef int TSinglenum
    ///  Check whether the Singlenum data member has been assigned a value.
    bool IsSetSinglenum(void) const;
    /// Check whether it is safe or not to call GetSinglenum method.
    bool CanGetSinglenum(void) const;
    void ResetSinglenum(void);
    TSinglenum GetSinglenum(void) const;
    void SetSinglenum(TSinglenum value);
    TSinglenum& SetSinglenum(void);

    /// the number of peaks allowed in the double window
    /// mandatory
    /// typedef int TDoublenum
    ///  Check whether the Doublenum data member has been assigned a value.
    bool IsSetDoublenum(void) const;
    /// Check whether it is safe or not to call GetDoublenum method.
    bool CanGetDoublenum(void) const;
    void ResetDoublenum(void);
    TDoublenum GetDoublenum(void) const;
    void SetDoublenum(TDoublenum value);
    TDoublenum& SetDoublenum(void);

    /// fixed PTM's
    /// mandatory
    /// typedef list< int > TFixed
    ///  Check whether the Fixed data member has been assigned a value.
    bool IsSetFixed(void) const;
    /// Check whether it is safe or not to call GetFixed method.
    bool CanGetFixed(void) const;
    void ResetFixed(void);
    const TFixed& GetFixed(void) const;
    TFixed& SetFixed(void);

    /// variable PTM's
    /// mandatory
    /// typedef list< int > TVariable
    ///  Check whether the Variable data member has been assigned a value.
    bool IsSetVariable(void) const;
    /// Check whether it is safe or not to call GetVariable method.
    bool CanGetVariable(void) const;
    void ResetVariable(void);
    const TVariable& GetVariable(void) const;
    TVariable& SetVariable(void);

    /// digestion enzyme
    /// mandatory
    /// typedef int TEnzyme
    ///  Check whether the Enzyme data member has been assigned a value.
    bool IsSetEnzyme(void) const;
    /// Check whether it is safe or not to call GetEnzyme method.
    bool CanGetEnzyme(void) const;
    void ResetEnzyme(void);
    TEnzyme GetEnzyme(void) const;
    void SetEnzyme(TEnzyme value);
    TEnzyme& SetEnzyme(void);

    /// number of missed cleaves allowed
    /// mandatory
    /// typedef int TMissedcleave
    ///  Check whether the Missedcleave data member has been assigned a value.
    bool IsSetMissedcleave(void) const;
    /// Check whether it is safe or not to call GetMissedcleave method.
    bool CanGetMissedcleave(void) const;
    void ResetMissedcleave(void);
    TMissedcleave GetMissedcleave(void) const;
    void SetMissedcleave(TMissedcleave value);
    TMissedcleave& SetMissedcleave(void);

    /// the number of hits kept in memory
    /// for a spectrum
    /// optional with default 25
    /// typedef int THitlistlen
    ///  Check whether the Hitlistlen data member has been assigned a value.
    bool IsSetHitlistlen(void) const;
    /// Check whether it is safe or not to call GetHitlistlen method.
    bool CanGetHitlistlen(void) const;
    void ResetHitlistlen(void);
    void SetDefaultHitlistlen(void);
    THitlistlen GetHitlistlen(void) const;
    void SetHitlistlen(THitlistlen value);
    THitlistlen& SetHitlistlen(void);

    /// sequence set to search, e.g. "nr"
    /// mandatory
    /// typedef string TDb
    ///  Check whether the Db data member has been assigned a value.
    bool IsSetDb(void) const;
    /// Check whether it is safe or not to call GetDb method.
    bool CanGetDb(void) const;
    void ResetDb(void);
    const TDb& GetDb(void) const;
    void SetDb(const TDb& value);
    void SetDb(TDb&& value);
    TDb& SetDb(void);

    /// number of m/z to consider in first pass
    /// mandatory
    /// typedef int TTophitnum
    ///  Check whether the Tophitnum data member has been assigned a value.
    bool IsSetTophitnum(void) const;
    /// Check whether it is safe or not to call GetTophitnum method.
    bool CanGetTophitnum(void) const;
    void ResetTophitnum(void);
    TTophitnum GetTophitnum(void) const;
    void SetTophitnum(TTophitnum value);
    TTophitnum& SetTophitnum(void);

    /// minimum number of m/z values for a valid hit
    /// optional with default 2
    /// typedef int TMinhit
    ///  Check whether the Minhit data member has been assigned a value.
    bool IsSetMinhit(void) const;
    /// Check whether it is safe or not to call GetMinhit method.
    bool CanGetMinhit(void) const;
    void ResetMinhit(void);
    void SetDefaultMinhit(void);
    TMinhit GetMinhit(void) const;
    void SetMinhit(TMinhit value);
    TMinhit& SetMinhit(void);

    /// minimum number of m/z for a valid spectra
    /// optional with default 4
    /// typedef int TMinspectra
    ///  Check whether the Minspectra data member has been assigned a value.
    bool IsSetMinspectra(void) const;
    /// Check whether it is safe or not to call GetMinspectra method.
    bool CanGetMinspectra(void) const;
    void ResetMinspectra(void);
    void SetDefaultMinspectra(void);
    TMinspectra GetMinspectra(void) const;
    void SetMinspectra(TMinspectra value);
    TMinspectra& SetMinspectra(void);

    /// scale for m/z float to integer
    /// optional with default 100
    /// typedef int TScale
    ///  Check whether the Scale data member has been assigned a value.
    bool IsSetScale(void) const;
    /// Check whether it is safe or not to call GetScale method.
    bool CanGetScale(void) const;
    void ResetScale(void);
    void SetDefaultScale(void);
    TScale GetScale(void) const;
    void SetScale(TScale value);
    TScale& SetScale(void);

    /// maximum number of mass ladders per
    /// database peptide
    /// optional with default 64
    /// typedef int TMaxmods
    ///  Check whether the Maxmods data member has been assigned a value.
    bool IsSetMaxmods(void) const;
    /// Check whether it is safe or not to call GetMaxmods method.
    bool CanGetMaxmods(void) const;
    void ResetMaxmods(void);
    void SetDefaultMaxmods(void);
    TMaxmods GetMaxmods(void) const;
    void SetMaxmods(TMaxmods value);
    TMaxmods& SetMaxmods(void);

    /// taxa to limit search
    /// optional
    /// typedef list< int > TTaxids
    ///  Check whether the Taxids data member has been assigned a value.
    bool IsSetTaxids(void) const;
    /// Check whether it is safe or not to call GetTaxids method.
    bool CanGetTaxids(void) const;
    void ResetTaxids(void);
    const TTaxids& GetTaxids(void) const;
    TTaxids& SetTaxids(void);

    /// how to deal with charges
    /// optional
    /// typedef CMSChargeHandle TChargehandling
    ///  Check whether the Chargehandling data member has been assigned a value.
    bool IsSetChargehandling(void) const;
    /// Check whether it is safe or not to call GetChargehandling method.
    bool CanGetChargehandling(void) const;
    void ResetChargehandling(void);
    const TChargehandling& GetChargehandling(void) const;
    void SetChargehandling(TChargehandling& value);
    TChargehandling& SetChargehandling(void);

    /// user defined modifications
    /// optional
    /// typedef CMSModSpecSet TUsermods
    ///  Check whether the Usermods data member has been assigned a value.
    bool IsSetUsermods(void) const;
    /// Check whether it is safe or not to call GetUsermods method.
    bool CanGetUsermods(void) const;
    void ResetUsermods(void);
    const TUsermods& GetUsermods(void) const;
    void SetUsermods(TUsermods& value);
    TUsermods& SetUsermods(void);

    /// min number of counts per precursor bin
    /// optional with default 1
    /// typedef int TPseudocount
    ///  Check whether the Pseudocount data member has been assigned a value.
    bool IsSetPseudocount(void) const;
    /// Check whether it is safe or not to call GetPseudocount method.
    bool CanGetPseudocount(void) const;
    void ResetPseudocount(void);
    void SetDefaultPseudocount(void);
    TPseudocount GetPseudocount(void) const;
    void SetPseudocount(TPseudocount value);
    TPseudocount& SetPseudocount(void);

    /// should b1 product be in search (1=no, 0=yes)
    /// optional with default 0
    /// typedef int TSearchb1
    ///  Check whether the Searchb1 data member has been assigned a value.
    bool IsSetSearchb1(void) const;
    /// Check whether it is safe or not to call GetSearchb1 method.
    bool CanGetSearchb1(void) const;
    void ResetSearchb1(void);
    void SetDefaultSearchb1(void);
    TSearchb1 GetSearchb1(void) const;
    void SetSearchb1(TSearchb1 value);
    TSearchb1& SetSearchb1(void);

    /// should c terminus ion be searched (1=no, 0=yes)
    /// optional with default 0
    /// typedef int TSearchctermproduct
    ///  Check whether the Searchctermproduct data member has been assigned a value.
    bool IsSetSearchctermproduct(void) const;
    /// Check whether it is safe or not to call GetSearchctermproduct method.
    bool CanGetSearchctermproduct(void) const;
    void ResetSearchctermproduct(void);
    void SetDefaultSearchctermproduct(void);
    TSearchctermproduct GetSearchctermproduct(void) const;
    void SetSearchctermproduct(TSearchctermproduct value);
    TSearchctermproduct& SetSearchctermproduct(void);

    /// max number of ions in each series (0=all)
    /// optional with default 0
    /// typedef int TMaxproductions
    ///  Check whether the Maxproductions data member has been assigned a value.
    bool IsSetMaxproductions(void) const;
    /// Check whether it is safe or not to call GetMaxproductions method.
    bool CanGetMaxproductions(void) const;
    void ResetMaxproductions(void);
    void SetDefaultMaxproductions(void);
    TMaxproductions GetMaxproductions(void) const;
    void SetMaxproductions(TMaxproductions value);
    TMaxproductions& SetMaxproductions(void);

    /// min number of AA in peptide for noenzyme search
    /// optional with default 4
    /// typedef int TMinnoenzyme
    ///  Check whether the Minnoenzyme data member has been assigned a value.
    bool IsSetMinnoenzyme(void) const;
    /// Check whether it is safe or not to call GetMinnoenzyme method.
    bool CanGetMinnoenzyme(void) const;
    void ResetMinnoenzyme(void);
    void SetDefaultMinnoenzyme(void);
    TMinnoenzyme GetMinnoenzyme(void) const;
    void SetMinnoenzyme(TMinnoenzyme value);
    TMinnoenzyme& SetMinnoenzyme(void);

    /// max number of AA in peptide for noenzyme search (0=none)
    /// optional with default 0
    /// typedef int TMaxnoenzyme
    ///  Check whether the Maxnoenzyme data member has been assigned a value.
    bool IsSetMaxnoenzyme(void) const;
    /// Check whether it is safe or not to call GetMaxnoenzyme method.
    bool CanGetMaxnoenzyme(void) const;
    void ResetMaxnoenzyme(void);
    void SetDefaultMaxnoenzyme(void);
    TMaxnoenzyme GetMaxnoenzyme(void) const;
    void SetMaxnoenzyme(TMaxnoenzyme value);
    TMaxnoenzyme& SetMaxnoenzyme(void);

    /// the threshold in Da for adding neutron
    /// optional
    /// typedef double TExactmass
    ///  Check whether the Exactmass data member has been assigned a value.
    bool IsSetExactmass(void) const;
    /// Check whether it is safe or not to call GetExactmass method.
    bool CanGetExactmass(void) const;
    void ResetExactmass(void);
    TExactmass GetExactmass(void) const;
    void SetExactmass(TExactmass value);
    TExactmass& SetExactmass(void);

    /// id of the search settings
    /// optional
    /// typedef int TSettingid
    ///  Check whether the Settingid data member has been assigned a value.
    bool IsSetSettingid(void) const;
    /// Check whether it is safe or not to call GetSettingid method.
    bool CanGetSettingid(void) const;
    void ResetSettingid(void);
    TSettingid GetSettingid(void) const;
    void SetSettingid(TSettingid value);
    TSettingid& SetSettingid(void);

    /// iterative search settings
    /// optional
    /// typedef CMSIterativeSettings TIterativesettings
    ///  Check whether the Iterativesettings data member has been assigned a value.
    bool IsSetIterativesettings(void) const;
    /// Check whether it is safe or not to call GetIterativesettings method.
    bool CanGetIterativesettings(void) const;
    void ResetIterativesettings(void);
    const TIterativesettings& GetIterativesettings(void) const;
    void SetIterativesettings(TIterativesettings& value);
    TIterativesettings& SetIterativesettings(void);

    /// turn on aggressive precursor culling for ETD (0=none)
    /// optional
    /// typedef int TPrecursorcull
    ///  Check whether the Precursorcull data member has been assigned a value.
    bool IsSetPrecursorcull(void) const;
    /// Check whether it is safe or not to call GetPrecursorcull method.
    bool CanGetPrecursorcull(void) const;
    void ResetPrecursorcull(void);
    TPrecursorcull GetPrecursorcull(void) const;
    void SetPrecursorcull(TPrecursorcull value);
    TPrecursorcull& SetPrecursorcull(void);

    /// input files
    /// optional
    /// typedef list< CRef< CMSInFile > > TInfiles
    ///  Check whether the Infiles data member has been assigned a value.
    bool IsSetInfiles(void) const;
    /// Check whether it is safe or not to call GetInfiles method.
    bool CanGetInfiles(void) const;
    void ResetInfiles(void);
    const TInfiles& GetInfiles(void) const;
    TInfiles& SetInfiles(void);

    /// output files
    /// optional
    /// typedef list< CRef< CMSOutFile > > TOutfiles
    ///  Check whether the Outfiles data member has been assigned a value.
    bool IsSetOutfiles(void) const;
    /// Check whether it is safe or not to call GetOutfiles method.
    bool CanGetOutfiles(void) const;
    void ResetOutfiles(void);
    const TOutfiles& GetOutfiles(void) const;
    TOutfiles& SetOutfiles(void);

    /// turn on correlation score (1=nocorr)
    /// optional
    /// typedef int TNocorrelationscore
    ///  Check whether the Nocorrelationscore data member has been assigned a value.
    bool IsSetNocorrelationscore(void) const;
    /// Check whether it is safe or not to call GetNocorrelationscore method.
    bool CanGetNocorrelationscore(void) const;
    void ResetNocorrelationscore(void);
    TNocorrelationscore GetNocorrelationscore(void) const;
    void SetNocorrelationscore(TNocorrelationscore value);
    TNocorrelationscore& SetNocorrelationscore(void);

    /// probability of a consecutive ion (used in correlation)
    /// optional
    /// typedef double TProbfollowingion
    ///  Check whether the Probfollowingion data member has been assigned a value.
    bool IsSetProbfollowingion(void) const;
    /// Check whether it is safe or not to call GetProbfollowingion method.
    bool CanGetProbfollowingion(void) const;
    void ResetProbfollowingion(void);
    TProbfollowingion GetProbfollowingion(void) const;
    void SetProbfollowingion(TProbfollowingion value);
    TProbfollowingion& SetProbfollowingion(void);

    /// should nmethionine be cleaved?
    /// optional
    /// typedef bool TNmethionine
    ///  Check whether the Nmethionine data member has been assigned a value.
    bool IsSetNmethionine(void) const;
    /// Check whether it is safe or not to call GetNmethionine method.
    bool CanGetNmethionine(void) const;
    void ResetNmethionine(void);
    TNmethionine GetNmethionine(void) const;
    void SetNmethionine(TNmethionine value);
    TNmethionine& SetNmethionine(void);

    /// fraction allowable adjustment of product mass tolerance
    /// optional
    /// typedef double TAutomassadjust
    ///  Check whether the Automassadjust data member has been assigned a value.
    bool IsSetAutomassadjust(void) const;
    /// Check whether it is safe or not to call GetAutomassadjust method.
    bool CanGetAutomassadjust(void) const;
    void ResetAutomassadjust(void);
    TAutomassadjust GetAutomassadjust(void) const;
    void SetAutomassadjust(TAutomassadjust value);
    TAutomassadjust& SetAutomassadjust(void);

    /// low mass filter in Daltons, unscaled
    /// optional
    /// typedef double TLomasscutoff
    ///  Check whether the Lomasscutoff data member has been assigned a value.
    bool IsSetLomasscutoff(void) const;
    /// Check whether it is safe or not to call GetLomasscutoff method.
    bool CanGetLomasscutoff(void) const;
    void ResetLomasscutoff(void);
    TLomasscutoff GetLomasscutoff(void) const;
    void SetLomasscutoff(TLomasscutoff value);
    TLomasscutoff& SetLomasscutoff(void);

    /// library search settings
    /// optional
    /// typedef CMSLibrarySettings TLibsearchsettings
    ///  Check whether the Libsearchsettings data member has been assigned a value.
    bool IsSetLibsearchsettings(void) const;
    /// Check whether it is safe or not to call GetLibsearchsettings method.
    bool CanGetLibsearchsettings(void) const;
    void ResetLibsearchsettings(void);
    const TLibsearchsettings& GetLibsearchsettings(void) const;
    void SetLibsearchsettings(TLibsearchsettings& value);
    TLibsearchsettings& SetLibsearchsettings(void);

    /// which ions to use no proline rule
    /// optional
    /// typedef list< int > TNoprolineions
    ///  Check whether the Noprolineions data member has been assigned a value.
    bool IsSetNoprolineions(void) const;
    /// Check whether it is safe or not to call GetNoprolineions method.
    bool CanGetNoprolineions(void) const;
    void ResetNoprolineions(void);
    const TNoprolineions& GetNoprolineions(void) const;
    TNoprolineions& SetNoprolineions(void);

    /// do reverse search
    /// optional
    /// typedef bool TReversesearch
    ///  Check whether the Reversesearch data member has been assigned a value.
    bool IsSetReversesearch(void) const;
    /// Check whether it is safe or not to call GetReversesearch method.
    bool CanGetReversesearch(void) const;
    void ResetReversesearch(void);
    TReversesearch GetReversesearch(void) const;
    void SetReversesearch(TReversesearch value);
    TReversesearch& SetReversesearch(void);

    /// extra search settings
    /// optional
    /// typedef list< CRef< CNameValue > > TOthersettings
    ///  Check whether the Othersettings data member has been assigned a value.
    bool IsSetOthersettings(void) const;
    /// Check whether it is safe or not to call GetOthersettings method.
    bool CanGetOthersettings(void) const;
    void ResetOthersettings(void);
    const TOthersettings& GetOthersettings(void) const;
    TOthersettings& SetOthersettings(void);

    /// number of isotopic peaks to search when using MSSearchType multiisotope
    /// optional
    /// typedef int TNumisotopes
    ///  Check whether the Numisotopes data member has been assigned a value.
    bool IsSetNumisotopes(void) const;
    /// Check whether it is safe or not to call GetNumisotopes method.
    bool CanGetNumisotopes(void) const;
    void ResetNumisotopes(void);
    TNumisotopes GetNumisotopes(void) const;
    void SetNumisotopes(TNumisotopes value);
    TNumisotopes& SetNumisotopes(void);

    /// search precursor as ppm
    /// optional
    /// typedef bool TPepppm
    ///  Check whether the Pepppm data member has been assigned a value.
    bool IsSetPepppm(void) const;
    /// Check whether it is safe or not to call GetPepppm method.
    bool CanGetPepppm(void) const;
    void ResetPepppm(void);
    TPepppm GetPepppm(void) const;
    void SetPepppm(TPepppm value);
    TPepppm& SetPepppm(void);

    /// search product as ppm
    /// optional
    /// typedef bool TMsmsppm
    ///  Check whether the Msmsppm data member has been assigned a value.
    bool IsSetMsmsppm(void) const;
    /// Check whether it is safe or not to call GetMsmsppm method.
    bool CanGetMsmsppm(void) const;
    void ResetMsmsppm(void);
    TMsmsppm GetMsmsppm(void) const;
    void SetMsmsppm(TMsmsppm value);
    TMsmsppm& SetMsmsppm(void);

    /// the maximum number of hits to report per spectrum, 0=all
    /// optional
    /// typedef int TReportedhitcount
    ///  Check whether the Reportedhitcount data member has been assigned a value.
    bool IsSetReportedhitcount(void) const;
    /// Check whether it is safe or not to call GetReportedhitcount method.
    bool CanGetReportedhitcount(void) const;
    void ResetReportedhitcount(void);
    TReportedhitcount GetReportedhitcount(void) const;
    void SetReportedhitcount(TReportedhitcount value);
    TReportedhitcount& SetReportedhitcount(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSSearchSettings_Base(const CMSSearchSettings_Base&);
    CMSSearchSettings_Base& operator=(const CMSSearchSettings_Base&);

    // data
    Uint4 m_set_State[4];
    int m_Precursorsearchtype;
    int m_Productsearchtype;
    list< int > m_Ionstosearch;
    double m_Peptol;
    double m_Msmstol;
    int m_Zdep;
    double m_Cutoff;
    double m_Cutlo;
    double m_Cuthi;
    double m_Cutinc;
    int m_Singlewin;
    int m_Doublewin;
    int m_Singlenum;
    int m_Doublenum;
    list< int > m_Fixed;
    list< int > m_Variable;
    int m_Enzyme;
    int m_Missedcleave;
    int m_Hitlistlen;
    string m_Db;
    int m_Tophitnum;
    int m_Minhit;
    int m_Minspectra;
    int m_Scale;
    int m_Maxmods;
    list< int > m_Taxids;
    CRef< TChargehandling > m_Chargehandling;
    CRef< TUsermods > m_Usermods;
    int m_Pseudocount;
    int m_Searchb1;
    int m_Searchctermproduct;
    int m_Maxproductions;
    int m_Minnoenzyme;
    int m_Maxnoenzyme;
    double m_Exactmass;
    int m_Settingid;
    CRef< TIterativesettings > m_Iterativesettings;
    int m_Precursorcull;
    list< CRef< CMSInFile > > m_Infiles;
    list< CRef< CMSOutFile > > m_Outfiles;
    int m_Nocorrelationscore;
    double m_Probfollowingion;
    bool m_Nmethionine;
    double m_Automassadjust;
    double m_Lomasscutoff;
    CRef< TLibsearchsettings > m_Libsearchsettings;
    list< int > m_Noprolineions;
    bool m_Reversesearch;
    list< CRef< CNameValue > > m_Othersettings;
    int m_Numisotopes;
    bool m_Pepppm;
    bool m_Msmsppm;
    int m_Reportedhitcount;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSSearchSettings_Base::IsSetPrecursorsearchtype(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetPrecursorsearchtype(void) const
{
    return IsSetPrecursorsearchtype();
}

inline
void CMSSearchSettings_Base::ResetPrecursorsearchtype(void)
{
    m_Precursorsearchtype = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CMSSearchSettings_Base::TPrecursorsearchtype CMSSearchSettings_Base::GetPrecursorsearchtype(void) const
{
    if (!CanGetPrecursorsearchtype()) {
        ThrowUnassigned(0);
    }
    return m_Precursorsearchtype;
}

inline
void CMSSearchSettings_Base::SetPrecursorsearchtype(CMSSearchSettings_Base::TPrecursorsearchtype value)
{
    m_Precursorsearchtype = value;
    m_set_State[0] |= 0x3;
}

inline
CMSSearchSettings_Base::TPrecursorsearchtype& CMSSearchSettings_Base::SetPrecursorsearchtype(void)
{
#ifdef _DEBUG
    if (!IsSetPrecursorsearchtype()) {
        memset(&m_Precursorsearchtype,UnassignedByte(),sizeof(m_Precursorsearchtype));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Precursorsearchtype;
}

inline
bool CMSSearchSettings_Base::IsSetProductsearchtype(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetProductsearchtype(void) const
{
    return IsSetProductsearchtype();
}

inline
void CMSSearchSettings_Base::ResetProductsearchtype(void)
{
    m_Productsearchtype = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CMSSearchSettings_Base::TProductsearchtype CMSSearchSettings_Base::GetProductsearchtype(void) const
{
    if (!CanGetProductsearchtype()) {
        ThrowUnassigned(1);
    }
    return m_Productsearchtype;
}

inline
void CMSSearchSettings_Base::SetProductsearchtype(CMSSearchSettings_Base::TProductsearchtype value)
{
    m_Productsearchtype = value;
    m_set_State[0] |= 0xc;
}

inline
CMSSearchSettings_Base::TProductsearchtype& CMSSearchSettings_Base::SetProductsearchtype(void)
{
#ifdef _DEBUG
    if (!IsSetProductsearchtype()) {
        memset(&m_Productsearchtype,UnassignedByte(),sizeof(m_Productsearchtype));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Productsearchtype;
}

inline
bool CMSSearchSettings_Base::IsSetIonstosearch(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetIonstosearch(void) const
{
    return true;
}

inline
const CMSSearchSettings_Base::TIonstosearch& CMSSearchSettings_Base::GetIonstosearch(void) const
{
    return m_Ionstosearch;
}

inline
CMSSearchSettings_Base::TIonstosearch& CMSSearchSettings_Base::SetIonstosearch(void)
{
    m_set_State[0] |= 0x10;
    return m_Ionstosearch;
}

inline
bool CMSSearchSettings_Base::IsSetPeptol(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetPeptol(void) const
{
    return IsSetPeptol();
}

inline
void CMSSearchSettings_Base::ResetPeptol(void)
{
    m_Peptol = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CMSSearchSettings_Base::TPeptol CMSSearchSettings_Base::GetPeptol(void) const
{
    if (!CanGetPeptol()) {
        ThrowUnassigned(3);
    }
    return m_Peptol;
}

inline
void CMSSearchSettings_Base::SetPeptol(CMSSearchSettings_Base::TPeptol value)
{
    m_Peptol = value;
    m_set_State[0] |= 0xc0;
}

inline
CMSSearchSettings_Base::TPeptol& CMSSearchSettings_Base::SetPeptol(void)
{
#ifdef _DEBUG
    if (!IsSetPeptol()) {
        memset(&m_Peptol,UnassignedByte(),sizeof(m_Peptol));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Peptol;
}

inline
bool CMSSearchSettings_Base::IsSetMsmstol(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetMsmstol(void) const
{
    return IsSetMsmstol();
}

inline
void CMSSearchSettings_Base::ResetMsmstol(void)
{
    m_Msmstol = 0;
    m_set_State[0] &= ~0x300;
}

inline
CMSSearchSettings_Base::TMsmstol CMSSearchSettings_Base::GetMsmstol(void) const
{
    if (!CanGetMsmstol()) {
        ThrowUnassigned(4);
    }
    return m_Msmstol;
}

inline
void CMSSearchSettings_Base::SetMsmstol(CMSSearchSettings_Base::TMsmstol value)
{
    m_Msmstol = value;
    m_set_State[0] |= 0x300;
}

inline
CMSSearchSettings_Base::TMsmstol& CMSSearchSettings_Base::SetMsmstol(void)
{
#ifdef _DEBUG
    if (!IsSetMsmstol()) {
        memset(&m_Msmstol,UnassignedByte(),sizeof(m_Msmstol));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Msmstol;
}

inline
bool CMSSearchSettings_Base::IsSetZdep(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetZdep(void) const
{
    return IsSetZdep();
}

inline
void CMSSearchSettings_Base::ResetZdep(void)
{
    m_Zdep = (int)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CMSSearchSettings_Base::TZdep CMSSearchSettings_Base::GetZdep(void) const
{
    if (!CanGetZdep()) {
        ThrowUnassigned(5);
    }
    return m_Zdep;
}

inline
void CMSSearchSettings_Base::SetZdep(CMSSearchSettings_Base::TZdep value)
{
    m_Zdep = value;
    m_set_State[0] |= 0xc00;
}

inline
CMSSearchSettings_Base::TZdep& CMSSearchSettings_Base::SetZdep(void)
{
#ifdef _DEBUG
    if (!IsSetZdep()) {
        memset(&m_Zdep,UnassignedByte(),sizeof(m_Zdep));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Zdep;
}

inline
bool CMSSearchSettings_Base::IsSetCutoff(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetCutoff(void) const
{
    return IsSetCutoff();
}

inline
void CMSSearchSettings_Base::ResetCutoff(void)
{
    m_Cutoff = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CMSSearchSettings_Base::TCutoff CMSSearchSettings_Base::GetCutoff(void) const
{
    if (!CanGetCutoff()) {
        ThrowUnassigned(6);
    }
    return m_Cutoff;
}

inline
void CMSSearchSettings_Base::SetCutoff(CMSSearchSettings_Base::TCutoff value)
{
    m_Cutoff = value;
    m_set_State[0] |= 0x3000;
}

inline
CMSSearchSettings_Base::TCutoff& CMSSearchSettings_Base::SetCutoff(void)
{
#ifdef _DEBUG
    if (!IsSetCutoff()) {
        memset(&m_Cutoff,UnassignedByte(),sizeof(m_Cutoff));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Cutoff;
}

inline
bool CMSSearchSettings_Base::IsSetCutlo(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetCutlo(void) const
{
    return IsSetCutlo();
}

inline
void CMSSearchSettings_Base::ResetCutlo(void)
{
    m_Cutlo = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CMSSearchSettings_Base::TCutlo CMSSearchSettings_Base::GetCutlo(void) const
{
    if (!CanGetCutlo()) {
        ThrowUnassigned(7);
    }
    return m_Cutlo;
}

inline
void CMSSearchSettings_Base::SetCutlo(CMSSearchSettings_Base::TCutlo value)
{
    m_Cutlo = value;
    m_set_State[0] |= 0xc000;
}

inline
CMSSearchSettings_Base::TCutlo& CMSSearchSettings_Base::SetCutlo(void)
{
#ifdef _DEBUG
    if (!IsSetCutlo()) {
        memset(&m_Cutlo,UnassignedByte(),sizeof(m_Cutlo));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Cutlo;
}

inline
bool CMSSearchSettings_Base::IsSetCuthi(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetCuthi(void) const
{
    return IsSetCuthi();
}

inline
void CMSSearchSettings_Base::ResetCuthi(void)
{
    m_Cuthi = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CMSSearchSettings_Base::TCuthi CMSSearchSettings_Base::GetCuthi(void) const
{
    if (!CanGetCuthi()) {
        ThrowUnassigned(8);
    }
    return m_Cuthi;
}

inline
void CMSSearchSettings_Base::SetCuthi(CMSSearchSettings_Base::TCuthi value)
{
    m_Cuthi = value;
    m_set_State[0] |= 0x30000;
}

inline
CMSSearchSettings_Base::TCuthi& CMSSearchSettings_Base::SetCuthi(void)
{
#ifdef _DEBUG
    if (!IsSetCuthi()) {
        memset(&m_Cuthi,UnassignedByte(),sizeof(m_Cuthi));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Cuthi;
}

inline
bool CMSSearchSettings_Base::IsSetCutinc(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetCutinc(void) const
{
    return IsSetCutinc();
}

inline
void CMSSearchSettings_Base::ResetCutinc(void)
{
    m_Cutinc = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CMSSearchSettings_Base::TCutinc CMSSearchSettings_Base::GetCutinc(void) const
{
    if (!CanGetCutinc()) {
        ThrowUnassigned(9);
    }
    return m_Cutinc;
}

inline
void CMSSearchSettings_Base::SetCutinc(CMSSearchSettings_Base::TCutinc value)
{
    m_Cutinc = value;
    m_set_State[0] |= 0xc0000;
}

inline
CMSSearchSettings_Base::TCutinc& CMSSearchSettings_Base::SetCutinc(void)
{
#ifdef _DEBUG
    if (!IsSetCutinc()) {
        memset(&m_Cutinc,UnassignedByte(),sizeof(m_Cutinc));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Cutinc;
}

inline
bool CMSSearchSettings_Base::IsSetSinglewin(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetSinglewin(void) const
{
    return IsSetSinglewin();
}

inline
void CMSSearchSettings_Base::ResetSinglewin(void)
{
    m_Singlewin = 0;
    m_set_State[0] &= ~0x300000;
}

inline
CMSSearchSettings_Base::TSinglewin CMSSearchSettings_Base::GetSinglewin(void) const
{
    if (!CanGetSinglewin()) {
        ThrowUnassigned(10);
    }
    return m_Singlewin;
}

inline
void CMSSearchSettings_Base::SetSinglewin(CMSSearchSettings_Base::TSinglewin value)
{
    m_Singlewin = value;
    m_set_State[0] |= 0x300000;
}

inline
CMSSearchSettings_Base::TSinglewin& CMSSearchSettings_Base::SetSinglewin(void)
{
#ifdef _DEBUG
    if (!IsSetSinglewin()) {
        memset(&m_Singlewin,UnassignedByte(),sizeof(m_Singlewin));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Singlewin;
}

inline
bool CMSSearchSettings_Base::IsSetDoublewin(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetDoublewin(void) const
{
    return IsSetDoublewin();
}

inline
void CMSSearchSettings_Base::ResetDoublewin(void)
{
    m_Doublewin = 0;
    m_set_State[0] &= ~0xc00000;
}

inline
CMSSearchSettings_Base::TDoublewin CMSSearchSettings_Base::GetDoublewin(void) const
{
    if (!CanGetDoublewin()) {
        ThrowUnassigned(11);
    }
    return m_Doublewin;
}

inline
void CMSSearchSettings_Base::SetDoublewin(CMSSearchSettings_Base::TDoublewin value)
{
    m_Doublewin = value;
    m_set_State[0] |= 0xc00000;
}

inline
CMSSearchSettings_Base::TDoublewin& CMSSearchSettings_Base::SetDoublewin(void)
{
#ifdef _DEBUG
    if (!IsSetDoublewin()) {
        memset(&m_Doublewin,UnassignedByte(),sizeof(m_Doublewin));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Doublewin;
}

inline
bool CMSSearchSettings_Base::IsSetSinglenum(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetSinglenum(void) const
{
    return IsSetSinglenum();
}

inline
void CMSSearchSettings_Base::ResetSinglenum(void)
{
    m_Singlenum = 0;
    m_set_State[0] &= ~0x3000000;
}

inline
CMSSearchSettings_Base::TSinglenum CMSSearchSettings_Base::GetSinglenum(void) const
{
    if (!CanGetSinglenum()) {
        ThrowUnassigned(12);
    }
    return m_Singlenum;
}

inline
void CMSSearchSettings_Base::SetSinglenum(CMSSearchSettings_Base::TSinglenum value)
{
    m_Singlenum = value;
    m_set_State[0] |= 0x3000000;
}

inline
CMSSearchSettings_Base::TSinglenum& CMSSearchSettings_Base::SetSinglenum(void)
{
#ifdef _DEBUG
    if (!IsSetSinglenum()) {
        memset(&m_Singlenum,UnassignedByte(),sizeof(m_Singlenum));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Singlenum;
}

inline
bool CMSSearchSettings_Base::IsSetDoublenum(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetDoublenum(void) const
{
    return IsSetDoublenum();
}

inline
void CMSSearchSettings_Base::ResetDoublenum(void)
{
    m_Doublenum = 0;
    m_set_State[0] &= ~0xc000000;
}

inline
CMSSearchSettings_Base::TDoublenum CMSSearchSettings_Base::GetDoublenum(void) const
{
    if (!CanGetDoublenum()) {
        ThrowUnassigned(13);
    }
    return m_Doublenum;
}

inline
void CMSSearchSettings_Base::SetDoublenum(CMSSearchSettings_Base::TDoublenum value)
{
    m_Doublenum = value;
    m_set_State[0] |= 0xc000000;
}

inline
CMSSearchSettings_Base::TDoublenum& CMSSearchSettings_Base::SetDoublenum(void)
{
#ifdef _DEBUG
    if (!IsSetDoublenum()) {
        memset(&m_Doublenum,UnassignedByte(),sizeof(m_Doublenum));
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Doublenum;
}

inline
bool CMSSearchSettings_Base::IsSetFixed(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetFixed(void) const
{
    return true;
}

inline
const CMSSearchSettings_Base::TFixed& CMSSearchSettings_Base::GetFixed(void) const
{
    return m_Fixed;
}

inline
CMSSearchSettings_Base::TFixed& CMSSearchSettings_Base::SetFixed(void)
{
    m_set_State[0] |= 0x10000000;
    return m_Fixed;
}

inline
bool CMSSearchSettings_Base::IsSetVariable(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetVariable(void) const
{
    return true;
}

inline
const CMSSearchSettings_Base::TVariable& CMSSearchSettings_Base::GetVariable(void) const
{
    return m_Variable;
}

inline
CMSSearchSettings_Base::TVariable& CMSSearchSettings_Base::SetVariable(void)
{
    m_set_State[0] |= 0x40000000;
    return m_Variable;
}

inline
bool CMSSearchSettings_Base::IsSetEnzyme(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetEnzyme(void) const
{
    return IsSetEnzyme();
}

inline
void CMSSearchSettings_Base::ResetEnzyme(void)
{
    m_Enzyme = (int)(0);
    m_set_State[1] &= ~0x3;
}

inline
CMSSearchSettings_Base::TEnzyme CMSSearchSettings_Base::GetEnzyme(void) const
{
    if (!CanGetEnzyme()) {
        ThrowUnassigned(16);
    }
    return m_Enzyme;
}

inline
void CMSSearchSettings_Base::SetEnzyme(CMSSearchSettings_Base::TEnzyme value)
{
    m_Enzyme = value;
    m_set_State[1] |= 0x3;
}

inline
CMSSearchSettings_Base::TEnzyme& CMSSearchSettings_Base::SetEnzyme(void)
{
#ifdef _DEBUG
    if (!IsSetEnzyme()) {
        memset(&m_Enzyme,UnassignedByte(),sizeof(m_Enzyme));
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Enzyme;
}

inline
bool CMSSearchSettings_Base::IsSetMissedcleave(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetMissedcleave(void) const
{
    return IsSetMissedcleave();
}

inline
void CMSSearchSettings_Base::ResetMissedcleave(void)
{
    m_Missedcleave = 0;
    m_set_State[1] &= ~0xc;
}

inline
CMSSearchSettings_Base::TMissedcleave CMSSearchSettings_Base::GetMissedcleave(void) const
{
    if (!CanGetMissedcleave()) {
        ThrowUnassigned(17);
    }
    return m_Missedcleave;
}

inline
void CMSSearchSettings_Base::SetMissedcleave(CMSSearchSettings_Base::TMissedcleave value)
{
    m_Missedcleave = value;
    m_set_State[1] |= 0xc;
}

inline
CMSSearchSettings_Base::TMissedcleave& CMSSearchSettings_Base::SetMissedcleave(void)
{
#ifdef _DEBUG
    if (!IsSetMissedcleave()) {
        memset(&m_Missedcleave,UnassignedByte(),sizeof(m_Missedcleave));
    }
#endif
    m_set_State[1] |= 0x4;
    return m_Missedcleave;
}

inline
bool CMSSearchSettings_Base::IsSetHitlistlen(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetHitlistlen(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetHitlistlen(void)
{
    m_Hitlistlen = 25;
    m_set_State[1] &= ~0x30;
}

inline
void CMSSearchSettings_Base::SetDefaultHitlistlen(void)
{
    ResetHitlistlen();
}

inline
CMSSearchSettings_Base::THitlistlen CMSSearchSettings_Base::GetHitlistlen(void) const
{
    return m_Hitlistlen;
}

inline
void CMSSearchSettings_Base::SetHitlistlen(CMSSearchSettings_Base::THitlistlen value)
{
    m_Hitlistlen = value;
    m_set_State[1] |= 0x30;
}

inline
CMSSearchSettings_Base::THitlistlen& CMSSearchSettings_Base::SetHitlistlen(void)
{
#ifdef _DEBUG
    if (!IsSetHitlistlen()) {
        memset(&m_Hitlistlen,UnassignedByte(),sizeof(m_Hitlistlen));
    }
#endif
    m_set_State[1] |= 0x10;
    return m_Hitlistlen;
}

inline
bool CMSSearchSettings_Base::IsSetDb(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetDb(void) const
{
    return IsSetDb();
}

inline
const CMSSearchSettings_Base::TDb& CMSSearchSettings_Base::GetDb(void) const
{
    if (!CanGetDb()) {
        ThrowUnassigned(19);
    }
    return m_Db;
}

inline
void CMSSearchSettings_Base::SetDb(const CMSSearchSettings_Base::TDb& value)
{
    m_Db = value;
    m_set_State[1] |= 0xc0;
}

inline
void CMSSearchSettings_Base::SetDb(CMSSearchSettings_Base::TDb&& value)
{
    m_Db = std::forward<CMSSearchSettings_Base::TDb>(value);
    m_set_State[1] |= 0xc0;
}

inline
CMSSearchSettings_Base::TDb& CMSSearchSettings_Base::SetDb(void)
{
#ifdef _DEBUG
    if (!IsSetDb()) {
        m_Db = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x40;
    return m_Db;
}

inline
bool CMSSearchSettings_Base::IsSetTophitnum(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetTophitnum(void) const
{
    return IsSetTophitnum();
}

inline
void CMSSearchSettings_Base::ResetTophitnum(void)
{
    m_Tophitnum = 0;
    m_set_State[1] &= ~0x300;
}

inline
CMSSearchSettings_Base::TTophitnum CMSSearchSettings_Base::GetTophitnum(void) const
{
    if (!CanGetTophitnum()) {
        ThrowUnassigned(20);
    }
    return m_Tophitnum;
}

inline
void CMSSearchSettings_Base::SetTophitnum(CMSSearchSettings_Base::TTophitnum value)
{
    m_Tophitnum = value;
    m_set_State[1] |= 0x300;
}

inline
CMSSearchSettings_Base::TTophitnum& CMSSearchSettings_Base::SetTophitnum(void)
{
#ifdef _DEBUG
    if (!IsSetTophitnum()) {
        memset(&m_Tophitnum,UnassignedByte(),sizeof(m_Tophitnum));
    }
#endif
    m_set_State[1] |= 0x100;
    return m_Tophitnum;
}

inline
bool CMSSearchSettings_Base::IsSetMinhit(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetMinhit(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetMinhit(void)
{
    m_Minhit = 2;
    m_set_State[1] &= ~0xc00;
}

inline
void CMSSearchSettings_Base::SetDefaultMinhit(void)
{
    ResetMinhit();
}

inline
CMSSearchSettings_Base::TMinhit CMSSearchSettings_Base::GetMinhit(void) const
{
    return m_Minhit;
}

inline
void CMSSearchSettings_Base::SetMinhit(CMSSearchSettings_Base::TMinhit value)
{
    m_Minhit = value;
    m_set_State[1] |= 0xc00;
}

inline
CMSSearchSettings_Base::TMinhit& CMSSearchSettings_Base::SetMinhit(void)
{
#ifdef _DEBUG
    if (!IsSetMinhit()) {
        memset(&m_Minhit,UnassignedByte(),sizeof(m_Minhit));
    }
#endif
    m_set_State[1] |= 0x400;
    return m_Minhit;
}

inline
bool CMSSearchSettings_Base::IsSetMinspectra(void) const
{
    return ((m_set_State[1] & 0x3000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetMinspectra(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetMinspectra(void)
{
    m_Minspectra = 4;
    m_set_State[1] &= ~0x3000;
}

inline
void CMSSearchSettings_Base::SetDefaultMinspectra(void)
{
    ResetMinspectra();
}

inline
CMSSearchSettings_Base::TMinspectra CMSSearchSettings_Base::GetMinspectra(void) const
{
    return m_Minspectra;
}

inline
void CMSSearchSettings_Base::SetMinspectra(CMSSearchSettings_Base::TMinspectra value)
{
    m_Minspectra = value;
    m_set_State[1] |= 0x3000;
}

inline
CMSSearchSettings_Base::TMinspectra& CMSSearchSettings_Base::SetMinspectra(void)
{
#ifdef _DEBUG
    if (!IsSetMinspectra()) {
        memset(&m_Minspectra,UnassignedByte(),sizeof(m_Minspectra));
    }
#endif
    m_set_State[1] |= 0x1000;
    return m_Minspectra;
}

inline
bool CMSSearchSettings_Base::IsSetScale(void) const
{
    return ((m_set_State[1] & 0xc000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetScale(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetScale(void)
{
    m_Scale = 100;
    m_set_State[1] &= ~0xc000;
}

inline
void CMSSearchSettings_Base::SetDefaultScale(void)
{
    ResetScale();
}

inline
CMSSearchSettings_Base::TScale CMSSearchSettings_Base::GetScale(void) const
{
    return m_Scale;
}

inline
void CMSSearchSettings_Base::SetScale(CMSSearchSettings_Base::TScale value)
{
    m_Scale = value;
    m_set_State[1] |= 0xc000;
}

inline
CMSSearchSettings_Base::TScale& CMSSearchSettings_Base::SetScale(void)
{
#ifdef _DEBUG
    if (!IsSetScale()) {
        memset(&m_Scale,UnassignedByte(),sizeof(m_Scale));
    }
#endif
    m_set_State[1] |= 0x4000;
    return m_Scale;
}

inline
bool CMSSearchSettings_Base::IsSetMaxmods(void) const
{
    return ((m_set_State[1] & 0x30000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetMaxmods(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetMaxmods(void)
{
    m_Maxmods = 64;
    m_set_State[1] &= ~0x30000;
}

inline
void CMSSearchSettings_Base::SetDefaultMaxmods(void)
{
    ResetMaxmods();
}

inline
CMSSearchSettings_Base::TMaxmods CMSSearchSettings_Base::GetMaxmods(void) const
{
    return m_Maxmods;
}

inline
void CMSSearchSettings_Base::SetMaxmods(CMSSearchSettings_Base::TMaxmods value)
{
    m_Maxmods = value;
    m_set_State[1] |= 0x30000;
}

inline
CMSSearchSettings_Base::TMaxmods& CMSSearchSettings_Base::SetMaxmods(void)
{
#ifdef _DEBUG
    if (!IsSetMaxmods()) {
        memset(&m_Maxmods,UnassignedByte(),sizeof(m_Maxmods));
    }
#endif
    m_set_State[1] |= 0x10000;
    return m_Maxmods;
}

inline
bool CMSSearchSettings_Base::IsSetTaxids(void) const
{
    return ((m_set_State[1] & 0xc0000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetTaxids(void) const
{
    return true;
}

inline
const CMSSearchSettings_Base::TTaxids& CMSSearchSettings_Base::GetTaxids(void) const
{
    return m_Taxids;
}

inline
CMSSearchSettings_Base::TTaxids& CMSSearchSettings_Base::SetTaxids(void)
{
    m_set_State[1] |= 0x40000;
    return m_Taxids;
}

inline
bool CMSSearchSettings_Base::IsSetChargehandling(void) const
{
    return m_Chargehandling.NotEmpty();
}

inline
bool CMSSearchSettings_Base::CanGetChargehandling(void) const
{
    return IsSetChargehandling();
}

inline
const CMSSearchSettings_Base::TChargehandling& CMSSearchSettings_Base::GetChargehandling(void) const
{
    if (!CanGetChargehandling()) {
        ThrowUnassigned(26);
    }
    return (*m_Chargehandling);
}

inline
bool CMSSearchSettings_Base::IsSetUsermods(void) const
{
    return m_Usermods.NotEmpty();
}

inline
bool CMSSearchSettings_Base::CanGetUsermods(void) const
{
    return IsSetUsermods();
}

inline
const CMSSearchSettings_Base::TUsermods& CMSSearchSettings_Base::GetUsermods(void) const
{
    if (!CanGetUsermods()) {
        ThrowUnassigned(27);
    }
    return (*m_Usermods);
}

inline
bool CMSSearchSettings_Base::IsSetPseudocount(void) const
{
    return ((m_set_State[1] & 0x3000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetPseudocount(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetPseudocount(void)
{
    m_Pseudocount = 1;
    m_set_State[1] &= ~0x3000000;
}

inline
void CMSSearchSettings_Base::SetDefaultPseudocount(void)
{
    ResetPseudocount();
}

inline
CMSSearchSettings_Base::TPseudocount CMSSearchSettings_Base::GetPseudocount(void) const
{
    return m_Pseudocount;
}

inline
void CMSSearchSettings_Base::SetPseudocount(CMSSearchSettings_Base::TPseudocount value)
{
    m_Pseudocount = value;
    m_set_State[1] |= 0x3000000;
}

inline
CMSSearchSettings_Base::TPseudocount& CMSSearchSettings_Base::SetPseudocount(void)
{
#ifdef _DEBUG
    if (!IsSetPseudocount()) {
        memset(&m_Pseudocount,UnassignedByte(),sizeof(m_Pseudocount));
    }
#endif
    m_set_State[1] |= 0x1000000;
    return m_Pseudocount;
}

inline
bool CMSSearchSettings_Base::IsSetSearchb1(void) const
{
    return ((m_set_State[1] & 0xc000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetSearchb1(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetSearchb1(void)
{
    m_Searchb1 = 0;
    m_set_State[1] &= ~0xc000000;
}

inline
void CMSSearchSettings_Base::SetDefaultSearchb1(void)
{
    ResetSearchb1();
}

inline
CMSSearchSettings_Base::TSearchb1 CMSSearchSettings_Base::GetSearchb1(void) const
{
    return m_Searchb1;
}

inline
void CMSSearchSettings_Base::SetSearchb1(CMSSearchSettings_Base::TSearchb1 value)
{
    m_Searchb1 = value;
    m_set_State[1] |= 0xc000000;
}

inline
CMSSearchSettings_Base::TSearchb1& CMSSearchSettings_Base::SetSearchb1(void)
{
#ifdef _DEBUG
    if (!IsSetSearchb1()) {
        memset(&m_Searchb1,UnassignedByte(),sizeof(m_Searchb1));
    }
#endif
    m_set_State[1] |= 0x4000000;
    return m_Searchb1;
}

inline
bool CMSSearchSettings_Base::IsSetSearchctermproduct(void) const
{
    return ((m_set_State[1] & 0x30000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetSearchctermproduct(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetSearchctermproduct(void)
{
    m_Searchctermproduct = 0;
    m_set_State[1] &= ~0x30000000;
}

inline
void CMSSearchSettings_Base::SetDefaultSearchctermproduct(void)
{
    ResetSearchctermproduct();
}

inline
CMSSearchSettings_Base::TSearchctermproduct CMSSearchSettings_Base::GetSearchctermproduct(void) const
{
    return m_Searchctermproduct;
}

inline
void CMSSearchSettings_Base::SetSearchctermproduct(CMSSearchSettings_Base::TSearchctermproduct value)
{
    m_Searchctermproduct = value;
    m_set_State[1] |= 0x30000000;
}

inline
CMSSearchSettings_Base::TSearchctermproduct& CMSSearchSettings_Base::SetSearchctermproduct(void)
{
#ifdef _DEBUG
    if (!IsSetSearchctermproduct()) {
        memset(&m_Searchctermproduct,UnassignedByte(),sizeof(m_Searchctermproduct));
    }
#endif
    m_set_State[1] |= 0x10000000;
    return m_Searchctermproduct;
}

inline
bool CMSSearchSettings_Base::IsSetMaxproductions(void) const
{
    return ((m_set_State[1] & 0xc0000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetMaxproductions(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetMaxproductions(void)
{
    m_Maxproductions = 0;
    m_set_State[1] &= ~0xc0000000;
}

inline
void CMSSearchSettings_Base::SetDefaultMaxproductions(void)
{
    ResetMaxproductions();
}

inline
CMSSearchSettings_Base::TMaxproductions CMSSearchSettings_Base::GetMaxproductions(void) const
{
    return m_Maxproductions;
}

inline
void CMSSearchSettings_Base::SetMaxproductions(CMSSearchSettings_Base::TMaxproductions value)
{
    m_Maxproductions = value;
    m_set_State[1] |= 0xc0000000;
}

inline
CMSSearchSettings_Base::TMaxproductions& CMSSearchSettings_Base::SetMaxproductions(void)
{
#ifdef _DEBUG
    if (!IsSetMaxproductions()) {
        memset(&m_Maxproductions,UnassignedByte(),sizeof(m_Maxproductions));
    }
#endif
    m_set_State[1] |= 0x40000000;
    return m_Maxproductions;
}

inline
bool CMSSearchSettings_Base::IsSetMinnoenzyme(void) const
{
    return ((m_set_State[2] & 0x3) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetMinnoenzyme(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetMinnoenzyme(void)
{
    m_Minnoenzyme = 4;
    m_set_State[2] &= ~0x3;
}

inline
void CMSSearchSettings_Base::SetDefaultMinnoenzyme(void)
{
    ResetMinnoenzyme();
}

inline
CMSSearchSettings_Base::TMinnoenzyme CMSSearchSettings_Base::GetMinnoenzyme(void) const
{
    return m_Minnoenzyme;
}

inline
void CMSSearchSettings_Base::SetMinnoenzyme(CMSSearchSettings_Base::TMinnoenzyme value)
{
    m_Minnoenzyme = value;
    m_set_State[2] |= 0x3;
}

inline
CMSSearchSettings_Base::TMinnoenzyme& CMSSearchSettings_Base::SetMinnoenzyme(void)
{
#ifdef _DEBUG
    if (!IsSetMinnoenzyme()) {
        memset(&m_Minnoenzyme,UnassignedByte(),sizeof(m_Minnoenzyme));
    }
#endif
    m_set_State[2] |= 0x1;
    return m_Minnoenzyme;
}

inline
bool CMSSearchSettings_Base::IsSetMaxnoenzyme(void) const
{
    return ((m_set_State[2] & 0xc) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetMaxnoenzyme(void) const
{
    return true;
}

inline
void CMSSearchSettings_Base::ResetMaxnoenzyme(void)
{
    m_Maxnoenzyme = 0;
    m_set_State[2] &= ~0xc;
}

inline
void CMSSearchSettings_Base::SetDefaultMaxnoenzyme(void)
{
    ResetMaxnoenzyme();
}

inline
CMSSearchSettings_Base::TMaxnoenzyme CMSSearchSettings_Base::GetMaxnoenzyme(void) const
{
    return m_Maxnoenzyme;
}

inline
void CMSSearchSettings_Base::SetMaxnoenzyme(CMSSearchSettings_Base::TMaxnoenzyme value)
{
    m_Maxnoenzyme = value;
    m_set_State[2] |= 0xc;
}

inline
CMSSearchSettings_Base::TMaxnoenzyme& CMSSearchSettings_Base::SetMaxnoenzyme(void)
{
#ifdef _DEBUG
    if (!IsSetMaxnoenzyme()) {
        memset(&m_Maxnoenzyme,UnassignedByte(),sizeof(m_Maxnoenzyme));
    }
#endif
    m_set_State[2] |= 0x4;
    return m_Maxnoenzyme;
}

inline
bool CMSSearchSettings_Base::IsSetExactmass(void) const
{
    return ((m_set_State[2] & 0x30) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetExactmass(void) const
{
    return IsSetExactmass();
}

inline
void CMSSearchSettings_Base::ResetExactmass(void)
{
    m_Exactmass = 0;
    m_set_State[2] &= ~0x30;
}

inline
CMSSearchSettings_Base::TExactmass CMSSearchSettings_Base::GetExactmass(void) const
{
    if (!CanGetExactmass()) {
        ThrowUnassigned(34);
    }
    return m_Exactmass;
}

inline
void CMSSearchSettings_Base::SetExactmass(CMSSearchSettings_Base::TExactmass value)
{
    m_Exactmass = value;
    m_set_State[2] |= 0x30;
}

inline
CMSSearchSettings_Base::TExactmass& CMSSearchSettings_Base::SetExactmass(void)
{
#ifdef _DEBUG
    if (!IsSetExactmass()) {
        memset(&m_Exactmass,UnassignedByte(),sizeof(m_Exactmass));
    }
#endif
    m_set_State[2] |= 0x10;
    return m_Exactmass;
}

inline
bool CMSSearchSettings_Base::IsSetSettingid(void) const
{
    return ((m_set_State[2] & 0xc0) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetSettingid(void) const
{
    return IsSetSettingid();
}

inline
void CMSSearchSettings_Base::ResetSettingid(void)
{
    m_Settingid = 0;
    m_set_State[2] &= ~0xc0;
}

inline
CMSSearchSettings_Base::TSettingid CMSSearchSettings_Base::GetSettingid(void) const
{
    if (!CanGetSettingid()) {
        ThrowUnassigned(35);
    }
    return m_Settingid;
}

inline
void CMSSearchSettings_Base::SetSettingid(CMSSearchSettings_Base::TSettingid value)
{
    m_Settingid = value;
    m_set_State[2] |= 0xc0;
}

inline
CMSSearchSettings_Base::TSettingid& CMSSearchSettings_Base::SetSettingid(void)
{
#ifdef _DEBUG
    if (!IsSetSettingid()) {
        memset(&m_Settingid,UnassignedByte(),sizeof(m_Settingid));
    }
#endif
    m_set_State[2] |= 0x40;
    return m_Settingid;
}

inline
bool CMSSearchSettings_Base::IsSetIterativesettings(void) const
{
    return m_Iterativesettings.NotEmpty();
}

inline
bool CMSSearchSettings_Base::CanGetIterativesettings(void) const
{
    return IsSetIterativesettings();
}

inline
const CMSSearchSettings_Base::TIterativesettings& CMSSearchSettings_Base::GetIterativesettings(void) const
{
    if (!CanGetIterativesettings()) {
        ThrowUnassigned(36);
    }
    return (*m_Iterativesettings);
}

inline
bool CMSSearchSettings_Base::IsSetPrecursorcull(void) const
{
    return ((m_set_State[2] & 0xc00) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetPrecursorcull(void) const
{
    return IsSetPrecursorcull();
}

inline
void CMSSearchSettings_Base::ResetPrecursorcull(void)
{
    m_Precursorcull = 0;
    m_set_State[2] &= ~0xc00;
}

inline
CMSSearchSettings_Base::TPrecursorcull CMSSearchSettings_Base::GetPrecursorcull(void) const
{
    if (!CanGetPrecursorcull()) {
        ThrowUnassigned(37);
    }
    return m_Precursorcull;
}

inline
void CMSSearchSettings_Base::SetPrecursorcull(CMSSearchSettings_Base::TPrecursorcull value)
{
    m_Precursorcull = value;
    m_set_State[2] |= 0xc00;
}

inline
CMSSearchSettings_Base::TPrecursorcull& CMSSearchSettings_Base::SetPrecursorcull(void)
{
#ifdef _DEBUG
    if (!IsSetPrecursorcull()) {
        memset(&m_Precursorcull,UnassignedByte(),sizeof(m_Precursorcull));
    }
#endif
    m_set_State[2] |= 0x400;
    return m_Precursorcull;
}

inline
bool CMSSearchSettings_Base::IsSetInfiles(void) const
{
    return ((m_set_State[2] & 0x3000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetInfiles(void) const
{
    return true;
}

inline
const CMSSearchSettings_Base::TInfiles& CMSSearchSettings_Base::GetInfiles(void) const
{
    return m_Infiles;
}

inline
CMSSearchSettings_Base::TInfiles& CMSSearchSettings_Base::SetInfiles(void)
{
    m_set_State[2] |= 0x1000;
    return m_Infiles;
}

inline
bool CMSSearchSettings_Base::IsSetOutfiles(void) const
{
    return ((m_set_State[2] & 0xc000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetOutfiles(void) const
{
    return true;
}

inline
const CMSSearchSettings_Base::TOutfiles& CMSSearchSettings_Base::GetOutfiles(void) const
{
    return m_Outfiles;
}

inline
CMSSearchSettings_Base::TOutfiles& CMSSearchSettings_Base::SetOutfiles(void)
{
    m_set_State[2] |= 0x4000;
    return m_Outfiles;
}

inline
bool CMSSearchSettings_Base::IsSetNocorrelationscore(void) const
{
    return ((m_set_State[2] & 0x30000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetNocorrelationscore(void) const
{
    return IsSetNocorrelationscore();
}

inline
void CMSSearchSettings_Base::ResetNocorrelationscore(void)
{
    m_Nocorrelationscore = 0;
    m_set_State[2] &= ~0x30000;
}

inline
CMSSearchSettings_Base::TNocorrelationscore CMSSearchSettings_Base::GetNocorrelationscore(void) const
{
    if (!CanGetNocorrelationscore()) {
        ThrowUnassigned(40);
    }
    return m_Nocorrelationscore;
}

inline
void CMSSearchSettings_Base::SetNocorrelationscore(CMSSearchSettings_Base::TNocorrelationscore value)
{
    m_Nocorrelationscore = value;
    m_set_State[2] |= 0x30000;
}

inline
CMSSearchSettings_Base::TNocorrelationscore& CMSSearchSettings_Base::SetNocorrelationscore(void)
{
#ifdef _DEBUG
    if (!IsSetNocorrelationscore()) {
        memset(&m_Nocorrelationscore,UnassignedByte(),sizeof(m_Nocorrelationscore));
    }
#endif
    m_set_State[2] |= 0x10000;
    return m_Nocorrelationscore;
}

inline
bool CMSSearchSettings_Base::IsSetProbfollowingion(void) const
{
    return ((m_set_State[2] & 0xc0000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetProbfollowingion(void) const
{
    return IsSetProbfollowingion();
}

inline
void CMSSearchSettings_Base::ResetProbfollowingion(void)
{
    m_Probfollowingion = 0;
    m_set_State[2] &= ~0xc0000;
}

inline
CMSSearchSettings_Base::TProbfollowingion CMSSearchSettings_Base::GetProbfollowingion(void) const
{
    if (!CanGetProbfollowingion()) {
        ThrowUnassigned(41);
    }
    return m_Probfollowingion;
}

inline
void CMSSearchSettings_Base::SetProbfollowingion(CMSSearchSettings_Base::TProbfollowingion value)
{
    m_Probfollowingion = value;
    m_set_State[2] |= 0xc0000;
}

inline
CMSSearchSettings_Base::TProbfollowingion& CMSSearchSettings_Base::SetProbfollowingion(void)
{
#ifdef _DEBUG
    if (!IsSetProbfollowingion()) {
        memset(&m_Probfollowingion,UnassignedByte(),sizeof(m_Probfollowingion));
    }
#endif
    m_set_State[2] |= 0x40000;
    return m_Probfollowingion;
}

inline
bool CMSSearchSettings_Base::IsSetNmethionine(void) const
{
    return ((m_set_State[2] & 0x300000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetNmethionine(void) const
{
    return IsSetNmethionine();
}

inline
void CMSSearchSettings_Base::ResetNmethionine(void)
{
    m_Nmethionine = 0;
    m_set_State[2] &= ~0x300000;
}

inline
CMSSearchSettings_Base::TNmethionine CMSSearchSettings_Base::GetNmethionine(void) const
{
    if (!CanGetNmethionine()) {
        ThrowUnassigned(42);
    }
    return m_Nmethionine;
}

inline
void CMSSearchSettings_Base::SetNmethionine(CMSSearchSettings_Base::TNmethionine value)
{
    m_Nmethionine = value;
    m_set_State[2] |= 0x300000;
}

inline
CMSSearchSettings_Base::TNmethionine& CMSSearchSettings_Base::SetNmethionine(void)
{
#ifdef _DEBUG
    if (!IsSetNmethionine()) {
        memset(&m_Nmethionine,UnassignedByte(),sizeof(m_Nmethionine));
    }
#endif
    m_set_State[2] |= 0x100000;
    return m_Nmethionine;
}

inline
bool CMSSearchSettings_Base::IsSetAutomassadjust(void) const
{
    return ((m_set_State[2] & 0xc00000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetAutomassadjust(void) const
{
    return IsSetAutomassadjust();
}

inline
void CMSSearchSettings_Base::ResetAutomassadjust(void)
{
    m_Automassadjust = 0;
    m_set_State[2] &= ~0xc00000;
}

inline
CMSSearchSettings_Base::TAutomassadjust CMSSearchSettings_Base::GetAutomassadjust(void) const
{
    if (!CanGetAutomassadjust()) {
        ThrowUnassigned(43);
    }
    return m_Automassadjust;
}

inline
void CMSSearchSettings_Base::SetAutomassadjust(CMSSearchSettings_Base::TAutomassadjust value)
{
    m_Automassadjust = value;
    m_set_State[2] |= 0xc00000;
}

inline
CMSSearchSettings_Base::TAutomassadjust& CMSSearchSettings_Base::SetAutomassadjust(void)
{
#ifdef _DEBUG
    if (!IsSetAutomassadjust()) {
        memset(&m_Automassadjust,UnassignedByte(),sizeof(m_Automassadjust));
    }
#endif
    m_set_State[2] |= 0x400000;
    return m_Automassadjust;
}

inline
bool CMSSearchSettings_Base::IsSetLomasscutoff(void) const
{
    return ((m_set_State[2] & 0x3000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetLomasscutoff(void) const
{
    return IsSetLomasscutoff();
}

inline
void CMSSearchSettings_Base::ResetLomasscutoff(void)
{
    m_Lomasscutoff = 0;
    m_set_State[2] &= ~0x3000000;
}

inline
CMSSearchSettings_Base::TLomasscutoff CMSSearchSettings_Base::GetLomasscutoff(void) const
{
    if (!CanGetLomasscutoff()) {
        ThrowUnassigned(44);
    }
    return m_Lomasscutoff;
}

inline
void CMSSearchSettings_Base::SetLomasscutoff(CMSSearchSettings_Base::TLomasscutoff value)
{
    m_Lomasscutoff = value;
    m_set_State[2] |= 0x3000000;
}

inline
CMSSearchSettings_Base::TLomasscutoff& CMSSearchSettings_Base::SetLomasscutoff(void)
{
#ifdef _DEBUG
    if (!IsSetLomasscutoff()) {
        memset(&m_Lomasscutoff,UnassignedByte(),sizeof(m_Lomasscutoff));
    }
#endif
    m_set_State[2] |= 0x1000000;
    return m_Lomasscutoff;
}

inline
bool CMSSearchSettings_Base::IsSetLibsearchsettings(void) const
{
    return m_Libsearchsettings.NotEmpty();
}

inline
bool CMSSearchSettings_Base::CanGetLibsearchsettings(void) const
{
    return IsSetLibsearchsettings();
}

inline
const CMSSearchSettings_Base::TLibsearchsettings& CMSSearchSettings_Base::GetLibsearchsettings(void) const
{
    if (!CanGetLibsearchsettings()) {
        ThrowUnassigned(45);
    }
    return (*m_Libsearchsettings);
}

inline
bool CMSSearchSettings_Base::IsSetNoprolineions(void) const
{
    return ((m_set_State[2] & 0x30000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetNoprolineions(void) const
{
    return true;
}

inline
const CMSSearchSettings_Base::TNoprolineions& CMSSearchSettings_Base::GetNoprolineions(void) const
{
    return m_Noprolineions;
}

inline
CMSSearchSettings_Base::TNoprolineions& CMSSearchSettings_Base::SetNoprolineions(void)
{
    m_set_State[2] |= 0x10000000;
    return m_Noprolineions;
}

inline
bool CMSSearchSettings_Base::IsSetReversesearch(void) const
{
    return ((m_set_State[2] & 0xc0000000) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetReversesearch(void) const
{
    return IsSetReversesearch();
}

inline
void CMSSearchSettings_Base::ResetReversesearch(void)
{
    m_Reversesearch = 0;
    m_set_State[2] &= ~0xc0000000;
}

inline
CMSSearchSettings_Base::TReversesearch CMSSearchSettings_Base::GetReversesearch(void) const
{
    if (!CanGetReversesearch()) {
        ThrowUnassigned(47);
    }
    return m_Reversesearch;
}

inline
void CMSSearchSettings_Base::SetReversesearch(CMSSearchSettings_Base::TReversesearch value)
{
    m_Reversesearch = value;
    m_set_State[2] |= 0xc0000000;
}

inline
CMSSearchSettings_Base::TReversesearch& CMSSearchSettings_Base::SetReversesearch(void)
{
#ifdef _DEBUG
    if (!IsSetReversesearch()) {
        memset(&m_Reversesearch,UnassignedByte(),sizeof(m_Reversesearch));
    }
#endif
    m_set_State[2] |= 0x40000000;
    return m_Reversesearch;
}

inline
bool CMSSearchSettings_Base::IsSetOthersettings(void) const
{
    return ((m_set_State[3] & 0x3) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetOthersettings(void) const
{
    return true;
}

inline
const CMSSearchSettings_Base::TOthersettings& CMSSearchSettings_Base::GetOthersettings(void) const
{
    return m_Othersettings;
}

inline
CMSSearchSettings_Base::TOthersettings& CMSSearchSettings_Base::SetOthersettings(void)
{
    m_set_State[3] |= 0x1;
    return m_Othersettings;
}

inline
bool CMSSearchSettings_Base::IsSetNumisotopes(void) const
{
    return ((m_set_State[3] & 0xc) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetNumisotopes(void) const
{
    return IsSetNumisotopes();
}

inline
void CMSSearchSettings_Base::ResetNumisotopes(void)
{
    m_Numisotopes = 0;
    m_set_State[3] &= ~0xc;
}

inline
CMSSearchSettings_Base::TNumisotopes CMSSearchSettings_Base::GetNumisotopes(void) const
{
    if (!CanGetNumisotopes()) {
        ThrowUnassigned(49);
    }
    return m_Numisotopes;
}

inline
void CMSSearchSettings_Base::SetNumisotopes(CMSSearchSettings_Base::TNumisotopes value)
{
    m_Numisotopes = value;
    m_set_State[3] |= 0xc;
}

inline
CMSSearchSettings_Base::TNumisotopes& CMSSearchSettings_Base::SetNumisotopes(void)
{
#ifdef _DEBUG
    if (!IsSetNumisotopes()) {
        memset(&m_Numisotopes,UnassignedByte(),sizeof(m_Numisotopes));
    }
#endif
    m_set_State[3] |= 0x4;
    return m_Numisotopes;
}

inline
bool CMSSearchSettings_Base::IsSetPepppm(void) const
{
    return ((m_set_State[3] & 0x30) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetPepppm(void) const
{
    return IsSetPepppm();
}

inline
void CMSSearchSettings_Base::ResetPepppm(void)
{
    m_Pepppm = 0;
    m_set_State[3] &= ~0x30;
}

inline
CMSSearchSettings_Base::TPepppm CMSSearchSettings_Base::GetPepppm(void) const
{
    if (!CanGetPepppm()) {
        ThrowUnassigned(50);
    }
    return m_Pepppm;
}

inline
void CMSSearchSettings_Base::SetPepppm(CMSSearchSettings_Base::TPepppm value)
{
    m_Pepppm = value;
    m_set_State[3] |= 0x30;
}

inline
CMSSearchSettings_Base::TPepppm& CMSSearchSettings_Base::SetPepppm(void)
{
#ifdef _DEBUG
    if (!IsSetPepppm()) {
        memset(&m_Pepppm,UnassignedByte(),sizeof(m_Pepppm));
    }
#endif
    m_set_State[3] |= 0x10;
    return m_Pepppm;
}

inline
bool CMSSearchSettings_Base::IsSetMsmsppm(void) const
{
    return ((m_set_State[3] & 0xc0) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetMsmsppm(void) const
{
    return IsSetMsmsppm();
}

inline
void CMSSearchSettings_Base::ResetMsmsppm(void)
{
    m_Msmsppm = 0;
    m_set_State[3] &= ~0xc0;
}

inline
CMSSearchSettings_Base::TMsmsppm CMSSearchSettings_Base::GetMsmsppm(void) const
{
    if (!CanGetMsmsppm()) {
        ThrowUnassigned(51);
    }
    return m_Msmsppm;
}

inline
void CMSSearchSettings_Base::SetMsmsppm(CMSSearchSettings_Base::TMsmsppm value)
{
    m_Msmsppm = value;
    m_set_State[3] |= 0xc0;
}

inline
CMSSearchSettings_Base::TMsmsppm& CMSSearchSettings_Base::SetMsmsppm(void)
{
#ifdef _DEBUG
    if (!IsSetMsmsppm()) {
        memset(&m_Msmsppm,UnassignedByte(),sizeof(m_Msmsppm));
    }
#endif
    m_set_State[3] |= 0x40;
    return m_Msmsppm;
}

inline
bool CMSSearchSettings_Base::IsSetReportedhitcount(void) const
{
    return ((m_set_State[3] & 0x300) != 0);
}

inline
bool CMSSearchSettings_Base::CanGetReportedhitcount(void) const
{
    return IsSetReportedhitcount();
}

inline
void CMSSearchSettings_Base::ResetReportedhitcount(void)
{
    m_Reportedhitcount = 0;
    m_set_State[3] &= ~0x300;
}

inline
CMSSearchSettings_Base::TReportedhitcount CMSSearchSettings_Base::GetReportedhitcount(void) const
{
    if (!CanGetReportedhitcount()) {
        ThrowUnassigned(52);
    }
    return m_Reportedhitcount;
}

inline
void CMSSearchSettings_Base::SetReportedhitcount(CMSSearchSettings_Base::TReportedhitcount value)
{
    m_Reportedhitcount = value;
    m_set_State[3] |= 0x300;
}

inline
CMSSearchSettings_Base::TReportedhitcount& CMSSearchSettings_Base::SetReportedhitcount(void)
{
#ifdef _DEBUG
    if (!IsSetReportedhitcount()) {
        memset(&m_Reportedhitcount,UnassignedByte(),sizeof(m_Reportedhitcount));
    }
#endif
    m_set_State[3] |= 0x100;
    return m_Reportedhitcount;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSSEARCHSETTINGS_BASE_HPP
