/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSIon_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSION_BASE_HPP
#define OBJECTS_OMSSA_MSION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/omssa/MSIonIsotopicType.hpp>
#include <objects/omssa/MSIonNeutralLoss.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMSImmonium;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// ion type at a finer level than ion series
class NCBI_OMSSA_EXPORT CMSIon_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSIon_Base(void);
    // destructor
    virtual ~CMSIon_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNeutralloss;
    typedef int TIsotope;
    typedef string TInternal;
    typedef CMSImmonium TImmonium;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_neutralloss,
        e_isotope,
        e_internal,
        e_immonium
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// is this peak a neutral loss?
    /// optional
    /// typedef int TNeutralloss
    ///  Check whether the Neutralloss data member has been assigned a value.
    bool IsSetNeutralloss(void) const;
    /// Check whether it is safe or not to call GetNeutralloss method.
    bool CanGetNeutralloss(void) const;
    void ResetNeutralloss(void);
    TNeutralloss GetNeutralloss(void) const;
    void SetNeutralloss(TNeutralloss value);
    TNeutralloss& SetNeutralloss(void);

    /// isotopic composition of peak
    /// optional
    /// typedef int TIsotope
    ///  Check whether the Isotope data member has been assigned a value.
    bool IsSetIsotope(void) const;
    /// Check whether it is safe or not to call GetIsotope method.
    bool CanGetIsotope(void) const;
    void ResetIsotope(void);
    TIsotope GetIsotope(void) const;
    void SetIsotope(TIsotope value);
    TIsotope& SetIsotope(void);

    /// if iontype is internal, this is the internal sequence
    /// optional
    /// typedef string TInternal
    ///  Check whether the Internal data member has been assigned a value.
    bool IsSetInternal(void) const;
    /// Check whether it is safe or not to call GetInternal method.
    bool CanGetInternal(void) const;
    void ResetInternal(void);
    const TInternal& GetInternal(void) const;
    void SetInternal(const TInternal& value);
    void SetInternal(TInternal&& value);
    TInternal& SetInternal(void);

    /// if iontype is immonium, show characteristics
    /// optional
    /// typedef CMSImmonium TImmonium
    ///  Check whether the Immonium data member has been assigned a value.
    bool IsSetImmonium(void) const;
    /// Check whether it is safe or not to call GetImmonium method.
    bool CanGetImmonium(void) const;
    void ResetImmonium(void);
    const TImmonium& GetImmonium(void) const;
    void SetImmonium(TImmonium& value);
    TImmonium& SetImmonium(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSIon_Base(const CMSIon_Base&);
    CMSIon_Base& operator=(const CMSIon_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Neutralloss;
    int m_Isotope;
    string m_Internal;
    CRef< TImmonium > m_Immonium;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSIon_Base::IsSetNeutralloss(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSIon_Base::CanGetNeutralloss(void) const
{
    return IsSetNeutralloss();
}

inline
void CMSIon_Base::ResetNeutralloss(void)
{
    m_Neutralloss = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CMSIon_Base::TNeutralloss CMSIon_Base::GetNeutralloss(void) const
{
    if (!CanGetNeutralloss()) {
        ThrowUnassigned(0);
    }
    return m_Neutralloss;
}

inline
void CMSIon_Base::SetNeutralloss(CMSIon_Base::TNeutralloss value)
{
    m_Neutralloss = value;
    m_set_State[0] |= 0x3;
}

inline
CMSIon_Base::TNeutralloss& CMSIon_Base::SetNeutralloss(void)
{
#ifdef _DEBUG
    if (!IsSetNeutralloss()) {
        memset(&m_Neutralloss,UnassignedByte(),sizeof(m_Neutralloss));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Neutralloss;
}

inline
bool CMSIon_Base::IsSetIsotope(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSIon_Base::CanGetIsotope(void) const
{
    return IsSetIsotope();
}

inline
void CMSIon_Base::ResetIsotope(void)
{
    m_Isotope = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CMSIon_Base::TIsotope CMSIon_Base::GetIsotope(void) const
{
    if (!CanGetIsotope()) {
        ThrowUnassigned(1);
    }
    return m_Isotope;
}

inline
void CMSIon_Base::SetIsotope(CMSIon_Base::TIsotope value)
{
    m_Isotope = value;
    m_set_State[0] |= 0xc;
}

inline
CMSIon_Base::TIsotope& CMSIon_Base::SetIsotope(void)
{
#ifdef _DEBUG
    if (!IsSetIsotope()) {
        memset(&m_Isotope,UnassignedByte(),sizeof(m_Isotope));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Isotope;
}

inline
bool CMSIon_Base::IsSetInternal(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSIon_Base::CanGetInternal(void) const
{
    return IsSetInternal();
}

inline
const CMSIon_Base::TInternal& CMSIon_Base::GetInternal(void) const
{
    if (!CanGetInternal()) {
        ThrowUnassigned(2);
    }
    return m_Internal;
}

inline
void CMSIon_Base::SetInternal(const CMSIon_Base::TInternal& value)
{
    m_Internal = value;
    m_set_State[0] |= 0x30;
}

inline
void CMSIon_Base::SetInternal(CMSIon_Base::TInternal&& value)
{
    m_Internal = std::forward<CMSIon_Base::TInternal>(value);
    m_set_State[0] |= 0x30;
}

inline
CMSIon_Base::TInternal& CMSIon_Base::SetInternal(void)
{
#ifdef _DEBUG
    if (!IsSetInternal()) {
        m_Internal = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Internal;
}

inline
bool CMSIon_Base::IsSetImmonium(void) const
{
    return m_Immonium.NotEmpty();
}

inline
bool CMSIon_Base::CanGetImmonium(void) const
{
    return IsSetImmonium();
}

inline
const CMSIon_Base::TImmonium& CMSIon_Base::GetImmonium(void) const
{
    if (!CanGetImmonium()) {
        ThrowUnassigned(3);
    }
    return (*m_Immonium);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSION_BASE_HPP
