/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PrintFormat_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'objprt.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OBJPRT_PRINTFORMAT_BASE_HPP
#define OBJECTS_OBJPRT_PRINTFORMAT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPrintForm;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_OBJPRT_EXPORT CPrintFormat_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPrintFormat_Base(void);
    // destructor
    virtual ~CPrintFormat_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TAsn1;
    typedef string TLabel;
    typedef string TPrefix;
    typedef string TSuffix;
    typedef CPrintForm TForm;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_asn1,
        e_label,
        e_prefix,
        e_suffix,
        e_form
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// ASN.1 partial path for this
    /// mandatory
    /// typedef string TAsn1
    ///  Check whether the Asn1 data member has been assigned a value.
    bool IsSetAsn1(void) const;
    /// Check whether it is safe or not to call GetAsn1 method.
    bool CanGetAsn1(void) const;
    void ResetAsn1(void);
    const TAsn1& GetAsn1(void) const;
    void SetAsn1(const TAsn1& value);
    void SetAsn1(TAsn1&& value);
    TAsn1& SetAsn1(void);

    /// printable label
    /// optional
    /// typedef string TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    const TLabel& GetLabel(void) const;
    void SetLabel(const TLabel& value);
    void SetLabel(TLabel&& value);
    TLabel& SetLabel(void);

    /// optional
    /// typedef string TPrefix
    ///  Check whether the Prefix data member has been assigned a value.
    bool IsSetPrefix(void) const;
    /// Check whether it is safe or not to call GetPrefix method.
    bool CanGetPrefix(void) const;
    void ResetPrefix(void);
    const TPrefix& GetPrefix(void) const;
    void SetPrefix(const TPrefix& value);
    void SetPrefix(TPrefix&& value);
    TPrefix& SetPrefix(void);

    /// optional
    /// typedef string TSuffix
    ///  Check whether the Suffix data member has been assigned a value.
    bool IsSetSuffix(void) const;
    /// Check whether it is safe or not to call GetSuffix method.
    bool CanGetSuffix(void) const;
    void ResetSuffix(void);
    const TSuffix& GetSuffix(void) const;
    void SetSuffix(const TSuffix& value);
    void SetSuffix(TSuffix&& value);
    TSuffix& SetSuffix(void);

    /// mandatory
    /// typedef CPrintForm TForm
    ///  Check whether the Form data member has been assigned a value.
    bool IsSetForm(void) const;
    /// Check whether it is safe or not to call GetForm method.
    bool CanGetForm(void) const;
    void ResetForm(void);
    const TForm& GetForm(void) const;
    void SetForm(TForm& value);
    TForm& SetForm(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPrintFormat_Base(const CPrintFormat_Base&);
    CPrintFormat_Base& operator=(const CPrintFormat_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Asn1;
    string m_Label;
    string m_Prefix;
    string m_Suffix;
    CRef< TForm > m_Form;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPrintFormat_Base::IsSetAsn1(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPrintFormat_Base::CanGetAsn1(void) const
{
    return IsSetAsn1();
}

inline
const CPrintFormat_Base::TAsn1& CPrintFormat_Base::GetAsn1(void) const
{
    if (!CanGetAsn1()) {
        ThrowUnassigned(0);
    }
    return m_Asn1;
}

inline
void CPrintFormat_Base::SetAsn1(const CPrintFormat_Base::TAsn1& value)
{
    m_Asn1 = value;
    m_set_State[0] |= 0x3;
}

inline
void CPrintFormat_Base::SetAsn1(CPrintFormat_Base::TAsn1&& value)
{
    m_Asn1 = std::forward<CPrintFormat_Base::TAsn1>(value);
    m_set_State[0] |= 0x3;
}

inline
CPrintFormat_Base::TAsn1& CPrintFormat_Base::SetAsn1(void)
{
#ifdef _DEBUG
    if (!IsSetAsn1()) {
        m_Asn1 = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Asn1;
}

inline
bool CPrintFormat_Base::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPrintFormat_Base::CanGetLabel(void) const
{
    return IsSetLabel();
}

inline
const CPrintFormat_Base::TLabel& CPrintFormat_Base::GetLabel(void) const
{
    if (!CanGetLabel()) {
        ThrowUnassigned(1);
    }
    return m_Label;
}

inline
void CPrintFormat_Base::SetLabel(const CPrintFormat_Base::TLabel& value)
{
    m_Label = value;
    m_set_State[0] |= 0xc;
}

inline
void CPrintFormat_Base::SetLabel(CPrintFormat_Base::TLabel&& value)
{
    m_Label = std::forward<CPrintFormat_Base::TLabel>(value);
    m_set_State[0] |= 0xc;
}

inline
CPrintFormat_Base::TLabel& CPrintFormat_Base::SetLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLabel()) {
        m_Label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Label;
}

inline
bool CPrintFormat_Base::IsSetPrefix(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPrintFormat_Base::CanGetPrefix(void) const
{
    return IsSetPrefix();
}

inline
const CPrintFormat_Base::TPrefix& CPrintFormat_Base::GetPrefix(void) const
{
    if (!CanGetPrefix()) {
        ThrowUnassigned(2);
    }
    return m_Prefix;
}

inline
void CPrintFormat_Base::SetPrefix(const CPrintFormat_Base::TPrefix& value)
{
    m_Prefix = value;
    m_set_State[0] |= 0x30;
}

inline
void CPrintFormat_Base::SetPrefix(CPrintFormat_Base::TPrefix&& value)
{
    m_Prefix = std::forward<CPrintFormat_Base::TPrefix>(value);
    m_set_State[0] |= 0x30;
}

inline
CPrintFormat_Base::TPrefix& CPrintFormat_Base::SetPrefix(void)
{
#ifdef _DEBUG
    if (!IsSetPrefix()) {
        m_Prefix = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Prefix;
}

inline
bool CPrintFormat_Base::IsSetSuffix(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPrintFormat_Base::CanGetSuffix(void) const
{
    return IsSetSuffix();
}

inline
const CPrintFormat_Base::TSuffix& CPrintFormat_Base::GetSuffix(void) const
{
    if (!CanGetSuffix()) {
        ThrowUnassigned(3);
    }
    return m_Suffix;
}

inline
void CPrintFormat_Base::SetSuffix(const CPrintFormat_Base::TSuffix& value)
{
    m_Suffix = value;
    m_set_State[0] |= 0xc0;
}

inline
void CPrintFormat_Base::SetSuffix(CPrintFormat_Base::TSuffix&& value)
{
    m_Suffix = std::forward<CPrintFormat_Base::TSuffix>(value);
    m_set_State[0] |= 0xc0;
}

inline
CPrintFormat_Base::TSuffix& CPrintFormat_Base::SetSuffix(void)
{
#ifdef _DEBUG
    if (!IsSetSuffix()) {
        m_Suffix = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Suffix;
}

inline
bool CPrintFormat_Base::IsSetForm(void) const
{
    return m_Form.NotEmpty();
}

inline
bool CPrintFormat_Base::CanGetForm(void) const
{
    return true;
}

inline
const CPrintFormat_Base::TForm& CPrintFormat_Base::GetForm(void) const
{
    if ( !m_Form ) {
        const_cast<CPrintFormat_Base*>(this)->ResetForm();
    }
    return (*m_Form);
}

inline
CPrintFormat_Base::TForm& CPrintFormat_Base::SetForm(void)
{
    if ( !m_Form ) {
        ResetForm();
    }
    return (*m_Form);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OBJPRT_PRINTFORMAT_BASE_HPP
