/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Transform_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_TRANSFORM_BASE_HPP
#define OBJECTS_MMDB3_TRANSFORM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMove;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CTransform_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTransform_Base(void);
    // destructor
    virtual ~CTransform_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TId;
    typedef list< CRef< CMove > > TMoves;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_moves
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    TId GetId(void) const;
    void SetId(TId value);
    TId& SetId(void);

    /// mandatory
    /// typedef list< CRef< CMove > > TMoves
    ///  Check whether the Moves data member has been assigned a value.
    bool IsSetMoves(void) const;
    /// Check whether it is safe or not to call GetMoves method.
    bool CanGetMoves(void) const;
    void ResetMoves(void);
    const TMoves& GetMoves(void) const;
    TMoves& SetMoves(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTransform_Base(const CTransform_Base&);
    CTransform_Base& operator=(const CTransform_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Id;
    list< CRef< CMove > > m_Moves;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTransform_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTransform_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CTransform_Base::ResetId(void)
{
    m_Id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CTransform_Base::TId CTransform_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CTransform_Base::SetId(CTransform_Base::TId value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CTransform_Base::TId& CTransform_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        memset(&m_Id,UnassignedByte(),sizeof(m_Id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CTransform_Base::IsSetMoves(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTransform_Base::CanGetMoves(void) const
{
    return true;
}

inline
const CTransform_Base::TMoves& CTransform_Base::GetMoves(void) const
{
    return m_Moves;
}

inline
CTransform_Base::TMoves& CTransform_Base::SetMoves(void)
{
    m_set_State[0] |= 0x4;
    return m_Moves;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_TRANSFORM_BASE_HPP
