/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Render_prop_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_RENDER_PROP_BASE_HPP
#define OBJECTS_MMDB3_RENDER_PROP_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// Note that Render-prop is compatible with the Annmm specification,
/// i.e., its numbering schemes do not clash with those in Render-prop.
enum ERender_prop {
    eRender_prop_default          =   0,  ///< Default view
    eRender_prop_wire             =   1,  ///< use wireframe 
    eRender_prop_space            =   2,  ///< use spacefill
    eRender_prop_stick            =   3,  ///< use stick model (thin cylinders)
    eRender_prop_ballNStick       =   4,  ///< use ball & stick model
    eRender_prop_thickWire        =   5,  ///< thicker wireframe
    eRender_prop_hide             =   9,  ///< don't show this
    eRender_prop_name             =  10,  ///< display its name next to it
    eRender_prop_number           =  11,  ///< display its number next to it 
    eRender_prop_pdbNumber        =  12,  ///< display its PDB number next to it
    eRender_prop_objWireFrame     = 150,  ///< display MMDB surface object as wireframe
    eRender_prop_objPolygons      = 151,  ///< display MMDB surface object as polygons   
    eRender_prop_colorsetCPK      = 225,  ///< color atoms like CPK models
    eRender_prop_colorsetbyChain  = 226,  ///< color each chain different
    eRender_prop_colorsetbyTemp   = 227,  ///< color using isotropic Temp factors 
    eRender_prop_colorsetbyRes    = 228,  ///< color using residue properties
    eRender_prop_colorsetbyLen    = 229,  ///< color changes along chain length
    eRender_prop_colorsetbySStru  = 230,  ///< color by secondary structure
    eRender_prop_colorsetbyHydro  = 231,  ///< color by hydrophobicity
    eRender_prop_colorsetbyObject = 246,  ///< color each object differently
    eRender_prop_colorsetbyDomain = 247,  ///< color each domain differently
    eRender_prop_other            = 255
};

/// Access to ERender_prop's attributes (values, names) as defined in spec
NCBI_MMDB3_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ERender_prop)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_RENDER_PROP_BASE_HPP
