/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Camera_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_CAMERA_BASE_HPP
#define OBJECTS_MMDB3_CAMERA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CGL_matrix;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// The camera is a position relative to the world coordinates
/// of the structure referred to by a location.  
/// this is used to set the initial position of the
/// camera using OpenGL.  scale is the value used to scale the
/// other values from floating point to integer
class NCBI_MMDB3_EXPORT CCamera_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCamera_Base(void);
    // destructor
    virtual ~CCamera_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TX;
    typedef int TY;
    typedef int TDistance;
    typedef int TAngle;
    typedef int TScale;
    typedef CGL_matrix TModelview;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_x,
        e_y,
        e_distance,
        e_angle,
        e_scale,
        e_modelview
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TX
    ///  Check whether the X data member has been assigned a value.
    bool IsSetX(void) const;
    /// Check whether it is safe or not to call GetX method.
    bool CanGetX(void) const;
    void ResetX(void);
    TX GetX(void) const;
    void SetX(TX value);
    TX& SetX(void);

    /// mandatory
    /// typedef int TY
    ///  Check whether the Y data member has been assigned a value.
    bool IsSetY(void) const;
    /// Check whether it is safe or not to call GetY method.
    bool CanGetY(void) const;
    void ResetY(void);
    TY GetY(void) const;
    void SetY(TY value);
    TY& SetY(void);

    /// mandatory
    /// typedef int TDistance
    ///  Check whether the Distance data member has been assigned a value.
    bool IsSetDistance(void) const;
    /// Check whether it is safe or not to call GetDistance method.
    bool CanGetDistance(void) const;
    void ResetDistance(void);
    TDistance GetDistance(void) const;
    void SetDistance(TDistance value);
    TDistance& SetDistance(void);

    /// mandatory
    /// typedef int TAngle
    ///  Check whether the Angle data member has been assigned a value.
    bool IsSetAngle(void) const;
    /// Check whether it is safe or not to call GetAngle method.
    bool CanGetAngle(void) const;
    void ResetAngle(void);
    TAngle GetAngle(void) const;
    void SetAngle(TAngle value);
    TAngle& SetAngle(void);

    /// mandatory
    /// typedef int TScale
    ///  Check whether the Scale data member has been assigned a value.
    bool IsSetScale(void) const;
    /// Check whether it is safe or not to call GetScale method.
    bool CanGetScale(void) const;
    void ResetScale(void);
    TScale GetScale(void) const;
    void SetScale(TScale value);
    TScale& SetScale(void);

    /// mandatory
    /// typedef CGL_matrix TModelview
    ///  Check whether the Modelview data member has been assigned a value.
    bool IsSetModelview(void) const;
    /// Check whether it is safe or not to call GetModelview method.
    bool CanGetModelview(void) const;
    void ResetModelview(void);
    const TModelview& GetModelview(void) const;
    void SetModelview(TModelview& value);
    TModelview& SetModelview(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCamera_Base(const CCamera_Base&);
    CCamera_Base& operator=(const CCamera_Base&);

    // data
    Uint4 m_set_State[1];
    int m_X;
    int m_Y;
    int m_Distance;
    int m_Angle;
    int m_Scale;
    CRef< TModelview > m_Modelview;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCamera_Base::IsSetX(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCamera_Base::CanGetX(void) const
{
    return IsSetX();
}

inline
void CCamera_Base::ResetX(void)
{
    m_X = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCamera_Base::TX CCamera_Base::GetX(void) const
{
    if (!CanGetX()) {
        ThrowUnassigned(0);
    }
    return m_X;
}

inline
void CCamera_Base::SetX(CCamera_Base::TX value)
{
    m_X = value;
    m_set_State[0] |= 0x3;
}

inline
CCamera_Base::TX& CCamera_Base::SetX(void)
{
#ifdef _DEBUG
    if (!IsSetX()) {
        memset(&m_X,UnassignedByte(),sizeof(m_X));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_X;
}

inline
bool CCamera_Base::IsSetY(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCamera_Base::CanGetY(void) const
{
    return IsSetY();
}

inline
void CCamera_Base::ResetY(void)
{
    m_Y = 0;
    m_set_State[0] &= ~0xc;
}

inline
CCamera_Base::TY CCamera_Base::GetY(void) const
{
    if (!CanGetY()) {
        ThrowUnassigned(1);
    }
    return m_Y;
}

inline
void CCamera_Base::SetY(CCamera_Base::TY value)
{
    m_Y = value;
    m_set_State[0] |= 0xc;
}

inline
CCamera_Base::TY& CCamera_Base::SetY(void)
{
#ifdef _DEBUG
    if (!IsSetY()) {
        memset(&m_Y,UnassignedByte(),sizeof(m_Y));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Y;
}

inline
bool CCamera_Base::IsSetDistance(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCamera_Base::CanGetDistance(void) const
{
    return IsSetDistance();
}

inline
void CCamera_Base::ResetDistance(void)
{
    m_Distance = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCamera_Base::TDistance CCamera_Base::GetDistance(void) const
{
    if (!CanGetDistance()) {
        ThrowUnassigned(2);
    }
    return m_Distance;
}

inline
void CCamera_Base::SetDistance(CCamera_Base::TDistance value)
{
    m_Distance = value;
    m_set_State[0] |= 0x30;
}

inline
CCamera_Base::TDistance& CCamera_Base::SetDistance(void)
{
#ifdef _DEBUG
    if (!IsSetDistance()) {
        memset(&m_Distance,UnassignedByte(),sizeof(m_Distance));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Distance;
}

inline
bool CCamera_Base::IsSetAngle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCamera_Base::CanGetAngle(void) const
{
    return IsSetAngle();
}

inline
void CCamera_Base::ResetAngle(void)
{
    m_Angle = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CCamera_Base::TAngle CCamera_Base::GetAngle(void) const
{
    if (!CanGetAngle()) {
        ThrowUnassigned(3);
    }
    return m_Angle;
}

inline
void CCamera_Base::SetAngle(CCamera_Base::TAngle value)
{
    m_Angle = value;
    m_set_State[0] |= 0xc0;
}

inline
CCamera_Base::TAngle& CCamera_Base::SetAngle(void)
{
#ifdef _DEBUG
    if (!IsSetAngle()) {
        memset(&m_Angle,UnassignedByte(),sizeof(m_Angle));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Angle;
}

inline
bool CCamera_Base::IsSetScale(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCamera_Base::CanGetScale(void) const
{
    return IsSetScale();
}

inline
void CCamera_Base::ResetScale(void)
{
    m_Scale = 0;
    m_set_State[0] &= ~0x300;
}

inline
CCamera_Base::TScale CCamera_Base::GetScale(void) const
{
    if (!CanGetScale()) {
        ThrowUnassigned(4);
    }
    return m_Scale;
}

inline
void CCamera_Base::SetScale(CCamera_Base::TScale value)
{
    m_Scale = value;
    m_set_State[0] |= 0x300;
}

inline
CCamera_Base::TScale& CCamera_Base::SetScale(void)
{
#ifdef _DEBUG
    if (!IsSetScale()) {
        memset(&m_Scale,UnassignedByte(),sizeof(m_Scale));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Scale;
}

inline
bool CCamera_Base::IsSetModelview(void) const
{
    return m_Modelview.NotEmpty();
}

inline
bool CCamera_Base::CanGetModelview(void) const
{
    return true;
}

inline
const CCamera_Base::TModelview& CCamera_Base::GetModelview(void) const
{
    if ( !m_Modelview ) {
        const_cast<CCamera_Base*>(this)->ResetModelview();
    }
    return (*m_Modelview);
}

inline
CCamera_Base::TModelview& CCamera_Base::SetModelview(void)
{
    if ( !m_Modelview ) {
        ResetModelview();
    }
    return (*m_Modelview);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_CAMERA_BASE_HPP
