/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Coordinates_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_COORDINATES_BASE_HPP
#define OBJECTS_MMDB2_COORDINATES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAtomic_coordinates;
class CDensity_coordinates;
class CSurface_coordinates;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Literal coordinates map chemical components into the model space.  Three 
/// mapping types are allowed, atomic coordinate models, density-grid models,
/// and surface models. A model consists of a sequence of such coordinate sets, 
/// and may thus combine coordinate subsets which have a different source.  
/// PDB-derived models contain a single atomic coordinate set, as they by
/// definition represent information from a single source.
class NCBI_MMDB2_EXPORT CCoordinates_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCoordinates_Base(void);
    // destructor
    virtual ~CCoordinates_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Atomic,
        e_Surface,
        e_Density
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_Density+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CAtomic_coordinates TAtomic;
    typedef CSurface_coordinates TSurface;
    typedef CDensity_coordinates TDensity;

    // getters
    // setters

    // typedef CAtomic_coordinates TAtomic
    bool IsAtomic(void) const;
    const TAtomic& GetAtomic(void) const;
    TAtomic& SetAtomic(void);
    void SetAtomic(TAtomic& value);

    // typedef CSurface_coordinates TSurface
    bool IsSurface(void) const;
    const TSurface& GetSurface(void) const;
    TSurface& SetSurface(void);
    void SetSurface(TSurface& value);

    // typedef CDensity_coordinates TDensity
    bool IsDensity(void) const;
    const TDensity& GetDensity(void) const;
    TDensity& SetDensity(void);
    void SetDensity(TDensity& value);


private:
    // copy constructor and assignment operator
    CCoordinates_Base(const CCoordinates_Base& );
    CCoordinates_Base& operator=(const CCoordinates_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CCoordinates_Base::E_Choice CCoordinates_Base::Which(void) const
{
    return m_choice;
}

inline
void CCoordinates_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CCoordinates_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CCoordinates_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CCoordinates_Base::IsAtomic(void) const
{
    return m_choice == e_Atomic;
}

inline
bool CCoordinates_Base::IsSurface(void) const
{
    return m_choice == e_Surface;
}

inline
bool CCoordinates_Base::IsDensity(void) const
{
    return m_choice == e_Density;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_COORDINATES_BASE_HPP
