/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Conformation_ensemble_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_CONFORMATION_ENSEMBLE_BASE_HPP
#define OBJECTS_MMDB2_CONFORMATION_ENSEMBLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/mmdb2/Alternate_conformation_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Correlated disorder ensemble is defined by a set of alternate conformation 
/// id's which identify coordinates relevant to that ensemble. These are 
/// defined from the validated and corrected contents of the PDB "alternate
/// conformation" field as described above.  A given ensemble, for example, may
/// consist of atom sites flagged by " " and "A" Alternate-conformation-ids. 
/// Names for ensembles are constructed from these flags. This example would be
/// named, in its description, "PDB Ensemble blank plus A".
/// Note that this interpretation is consistent with common PDB usage of the 
/// "alternate conformation" field, but that PDB specifications do not formally
/// distinguish between correlated and uncorrelated disorder in crystallographic
/// models. Ensembles identified in MMDB thus may not correspond to the meaning
/// intended by PDB or the depositor.  No information is lost, however, and
/// if the intended meaning is known alternative ensemble descriptions may be
/// reconstructed directly from the Alternate-conformation-ids.
/// Note that correlated disorder as defined here is allowed within an atomic 
/// coordinate set but not between the multiple sets which may define a model. 
/// Multiple sets within the same model are intended as a means to represent 
/// assemblies modeled from different experimentally determined structures,
/// where correlated disorder between coordinate sets is not relevant.
class NCBI_MMDB2_EXPORT CConformation_ensemble_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CConformation_ensemble_Base(void);
    // destructor
    virtual ~CConformation_ensemble_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TName;
    typedef list< CAlternate_conformation_id > TAlt_conf_ids;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_alt_conf_ids
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// mandatory
    /// typedef list< CAlternate_conformation_id > TAlt_conf_ids
    ///  Check whether the Alt_conf_ids data member has been assigned a value.
    bool IsSetAlt_conf_ids(void) const;
    /// Check whether it is safe or not to call GetAlt_conf_ids method.
    bool CanGetAlt_conf_ids(void) const;
    void ResetAlt_conf_ids(void);
    const TAlt_conf_ids& GetAlt_conf_ids(void) const;
    TAlt_conf_ids& SetAlt_conf_ids(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CConformation_ensemble_Base(const CConformation_ensemble_Base&);
    CConformation_ensemble_Base& operator=(const CConformation_ensemble_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Name;
    list< CAlternate_conformation_id > m_Alt_conf_ids;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CConformation_ensemble_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CConformation_ensemble_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CConformation_ensemble_Base::TName& CConformation_ensemble_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CConformation_ensemble_Base::SetName(const CConformation_ensemble_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CConformation_ensemble_Base::SetName(CConformation_ensemble_Base::TName&& value)
{
    m_Name = std::forward<CConformation_ensemble_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CConformation_ensemble_Base::TName& CConformation_ensemble_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CConformation_ensemble_Base::IsSetAlt_conf_ids(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CConformation_ensemble_Base::CanGetAlt_conf_ids(void) const
{
    return true;
}

inline
const CConformation_ensemble_Base::TAlt_conf_ids& CConformation_ensemble_Base::GetAlt_conf_ids(void) const
{
    return m_Alt_conf_ids;
}

inline
CConformation_ensemble_Base::TAlt_conf_ids& CConformation_ensemble_Base::SetAlt_conf_ids(void)
{
    m_set_State[0] |= 0x4;
    return m_Alt_conf_ids;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_CONFORMATION_ENSEMBLE_BASE_HPP
