/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Atomic_occupancies_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_ATOMIC_OCCUPANCIES_BASE_HPP
#define OBJECTS_MMDB2_ATOMIC_OCCUPANCIES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB2_EXPORT CAtomic_occupancies_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAtomic_occupancies_Base(void);
    // destructor
    virtual ~CAtomic_occupancies_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TScale_factor;
    typedef list< int > TO;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_scale_factor,
        e_o
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// mandatory
    /// typedef list< int > TO
    ///  Check whether the O data member has been assigned a value.
    bool IsSetO(void) const;
    /// Check whether it is safe or not to call GetO method.
    bool CanGetO(void) const;
    void ResetO(void);
    const TO& GetO(void) const;
    TO& SetO(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAtomic_occupancies_Base(const CAtomic_occupancies_Base&);
    CAtomic_occupancies_Base& operator=(const CAtomic_occupancies_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Scale_factor;
    list< int > m_O;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAtomic_occupancies_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAtomic_occupancies_Base::CanGetScale_factor(void) const
{
    return IsSetScale_factor();
}

inline
void CAtomic_occupancies_Base::ResetScale_factor(void)
{
    m_Scale_factor = 0;
    m_set_State[0] &= ~0x3;
}

inline
CAtomic_occupancies_Base::TScale_factor CAtomic_occupancies_Base::GetScale_factor(void) const
{
    if (!CanGetScale_factor()) {
        ThrowUnassigned(0);
    }
    return m_Scale_factor;
}

inline
void CAtomic_occupancies_Base::SetScale_factor(CAtomic_occupancies_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0x3;
}

inline
CAtomic_occupancies_Base::TScale_factor& CAtomic_occupancies_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Scale_factor;
}

inline
bool CAtomic_occupancies_Base::IsSetO(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAtomic_occupancies_Base::CanGetO(void) const
{
    return true;
}

inline
const CAtomic_occupancies_Base::TO& CAtomic_occupancies_Base::GetO(void) const
{
    return m_O;
}

inline
CAtomic_occupancies_Base::TO& CAtomic_occupancies_Base::SetO(void)
{
    m_set_State[0] |= 0x4;
    return m_O;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_ATOMIC_OCCUPANCIES_BASE_HPP
