/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Atomic_coordinates_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_ATOMIC_COORDINATES_BASE_HPP
#define OBJECTS_MMDB2_ATOMIC_COORDINATES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAlternate_conformation_ids;
class CAtom_pntrs;
class CAtomic_occupancies;
class CAtomic_temperature_factors;
class CConformation_ensemble;
class CModel_space_points;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Literal atomic coordinate values give location, occupancy and order
/// parameters, and a pointer to a specific atom defined in the biostruc graph.
/// Temperature and occupancy factors have their conventional crystallographic
/// definitions, with units defined in the model space declaration.  Atoms,
/// sites, temperature-factors, occupancies and alternate-conformation-ids
/// are parallel arrays, i.e. the have the same number of values as given by
/// number-of-points. Conformation ensembles represent distinct correlated-
/// disorder subsets of the coordinates.  They will be present only for certain 
/// "views" of PDB structures, as described above. Their derivation from PDB-
/// supplied "alternate-conformation" ids is described below. 
class NCBI_MMDB2_EXPORT CAtomic_coordinates_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAtomic_coordinates_Base(void);
    // destructor
    virtual ~CAtomic_coordinates_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNumber_of_points;
    typedef CAtom_pntrs TAtoms;
    typedef CModel_space_points TSites;
    typedef CAtomic_temperature_factors TTemperature_factors;
    typedef CAtomic_occupancies TOccupancies;
    typedef CAlternate_conformation_ids TAlternate_conf_ids;
    typedef list< CRef< CConformation_ensemble > > TConf_ensembles;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_number_of_points,
        e_atoms,
        e_sites,
        e_temperature_factors,
        e_occupancies,
        e_alternate_conf_ids,
        e_conf_ensembles
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TNumber_of_points
    ///  Check whether the Number_of_points data member has been assigned a value.
    bool IsSetNumber_of_points(void) const;
    /// Check whether it is safe or not to call GetNumber_of_points method.
    bool CanGetNumber_of_points(void) const;
    void ResetNumber_of_points(void);
    TNumber_of_points GetNumber_of_points(void) const;
    void SetNumber_of_points(TNumber_of_points value);
    TNumber_of_points& SetNumber_of_points(void);

    /// mandatory
    /// typedef CAtom_pntrs TAtoms
    ///  Check whether the Atoms data member has been assigned a value.
    bool IsSetAtoms(void) const;
    /// Check whether it is safe or not to call GetAtoms method.
    bool CanGetAtoms(void) const;
    void ResetAtoms(void);
    const TAtoms& GetAtoms(void) const;
    void SetAtoms(TAtoms& value);
    TAtoms& SetAtoms(void);

    /// mandatory
    /// typedef CModel_space_points TSites
    ///  Check whether the Sites data member has been assigned a value.
    bool IsSetSites(void) const;
    /// Check whether it is safe or not to call GetSites method.
    bool CanGetSites(void) const;
    void ResetSites(void);
    const TSites& GetSites(void) const;
    void SetSites(TSites& value);
    TSites& SetSites(void);

    /// optional
    /// typedef CAtomic_temperature_factors TTemperature_factors
    ///  Check whether the Temperature_factors data member has been assigned a value.
    bool IsSetTemperature_factors(void) const;
    /// Check whether it is safe or not to call GetTemperature_factors method.
    bool CanGetTemperature_factors(void) const;
    void ResetTemperature_factors(void);
    const TTemperature_factors& GetTemperature_factors(void) const;
    void SetTemperature_factors(TTemperature_factors& value);
    TTemperature_factors& SetTemperature_factors(void);

    /// optional
    /// typedef CAtomic_occupancies TOccupancies
    ///  Check whether the Occupancies data member has been assigned a value.
    bool IsSetOccupancies(void) const;
    /// Check whether it is safe or not to call GetOccupancies method.
    bool CanGetOccupancies(void) const;
    void ResetOccupancies(void);
    const TOccupancies& GetOccupancies(void) const;
    void SetOccupancies(TOccupancies& value);
    TOccupancies& SetOccupancies(void);

    /// optional
    /// typedef CAlternate_conformation_ids TAlternate_conf_ids
    ///  Check whether the Alternate_conf_ids data member has been assigned a value.
    bool IsSetAlternate_conf_ids(void) const;
    /// Check whether it is safe or not to call GetAlternate_conf_ids method.
    bool CanGetAlternate_conf_ids(void) const;
    void ResetAlternate_conf_ids(void);
    const TAlternate_conf_ids& GetAlternate_conf_ids(void) const;
    void SetAlternate_conf_ids(TAlternate_conf_ids& value);
    TAlternate_conf_ids& SetAlternate_conf_ids(void);

    /// optional
    /// typedef list< CRef< CConformation_ensemble > > TConf_ensembles
    ///  Check whether the Conf_ensembles data member has been assigned a value.
    bool IsSetConf_ensembles(void) const;
    /// Check whether it is safe or not to call GetConf_ensembles method.
    bool CanGetConf_ensembles(void) const;
    void ResetConf_ensembles(void);
    const TConf_ensembles& GetConf_ensembles(void) const;
    TConf_ensembles& SetConf_ensembles(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAtomic_coordinates_Base(const CAtomic_coordinates_Base&);
    CAtomic_coordinates_Base& operator=(const CAtomic_coordinates_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Number_of_points;
    CRef< TAtoms > m_Atoms;
    CRef< TSites > m_Sites;
    CRef< TTemperature_factors > m_Temperature_factors;
    CRef< TOccupancies > m_Occupancies;
    CRef< TAlternate_conf_ids > m_Alternate_conf_ids;
    list< CRef< CConformation_ensemble > > m_Conf_ensembles;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAtomic_coordinates_Base::IsSetNumber_of_points(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAtomic_coordinates_Base::CanGetNumber_of_points(void) const
{
    return IsSetNumber_of_points();
}

inline
void CAtomic_coordinates_Base::ResetNumber_of_points(void)
{
    m_Number_of_points = 0;
    m_set_State[0] &= ~0x3;
}

inline
CAtomic_coordinates_Base::TNumber_of_points CAtomic_coordinates_Base::GetNumber_of_points(void) const
{
    if (!CanGetNumber_of_points()) {
        ThrowUnassigned(0);
    }
    return m_Number_of_points;
}

inline
void CAtomic_coordinates_Base::SetNumber_of_points(CAtomic_coordinates_Base::TNumber_of_points value)
{
    m_Number_of_points = value;
    m_set_State[0] |= 0x3;
}

inline
CAtomic_coordinates_Base::TNumber_of_points& CAtomic_coordinates_Base::SetNumber_of_points(void)
{
#ifdef _DEBUG
    if (!IsSetNumber_of_points()) {
        memset(&m_Number_of_points,UnassignedByte(),sizeof(m_Number_of_points));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Number_of_points;
}

inline
bool CAtomic_coordinates_Base::IsSetAtoms(void) const
{
    return m_Atoms.NotEmpty();
}

inline
bool CAtomic_coordinates_Base::CanGetAtoms(void) const
{
    return true;
}

inline
const CAtomic_coordinates_Base::TAtoms& CAtomic_coordinates_Base::GetAtoms(void) const
{
    if ( !m_Atoms ) {
        const_cast<CAtomic_coordinates_Base*>(this)->ResetAtoms();
    }
    return (*m_Atoms);
}

inline
CAtomic_coordinates_Base::TAtoms& CAtomic_coordinates_Base::SetAtoms(void)
{
    if ( !m_Atoms ) {
        ResetAtoms();
    }
    return (*m_Atoms);
}

inline
bool CAtomic_coordinates_Base::IsSetSites(void) const
{
    return m_Sites.NotEmpty();
}

inline
bool CAtomic_coordinates_Base::CanGetSites(void) const
{
    return true;
}

inline
const CAtomic_coordinates_Base::TSites& CAtomic_coordinates_Base::GetSites(void) const
{
    if ( !m_Sites ) {
        const_cast<CAtomic_coordinates_Base*>(this)->ResetSites();
    }
    return (*m_Sites);
}

inline
CAtomic_coordinates_Base::TSites& CAtomic_coordinates_Base::SetSites(void)
{
    if ( !m_Sites ) {
        ResetSites();
    }
    return (*m_Sites);
}

inline
bool CAtomic_coordinates_Base::IsSetTemperature_factors(void) const
{
    return m_Temperature_factors.NotEmpty();
}

inline
bool CAtomic_coordinates_Base::CanGetTemperature_factors(void) const
{
    return IsSetTemperature_factors();
}

inline
const CAtomic_coordinates_Base::TTemperature_factors& CAtomic_coordinates_Base::GetTemperature_factors(void) const
{
    if (!CanGetTemperature_factors()) {
        ThrowUnassigned(3);
    }
    return (*m_Temperature_factors);
}

inline
bool CAtomic_coordinates_Base::IsSetOccupancies(void) const
{
    return m_Occupancies.NotEmpty();
}

inline
bool CAtomic_coordinates_Base::CanGetOccupancies(void) const
{
    return IsSetOccupancies();
}

inline
const CAtomic_coordinates_Base::TOccupancies& CAtomic_coordinates_Base::GetOccupancies(void) const
{
    if (!CanGetOccupancies()) {
        ThrowUnassigned(4);
    }
    return (*m_Occupancies);
}

inline
bool CAtomic_coordinates_Base::IsSetAlternate_conf_ids(void) const
{
    return m_Alternate_conf_ids.NotEmpty();
}

inline
bool CAtomic_coordinates_Base::CanGetAlternate_conf_ids(void) const
{
    return IsSetAlternate_conf_ids();
}

inline
const CAtomic_coordinates_Base::TAlternate_conf_ids& CAtomic_coordinates_Base::GetAlternate_conf_ids(void) const
{
    if (!CanGetAlternate_conf_ids()) {
        ThrowUnassigned(5);
    }
    return (*m_Alternate_conf_ids);
}

inline
bool CAtomic_coordinates_Base::IsSetConf_ensembles(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CAtomic_coordinates_Base::CanGetConf_ensembles(void) const
{
    return true;
}

inline
const CAtomic_coordinates_Base::TConf_ensembles& CAtomic_coordinates_Base::GetConf_ensembles(void) const
{
    return m_Conf_ensembles;
}

inline
CAtomic_coordinates_Base::TConf_ensembles& CAtomic_coordinates_Base::SetConf_ensembles(void)
{
    m_set_State[0] |= 0x1000;
    return m_Conf_ensembles;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_ATOMIC_COORDINATES_BASE_HPP
