/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Residue_graph_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_RESIDUE_GRAPH_BASE_HPP
#define OBJECTS_MMDB1_RESIDUE_GRAPH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/mmdb1/Residue_graph_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAtom;
class CBiomol_descr;
class CChiral_center;
class CIntra_residue_bond;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Residue graphs define atomic formulae, connectivity, chirality, and names.
/// For standard residue graphs from the MMDB dictionary the PDB-assigned 
/// residue-type code appears as the name within the residue graph description,
/// and the full trivial name of the residue as a comment within that 
/// description.  For any nonstandard residue graphs provided with an MMDB 
/// biostruc the PDB-assigned residue-type code similarly appears as the name 
/// within the description, and any information provided on PDB HET records as 
/// a pdb-comment within that description.  
/// Note that nonstandard residue graphs for a PDB-derived biostruc may be 
/// incomplete. Current PDB format cannot represent connectivity for groups 
/// which are disordered, and for which no coordinates are given.  In these 
/// cases the residue graph defined in MMDB represents only the subgraph that 
/// could be identified from available ATOM, HETATM and CONECT records.
class NCBI_MMDB1_EXPORT CResidue_graph_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CResidue_graph_Base(void);
    // destructor
    virtual ~CResidue_graph_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EResidue_type {
        eResidue_type_deoxyribonucleotide =   1,
        eResidue_type_ribonucleotide      =   2,
        eResidue_type_amino_acid          =   3,
        eResidue_type_other               = 255
    };
    
    /// Access to EResidue_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EResidue_type)(void);
    
    // types
    typedef CResidue_graph_id TId;
    typedef list< CRef< CBiomol_descr > > TDescr;
    typedef int TResidue_type;
    typedef list< string > TIupac_code;
    typedef list< CRef< CAtom > > TAtoms;
    typedef list< CRef< CIntra_residue_bond > > TBonds;
    typedef list< CRef< CChiral_center > > TChiral_centers;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_descr,
        e_residue_type,
        e_iupac_code,
        e_atoms,
        e_bonds,
        e_chiral_centers
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CResidue_graph_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    TId& SetId(void);

    /// optional
    /// typedef list< CRef< CBiomol_descr > > TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    TDescr& SetDescr(void);

    /// optional
    /// typedef int TResidue_type
    ///  Check whether the Residue_type data member has been assigned a value.
    bool IsSetResidue_type(void) const;
    /// Check whether it is safe or not to call GetResidue_type method.
    bool CanGetResidue_type(void) const;
    void ResetResidue_type(void);
    TResidue_type GetResidue_type(void) const;
    void SetResidue_type(TResidue_type value);
    TResidue_type& SetResidue_type(void);

    /// optional
    /// typedef list< string > TIupac_code
    ///  Check whether the Iupac_code data member has been assigned a value.
    bool IsSetIupac_code(void) const;
    /// Check whether it is safe or not to call GetIupac_code method.
    bool CanGetIupac_code(void) const;
    void ResetIupac_code(void);
    const TIupac_code& GetIupac_code(void) const;
    TIupac_code& SetIupac_code(void);

    /// mandatory
    /// typedef list< CRef< CAtom > > TAtoms
    ///  Check whether the Atoms data member has been assigned a value.
    bool IsSetAtoms(void) const;
    /// Check whether it is safe or not to call GetAtoms method.
    bool CanGetAtoms(void) const;
    void ResetAtoms(void);
    const TAtoms& GetAtoms(void) const;
    TAtoms& SetAtoms(void);

    /// mandatory
    /// typedef list< CRef< CIntra_residue_bond > > TBonds
    ///  Check whether the Bonds data member has been assigned a value.
    bool IsSetBonds(void) const;
    /// Check whether it is safe or not to call GetBonds method.
    bool CanGetBonds(void) const;
    void ResetBonds(void);
    const TBonds& GetBonds(void) const;
    TBonds& SetBonds(void);

    /// optional
    /// typedef list< CRef< CChiral_center > > TChiral_centers
    ///  Check whether the Chiral_centers data member has been assigned a value.
    bool IsSetChiral_centers(void) const;
    /// Check whether it is safe or not to call GetChiral_centers method.
    bool CanGetChiral_centers(void) const;
    void ResetChiral_centers(void);
    const TChiral_centers& GetChiral_centers(void) const;
    TChiral_centers& SetChiral_centers(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CResidue_graph_Base(const CResidue_graph_Base&);
    CResidue_graph_Base& operator=(const CResidue_graph_Base&);

    // data
    Uint4 m_set_State[1];
    CResidue_graph_id m_Id;
    list< CRef< CBiomol_descr > > m_Descr;
    int m_Residue_type;
    list< string > m_Iupac_code;
    list< CRef< CAtom > > m_Atoms;
    list< CRef< CIntra_residue_bond > > m_Bonds;
    list< CRef< CChiral_center > > m_Chiral_centers;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CResidue_graph_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CResidue_graph_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CResidue_graph_Base::ResetId(void)
{
    m_Id = CResidue_graph_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CResidue_graph_Base::TId& CResidue_graph_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CResidue_graph_Base::SetId(const CResidue_graph_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CResidue_graph_Base::TId& CResidue_graph_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CResidue_graph_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CResidue_graph_Base::CanGetDescr(void) const
{
    return true;
}

inline
const CResidue_graph_Base::TDescr& CResidue_graph_Base::GetDescr(void) const
{
    return m_Descr;
}

inline
CResidue_graph_Base::TDescr& CResidue_graph_Base::SetDescr(void)
{
    m_set_State[0] |= 0x4;
    return m_Descr;
}

inline
bool CResidue_graph_Base::IsSetResidue_type(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CResidue_graph_Base::CanGetResidue_type(void) const
{
    return IsSetResidue_type();
}

inline
void CResidue_graph_Base::ResetResidue_type(void)
{
    m_Residue_type = (EResidue_type)(0);
    m_set_State[0] &= ~0x30;
}

inline
CResidue_graph_Base::TResidue_type CResidue_graph_Base::GetResidue_type(void) const
{
    if (!CanGetResidue_type()) {
        ThrowUnassigned(2);
    }
    return m_Residue_type;
}

inline
void CResidue_graph_Base::SetResidue_type(CResidue_graph_Base::TResidue_type value)
{
    m_Residue_type = value;
    m_set_State[0] |= 0x30;
}

inline
CResidue_graph_Base::TResidue_type& CResidue_graph_Base::SetResidue_type(void)
{
#ifdef _DEBUG
    if (!IsSetResidue_type()) {
        memset(&m_Residue_type,UnassignedByte(),sizeof(m_Residue_type));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Residue_type;
}

inline
bool CResidue_graph_Base::IsSetIupac_code(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CResidue_graph_Base::CanGetIupac_code(void) const
{
    return true;
}

inline
const CResidue_graph_Base::TIupac_code& CResidue_graph_Base::GetIupac_code(void) const
{
    return m_Iupac_code;
}

inline
CResidue_graph_Base::TIupac_code& CResidue_graph_Base::SetIupac_code(void)
{
    m_set_State[0] |= 0x40;
    return m_Iupac_code;
}

inline
bool CResidue_graph_Base::IsSetAtoms(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CResidue_graph_Base::CanGetAtoms(void) const
{
    return true;
}

inline
const CResidue_graph_Base::TAtoms& CResidue_graph_Base::GetAtoms(void) const
{
    return m_Atoms;
}

inline
CResidue_graph_Base::TAtoms& CResidue_graph_Base::SetAtoms(void)
{
    m_set_State[0] |= 0x100;
    return m_Atoms;
}

inline
bool CResidue_graph_Base::IsSetBonds(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CResidue_graph_Base::CanGetBonds(void) const
{
    return true;
}

inline
const CResidue_graph_Base::TBonds& CResidue_graph_Base::GetBonds(void) const
{
    return m_Bonds;
}

inline
CResidue_graph_Base::TBonds& CResidue_graph_Base::SetBonds(void)
{
    m_set_State[0] |= 0x400;
    return m_Bonds;
}

inline
bool CResidue_graph_Base::IsSetChiral_centers(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CResidue_graph_Base::CanGetChiral_centers(void) const
{
    return true;
}

inline
const CResidue_graph_Base::TChiral_centers& CResidue_graph_Base::GetChiral_centers(void) const
{
    return m_Chiral_centers;
}

inline
CResidue_graph_Base::TChiral_centers& CResidue_graph_Base::SetChiral_centers(void)
{
    m_set_State[0] |= 0x1000;
    return m_Chiral_centers;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_RESIDUE_GRAPH_BASE_HPP
