/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Biostruc_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_BIOSTRUC_ID_BASE_HPP
#define OBJECTS_MMDB1_BIOSTRUC_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/mmdb1/Mmdb_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CObject_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// A Biostruc-id is a collection identifiers for the molecular assembly.
/// Mmdb-id's are NCBI-assigned, and are intended to be unique and stable 
/// identifiers.  Other-id's are synonyms.
class NCBI_MMDB1_EXPORT CBiostruc_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBiostruc_id_Base(void);
    // destructor
    virtual ~CBiostruc_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,     ///< No variant selected
        e_Mmdb_id,
        e_Other_database,
        e_Local_id
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_Local_id+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CMmdb_id TMmdb_id;
    typedef CDbtag TOther_database;
    typedef CObject_id TLocal_id;

    // getters
    // setters

    // typedef CMmdb_id TMmdb_id
    bool IsMmdb_id(void) const;
    const TMmdb_id& GetMmdb_id(void) const;
    TMmdb_id& SetMmdb_id(void);
    void SetMmdb_id(const TMmdb_id& value);

    // typedef CDbtag TOther_database
    bool IsOther_database(void) const;
    const TOther_database& GetOther_database(void) const;
    TOther_database& SetOther_database(void);
    void SetOther_database(TOther_database& value);

    // typedef CObject_id TLocal_id
    bool IsLocal_id(void) const;
    const TLocal_id& GetLocal_id(void) const;
    TLocal_id& SetLocal_id(void);
    void SetLocal_id(TLocal_id& value);


private:
    // copy constructor and assignment operator
    CBiostruc_id_Base(const CBiostruc_id_Base& );
    CBiostruc_id_Base& operator=(const CBiostruc_id_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TMmdb_id> m_Mmdb_id;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CBiostruc_id_Base::E_Choice CBiostruc_id_Base::Which(void) const
{
    return m_choice;
}

inline
void CBiostruc_id_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBiostruc_id_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBiostruc_id_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBiostruc_id_Base::IsMmdb_id(void) const
{
    return m_choice == e_Mmdb_id;
}

inline
const CBiostruc_id_Base::TMmdb_id& CBiostruc_id_Base::GetMmdb_id(void) const
{
    CheckSelected(e_Mmdb_id);
    return *m_Mmdb_id;
}

inline
CBiostruc_id_Base::TMmdb_id& CBiostruc_id_Base::SetMmdb_id(void)
{
    Select(e_Mmdb_id, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Mmdb_id;
}

inline
bool CBiostruc_id_Base::IsOther_database(void) const
{
    return m_choice == e_Other_database;
}

inline
bool CBiostruc_id_Base::IsLocal_id(void) const
{
    return m_choice == e_Local_id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_BIOSTRUC_ID_BASE_HPP
