/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file mla_client_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mla.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MLA_MLA_CLIENT_BASE_HPP
#define OBJECTS_MLA_MLA_CLIENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/biblio/PubMedId.hpp>
#include <objects/mla/Mla_back.hpp>
#include <objects/mla/Mla_request.hpp>
#include <serial/rpcbase.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MLA_EXPORT CMLAClient_Base : public CRPCClient<CMla_request, CMla_back>
{
    typedef CRPCClient<CMla_request, CMla_back> Tparent;
public:
    // constructor
    CMLAClient_Base(void);
    // destructor
    virtual ~CMLAClient_Base(void);

    typedef CMla_request TRequest;
    typedef CMla_back TReply;
    typedef TRequest TRequestChoice;
    typedef TReply TReplyChoice;

    virtual void Ask(const TRequest& request, TReply& reply);
    virtual void Ask(const TRequest& request, TReply& reply,
                     TReplyChoice::E_Choice wanted);

    virtual void AskInit
        (TReply* reply = 0);

    virtual CRef<CMedline_entry> AskGetmle
        (const int& req, TReply* reply = 0);

    virtual CRef<CPub> AskGetpub
        (const int& req, TReply* reply = 0);

    virtual CRef<CTitle_msg_list> AskGettitle
        (const CTitle_msg& req, TReply* reply = 0);

    virtual int AskCitmatch
        (const CPub& req, TReply* reply = 0);

    virtual void AskFini
        (TReply* reply = 0);

    virtual list< int > AskGetmriuids
        (const int& req, TReply* reply = 0);

    virtual list< int > AskGetaccuids
        (const CMedline_si& req, TReply* reply = 0);

    virtual CPubMedId AskUidtopmid
        (const int& req, TReply* reply = 0);

    virtual int AskPmidtouid
        (const CPubMedId& req, TReply* reply = 0);

    virtual CRef<CPubmed_entry> AskGetmlepmid
        (const CPubMedId& req, TReply* reply = 0);

    virtual CRef<CPub> AskGetpubpmid
        (const CPubMedId& req, TReply* reply = 0);

    virtual int AskCitmatchpmid
        (const CPub& req, TReply* reply = 0);

    virtual list< int > AskGetmripmids
        (const int& req, TReply* reply = 0);

    virtual list< int > AskGetaccpmids
        (const CMedline_si& req, TReply* reply = 0);

    virtual list< int > AskCitlstpmids
        (const CPub& req, TReply* reply = 0);

    virtual CRef<CPubmed_entry> AskGetmleuid
        (const int& req, TReply* reply = 0);

    virtual CRef<CMedlars_entry> AskGetmlrpmid
        (const CPubMedId& req, TReply* reply = 0);

    virtual CRef<CMedlars_entry> AskGetmlruid
        (const int& req, TReply* reply = 0);


protected:
    void x_Connect(void);

    /// Disconnect as cleanly as possible.
    ///
    /// @note Derived classes that override this method
    /// should copy the destructor logic that calls it (via
    /// Disconnect, which avoids duplicate calls).
    void x_Disconnect(void);

private:
    TReplyChoice& x_Choice(TReply& reply);
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CMLAClient_Base::TReplyChoice& CMLAClient_Base::x_Choice(CMLAClient_Base::TReply& reply)
{
    return reply;
}

inline
void CMLAClient_Base::Ask(const CMLAClient_Base::TRequest& request, CMLAClient_Base::TReply& reply)
{
    Tparent::Ask(request, reply);
}


///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MLA_MLA_CLIENT_BASE_HPP
