/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Title_msg_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mla.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MLA_TITLE_MSG_BASE_HPP
#define OBJECTS_MLA_TITLE_MSG_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/mla/Title_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTitle;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Title match request/response
class NCBI_MLA_EXPORT CTitle_msg_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTitle_msg_Base(void);
    // destructor
    virtual ~CTitle_msg_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef ETitle_type TType;
    typedef CTitle TTitle;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_title
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// type to get, or type returned
    /// mandatory
    /// typedef ETitle_type TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// title(s) to look up, or title(s) found
    /// mandatory
    /// typedef CTitle TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(TTitle& value);
    TTitle& SetTitle(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTitle_msg_Base(const CTitle_msg_Base&);
    CTitle_msg_Base& operator=(const CTitle_msg_Base&);

    // data
    Uint4 m_set_State[1];
    ETitle_type m_Type;
    CRef< TTitle > m_Title;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTitle_msg_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTitle_msg_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CTitle_msg_Base::ResetType(void)
{
    m_Type = (ncbi::objects::ETitle_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CTitle_msg_Base::TType CTitle_msg_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CTitle_msg_Base::SetType(CTitle_msg_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CTitle_msg_Base::TType& CTitle_msg_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CTitle_msg_Base::IsSetTitle(void) const
{
    return m_Title.NotEmpty();
}

inline
bool CTitle_msg_Base::CanGetTitle(void) const
{
    return true;
}

inline
const CTitle_msg_Base::TTitle& CTitle_msg_Base::GetTitle(void) const
{
    if ( !m_Title ) {
        const_cast<CTitle_msg_Base*>(this)->ResetTitle();
    }
    return (*m_Title);
}

inline
CTitle_msg_Base::TTitle& CTitle_msg_Base::SetTitle(void)
{
    if ( !m_Title ) {
        ResetTitle();
    }
    return (*m_Title);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MLA_TITLE_MSG_BASE_HPP
