/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mla_request_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mla.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MLA_MLA_REQUEST_BASE_HPP
#define OBJECTS_MLA_MLA_REQUEST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/biblio/PubMedId.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMedline_si;
class CPub;
class CTitle_msg;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///**********************************
/// requests
///
class NCBI_MLA_EXPORT CMla_request_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMla_request_Base(void);
    // destructor
    virtual ~CMla_request_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,   ///< No variant selected
        e_Init,          ///< DlInit
        e_Getmle,        ///< get MedlineEntry
        e_Getpub,        ///< get citation by muid
        e_Gettitle,      ///< match titles
        e_Citmatch,      ///<
        e_Fini,          ///< DlFini
        e_Getmriuids,    ///< Get MUIDs for an MRI
        e_Getaccuids,    ///< Get MUIDs for an Accessions
        e_Uidtopmid,     ///< get PMID for MUID
        e_Pmidtouid,     ///< get MUID for PMID
        e_Getmlepmid,    ///< get MedlineEntry by PubMed id
        e_Getpubpmid,    ///< get citation by PubMed id
        e_Citmatchpmid,  ///< citation match, PMID on out
        e_Getmripmids,   ///< get PMIDs for an MRI
        e_Getaccpmids,   ///< get PMIDs for an Accessions
        e_Citlstpmids,   ///< generate list of PMID for Pub
        e_Getmleuid,     ///< get MedlineEntry by Medline id
        e_Getmlrpmid,    ///< get MedlarsEntry by PubMed id
        e_Getmlruid      ///< get MedlarsEntry by Medline id
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 20 ///< == e_Getmlruid+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef int TGetmle;
    typedef int TGetpub;
    typedef CTitle_msg TGettitle;
    typedef CPub TCitmatch;
    typedef int TGetmriuids;
    typedef CMedline_si TGetaccuids;
    typedef int TUidtopmid;
    typedef CPubMedId TPmidtouid;
    typedef CPubMedId TGetmlepmid;
    typedef CPubMedId TGetpubpmid;
    typedef CPub TCitmatchpmid;
    typedef int TGetmripmids;
    typedef CMedline_si TGetaccpmids;
    typedef CPub TCitlstpmids;
    typedef int TGetmleuid;
    typedef CPubMedId TGetmlrpmid;
    typedef int TGetmlruid;

    // getters
    // setters


    bool IsInit(void) const;
    void SetInit(void);

    // typedef int TGetmle
    bool IsGetmle(void) const;
    TGetmle GetGetmle(void) const;
    TGetmle& SetGetmle(void);
    void SetGetmle(TGetmle value);

    // typedef int TGetpub
    bool IsGetpub(void) const;
    TGetpub GetGetpub(void) const;
    TGetpub& SetGetpub(void);
    void SetGetpub(TGetpub value);

    // typedef CTitle_msg TGettitle
    bool IsGettitle(void) const;
    const TGettitle& GetGettitle(void) const;
    TGettitle& SetGettitle(void);
    void SetGettitle(TGettitle& value);

    // typedef CPub TCitmatch
    bool IsCitmatch(void) const;
    const TCitmatch& GetCitmatch(void) const;
    TCitmatch& SetCitmatch(void);
    void SetCitmatch(TCitmatch& value);


    bool IsFini(void) const;
    void SetFini(void);

    // typedef int TGetmriuids
    bool IsGetmriuids(void) const;
    TGetmriuids GetGetmriuids(void) const;
    TGetmriuids& SetGetmriuids(void);
    void SetGetmriuids(TGetmriuids value);

    // typedef CMedline_si TGetaccuids
    bool IsGetaccuids(void) const;
    const TGetaccuids& GetGetaccuids(void) const;
    TGetaccuids& SetGetaccuids(void);
    void SetGetaccuids(TGetaccuids& value);

    // typedef int TUidtopmid
    bool IsUidtopmid(void) const;
    TUidtopmid GetUidtopmid(void) const;
    TUidtopmid& SetUidtopmid(void);
    void SetUidtopmid(TUidtopmid value);

    // typedef CPubMedId TPmidtouid
    bool IsPmidtouid(void) const;
    const TPmidtouid& GetPmidtouid(void) const;
    TPmidtouid& SetPmidtouid(void);
    void SetPmidtouid(const TPmidtouid& value);

    // typedef CPubMedId TGetmlepmid
    bool IsGetmlepmid(void) const;
    const TGetmlepmid& GetGetmlepmid(void) const;
    TGetmlepmid& SetGetmlepmid(void);
    void SetGetmlepmid(const TGetmlepmid& value);

    // typedef CPubMedId TGetpubpmid
    bool IsGetpubpmid(void) const;
    const TGetpubpmid& GetGetpubpmid(void) const;
    TGetpubpmid& SetGetpubpmid(void);
    void SetGetpubpmid(const TGetpubpmid& value);

    // typedef CPub TCitmatchpmid
    bool IsCitmatchpmid(void) const;
    const TCitmatchpmid& GetCitmatchpmid(void) const;
    TCitmatchpmid& SetCitmatchpmid(void);
    void SetCitmatchpmid(TCitmatchpmid& value);

    // typedef int TGetmripmids
    bool IsGetmripmids(void) const;
    TGetmripmids GetGetmripmids(void) const;
    TGetmripmids& SetGetmripmids(void);
    void SetGetmripmids(TGetmripmids value);

    // typedef CMedline_si TGetaccpmids
    bool IsGetaccpmids(void) const;
    const TGetaccpmids& GetGetaccpmids(void) const;
    TGetaccpmids& SetGetaccpmids(void);
    void SetGetaccpmids(TGetaccpmids& value);

    // typedef CPub TCitlstpmids
    bool IsCitlstpmids(void) const;
    const TCitlstpmids& GetCitlstpmids(void) const;
    TCitlstpmids& SetCitlstpmids(void);
    void SetCitlstpmids(TCitlstpmids& value);

    // typedef int TGetmleuid
    bool IsGetmleuid(void) const;
    TGetmleuid GetGetmleuid(void) const;
    TGetmleuid& SetGetmleuid(void);
    void SetGetmleuid(TGetmleuid value);

    // typedef CPubMedId TGetmlrpmid
    bool IsGetmlrpmid(void) const;
    const TGetmlrpmid& GetGetmlrpmid(void) const;
    TGetmlrpmid& SetGetmlrpmid(void);
    void SetGetmlrpmid(const TGetmlrpmid& value);

    // typedef int TGetmlruid
    bool IsGetmlruid(void) const;
    TGetmlruid GetGetmlruid(void) const;
    TGetmlruid& SetGetmlruid(void);
    void SetGetmlruid(TGetmlruid value);


private:
    // copy constructor and assignment operator
    CMla_request_Base(const CMla_request_Base& );
    CMla_request_Base& operator=(const CMla_request_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TGetmle m_Getmle;
        TGetpub m_Getpub;
        TGetmriuids m_Getmriuids;
        TUidtopmid m_Uidtopmid;
        NCBI_NS_NCBI::CUnionBuffer<TPmidtouid> m_Pmidtouid;
        NCBI_NS_NCBI::CUnionBuffer<TGetmlepmid> m_Getmlepmid;
        NCBI_NS_NCBI::CUnionBuffer<TGetpubpmid> m_Getpubpmid;
        TGetmripmids m_Getmripmids;
        TGetmleuid m_Getmleuid;
        NCBI_NS_NCBI::CUnionBuffer<TGetmlrpmid> m_Getmlrpmid;
        TGetmlruid m_Getmlruid;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CMla_request_Base::E_Choice CMla_request_Base::Which(void) const
{
    return m_choice;
}

inline
void CMla_request_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CMla_request_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CMla_request_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CMla_request_Base::IsInit(void) const
{
    return m_choice == e_Init;
}

inline
void CMla_request_Base::SetInit(void)
{
    Select(e_Init, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMla_request_Base::IsGetmle(void) const
{
    return m_choice == e_Getmle;
}

inline
CMla_request_Base::TGetmle CMla_request_Base::GetGetmle(void) const
{
    CheckSelected(e_Getmle);
    return m_Getmle;
}

inline
CMla_request_Base::TGetmle& CMla_request_Base::SetGetmle(void)
{
    Select(e_Getmle, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getmle;
}

inline
void CMla_request_Base::SetGetmle(CMla_request_Base::TGetmle value)
{
    Select(e_Getmle, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getmle = value;
}

inline
bool CMla_request_Base::IsGetpub(void) const
{
    return m_choice == e_Getpub;
}

inline
CMla_request_Base::TGetpub CMla_request_Base::GetGetpub(void) const
{
    CheckSelected(e_Getpub);
    return m_Getpub;
}

inline
CMla_request_Base::TGetpub& CMla_request_Base::SetGetpub(void)
{
    Select(e_Getpub, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getpub;
}

inline
void CMla_request_Base::SetGetpub(CMla_request_Base::TGetpub value)
{
    Select(e_Getpub, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getpub = value;
}

inline
bool CMla_request_Base::IsGettitle(void) const
{
    return m_choice == e_Gettitle;
}

inline
bool CMla_request_Base::IsCitmatch(void) const
{
    return m_choice == e_Citmatch;
}

inline
bool CMla_request_Base::IsFini(void) const
{
    return m_choice == e_Fini;
}

inline
void CMla_request_Base::SetFini(void)
{
    Select(e_Fini, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CMla_request_Base::IsGetmriuids(void) const
{
    return m_choice == e_Getmriuids;
}

inline
CMla_request_Base::TGetmriuids CMla_request_Base::GetGetmriuids(void) const
{
    CheckSelected(e_Getmriuids);
    return m_Getmriuids;
}

inline
CMla_request_Base::TGetmriuids& CMla_request_Base::SetGetmriuids(void)
{
    Select(e_Getmriuids, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getmriuids;
}

inline
void CMla_request_Base::SetGetmriuids(CMla_request_Base::TGetmriuids value)
{
    Select(e_Getmriuids, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getmriuids = value;
}

inline
bool CMla_request_Base::IsGetaccuids(void) const
{
    return m_choice == e_Getaccuids;
}

inline
bool CMla_request_Base::IsUidtopmid(void) const
{
    return m_choice == e_Uidtopmid;
}

inline
CMla_request_Base::TUidtopmid CMla_request_Base::GetUidtopmid(void) const
{
    CheckSelected(e_Uidtopmid);
    return m_Uidtopmid;
}

inline
CMla_request_Base::TUidtopmid& CMla_request_Base::SetUidtopmid(void)
{
    Select(e_Uidtopmid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Uidtopmid;
}

inline
void CMla_request_Base::SetUidtopmid(CMla_request_Base::TUidtopmid value)
{
    Select(e_Uidtopmid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Uidtopmid = value;
}

inline
bool CMla_request_Base::IsPmidtouid(void) const
{
    return m_choice == e_Pmidtouid;
}

inline
const CMla_request_Base::TPmidtouid& CMla_request_Base::GetPmidtouid(void) const
{
    CheckSelected(e_Pmidtouid);
    return *m_Pmidtouid;
}

inline
CMla_request_Base::TPmidtouid& CMla_request_Base::SetPmidtouid(void)
{
    Select(e_Pmidtouid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Pmidtouid;
}

inline
bool CMla_request_Base::IsGetmlepmid(void) const
{
    return m_choice == e_Getmlepmid;
}

inline
const CMla_request_Base::TGetmlepmid& CMla_request_Base::GetGetmlepmid(void) const
{
    CheckSelected(e_Getmlepmid);
    return *m_Getmlepmid;
}

inline
CMla_request_Base::TGetmlepmid& CMla_request_Base::SetGetmlepmid(void)
{
    Select(e_Getmlepmid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getmlepmid;
}

inline
bool CMla_request_Base::IsGetpubpmid(void) const
{
    return m_choice == e_Getpubpmid;
}

inline
const CMla_request_Base::TGetpubpmid& CMla_request_Base::GetGetpubpmid(void) const
{
    CheckSelected(e_Getpubpmid);
    return *m_Getpubpmid;
}

inline
CMla_request_Base::TGetpubpmid& CMla_request_Base::SetGetpubpmid(void)
{
    Select(e_Getpubpmid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getpubpmid;
}

inline
bool CMla_request_Base::IsCitmatchpmid(void) const
{
    return m_choice == e_Citmatchpmid;
}

inline
bool CMla_request_Base::IsGetmripmids(void) const
{
    return m_choice == e_Getmripmids;
}

inline
CMla_request_Base::TGetmripmids CMla_request_Base::GetGetmripmids(void) const
{
    CheckSelected(e_Getmripmids);
    return m_Getmripmids;
}

inline
CMla_request_Base::TGetmripmids& CMla_request_Base::SetGetmripmids(void)
{
    Select(e_Getmripmids, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getmripmids;
}

inline
void CMla_request_Base::SetGetmripmids(CMla_request_Base::TGetmripmids value)
{
    Select(e_Getmripmids, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getmripmids = value;
}

inline
bool CMla_request_Base::IsGetaccpmids(void) const
{
    return m_choice == e_Getaccpmids;
}

inline
bool CMla_request_Base::IsCitlstpmids(void) const
{
    return m_choice == e_Citlstpmids;
}

inline
bool CMla_request_Base::IsGetmleuid(void) const
{
    return m_choice == e_Getmleuid;
}

inline
CMla_request_Base::TGetmleuid CMla_request_Base::GetGetmleuid(void) const
{
    CheckSelected(e_Getmleuid);
    return m_Getmleuid;
}

inline
CMla_request_Base::TGetmleuid& CMla_request_Base::SetGetmleuid(void)
{
    Select(e_Getmleuid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getmleuid;
}

inline
void CMla_request_Base::SetGetmleuid(CMla_request_Base::TGetmleuid value)
{
    Select(e_Getmleuid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getmleuid = value;
}

inline
bool CMla_request_Base::IsGetmlrpmid(void) const
{
    return m_choice == e_Getmlrpmid;
}

inline
const CMla_request_Base::TGetmlrpmid& CMla_request_Base::GetGetmlrpmid(void) const
{
    CheckSelected(e_Getmlrpmid);
    return *m_Getmlrpmid;
}

inline
CMla_request_Base::TGetmlrpmid& CMla_request_Base::SetGetmlrpmid(void)
{
    Select(e_Getmlrpmid, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Getmlrpmid;
}

inline
bool CMla_request_Base::IsGetmlruid(void) const
{
    return m_choice == e_Getmlruid;
}

inline
CMla_request_Base::TGetmlruid CMla_request_Base::GetGetmlruid(void) const
{
    CheckSelected(e_Getmlruid);
    return m_Getmlruid;
}

inline
CMla_request_Base::TGetmlruid& CMla_request_Base::SetGetmlruid(void)
{
    Select(e_Getmlruid, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Getmlruid;
}

inline
void CMla_request_Base::SetGetmlruid(CMla_request_Base::TGetmlruid value)
{
    Select(e_Getmlruid, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Getmlruid = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MLA_MLA_REQUEST_BASE_HPP
