/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mim_set_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mim.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MIM_MIM_SET_BASE_HPP
#define OBJECTS_MIM_MIM_SET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMim_date;
class CMim_entry;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MIM_EXPORT CMim_set_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMim_set_Base(void);
    // destructor
    virtual ~CMim_set_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMim_date TReleaseDate;
    typedef list< CRef< CMim_entry > > TMimEntries;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_releaseDate,
        e_mimEntries
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CMim_date TReleaseDate
    ///  Check whether the ReleaseDate data member has been assigned a value.
    bool IsSetReleaseDate(void) const;
    /// Check whether it is safe or not to call GetReleaseDate method.
    bool CanGetReleaseDate(void) const;
    void ResetReleaseDate(void);
    const TReleaseDate& GetReleaseDate(void) const;
    void SetReleaseDate(TReleaseDate& value);
    TReleaseDate& SetReleaseDate(void);

    /// mandatory
    /// typedef list< CRef< CMim_entry > > TMimEntries
    ///  Check whether the MimEntries data member has been assigned a value.
    bool IsSetMimEntries(void) const;
    /// Check whether it is safe or not to call GetMimEntries method.
    bool CanGetMimEntries(void) const;
    void ResetMimEntries(void);
    const TMimEntries& GetMimEntries(void) const;
    TMimEntries& SetMimEntries(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMim_set_Base(const CMim_set_Base&);
    CMim_set_Base& operator=(const CMim_set_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TReleaseDate > m_ReleaseDate;
    list< CRef< CMim_entry > > m_MimEntries;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMim_set_Base::IsSetReleaseDate(void) const
{
    return m_ReleaseDate.NotEmpty();
}

inline
bool CMim_set_Base::CanGetReleaseDate(void) const
{
    return true;
}

inline
const CMim_set_Base::TReleaseDate& CMim_set_Base::GetReleaseDate(void) const
{
    if ( !m_ReleaseDate ) {
        const_cast<CMim_set_Base*>(this)->ResetReleaseDate();
    }
    return (*m_ReleaseDate);
}

inline
CMim_set_Base::TReleaseDate& CMim_set_Base::SetReleaseDate(void)
{
    if ( !m_ReleaseDate ) {
        ResetReleaseDate();
    }
    return (*m_ReleaseDate);
}

inline
bool CMim_set_Base::IsSetMimEntries(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMim_set_Base::CanGetMimEntries(void) const
{
    return true;
}

inline
const CMim_set_Base::TMimEntries& CMim_set_Base::GetMimEntries(void) const
{
    return m_MimEntries;
}

inline
CMim_set_Base::TMimEntries& CMim_set_Base::SetMimEntries(void)
{
    m_set_State[0] |= 0x4;
    return m_MimEntries;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MIM_MIM_SET_BASE_HPP
