/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mim_reference_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mim.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MIM_MIM_REFERENCE_BASE_HPP
#define OBJECTS_MIM_MIM_REFERENCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMim_author;
class CMim_date;
class CMim_page;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MIM_EXPORT CMim_reference_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMim_reference_Base(void);
    // destructor
    virtual ~CMim_reference_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_not_set                = 0,
        eType_citation               = 1,
        eType_book                   = 2,
        eType_personal_communication = 3,
        eType_book_citation          = 4
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TNumber;
    typedef int TOrigNumber;
    typedef EType TType;
    typedef list< CRef< CMim_author > > TAuthors;
    typedef string TPrimaryAuthor;
    typedef string TOtherAuthors;
    typedef string TCitationTitle;
    typedef int TCitationType;
    typedef string TBookTitle;
    typedef list< CRef< CMim_author > > TEditors;
    typedef string TVolume;
    typedef string TEdition;
    typedef string TJournal;
    typedef string TSeries;
    typedef string TPublisher;
    typedef string TPlace;
    typedef string TCommNote;
    typedef CMim_date TPubDate;
    typedef list< CRef< CMim_page > > TPages;
    typedef string TMiscInfo;
    typedef int TPubmedUID;
    typedef bool TAmbiguous;
    typedef bool TNoLink;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_number,
        e_origNumber,
        e_type,
        e_authors,
        e_primaryAuthor,
        e_otherAuthors,
        e_citationTitle,
        e_citationType,
        e_bookTitle,
        e_editors,
        e_volume,
        e_edition,
        e_journal,
        e_series,
        e_publisher,
        e_place,
        e_commNote,
        e_pubDate,
        e_pages,
        e_miscInfo,
        e_pubmedUID,
        e_ambiguous,
        e_noLink
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 24> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TNumber
    ///  Check whether the Number data member has been assigned a value.
    bool IsSetNumber(void) const;
    /// Check whether it is safe or not to call GetNumber method.
    bool CanGetNumber(void) const;
    void ResetNumber(void);
    TNumber GetNumber(void) const;
    void SetNumber(TNumber value);
    TNumber& SetNumber(void);

    /// optional
    /// typedef int TOrigNumber
    ///  Check whether the OrigNumber data member has been assigned a value.
    bool IsSetOrigNumber(void) const;
    /// Check whether it is safe or not to call GetOrigNumber method.
    bool CanGetOrigNumber(void) const;
    void ResetOrigNumber(void);
    TOrigNumber GetOrigNumber(void) const;
    void SetOrigNumber(TOrigNumber value);
    TOrigNumber& SetOrigNumber(void);

    /// optional
    /// typedef EType TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef list< CRef< CMim_author > > TAuthors
    ///  Check whether the Authors data member has been assigned a value.
    bool IsSetAuthors(void) const;
    /// Check whether it is safe or not to call GetAuthors method.
    bool CanGetAuthors(void) const;
    void ResetAuthors(void);
    const TAuthors& GetAuthors(void) const;
    TAuthors& SetAuthors(void);

    /// mandatory
    /// typedef string TPrimaryAuthor
    ///  Check whether the PrimaryAuthor data member has been assigned a value.
    bool IsSetPrimaryAuthor(void) const;
    /// Check whether it is safe or not to call GetPrimaryAuthor method.
    bool CanGetPrimaryAuthor(void) const;
    void ResetPrimaryAuthor(void);
    const TPrimaryAuthor& GetPrimaryAuthor(void) const;
    void SetPrimaryAuthor(const TPrimaryAuthor& value);
    void SetPrimaryAuthor(TPrimaryAuthor&& value);
    TPrimaryAuthor& SetPrimaryAuthor(void);

    /// mandatory
    /// typedef string TOtherAuthors
    ///  Check whether the OtherAuthors data member has been assigned a value.
    bool IsSetOtherAuthors(void) const;
    /// Check whether it is safe or not to call GetOtherAuthors method.
    bool CanGetOtherAuthors(void) const;
    void ResetOtherAuthors(void);
    const TOtherAuthors& GetOtherAuthors(void) const;
    void SetOtherAuthors(const TOtherAuthors& value);
    void SetOtherAuthors(TOtherAuthors&& value);
    TOtherAuthors& SetOtherAuthors(void);

    /// mandatory
    /// typedef string TCitationTitle
    ///  Check whether the CitationTitle data member has been assigned a value.
    bool IsSetCitationTitle(void) const;
    /// Check whether it is safe or not to call GetCitationTitle method.
    bool CanGetCitationTitle(void) const;
    void ResetCitationTitle(void);
    const TCitationTitle& GetCitationTitle(void) const;
    void SetCitationTitle(const TCitationTitle& value);
    void SetCitationTitle(TCitationTitle&& value);
    TCitationTitle& SetCitationTitle(void);

    /// optional
    /// typedef int TCitationType
    ///  Check whether the CitationType data member has been assigned a value.
    bool IsSetCitationType(void) const;
    /// Check whether it is safe or not to call GetCitationType method.
    bool CanGetCitationType(void) const;
    void ResetCitationType(void);
    TCitationType GetCitationType(void) const;
    void SetCitationType(TCitationType value);
    TCitationType& SetCitationType(void);

    /// optional
    /// typedef string TBookTitle
    ///  Check whether the BookTitle data member has been assigned a value.
    bool IsSetBookTitle(void) const;
    /// Check whether it is safe or not to call GetBookTitle method.
    bool CanGetBookTitle(void) const;
    void ResetBookTitle(void);
    const TBookTitle& GetBookTitle(void) const;
    void SetBookTitle(const TBookTitle& value);
    void SetBookTitle(TBookTitle&& value);
    TBookTitle& SetBookTitle(void);

    /// optional
    /// typedef list< CRef< CMim_author > > TEditors
    ///  Check whether the Editors data member has been assigned a value.
    bool IsSetEditors(void) const;
    /// Check whether it is safe or not to call GetEditors method.
    bool CanGetEditors(void) const;
    void ResetEditors(void);
    const TEditors& GetEditors(void) const;
    TEditors& SetEditors(void);

    /// optional
    /// typedef string TVolume
    ///  Check whether the Volume data member has been assigned a value.
    bool IsSetVolume(void) const;
    /// Check whether it is safe or not to call GetVolume method.
    bool CanGetVolume(void) const;
    void ResetVolume(void);
    const TVolume& GetVolume(void) const;
    void SetVolume(const TVolume& value);
    void SetVolume(TVolume&& value);
    TVolume& SetVolume(void);

    /// optional
    /// typedef string TEdition
    ///  Check whether the Edition data member has been assigned a value.
    bool IsSetEdition(void) const;
    /// Check whether it is safe or not to call GetEdition method.
    bool CanGetEdition(void) const;
    void ResetEdition(void);
    const TEdition& GetEdition(void) const;
    void SetEdition(const TEdition& value);
    void SetEdition(TEdition&& value);
    TEdition& SetEdition(void);

    /// optional
    /// typedef string TJournal
    ///  Check whether the Journal data member has been assigned a value.
    bool IsSetJournal(void) const;
    /// Check whether it is safe or not to call GetJournal method.
    bool CanGetJournal(void) const;
    void ResetJournal(void);
    const TJournal& GetJournal(void) const;
    void SetJournal(const TJournal& value);
    void SetJournal(TJournal&& value);
    TJournal& SetJournal(void);

    /// optional
    /// typedef string TSeries
    ///  Check whether the Series data member has been assigned a value.
    bool IsSetSeries(void) const;
    /// Check whether it is safe or not to call GetSeries method.
    bool CanGetSeries(void) const;
    void ResetSeries(void);
    const TSeries& GetSeries(void) const;
    void SetSeries(const TSeries& value);
    void SetSeries(TSeries&& value);
    TSeries& SetSeries(void);

    /// optional
    /// typedef string TPublisher
    ///  Check whether the Publisher data member has been assigned a value.
    bool IsSetPublisher(void) const;
    /// Check whether it is safe or not to call GetPublisher method.
    bool CanGetPublisher(void) const;
    void ResetPublisher(void);
    const TPublisher& GetPublisher(void) const;
    void SetPublisher(const TPublisher& value);
    void SetPublisher(TPublisher&& value);
    TPublisher& SetPublisher(void);

    /// optional
    /// typedef string TPlace
    ///  Check whether the Place data member has been assigned a value.
    bool IsSetPlace(void) const;
    /// Check whether it is safe or not to call GetPlace method.
    bool CanGetPlace(void) const;
    void ResetPlace(void);
    const TPlace& GetPlace(void) const;
    void SetPlace(const TPlace& value);
    void SetPlace(TPlace&& value);
    TPlace& SetPlace(void);

    /// optional
    /// typedef string TCommNote
    ///  Check whether the CommNote data member has been assigned a value.
    bool IsSetCommNote(void) const;
    /// Check whether it is safe or not to call GetCommNote method.
    bool CanGetCommNote(void) const;
    void ResetCommNote(void);
    const TCommNote& GetCommNote(void) const;
    void SetCommNote(const TCommNote& value);
    void SetCommNote(TCommNote&& value);
    TCommNote& SetCommNote(void);

    /// mandatory
    /// typedef CMim_date TPubDate
    ///  Check whether the PubDate data member has been assigned a value.
    bool IsSetPubDate(void) const;
    /// Check whether it is safe or not to call GetPubDate method.
    bool CanGetPubDate(void) const;
    void ResetPubDate(void);
    const TPubDate& GetPubDate(void) const;
    void SetPubDate(TPubDate& value);
    TPubDate& SetPubDate(void);

    /// optional
    /// typedef list< CRef< CMim_page > > TPages
    ///  Check whether the Pages data member has been assigned a value.
    bool IsSetPages(void) const;
    /// Check whether it is safe or not to call GetPages method.
    bool CanGetPages(void) const;
    void ResetPages(void);
    const TPages& GetPages(void) const;
    TPages& SetPages(void);

    /// optional
    /// typedef string TMiscInfo
    ///  Check whether the MiscInfo data member has been assigned a value.
    bool IsSetMiscInfo(void) const;
    /// Check whether it is safe or not to call GetMiscInfo method.
    bool CanGetMiscInfo(void) const;
    void ResetMiscInfo(void);
    const TMiscInfo& GetMiscInfo(void) const;
    void SetMiscInfo(const TMiscInfo& value);
    void SetMiscInfo(TMiscInfo&& value);
    TMiscInfo& SetMiscInfo(void);

    /// optional
    /// typedef int TPubmedUID
    ///  Check whether the PubmedUID data member has been assigned a value.
    bool IsSetPubmedUID(void) const;
    /// Check whether it is safe or not to call GetPubmedUID method.
    bool CanGetPubmedUID(void) const;
    void ResetPubmedUID(void);
    TPubmedUID GetPubmedUID(void) const;
    void SetPubmedUID(TPubmedUID value);
    TPubmedUID& SetPubmedUID(void);

    /// mandatory
    /// typedef bool TAmbiguous
    ///  Check whether the Ambiguous data member has been assigned a value.
    bool IsSetAmbiguous(void) const;
    /// Check whether it is safe or not to call GetAmbiguous method.
    bool CanGetAmbiguous(void) const;
    void ResetAmbiguous(void);
    TAmbiguous GetAmbiguous(void) const;
    void SetAmbiguous(TAmbiguous value);
    TAmbiguous& SetAmbiguous(void);

    /// optional
    /// typedef bool TNoLink
    ///  Check whether the NoLink data member has been assigned a value.
    bool IsSetNoLink(void) const;
    /// Check whether it is safe or not to call GetNoLink method.
    bool CanGetNoLink(void) const;
    void ResetNoLink(void);
    TNoLink GetNoLink(void) const;
    void SetNoLink(TNoLink value);
    TNoLink& SetNoLink(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMim_reference_Base(const CMim_reference_Base&);
    CMim_reference_Base& operator=(const CMim_reference_Base&);

    // data
    Uint4 m_set_State[2];
    int m_Number;
    int m_OrigNumber;
    EType m_Type;
    list< CRef< CMim_author > > m_Authors;
    string m_PrimaryAuthor;
    string m_OtherAuthors;
    string m_CitationTitle;
    int m_CitationType;
    string m_BookTitle;
    list< CRef< CMim_author > > m_Editors;
    string m_Volume;
    string m_Edition;
    string m_Journal;
    string m_Series;
    string m_Publisher;
    string m_Place;
    string m_CommNote;
    CRef< TPubDate > m_PubDate;
    list< CRef< CMim_page > > m_Pages;
    string m_MiscInfo;
    int m_PubmedUID;
    bool m_Ambiguous;
    bool m_NoLink;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMim_reference_Base::IsSetNumber(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMim_reference_Base::CanGetNumber(void) const
{
    return IsSetNumber();
}

inline
void CMim_reference_Base::ResetNumber(void)
{
    m_Number = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMim_reference_Base::TNumber CMim_reference_Base::GetNumber(void) const
{
    if (!CanGetNumber()) {
        ThrowUnassigned(0);
    }
    return m_Number;
}

inline
void CMim_reference_Base::SetNumber(CMim_reference_Base::TNumber value)
{
    m_Number = value;
    m_set_State[0] |= 0x3;
}

inline
CMim_reference_Base::TNumber& CMim_reference_Base::SetNumber(void)
{
#ifdef _DEBUG
    if (!IsSetNumber()) {
        memset(&m_Number,UnassignedByte(),sizeof(m_Number));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Number;
}

inline
bool CMim_reference_Base::IsSetOrigNumber(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMim_reference_Base::CanGetOrigNumber(void) const
{
    return IsSetOrigNumber();
}

inline
void CMim_reference_Base::ResetOrigNumber(void)
{
    m_OrigNumber = 0;
    m_set_State[0] &= ~0xc;
}

inline
CMim_reference_Base::TOrigNumber CMim_reference_Base::GetOrigNumber(void) const
{
    if (!CanGetOrigNumber()) {
        ThrowUnassigned(1);
    }
    return m_OrigNumber;
}

inline
void CMim_reference_Base::SetOrigNumber(CMim_reference_Base::TOrigNumber value)
{
    m_OrigNumber = value;
    m_set_State[0] |= 0xc;
}

inline
CMim_reference_Base::TOrigNumber& CMim_reference_Base::SetOrigNumber(void)
{
#ifdef _DEBUG
    if (!IsSetOrigNumber()) {
        memset(&m_OrigNumber,UnassignedByte(),sizeof(m_OrigNumber));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_OrigNumber;
}

inline
bool CMim_reference_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMim_reference_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CMim_reference_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x30;
}

inline
CMim_reference_Base::TType CMim_reference_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(2);
    }
    return m_Type;
}

inline
void CMim_reference_Base::SetType(CMim_reference_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x30;
}

inline
CMim_reference_Base::TType& CMim_reference_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Type;
}

inline
bool CMim_reference_Base::IsSetAuthors(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMim_reference_Base::CanGetAuthors(void) const
{
    return true;
}

inline
const CMim_reference_Base::TAuthors& CMim_reference_Base::GetAuthors(void) const
{
    return m_Authors;
}

inline
CMim_reference_Base::TAuthors& CMim_reference_Base::SetAuthors(void)
{
    m_set_State[0] |= 0x40;
    return m_Authors;
}

inline
bool CMim_reference_Base::IsSetPrimaryAuthor(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMim_reference_Base::CanGetPrimaryAuthor(void) const
{
    return IsSetPrimaryAuthor();
}

inline
const CMim_reference_Base::TPrimaryAuthor& CMim_reference_Base::GetPrimaryAuthor(void) const
{
    if (!CanGetPrimaryAuthor()) {
        ThrowUnassigned(4);
    }
    return m_PrimaryAuthor;
}

inline
void CMim_reference_Base::SetPrimaryAuthor(const CMim_reference_Base::TPrimaryAuthor& value)
{
    m_PrimaryAuthor = value;
    m_set_State[0] |= 0x300;
}

inline
void CMim_reference_Base::SetPrimaryAuthor(CMim_reference_Base::TPrimaryAuthor&& value)
{
    m_PrimaryAuthor = std::forward<CMim_reference_Base::TPrimaryAuthor>(value);
    m_set_State[0] |= 0x300;
}

inline
CMim_reference_Base::TPrimaryAuthor& CMim_reference_Base::SetPrimaryAuthor(void)
{
#ifdef _DEBUG
    if (!IsSetPrimaryAuthor()) {
        m_PrimaryAuthor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_PrimaryAuthor;
}

inline
bool CMim_reference_Base::IsSetOtherAuthors(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMim_reference_Base::CanGetOtherAuthors(void) const
{
    return IsSetOtherAuthors();
}

inline
const CMim_reference_Base::TOtherAuthors& CMim_reference_Base::GetOtherAuthors(void) const
{
    if (!CanGetOtherAuthors()) {
        ThrowUnassigned(5);
    }
    return m_OtherAuthors;
}

inline
void CMim_reference_Base::SetOtherAuthors(const CMim_reference_Base::TOtherAuthors& value)
{
    m_OtherAuthors = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMim_reference_Base::SetOtherAuthors(CMim_reference_Base::TOtherAuthors&& value)
{
    m_OtherAuthors = std::forward<CMim_reference_Base::TOtherAuthors>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMim_reference_Base::TOtherAuthors& CMim_reference_Base::SetOtherAuthors(void)
{
#ifdef _DEBUG
    if (!IsSetOtherAuthors()) {
        m_OtherAuthors = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_OtherAuthors;
}

inline
bool CMim_reference_Base::IsSetCitationTitle(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMim_reference_Base::CanGetCitationTitle(void) const
{
    return IsSetCitationTitle();
}

inline
const CMim_reference_Base::TCitationTitle& CMim_reference_Base::GetCitationTitle(void) const
{
    if (!CanGetCitationTitle()) {
        ThrowUnassigned(6);
    }
    return m_CitationTitle;
}

inline
void CMim_reference_Base::SetCitationTitle(const CMim_reference_Base::TCitationTitle& value)
{
    m_CitationTitle = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMim_reference_Base::SetCitationTitle(CMim_reference_Base::TCitationTitle&& value)
{
    m_CitationTitle = std::forward<CMim_reference_Base::TCitationTitle>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMim_reference_Base::TCitationTitle& CMim_reference_Base::SetCitationTitle(void)
{
#ifdef _DEBUG
    if (!IsSetCitationTitle()) {
        m_CitationTitle = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_CitationTitle;
}

inline
bool CMim_reference_Base::IsSetCitationType(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMim_reference_Base::CanGetCitationType(void) const
{
    return IsSetCitationType();
}

inline
void CMim_reference_Base::ResetCitationType(void)
{
    m_CitationType = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CMim_reference_Base::TCitationType CMim_reference_Base::GetCitationType(void) const
{
    if (!CanGetCitationType()) {
        ThrowUnassigned(7);
    }
    return m_CitationType;
}

inline
void CMim_reference_Base::SetCitationType(CMim_reference_Base::TCitationType value)
{
    m_CitationType = value;
    m_set_State[0] |= 0xc000;
}

inline
CMim_reference_Base::TCitationType& CMim_reference_Base::SetCitationType(void)
{
#ifdef _DEBUG
    if (!IsSetCitationType()) {
        memset(&m_CitationType,UnassignedByte(),sizeof(m_CitationType));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_CitationType;
}

inline
bool CMim_reference_Base::IsSetBookTitle(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMim_reference_Base::CanGetBookTitle(void) const
{
    return IsSetBookTitle();
}

inline
const CMim_reference_Base::TBookTitle& CMim_reference_Base::GetBookTitle(void) const
{
    if (!CanGetBookTitle()) {
        ThrowUnassigned(8);
    }
    return m_BookTitle;
}

inline
void CMim_reference_Base::SetBookTitle(const CMim_reference_Base::TBookTitle& value)
{
    m_BookTitle = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMim_reference_Base::SetBookTitle(CMim_reference_Base::TBookTitle&& value)
{
    m_BookTitle = std::forward<CMim_reference_Base::TBookTitle>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMim_reference_Base::TBookTitle& CMim_reference_Base::SetBookTitle(void)
{
#ifdef _DEBUG
    if (!IsSetBookTitle()) {
        m_BookTitle = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_BookTitle;
}

inline
bool CMim_reference_Base::IsSetEditors(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMim_reference_Base::CanGetEditors(void) const
{
    return true;
}

inline
const CMim_reference_Base::TEditors& CMim_reference_Base::GetEditors(void) const
{
    return m_Editors;
}

inline
CMim_reference_Base::TEditors& CMim_reference_Base::SetEditors(void)
{
    m_set_State[0] |= 0x40000;
    return m_Editors;
}

inline
bool CMim_reference_Base::IsSetVolume(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMim_reference_Base::CanGetVolume(void) const
{
    return IsSetVolume();
}

inline
const CMim_reference_Base::TVolume& CMim_reference_Base::GetVolume(void) const
{
    if (!CanGetVolume()) {
        ThrowUnassigned(10);
    }
    return m_Volume;
}

inline
void CMim_reference_Base::SetVolume(const CMim_reference_Base::TVolume& value)
{
    m_Volume = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMim_reference_Base::SetVolume(CMim_reference_Base::TVolume&& value)
{
    m_Volume = std::forward<CMim_reference_Base::TVolume>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMim_reference_Base::TVolume& CMim_reference_Base::SetVolume(void)
{
#ifdef _DEBUG
    if (!IsSetVolume()) {
        m_Volume = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Volume;
}

inline
bool CMim_reference_Base::IsSetEdition(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMim_reference_Base::CanGetEdition(void) const
{
    return IsSetEdition();
}

inline
const CMim_reference_Base::TEdition& CMim_reference_Base::GetEdition(void) const
{
    if (!CanGetEdition()) {
        ThrowUnassigned(11);
    }
    return m_Edition;
}

inline
void CMim_reference_Base::SetEdition(const CMim_reference_Base::TEdition& value)
{
    m_Edition = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CMim_reference_Base::SetEdition(CMim_reference_Base::TEdition&& value)
{
    m_Edition = std::forward<CMim_reference_Base::TEdition>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CMim_reference_Base::TEdition& CMim_reference_Base::SetEdition(void)
{
#ifdef _DEBUG
    if (!IsSetEdition()) {
        m_Edition = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Edition;
}

inline
bool CMim_reference_Base::IsSetJournal(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMim_reference_Base::CanGetJournal(void) const
{
    return IsSetJournal();
}

inline
const CMim_reference_Base::TJournal& CMim_reference_Base::GetJournal(void) const
{
    if (!CanGetJournal()) {
        ThrowUnassigned(12);
    }
    return m_Journal;
}

inline
void CMim_reference_Base::SetJournal(const CMim_reference_Base::TJournal& value)
{
    m_Journal = value;
    m_set_State[0] |= 0x3000000;
}

inline
void CMim_reference_Base::SetJournal(CMim_reference_Base::TJournal&& value)
{
    m_Journal = std::forward<CMim_reference_Base::TJournal>(value);
    m_set_State[0] |= 0x3000000;
}

inline
CMim_reference_Base::TJournal& CMim_reference_Base::SetJournal(void)
{
#ifdef _DEBUG
    if (!IsSetJournal()) {
        m_Journal = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Journal;
}

inline
bool CMim_reference_Base::IsSetSeries(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMim_reference_Base::CanGetSeries(void) const
{
    return IsSetSeries();
}

inline
const CMim_reference_Base::TSeries& CMim_reference_Base::GetSeries(void) const
{
    if (!CanGetSeries()) {
        ThrowUnassigned(13);
    }
    return m_Series;
}

inline
void CMim_reference_Base::SetSeries(const CMim_reference_Base::TSeries& value)
{
    m_Series = value;
    m_set_State[0] |= 0xc000000;
}

inline
void CMim_reference_Base::SetSeries(CMim_reference_Base::TSeries&& value)
{
    m_Series = std::forward<CMim_reference_Base::TSeries>(value);
    m_set_State[0] |= 0xc000000;
}

inline
CMim_reference_Base::TSeries& CMim_reference_Base::SetSeries(void)
{
#ifdef _DEBUG
    if (!IsSetSeries()) {
        m_Series = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Series;
}

inline
bool CMim_reference_Base::IsSetPublisher(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMim_reference_Base::CanGetPublisher(void) const
{
    return IsSetPublisher();
}

inline
const CMim_reference_Base::TPublisher& CMim_reference_Base::GetPublisher(void) const
{
    if (!CanGetPublisher()) {
        ThrowUnassigned(14);
    }
    return m_Publisher;
}

inline
void CMim_reference_Base::SetPublisher(const CMim_reference_Base::TPublisher& value)
{
    m_Publisher = value;
    m_set_State[0] |= 0x30000000;
}

inline
void CMim_reference_Base::SetPublisher(CMim_reference_Base::TPublisher&& value)
{
    m_Publisher = std::forward<CMim_reference_Base::TPublisher>(value);
    m_set_State[0] |= 0x30000000;
}

inline
CMim_reference_Base::TPublisher& CMim_reference_Base::SetPublisher(void)
{
#ifdef _DEBUG
    if (!IsSetPublisher()) {
        m_Publisher = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Publisher;
}

inline
bool CMim_reference_Base::IsSetPlace(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMim_reference_Base::CanGetPlace(void) const
{
    return IsSetPlace();
}

inline
const CMim_reference_Base::TPlace& CMim_reference_Base::GetPlace(void) const
{
    if (!CanGetPlace()) {
        ThrowUnassigned(15);
    }
    return m_Place;
}

inline
void CMim_reference_Base::SetPlace(const CMim_reference_Base::TPlace& value)
{
    m_Place = value;
    m_set_State[0] |= 0xc0000000;
}

inline
void CMim_reference_Base::SetPlace(CMim_reference_Base::TPlace&& value)
{
    m_Place = std::forward<CMim_reference_Base::TPlace>(value);
    m_set_State[0] |= 0xc0000000;
}

inline
CMim_reference_Base::TPlace& CMim_reference_Base::SetPlace(void)
{
#ifdef _DEBUG
    if (!IsSetPlace()) {
        m_Place = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Place;
}

inline
bool CMim_reference_Base::IsSetCommNote(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CMim_reference_Base::CanGetCommNote(void) const
{
    return IsSetCommNote();
}

inline
const CMim_reference_Base::TCommNote& CMim_reference_Base::GetCommNote(void) const
{
    if (!CanGetCommNote()) {
        ThrowUnassigned(16);
    }
    return m_CommNote;
}

inline
void CMim_reference_Base::SetCommNote(const CMim_reference_Base::TCommNote& value)
{
    m_CommNote = value;
    m_set_State[1] |= 0x3;
}

inline
void CMim_reference_Base::SetCommNote(CMim_reference_Base::TCommNote&& value)
{
    m_CommNote = std::forward<CMim_reference_Base::TCommNote>(value);
    m_set_State[1] |= 0x3;
}

inline
CMim_reference_Base::TCommNote& CMim_reference_Base::SetCommNote(void)
{
#ifdef _DEBUG
    if (!IsSetCommNote()) {
        m_CommNote = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x1;
    return m_CommNote;
}

inline
bool CMim_reference_Base::IsSetPubDate(void) const
{
    return m_PubDate.NotEmpty();
}

inline
bool CMim_reference_Base::CanGetPubDate(void) const
{
    return true;
}

inline
const CMim_reference_Base::TPubDate& CMim_reference_Base::GetPubDate(void) const
{
    if ( !m_PubDate ) {
        const_cast<CMim_reference_Base*>(this)->ResetPubDate();
    }
    return (*m_PubDate);
}

inline
CMim_reference_Base::TPubDate& CMim_reference_Base::SetPubDate(void)
{
    if ( !m_PubDate ) {
        ResetPubDate();
    }
    return (*m_PubDate);
}

inline
bool CMim_reference_Base::IsSetPages(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CMim_reference_Base::CanGetPages(void) const
{
    return true;
}

inline
const CMim_reference_Base::TPages& CMim_reference_Base::GetPages(void) const
{
    return m_Pages;
}

inline
CMim_reference_Base::TPages& CMim_reference_Base::SetPages(void)
{
    m_set_State[1] |= 0x10;
    return m_Pages;
}

inline
bool CMim_reference_Base::IsSetMiscInfo(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CMim_reference_Base::CanGetMiscInfo(void) const
{
    return IsSetMiscInfo();
}

inline
const CMim_reference_Base::TMiscInfo& CMim_reference_Base::GetMiscInfo(void) const
{
    if (!CanGetMiscInfo()) {
        ThrowUnassigned(19);
    }
    return m_MiscInfo;
}

inline
void CMim_reference_Base::SetMiscInfo(const CMim_reference_Base::TMiscInfo& value)
{
    m_MiscInfo = value;
    m_set_State[1] |= 0xc0;
}

inline
void CMim_reference_Base::SetMiscInfo(CMim_reference_Base::TMiscInfo&& value)
{
    m_MiscInfo = std::forward<CMim_reference_Base::TMiscInfo>(value);
    m_set_State[1] |= 0xc0;
}

inline
CMim_reference_Base::TMiscInfo& CMim_reference_Base::SetMiscInfo(void)
{
#ifdef _DEBUG
    if (!IsSetMiscInfo()) {
        m_MiscInfo = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x40;
    return m_MiscInfo;
}

inline
bool CMim_reference_Base::IsSetPubmedUID(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CMim_reference_Base::CanGetPubmedUID(void) const
{
    return IsSetPubmedUID();
}

inline
void CMim_reference_Base::ResetPubmedUID(void)
{
    m_PubmedUID = 0;
    m_set_State[1] &= ~0x300;
}

inline
CMim_reference_Base::TPubmedUID CMim_reference_Base::GetPubmedUID(void) const
{
    if (!CanGetPubmedUID()) {
        ThrowUnassigned(20);
    }
    return m_PubmedUID;
}

inline
void CMim_reference_Base::SetPubmedUID(CMim_reference_Base::TPubmedUID value)
{
    m_PubmedUID = value;
    m_set_State[1] |= 0x300;
}

inline
CMim_reference_Base::TPubmedUID& CMim_reference_Base::SetPubmedUID(void)
{
#ifdef _DEBUG
    if (!IsSetPubmedUID()) {
        memset(&m_PubmedUID,UnassignedByte(),sizeof(m_PubmedUID));
    }
#endif
    m_set_State[1] |= 0x100;
    return m_PubmedUID;
}

inline
bool CMim_reference_Base::IsSetAmbiguous(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CMim_reference_Base::CanGetAmbiguous(void) const
{
    return IsSetAmbiguous();
}

inline
void CMim_reference_Base::ResetAmbiguous(void)
{
    m_Ambiguous = 0;
    m_set_State[1] &= ~0xc00;
}

inline
CMim_reference_Base::TAmbiguous CMim_reference_Base::GetAmbiguous(void) const
{
    if (!CanGetAmbiguous()) {
        ThrowUnassigned(21);
    }
    return m_Ambiguous;
}

inline
void CMim_reference_Base::SetAmbiguous(CMim_reference_Base::TAmbiguous value)
{
    m_Ambiguous = value;
    m_set_State[1] |= 0xc00;
}

inline
CMim_reference_Base::TAmbiguous& CMim_reference_Base::SetAmbiguous(void)
{
#ifdef _DEBUG
    if (!IsSetAmbiguous()) {
        memset(&m_Ambiguous,UnassignedByte(),sizeof(m_Ambiguous));
    }
#endif
    m_set_State[1] |= 0x400;
    return m_Ambiguous;
}

inline
bool CMim_reference_Base::IsSetNoLink(void) const
{
    return ((m_set_State[1] & 0x3000) != 0);
}

inline
bool CMim_reference_Base::CanGetNoLink(void) const
{
    return IsSetNoLink();
}

inline
void CMim_reference_Base::ResetNoLink(void)
{
    m_NoLink = 0;
    m_set_State[1] &= ~0x3000;
}

inline
CMim_reference_Base::TNoLink CMim_reference_Base::GetNoLink(void) const
{
    if (!CanGetNoLink()) {
        ThrowUnassigned(22);
    }
    return m_NoLink;
}

inline
void CMim_reference_Base::SetNoLink(CMim_reference_Base::TNoLink value)
{
    m_NoLink = value;
    m_set_State[1] |= 0x3000;
}

inline
CMim_reference_Base::TNoLink& CMim_reference_Base::SetNoLink(void)
{
#ifdef _DEBUG
    if (!IsSetNoLink()) {
        memset(&m_NoLink,UnassignedByte(),sizeof(m_NoLink));
    }
#endif
    m_set_State[1] |= 0x1000;
    return m_NoLink;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MIM_MIM_REFERENCE_BASE_HPP
