/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Table_match_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_TABLE_MATCH_BASE_HPP
#define OBJECTS_MACRO_TABLE_MATCH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/String_location.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTable_match_type;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CTable_match_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTable_match_Base(void);
    // destructor
    virtual ~CTable_match_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CTable_match_type TMatch_type;
    typedef EString_location TMatch_location;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_match_type,
        e_match_location
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CTable_match_type TMatch_type
    ///  Check whether the Match_type data member has been assigned a value.
    bool IsSetMatch_type(void) const;
    /// Check whether it is safe or not to call GetMatch_type method.
    bool CanGetMatch_type(void) const;
    void ResetMatch_type(void);
    const TMatch_type& GetMatch_type(void) const;
    void SetMatch_type(TMatch_type& value);
    TMatch_type& SetMatch_type(void);

    /// optional with default eString_location_equals
    /// typedef EString_location TMatch_location
    ///  Check whether the Match_location data member has been assigned a value.
    bool IsSetMatch_location(void) const;
    /// Check whether it is safe or not to call GetMatch_location method.
    bool CanGetMatch_location(void) const;
    void ResetMatch_location(void);
    void SetDefaultMatch_location(void);
    TMatch_location GetMatch_location(void) const;
    void SetMatch_location(TMatch_location value);
    TMatch_location& SetMatch_location(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTable_match_Base(const CTable_match_Base&);
    CTable_match_Base& operator=(const CTable_match_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TMatch_type > m_Match_type;
    EString_location m_Match_location;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTable_match_Base::IsSetMatch_type(void) const
{
    return m_Match_type.NotEmpty();
}

inline
bool CTable_match_Base::CanGetMatch_type(void) const
{
    return true;
}

inline
const CTable_match_Base::TMatch_type& CTable_match_Base::GetMatch_type(void) const
{
    if ( !m_Match_type ) {
        const_cast<CTable_match_Base*>(this)->ResetMatch_type();
    }
    return (*m_Match_type);
}

inline
CTable_match_Base::TMatch_type& CTable_match_Base::SetMatch_type(void)
{
    if ( !m_Match_type ) {
        ResetMatch_type();
    }
    return (*m_Match_type);
}

inline
bool CTable_match_Base::IsSetMatch_location(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTable_match_Base::CanGetMatch_location(void) const
{
    return true;
}

inline
void CTable_match_Base::ResetMatch_location(void)
{
    m_Match_location = eString_location_equals;
    m_set_State[0] &= ~0xc;
}

inline
void CTable_match_Base::SetDefaultMatch_location(void)
{
    ResetMatch_location();
}

inline
CTable_match_Base::TMatch_location CTable_match_Base::GetMatch_location(void) const
{
    return m_Match_location;
}

inline
void CTable_match_Base::SetMatch_location(CTable_match_Base::TMatch_location value)
{
    m_Match_location = value;
    m_set_State[0] |= 0xc;
}

inline
CTable_match_Base::TMatch_location& CTable_match_Base::SetMatch_location(void)
{
#ifdef _DEBUG
    if (!IsSetMatch_location()) {
        memset(&m_Match_location,UnassignedByte(),sizeof(m_Match_location));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Match_location;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_TABLE_MATCH_BASE_HPP
