/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Retranslate_cds_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_RETRANSLATE_CDS_ACTION_BASE_HPP
#define OBJECTS_MACRO_RETRANSLATE_CDS_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CRetranslate_cds_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRetranslate_cds_action_Base(void);
    // destructor
    virtual ~CRetranslate_cds_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef bool TObey_stop_codon;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_obey_stop_codon
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef bool TObey_stop_codon
    ///  Check whether the Obey_stop_codon data member has been assigned a value.
    bool IsSetObey_stop_codon(void) const;
    /// Check whether it is safe or not to call GetObey_stop_codon method.
    bool CanGetObey_stop_codon(void) const;
    void ResetObey_stop_codon(void);
    TObey_stop_codon GetObey_stop_codon(void) const;
    void SetObey_stop_codon(TObey_stop_codon value);
    TObey_stop_codon& SetObey_stop_codon(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRetranslate_cds_action_Base(const CRetranslate_cds_action_Base&);
    CRetranslate_cds_action_Base& operator=(const CRetranslate_cds_action_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_Obey_stop_codon;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRetranslate_cds_action_Base::IsSetObey_stop_codon(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRetranslate_cds_action_Base::CanGetObey_stop_codon(void) const
{
    return IsSetObey_stop_codon();
}

inline
void CRetranslate_cds_action_Base::ResetObey_stop_codon(void)
{
    m_Obey_stop_codon = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRetranslate_cds_action_Base::TObey_stop_codon CRetranslate_cds_action_Base::GetObey_stop_codon(void) const
{
    if (!CanGetObey_stop_codon()) {
        ThrowUnassigned(0);
    }
    return m_Obey_stop_codon;
}

inline
void CRetranslate_cds_action_Base::SetObey_stop_codon(CRetranslate_cds_action_Base::TObey_stop_codon value)
{
    m_Obey_stop_codon = value;
    m_set_State[0] |= 0x3;
}

inline
CRetranslate_cds_action_Base::TObey_stop_codon& CRetranslate_cds_action_Base::SetObey_stop_codon(void)
{
#ifdef _DEBUG
    if (!IsSetObey_stop_codon()) {
        memset(&m_Obey_stop_codon,UnassignedByte(),sizeof(m_Obey_stop_codon));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Obey_stop_codon;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_RETRANSLATE_CDS_ACTION_BASE_HPP
