/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Pub_field_speci_const_type_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_PUB_FIELD_SPECI_CONST_TYPE_BASE_HPP
#define OBJECTS_MACRO_PUB_FIELD_SPECI_CONST_TYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPub_field_special_constraint_type_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPub_field_special_constraint_type_Base(void);
    // destructor
    virtual ~CPub_field_special_constraint_type_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,     ///< No variant selected
        e_Is_present,
        e_Is_not_present,
        e_Is_all_caps,
        e_Is_all_lower,
        e_Is_all_punct
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 6 ///< == e_Is_all_punct+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types

    // getters
    // setters


    bool IsIs_present(void) const;
    void SetIs_present(void);


    bool IsIs_not_present(void) const;
    void SetIs_not_present(void);


    bool IsIs_all_caps(void) const;
    void SetIs_all_caps(void);


    bool IsIs_all_lower(void) const;
    void SetIs_all_lower(void);


    bool IsIs_all_punct(void) const;
    void SetIs_all_punct(void);


private:
    // copy constructor and assignment operator
    CPub_field_special_constraint_type_Base(const CPub_field_special_constraint_type_Base& );
    CPub_field_special_constraint_type_Base& operator=(const CPub_field_special_constraint_type_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPub_field_special_constraint_type_Base::E_Choice CPub_field_special_constraint_type_Base::Which(void) const
{
    return m_choice;
}

inline
void CPub_field_special_constraint_type_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPub_field_special_constraint_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPub_field_special_constraint_type_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPub_field_special_constraint_type_Base::IsIs_present(void) const
{
    return m_choice == e_Is_present;
}

inline
void CPub_field_special_constraint_type_Base::SetIs_present(void)
{
    Select(e_Is_present, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CPub_field_special_constraint_type_Base::IsIs_not_present(void) const
{
    return m_choice == e_Is_not_present;
}

inline
void CPub_field_special_constraint_type_Base::SetIs_not_present(void)
{
    Select(e_Is_not_present, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CPub_field_special_constraint_type_Base::IsIs_all_caps(void) const
{
    return m_choice == e_Is_all_caps;
}

inline
void CPub_field_special_constraint_type_Base::SetIs_all_caps(void)
{
    Select(e_Is_all_caps, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CPub_field_special_constraint_type_Base::IsIs_all_lower(void) const
{
    return m_choice == e_Is_all_lower;
}

inline
void CPub_field_special_constraint_type_Base::SetIs_all_lower(void)
{
    Select(e_Is_all_lower, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CPub_field_special_constraint_type_Base::IsIs_all_punct(void) const
{
    return m_choice == e_Is_all_punct;
}

inline
void CPub_field_special_constraint_type_Base::SetIs_all_punct(void)
{
    Select(e_Is_all_punct, NCBI_NS_NCBI::eDoNotResetVariant);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_PUB_FIELD_SPECI_CONST_TYPE_BASE_HPP
