/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Make_gene_xref_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_MAKE_GENE_XREF_ACTION_BASE_HPP
#define OBJECTS_MACRO_MAKE_GENE_XREF_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Macro_feature_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CConstraint_choice_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMake_gene_xref_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMake_gene_xref_action_Base(void);
    // destructor
    virtual ~CMake_gene_xref_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EMacro_feature_type TFeature;
    typedef CConstraint_choice_set TConstraint;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_feature,
        e_constraint
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EMacro_feature_type TFeature
    ///  Check whether the Feature data member has been assigned a value.
    bool IsSetFeature(void) const;
    /// Check whether it is safe or not to call GetFeature method.
    bool CanGetFeature(void) const;
    void ResetFeature(void);
    TFeature GetFeature(void) const;
    void SetFeature(TFeature value);
    TFeature& SetFeature(void);

    /// optional
    /// typedef CConstraint_choice_set TConstraint
    ///  Check whether the Constraint data member has been assigned a value.
    bool IsSetConstraint(void) const;
    /// Check whether it is safe or not to call GetConstraint method.
    bool CanGetConstraint(void) const;
    void ResetConstraint(void);
    const TConstraint& GetConstraint(void) const;
    void SetConstraint(TConstraint& value);
    TConstraint& SetConstraint(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMake_gene_xref_action_Base(const CMake_gene_xref_action_Base&);
    CMake_gene_xref_action_Base& operator=(const CMake_gene_xref_action_Base&);

    // data
    Uint4 m_set_State[1];
    EMacro_feature_type m_Feature;
    CRef< TConstraint > m_Constraint;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMake_gene_xref_action_Base::IsSetFeature(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMake_gene_xref_action_Base::CanGetFeature(void) const
{
    return IsSetFeature();
}

inline
void CMake_gene_xref_action_Base::ResetFeature(void)
{
    m_Feature = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CMake_gene_xref_action_Base::TFeature CMake_gene_xref_action_Base::GetFeature(void) const
{
    if (!CanGetFeature()) {
        ThrowUnassigned(0);
    }
    return m_Feature;
}

inline
void CMake_gene_xref_action_Base::SetFeature(CMake_gene_xref_action_Base::TFeature value)
{
    m_Feature = value;
    m_set_State[0] |= 0x3;
}

inline
CMake_gene_xref_action_Base::TFeature& CMake_gene_xref_action_Base::SetFeature(void)
{
#ifdef _DEBUG
    if (!IsSetFeature()) {
        memset(&m_Feature,UnassignedByte(),sizeof(m_Feature));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Feature;
}

inline
bool CMake_gene_xref_action_Base::IsSetConstraint(void) const
{
    return m_Constraint.NotEmpty();
}

inline
bool CMake_gene_xref_action_Base::CanGetConstraint(void) const
{
    return IsSetConstraint();
}

inline
const CMake_gene_xref_action_Base::TConstraint& CMake_gene_xref_action_Base::GetConstraint(void) const
{
    if (!CanGetConstraint()) {
        ThrowUnassigned(1);
    }
    return (*m_Constraint);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_MAKE_GENE_XREF_ACTION_BASE_HPP
