/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Feature_field_legal_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_FEATURE_FIELD_LEGAL_BASE_HPP
#define OBJECTS_MACRO_FEATURE_FIELD_LEGAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Feat_qual_legal.hpp>
#include <objects/macro/Macro_feature_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CFeature_field_legal_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CFeature_field_legal_Base(void);
    // destructor
    virtual ~CFeature_field_legal_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EMacro_feature_type TType;
    typedef EFeat_qual_legal TField;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_field
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EMacro_feature_type TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef EFeat_qual_legal TField
    ///  Check whether the Field data member has been assigned a value.
    bool IsSetField(void) const;
    /// Check whether it is safe or not to call GetField method.
    bool CanGetField(void) const;
    void ResetField(void);
    TField GetField(void) const;
    void SetField(TField value);
    TField& SetField(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CFeature_field_legal_Base(const CFeature_field_legal_Base&);
    CFeature_field_legal_Base& operator=(const CFeature_field_legal_Base&);

    // data
    Uint4 m_set_State[1];
    EMacro_feature_type m_Type;
    EFeat_qual_legal m_Field;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CFeature_field_legal_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CFeature_field_legal_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CFeature_field_legal_Base::ResetType(void)
{
    m_Type = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CFeature_field_legal_Base::TType CFeature_field_legal_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CFeature_field_legal_Base::SetType(CFeature_field_legal_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CFeature_field_legal_Base::TType& CFeature_field_legal_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CFeature_field_legal_Base::IsSetField(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CFeature_field_legal_Base::CanGetField(void) const
{
    return IsSetField();
}

inline
void CFeature_field_legal_Base::ResetField(void)
{
    m_Field = (ncbi::objects::EFeat_qual_legal)(0);
    m_set_State[0] &= ~0xc;
}

inline
CFeature_field_legal_Base::TField CFeature_field_legal_Base::GetField(void) const
{
    if (!CanGetField()) {
        ThrowUnassigned(1);
    }
    return m_Field;
}

inline
void CFeature_field_legal_Base::SetField(CFeature_field_legal_Base::TField value)
{
    m_Field = value;
    m_set_State[0] |= 0xc;
}

inline
CFeature_field_legal_Base::TField& CFeature_field_legal_Base::SetField(void)
{
#ifdef _DEBUG
    if (!IsSetField()) {
        memset(&m_Field,UnassignedByte(),sizeof(m_Field));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Field;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_FEATURE_FIELD_LEGAL_BASE_HPP
