/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Edit_featur_locatio_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_EDIT_FEATUR_LOCATIO_ACTION_BASE_HPP
#define OBJECTS_MACRO_EDIT_FEATUR_LOCATIO_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Macro_feature_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CConstraint_choice_set;
class CLocation_edit_type;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CEdit_feature_location_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEdit_feature_location_action_Base(void);
    // destructor
    virtual ~CEdit_feature_location_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EMacro_feature_type TType;
    typedef CLocation_edit_type TAction;
    typedef bool TRetranslate_cds;
    typedef bool TAlso_edit_gene;
    typedef CConstraint_choice_set TConstraint;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_action,
        e_retranslate_cds,
        e_also_edit_gene,
        e_constraint
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EMacro_feature_type TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef CLocation_edit_type TAction
    ///  Check whether the Action data member has been assigned a value.
    bool IsSetAction(void) const;
    /// Check whether it is safe or not to call GetAction method.
    bool CanGetAction(void) const;
    void ResetAction(void);
    const TAction& GetAction(void) const;
    void SetAction(TAction& value);
    TAction& SetAction(void);

    /// optional
    /// typedef bool TRetranslate_cds
    ///  Check whether the Retranslate_cds data member has been assigned a value.
    bool IsSetRetranslate_cds(void) const;
    /// Check whether it is safe or not to call GetRetranslate_cds method.
    bool CanGetRetranslate_cds(void) const;
    void ResetRetranslate_cds(void);
    TRetranslate_cds GetRetranslate_cds(void) const;
    void SetRetranslate_cds(TRetranslate_cds value);
    TRetranslate_cds& SetRetranslate_cds(void);

    /// optional
    /// typedef bool TAlso_edit_gene
    ///  Check whether the Also_edit_gene data member has been assigned a value.
    bool IsSetAlso_edit_gene(void) const;
    /// Check whether it is safe or not to call GetAlso_edit_gene method.
    bool CanGetAlso_edit_gene(void) const;
    void ResetAlso_edit_gene(void);
    TAlso_edit_gene GetAlso_edit_gene(void) const;
    void SetAlso_edit_gene(TAlso_edit_gene value);
    TAlso_edit_gene& SetAlso_edit_gene(void);

    /// optional
    /// typedef CConstraint_choice_set TConstraint
    ///  Check whether the Constraint data member has been assigned a value.
    bool IsSetConstraint(void) const;
    /// Check whether it is safe or not to call GetConstraint method.
    bool CanGetConstraint(void) const;
    void ResetConstraint(void);
    const TConstraint& GetConstraint(void) const;
    void SetConstraint(TConstraint& value);
    TConstraint& SetConstraint(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEdit_feature_location_action_Base(const CEdit_feature_location_action_Base&);
    CEdit_feature_location_action_Base& operator=(const CEdit_feature_location_action_Base&);

    // data
    Uint4 m_set_State[1];
    EMacro_feature_type m_Type;
    CRef< TAction > m_Action;
    bool m_Retranslate_cds;
    bool m_Also_edit_gene;
    CRef< TConstraint > m_Constraint;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEdit_feature_location_action_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEdit_feature_location_action_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CEdit_feature_location_action_Base::ResetType(void)
{
    m_Type = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CEdit_feature_location_action_Base::TType CEdit_feature_location_action_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CEdit_feature_location_action_Base::SetType(CEdit_feature_location_action_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CEdit_feature_location_action_Base::TType& CEdit_feature_location_action_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CEdit_feature_location_action_Base::IsSetAction(void) const
{
    return m_Action.NotEmpty();
}

inline
bool CEdit_feature_location_action_Base::CanGetAction(void) const
{
    return true;
}

inline
const CEdit_feature_location_action_Base::TAction& CEdit_feature_location_action_Base::GetAction(void) const
{
    if ( !m_Action ) {
        const_cast<CEdit_feature_location_action_Base*>(this)->ResetAction();
    }
    return (*m_Action);
}

inline
CEdit_feature_location_action_Base::TAction& CEdit_feature_location_action_Base::SetAction(void)
{
    if ( !m_Action ) {
        ResetAction();
    }
    return (*m_Action);
}

inline
bool CEdit_feature_location_action_Base::IsSetRetranslate_cds(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEdit_feature_location_action_Base::CanGetRetranslate_cds(void) const
{
    return IsSetRetranslate_cds();
}

inline
void CEdit_feature_location_action_Base::ResetRetranslate_cds(void)
{
    m_Retranslate_cds = 0;
    m_set_State[0] &= ~0x30;
}

inline
CEdit_feature_location_action_Base::TRetranslate_cds CEdit_feature_location_action_Base::GetRetranslate_cds(void) const
{
    if (!CanGetRetranslate_cds()) {
        ThrowUnassigned(2);
    }
    return m_Retranslate_cds;
}

inline
void CEdit_feature_location_action_Base::SetRetranslate_cds(CEdit_feature_location_action_Base::TRetranslate_cds value)
{
    m_Retranslate_cds = value;
    m_set_State[0] |= 0x30;
}

inline
CEdit_feature_location_action_Base::TRetranslate_cds& CEdit_feature_location_action_Base::SetRetranslate_cds(void)
{
#ifdef _DEBUG
    if (!IsSetRetranslate_cds()) {
        memset(&m_Retranslate_cds,UnassignedByte(),sizeof(m_Retranslate_cds));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Retranslate_cds;
}

inline
bool CEdit_feature_location_action_Base::IsSetAlso_edit_gene(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CEdit_feature_location_action_Base::CanGetAlso_edit_gene(void) const
{
    return IsSetAlso_edit_gene();
}

inline
void CEdit_feature_location_action_Base::ResetAlso_edit_gene(void)
{
    m_Also_edit_gene = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CEdit_feature_location_action_Base::TAlso_edit_gene CEdit_feature_location_action_Base::GetAlso_edit_gene(void) const
{
    if (!CanGetAlso_edit_gene()) {
        ThrowUnassigned(3);
    }
    return m_Also_edit_gene;
}

inline
void CEdit_feature_location_action_Base::SetAlso_edit_gene(CEdit_feature_location_action_Base::TAlso_edit_gene value)
{
    m_Also_edit_gene = value;
    m_set_State[0] |= 0xc0;
}

inline
CEdit_feature_location_action_Base::TAlso_edit_gene& CEdit_feature_location_action_Base::SetAlso_edit_gene(void)
{
#ifdef _DEBUG
    if (!IsSetAlso_edit_gene()) {
        memset(&m_Also_edit_gene,UnassignedByte(),sizeof(m_Also_edit_gene));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Also_edit_gene;
}

inline
bool CEdit_feature_location_action_Base::IsSetConstraint(void) const
{
    return m_Constraint.NotEmpty();
}

inline
bool CEdit_feature_location_action_Base::CanGetConstraint(void) const
{
    return IsSetConstraint();
}

inline
const CEdit_feature_location_action_Base::TConstraint& CEdit_feature_location_action_Base::GetConstraint(void) const
{
    if (!CanGetConstraint()) {
        ThrowUnassigned(4);
    }
    return (*m_Constraint);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_EDIT_FEATUR_LOCATIO_ACTION_BASE_HPP
