/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Convert_feature_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_CONVERT_FEATURE_ACTION_BASE_HPP
#define OBJECTS_MACRO_CONVERT_FEATURE_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Macro_feature_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CConstraint_choice_set;
class CConvert_feature_dst_options;
class CConvert_feature_src_options;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CConvert_feature_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CConvert_feature_action_Base(void);
    // destructor
    virtual ~CConvert_feature_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EMacro_feature_type TType_from;
    typedef EMacro_feature_type TType_to;
    typedef CConvert_feature_src_options TSrc_options;
    typedef CConvert_feature_dst_options TDst_options;
    typedef bool TLeave_original;
    typedef CConstraint_choice_set TSrc_feat_constraint;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type_from,
        e_type_to,
        e_src_options,
        e_dst_options,
        e_leave_original,
        e_src_feat_constraint
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EMacro_feature_type TType_from
    ///  Check whether the Type_from data member has been assigned a value.
    bool IsSetType_from(void) const;
    /// Check whether it is safe or not to call GetType_from method.
    bool CanGetType_from(void) const;
    void ResetType_from(void);
    TType_from GetType_from(void) const;
    void SetType_from(TType_from value);
    TType_from& SetType_from(void);

    /// mandatory
    /// typedef EMacro_feature_type TType_to
    ///  Check whether the Type_to data member has been assigned a value.
    bool IsSetType_to(void) const;
    /// Check whether it is safe or not to call GetType_to method.
    bool CanGetType_to(void) const;
    void ResetType_to(void);
    TType_to GetType_to(void) const;
    void SetType_to(TType_to value);
    TType_to& SetType_to(void);

    /// optional
    /// typedef CConvert_feature_src_options TSrc_options
    ///  Check whether the Src_options data member has been assigned a value.
    bool IsSetSrc_options(void) const;
    /// Check whether it is safe or not to call GetSrc_options method.
    bool CanGetSrc_options(void) const;
    void ResetSrc_options(void);
    const TSrc_options& GetSrc_options(void) const;
    void SetSrc_options(TSrc_options& value);
    TSrc_options& SetSrc_options(void);

    /// optional
    /// typedef CConvert_feature_dst_options TDst_options
    ///  Check whether the Dst_options data member has been assigned a value.
    bool IsSetDst_options(void) const;
    /// Check whether it is safe or not to call GetDst_options method.
    bool CanGetDst_options(void) const;
    void ResetDst_options(void);
    const TDst_options& GetDst_options(void) const;
    void SetDst_options(TDst_options& value);
    TDst_options& SetDst_options(void);

    /// mandatory
    /// typedef bool TLeave_original
    ///  Check whether the Leave_original data member has been assigned a value.
    bool IsSetLeave_original(void) const;
    /// Check whether it is safe or not to call GetLeave_original method.
    bool CanGetLeave_original(void) const;
    void ResetLeave_original(void);
    TLeave_original GetLeave_original(void) const;
    void SetLeave_original(TLeave_original value);
    TLeave_original& SetLeave_original(void);

    /// optional
    /// typedef CConstraint_choice_set TSrc_feat_constraint
    ///  Check whether the Src_feat_constraint data member has been assigned a value.
    bool IsSetSrc_feat_constraint(void) const;
    /// Check whether it is safe or not to call GetSrc_feat_constraint method.
    bool CanGetSrc_feat_constraint(void) const;
    void ResetSrc_feat_constraint(void);
    const TSrc_feat_constraint& GetSrc_feat_constraint(void) const;
    void SetSrc_feat_constraint(TSrc_feat_constraint& value);
    TSrc_feat_constraint& SetSrc_feat_constraint(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CConvert_feature_action_Base(const CConvert_feature_action_Base&);
    CConvert_feature_action_Base& operator=(const CConvert_feature_action_Base&);

    // data
    Uint4 m_set_State[1];
    EMacro_feature_type m_Type_from;
    EMacro_feature_type m_Type_to;
    CRef< TSrc_options > m_Src_options;
    CRef< TDst_options > m_Dst_options;
    bool m_Leave_original;
    CRef< TSrc_feat_constraint > m_Src_feat_constraint;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CConvert_feature_action_Base::IsSetType_from(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CConvert_feature_action_Base::CanGetType_from(void) const
{
    return IsSetType_from();
}

inline
void CConvert_feature_action_Base::ResetType_from(void)
{
    m_Type_from = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CConvert_feature_action_Base::TType_from CConvert_feature_action_Base::GetType_from(void) const
{
    if (!CanGetType_from()) {
        ThrowUnassigned(0);
    }
    return m_Type_from;
}

inline
void CConvert_feature_action_Base::SetType_from(CConvert_feature_action_Base::TType_from value)
{
    m_Type_from = value;
    m_set_State[0] |= 0x3;
}

inline
CConvert_feature_action_Base::TType_from& CConvert_feature_action_Base::SetType_from(void)
{
#ifdef _DEBUG
    if (!IsSetType_from()) {
        memset(&m_Type_from,UnassignedByte(),sizeof(m_Type_from));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type_from;
}

inline
bool CConvert_feature_action_Base::IsSetType_to(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CConvert_feature_action_Base::CanGetType_to(void) const
{
    return IsSetType_to();
}

inline
void CConvert_feature_action_Base::ResetType_to(void)
{
    m_Type_to = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0xc;
}

inline
CConvert_feature_action_Base::TType_to CConvert_feature_action_Base::GetType_to(void) const
{
    if (!CanGetType_to()) {
        ThrowUnassigned(1);
    }
    return m_Type_to;
}

inline
void CConvert_feature_action_Base::SetType_to(CConvert_feature_action_Base::TType_to value)
{
    m_Type_to = value;
    m_set_State[0] |= 0xc;
}

inline
CConvert_feature_action_Base::TType_to& CConvert_feature_action_Base::SetType_to(void)
{
#ifdef _DEBUG
    if (!IsSetType_to()) {
        memset(&m_Type_to,UnassignedByte(),sizeof(m_Type_to));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type_to;
}

inline
bool CConvert_feature_action_Base::IsSetSrc_options(void) const
{
    return m_Src_options.NotEmpty();
}

inline
bool CConvert_feature_action_Base::CanGetSrc_options(void) const
{
    return IsSetSrc_options();
}

inline
const CConvert_feature_action_Base::TSrc_options& CConvert_feature_action_Base::GetSrc_options(void) const
{
    if (!CanGetSrc_options()) {
        ThrowUnassigned(2);
    }
    return (*m_Src_options);
}

inline
bool CConvert_feature_action_Base::IsSetDst_options(void) const
{
    return m_Dst_options.NotEmpty();
}

inline
bool CConvert_feature_action_Base::CanGetDst_options(void) const
{
    return IsSetDst_options();
}

inline
const CConvert_feature_action_Base::TDst_options& CConvert_feature_action_Base::GetDst_options(void) const
{
    if (!CanGetDst_options()) {
        ThrowUnassigned(3);
    }
    return (*m_Dst_options);
}

inline
bool CConvert_feature_action_Base::IsSetLeave_original(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CConvert_feature_action_Base::CanGetLeave_original(void) const
{
    return IsSetLeave_original();
}

inline
void CConvert_feature_action_Base::ResetLeave_original(void)
{
    m_Leave_original = 0;
    m_set_State[0] &= ~0x300;
}

inline
CConvert_feature_action_Base::TLeave_original CConvert_feature_action_Base::GetLeave_original(void) const
{
    if (!CanGetLeave_original()) {
        ThrowUnassigned(4);
    }
    return m_Leave_original;
}

inline
void CConvert_feature_action_Base::SetLeave_original(CConvert_feature_action_Base::TLeave_original value)
{
    m_Leave_original = value;
    m_set_State[0] |= 0x300;
}

inline
CConvert_feature_action_Base::TLeave_original& CConvert_feature_action_Base::SetLeave_original(void)
{
#ifdef _DEBUG
    if (!IsSetLeave_original()) {
        memset(&m_Leave_original,UnassignedByte(),sizeof(m_Leave_original));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Leave_original;
}

inline
bool CConvert_feature_action_Base::IsSetSrc_feat_constraint(void) const
{
    return m_Src_feat_constraint.NotEmpty();
}

inline
bool CConvert_feature_action_Base::CanGetSrc_feat_constraint(void) const
{
    return IsSetSrc_feat_constraint();
}

inline
const CConvert_feature_action_Base::TSrc_feat_constraint& CConvert_feature_action_Base::GetSrc_feat_constraint(void) const
{
    if (!CanGetSrc_feat_constraint()) {
        ThrowUnassigned(5);
    }
    return (*m_Src_feat_constraint);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_CONVERT_FEATURE_ACTION_BASE_HPP
