/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID1server_back_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID1_ID1SERVER_BACK_BASE_HPP
#define OBJECTS_ID1_ID1SERVER_BACK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID1SeqEntry_info;
class CID1Seq_hist;
class CID1blob_info;
class CSeq_entry;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID1_EXPORT CID1server_back_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID1server_back_Base(void);
    // destructor
    virtual ~CID1server_back_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,      ///< No variant selected
        e_Init,             ///< DlInit
        e_Error,
        e_Gotgi,
        e_Gotseqentry,      ///< live
        e_Gotdeadseqentry,  ///< dead
        e_Fini,             ///< DlFini
        e_Gistate,
        e_Ids,
        e_Gihist,           ///< because hand crafted Seq-hist does not follow   same conventions 
        e_Girevhist,
        e_Gotsewithinfo,
        e_Gotblobinfo
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 13 ///< == e_Gotblobinfo+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef int TError;
    typedef NCBI_NS_NCBI::TGi TGotgi;
    typedef CSeq_entry TGotseqentry;
    typedef CSeq_entry TGotdeadseqentry;
    typedef int TGistate;
    typedef list< CRef< CSeq_id > > TIds;
    typedef list< CRef< CID1Seq_hist > > TGihist;
    typedef list< CRef< CID1Seq_hist > > TGirevhist;
    typedef CID1SeqEntry_info TGotsewithinfo;
    typedef CID1blob_info TGotblobinfo;

    // getters
    // setters


    bool IsInit(void) const;
    void SetInit(void);

    // typedef int TError
    bool IsError(void) const;
    TError GetError(void) const;
    TError& SetError(void);
    void SetError(TError value);

    // typedef NCBI_NS_NCBI::TGi TGotgi
    bool IsGotgi(void) const;
    TGotgi GetGotgi(void) const;
    TGotgi& SetGotgi(void);
    void SetGotgi(TGotgi value);

    // typedef CSeq_entry TGotseqentry
    bool IsGotseqentry(void) const;
    const TGotseqentry& GetGotseqentry(void) const;
    TGotseqentry& SetGotseqentry(void);
    void SetGotseqentry(TGotseqentry& value);

    // typedef CSeq_entry TGotdeadseqentry
    bool IsGotdeadseqentry(void) const;
    const TGotdeadseqentry& GetGotdeadseqentry(void) const;
    TGotdeadseqentry& SetGotdeadseqentry(void);
    void SetGotdeadseqentry(TGotdeadseqentry& value);


    bool IsFini(void) const;
    void SetFini(void);

    // typedef int TGistate
    bool IsGistate(void) const;
    TGistate GetGistate(void) const;
    TGistate& SetGistate(void);
    void SetGistate(TGistate value);

    // typedef list< CRef< CSeq_id > > TIds
    bool IsIds(void) const;
    const TIds& GetIds(void) const;
    TIds& SetIds(void);

    // typedef list< CRef< CID1Seq_hist > > TGihist
    bool IsGihist(void) const;
    const TGihist& GetGihist(void) const;
    TGihist& SetGihist(void);

    // typedef list< CRef< CID1Seq_hist > > TGirevhist
    bool IsGirevhist(void) const;
    const TGirevhist& GetGirevhist(void) const;
    TGirevhist& SetGirevhist(void);

    // typedef CID1SeqEntry_info TGotsewithinfo
    bool IsGotsewithinfo(void) const;
    const TGotsewithinfo& GetGotsewithinfo(void) const;
    TGotsewithinfo& SetGotsewithinfo(void);
    void SetGotsewithinfo(TGotsewithinfo& value);

    // typedef CID1blob_info TGotblobinfo
    bool IsGotblobinfo(void) const;
    const TGotblobinfo& GetGotblobinfo(void) const;
    TGotblobinfo& SetGotblobinfo(void);
    void SetGotblobinfo(TGotblobinfo& value);


private:
    // copy constructor and assignment operator
    CID1server_back_Base(const CID1server_back_Base& );
    CID1server_back_Base& operator=(const CID1server_back_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TError m_Error;
        ncbi::TIntId m_Gotgi;
        TGistate m_Gistate;
        NCBI_NS_NCBI::CUnionBuffer<TIds> m_Ids;
        NCBI_NS_NCBI::CUnionBuffer<TGihist> m_Gihist;
        NCBI_NS_NCBI::CUnionBuffer<TGirevhist> m_Girevhist;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CID1server_back_Base::E_Choice CID1server_back_Base::Which(void) const
{
    return m_choice;
}

inline
void CID1server_back_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CID1server_back_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CID1server_back_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CID1server_back_Base::IsInit(void) const
{
    return m_choice == e_Init;
}

inline
void CID1server_back_Base::SetInit(void)
{
    Select(e_Init, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CID1server_back_Base::IsError(void) const
{
    return m_choice == e_Error;
}

inline
CID1server_back_Base::TError CID1server_back_Base::GetError(void) const
{
    CheckSelected(e_Error);
    return m_Error;
}

inline
CID1server_back_Base::TError& CID1server_back_Base::SetError(void)
{
    Select(e_Error, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Error;
}

inline
void CID1server_back_Base::SetError(CID1server_back_Base::TError value)
{
    Select(e_Error, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Error = value;
}

inline
bool CID1server_back_Base::IsGotgi(void) const
{
    return m_choice == e_Gotgi;
}

inline
CID1server_back_Base::TGotgi CID1server_back_Base::GetGotgi(void) const
{
    CheckSelected(e_Gotgi);
    return reinterpret_cast<const TGotgi&>(m_Gotgi);
}

inline
CID1server_back_Base::TGotgi& CID1server_back_Base::SetGotgi(void)
{
    Select(e_Gotgi, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TGotgi&>(m_Gotgi);
}

inline
void CID1server_back_Base::SetGotgi(CID1server_back_Base::TGotgi value)
{
    Select(e_Gotgi, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TGotgi&>(m_Gotgi) = value;
}

inline
bool CID1server_back_Base::IsGotseqentry(void) const
{
    return m_choice == e_Gotseqentry;
}

inline
bool CID1server_back_Base::IsGotdeadseqentry(void) const
{
    return m_choice == e_Gotdeadseqentry;
}

inline
bool CID1server_back_Base::IsFini(void) const
{
    return m_choice == e_Fini;
}

inline
void CID1server_back_Base::SetFini(void)
{
    Select(e_Fini, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CID1server_back_Base::IsGistate(void) const
{
    return m_choice == e_Gistate;
}

inline
CID1server_back_Base::TGistate CID1server_back_Base::GetGistate(void) const
{
    CheckSelected(e_Gistate);
    return m_Gistate;
}

inline
CID1server_back_Base::TGistate& CID1server_back_Base::SetGistate(void)
{
    Select(e_Gistate, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Gistate;
}

inline
void CID1server_back_Base::SetGistate(CID1server_back_Base::TGistate value)
{
    Select(e_Gistate, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Gistate = value;
}

inline
bool CID1server_back_Base::IsIds(void) const
{
    return m_choice == e_Ids;
}

inline
const CID1server_back_Base::TIds& CID1server_back_Base::GetIds(void) const
{
    CheckSelected(e_Ids);
    return *m_Ids;
}

inline
CID1server_back_Base::TIds& CID1server_back_Base::SetIds(void)
{
    Select(e_Ids, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Ids;
}

inline
bool CID1server_back_Base::IsGihist(void) const
{
    return m_choice == e_Gihist;
}

inline
const CID1server_back_Base::TGihist& CID1server_back_Base::GetGihist(void) const
{
    CheckSelected(e_Gihist);
    return *m_Gihist;
}

inline
CID1server_back_Base::TGihist& CID1server_back_Base::SetGihist(void)
{
    Select(e_Gihist, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Gihist;
}

inline
bool CID1server_back_Base::IsGirevhist(void) const
{
    return m_choice == e_Girevhist;
}

inline
const CID1server_back_Base::TGirevhist& CID1server_back_Base::GetGirevhist(void) const
{
    CheckSelected(e_Girevhist);
    return *m_Girevhist;
}

inline
CID1server_back_Base::TGirevhist& CID1server_back_Base::SetGirevhist(void)
{
    Select(e_Girevhist, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Girevhist;
}

inline
bool CID1server_back_Base::IsGotsewithinfo(void) const
{
    return m_choice == e_Gotsewithinfo;
}

inline
bool CID1server_back_Base::IsGotblobinfo(void) const
{
    return m_choice == e_Gotblobinfo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID1_ID1SERVER_BACK_BASE_HPP
