/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HG_Entry_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'homologene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_HOMOLOGENE_HG_ENTRY_BASE_HPP
#define OBJECTS_HOMOLOGENE_HG_ENTRY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;
class CHG_CommentarySet;
class CHG_Gene;
class CHG_Node;
class CHG_Stats;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CHG_Entry_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHG_Entry_Base(void);
    // destructor
    virtual ~CHG_Entry_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int THg_id;
    typedef int TVersion;
    typedef string TTitle;
    typedef string TCaption;
    typedef int TTaxid;
    typedef list< CRef< CHG_Gene > > TGenes;
    typedef CDate TCr_date;
    typedef CDate TUp_date;
    typedef list< CRef< CHG_Stats > > TDistances;
    typedef list< CRef< CHG_CommentarySet > > TCommentaries;
    typedef list< string > TWarnings;
    typedef CHG_Node TNode;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_hg_id,
        e_version,
        e_title,
        e_caption,
        e_taxid,
        e_genes,
        e_cr_date,
        e_up_date,
        e_distances,
        e_commentaries,
        e_warnings,
        e_node
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 13> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int THg_id
    ///  Check whether the Hg_id data member has been assigned a value.
    bool IsSetHg_id(void) const;
    /// Check whether it is safe or not to call GetHg_id method.
    bool CanGetHg_id(void) const;
    void ResetHg_id(void);
    THg_id GetHg_id(void) const;
    void SetHg_id(THg_id value);
    THg_id& SetHg_id(void);

    /// optional
    /// typedef int TVersion
    ///  Check whether the Version data member has been assigned a value.
    bool IsSetVersion(void) const;
    /// Check whether it is safe or not to call GetVersion method.
    bool CanGetVersion(void) const;
    void ResetVersion(void);
    TVersion GetVersion(void) const;
    void SetVersion(TVersion value);
    TVersion& SetVersion(void);

    /// optional
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// optional
    /// typedef string TCaption
    ///  Check whether the Caption data member has been assigned a value.
    bool IsSetCaption(void) const;
    /// Check whether it is safe or not to call GetCaption method.
    bool CanGetCaption(void) const;
    void ResetCaption(void);
    const TCaption& GetCaption(void) const;
    void SetCaption(const TCaption& value);
    void SetCaption(TCaption&& value);
    TCaption& SetCaption(void);

    /// optional
    /// typedef int TTaxid
    ///  Check whether the Taxid data member has been assigned a value.
    bool IsSetTaxid(void) const;
    /// Check whether it is safe or not to call GetTaxid method.
    bool CanGetTaxid(void) const;
    void ResetTaxid(void);
    TTaxid GetTaxid(void) const;
    void SetTaxid(TTaxid value);
    TTaxid& SetTaxid(void);

    /// optional
    /// typedef list< CRef< CHG_Gene > > TGenes
    ///  Check whether the Genes data member has been assigned a value.
    bool IsSetGenes(void) const;
    /// Check whether it is safe or not to call GetGenes method.
    bool CanGetGenes(void) const;
    void ResetGenes(void);
    const TGenes& GetGenes(void) const;
    TGenes& SetGenes(void);

    /// optional
    /// typedef CDate TCr_date
    ///  Check whether the Cr_date data member has been assigned a value.
    bool IsSetCr_date(void) const;
    /// Check whether it is safe or not to call GetCr_date method.
    bool CanGetCr_date(void) const;
    void ResetCr_date(void);
    const TCr_date& GetCr_date(void) const;
    void SetCr_date(TCr_date& value);
    TCr_date& SetCr_date(void);

    /// optional
    /// typedef CDate TUp_date
    ///  Check whether the Up_date data member has been assigned a value.
    bool IsSetUp_date(void) const;
    /// Check whether it is safe or not to call GetUp_date method.
    bool CanGetUp_date(void) const;
    void ResetUp_date(void);
    const TUp_date& GetUp_date(void) const;
    void SetUp_date(TUp_date& value);
    TUp_date& SetUp_date(void);

    /// optional
    /// typedef list< CRef< CHG_Stats > > TDistances
    ///  Check whether the Distances data member has been assigned a value.
    bool IsSetDistances(void) const;
    /// Check whether it is safe or not to call GetDistances method.
    bool CanGetDistances(void) const;
    void ResetDistances(void);
    const TDistances& GetDistances(void) const;
    TDistances& SetDistances(void);

    /// optional
    /// typedef list< CRef< CHG_CommentarySet > > TCommentaries
    ///  Check whether the Commentaries data member has been assigned a value.
    bool IsSetCommentaries(void) const;
    /// Check whether it is safe or not to call GetCommentaries method.
    bool CanGetCommentaries(void) const;
    void ResetCommentaries(void);
    const TCommentaries& GetCommentaries(void) const;
    TCommentaries& SetCommentaries(void);

    /// optional
    /// typedef list< string > TWarnings
    ///  Check whether the Warnings data member has been assigned a value.
    bool IsSetWarnings(void) const;
    /// Check whether it is safe or not to call GetWarnings method.
    bool CanGetWarnings(void) const;
    void ResetWarnings(void);
    const TWarnings& GetWarnings(void) const;
    TWarnings& SetWarnings(void);

    /// optional
    /// typedef CHG_Node TNode
    ///  Check whether the Node data member has been assigned a value.
    bool IsSetNode(void) const;
    /// Check whether it is safe or not to call GetNode method.
    bool CanGetNode(void) const;
    void ResetNode(void);
    const TNode& GetNode(void) const;
    void SetNode(TNode& value);
    TNode& SetNode(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHG_Entry_Base(const CHG_Entry_Base&);
    CHG_Entry_Base& operator=(const CHG_Entry_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Hg_id;
    int m_Version;
    string m_Title;
    string m_Caption;
    int m_Taxid;
    list< CRef< CHG_Gene > > m_Genes;
    CRef< TCr_date > m_Cr_date;
    CRef< TUp_date > m_Up_date;
    list< CRef< CHG_Stats > > m_Distances;
    list< CRef< CHG_CommentarySet > > m_Commentaries;
    list< string > m_Warnings;
    CRef< TNode > m_Node;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHG_Entry_Base::IsSetHg_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHG_Entry_Base::CanGetHg_id(void) const
{
    return IsSetHg_id();
}

inline
void CHG_Entry_Base::ResetHg_id(void)
{
    m_Hg_id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CHG_Entry_Base::THg_id CHG_Entry_Base::GetHg_id(void) const
{
    if (!CanGetHg_id()) {
        ThrowUnassigned(0);
    }
    return m_Hg_id;
}

inline
void CHG_Entry_Base::SetHg_id(CHG_Entry_Base::THg_id value)
{
    m_Hg_id = value;
    m_set_State[0] |= 0x3;
}

inline
CHG_Entry_Base::THg_id& CHG_Entry_Base::SetHg_id(void)
{
#ifdef _DEBUG
    if (!IsSetHg_id()) {
        memset(&m_Hg_id,UnassignedByte(),sizeof(m_Hg_id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Hg_id;
}

inline
bool CHG_Entry_Base::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHG_Entry_Base::CanGetVersion(void) const
{
    return IsSetVersion();
}

inline
void CHG_Entry_Base::ResetVersion(void)
{
    m_Version = 0;
    m_set_State[0] &= ~0xc;
}

inline
CHG_Entry_Base::TVersion CHG_Entry_Base::GetVersion(void) const
{
    if (!CanGetVersion()) {
        ThrowUnassigned(1);
    }
    return m_Version;
}

inline
void CHG_Entry_Base::SetVersion(CHG_Entry_Base::TVersion value)
{
    m_Version = value;
    m_set_State[0] |= 0xc;
}

inline
CHG_Entry_Base::TVersion& CHG_Entry_Base::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        memset(&m_Version,UnassignedByte(),sizeof(m_Version));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Version;
}

inline
bool CHG_Entry_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CHG_Entry_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CHG_Entry_Base::TTitle& CHG_Entry_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(2);
    }
    return m_Title;
}

inline
void CHG_Entry_Base::SetTitle(const CHG_Entry_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x30;
}

inline
void CHG_Entry_Base::SetTitle(CHG_Entry_Base::TTitle&& value)
{
    m_Title = std::forward<CHG_Entry_Base::TTitle>(value);
    m_set_State[0] |= 0x30;
}

inline
CHG_Entry_Base::TTitle& CHG_Entry_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Title;
}

inline
bool CHG_Entry_Base::IsSetCaption(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CHG_Entry_Base::CanGetCaption(void) const
{
    return IsSetCaption();
}

inline
const CHG_Entry_Base::TCaption& CHG_Entry_Base::GetCaption(void) const
{
    if (!CanGetCaption()) {
        ThrowUnassigned(3);
    }
    return m_Caption;
}

inline
void CHG_Entry_Base::SetCaption(const CHG_Entry_Base::TCaption& value)
{
    m_Caption = value;
    m_set_State[0] |= 0xc0;
}

inline
void CHG_Entry_Base::SetCaption(CHG_Entry_Base::TCaption&& value)
{
    m_Caption = std::forward<CHG_Entry_Base::TCaption>(value);
    m_set_State[0] |= 0xc0;
}

inline
CHG_Entry_Base::TCaption& CHG_Entry_Base::SetCaption(void)
{
#ifdef _DEBUG
    if (!IsSetCaption()) {
        m_Caption = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Caption;
}

inline
bool CHG_Entry_Base::IsSetTaxid(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CHG_Entry_Base::CanGetTaxid(void) const
{
    return IsSetTaxid();
}

inline
void CHG_Entry_Base::ResetTaxid(void)
{
    m_Taxid = 0;
    m_set_State[0] &= ~0x300;
}

inline
CHG_Entry_Base::TTaxid CHG_Entry_Base::GetTaxid(void) const
{
    if (!CanGetTaxid()) {
        ThrowUnassigned(4);
    }
    return m_Taxid;
}

inline
void CHG_Entry_Base::SetTaxid(CHG_Entry_Base::TTaxid value)
{
    m_Taxid = value;
    m_set_State[0] |= 0x300;
}

inline
CHG_Entry_Base::TTaxid& CHG_Entry_Base::SetTaxid(void)
{
#ifdef _DEBUG
    if (!IsSetTaxid()) {
        memset(&m_Taxid,UnassignedByte(),sizeof(m_Taxid));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Taxid;
}

inline
bool CHG_Entry_Base::IsSetGenes(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CHG_Entry_Base::CanGetGenes(void) const
{
    return true;
}

inline
const CHG_Entry_Base::TGenes& CHG_Entry_Base::GetGenes(void) const
{
    return m_Genes;
}

inline
CHG_Entry_Base::TGenes& CHG_Entry_Base::SetGenes(void)
{
    m_set_State[0] |= 0x400;
    return m_Genes;
}

inline
bool CHG_Entry_Base::IsSetCr_date(void) const
{
    return m_Cr_date.NotEmpty();
}

inline
bool CHG_Entry_Base::CanGetCr_date(void) const
{
    return IsSetCr_date();
}

inline
const CHG_Entry_Base::TCr_date& CHG_Entry_Base::GetCr_date(void) const
{
    if (!CanGetCr_date()) {
        ThrowUnassigned(6);
    }
    return (*m_Cr_date);
}

inline
bool CHG_Entry_Base::IsSetUp_date(void) const
{
    return m_Up_date.NotEmpty();
}

inline
bool CHG_Entry_Base::CanGetUp_date(void) const
{
    return IsSetUp_date();
}

inline
const CHG_Entry_Base::TUp_date& CHG_Entry_Base::GetUp_date(void) const
{
    if (!CanGetUp_date()) {
        ThrowUnassigned(7);
    }
    return (*m_Up_date);
}

inline
bool CHG_Entry_Base::IsSetDistances(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CHG_Entry_Base::CanGetDistances(void) const
{
    return true;
}

inline
const CHG_Entry_Base::TDistances& CHG_Entry_Base::GetDistances(void) const
{
    return m_Distances;
}

inline
CHG_Entry_Base::TDistances& CHG_Entry_Base::SetDistances(void)
{
    m_set_State[0] |= 0x10000;
    return m_Distances;
}

inline
bool CHG_Entry_Base::IsSetCommentaries(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CHG_Entry_Base::CanGetCommentaries(void) const
{
    return true;
}

inline
const CHG_Entry_Base::TCommentaries& CHG_Entry_Base::GetCommentaries(void) const
{
    return m_Commentaries;
}

inline
CHG_Entry_Base::TCommentaries& CHG_Entry_Base::SetCommentaries(void)
{
    m_set_State[0] |= 0x40000;
    return m_Commentaries;
}

inline
bool CHG_Entry_Base::IsSetWarnings(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CHG_Entry_Base::CanGetWarnings(void) const
{
    return true;
}

inline
const CHG_Entry_Base::TWarnings& CHG_Entry_Base::GetWarnings(void) const
{
    return m_Warnings;
}

inline
CHG_Entry_Base::TWarnings& CHG_Entry_Base::SetWarnings(void)
{
    m_set_State[0] |= 0x100000;
    return m_Warnings;
}

inline
bool CHG_Entry_Base::IsSetNode(void) const
{
    return m_Node.NotEmpty();
}

inline
bool CHG_Entry_Base::CanGetNode(void) const
{
    return IsSetNode();
}

inline
const CHG_Entry_Base::TNode& CHG_Entry_Base::GetNode(void) const
{
    if (!CanGetNode()) {
        ThrowUnassigned(11);
    }
    return (*m_Node);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_HOMOLOGENE_HG_ENTRY_BASE_HPP
