/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HG_Alignment_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'homologene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_HOMOLOGENE_HG_ALIGNMENT_BASE_HPP
#define OBJECTS_HOMOLOGENE_HG_ALIGNMENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_align;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CHG_Alignment_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHG_Alignment_Base(void);
    // destructor
    virtual ~CHG_Alignment_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int THg_id;
    typedef CSeq_align TAlignment;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_hg_id,
        e_alignment
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int THg_id
    ///  Check whether the Hg_id data member has been assigned a value.
    bool IsSetHg_id(void) const;
    /// Check whether it is safe or not to call GetHg_id method.
    bool CanGetHg_id(void) const;
    void ResetHg_id(void);
    THg_id GetHg_id(void) const;
    void SetHg_id(THg_id value);
    THg_id& SetHg_id(void);

    /// mandatory
    /// typedef CSeq_align TAlignment
    ///  Check whether the Alignment data member has been assigned a value.
    bool IsSetAlignment(void) const;
    /// Check whether it is safe or not to call GetAlignment method.
    bool CanGetAlignment(void) const;
    void ResetAlignment(void);
    const TAlignment& GetAlignment(void) const;
    void SetAlignment(TAlignment& value);
    TAlignment& SetAlignment(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHG_Alignment_Base(const CHG_Alignment_Base&);
    CHG_Alignment_Base& operator=(const CHG_Alignment_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Hg_id;
    CRef< TAlignment > m_Alignment;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHG_Alignment_Base::IsSetHg_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHG_Alignment_Base::CanGetHg_id(void) const
{
    return IsSetHg_id();
}

inline
void CHG_Alignment_Base::ResetHg_id(void)
{
    m_Hg_id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CHG_Alignment_Base::THg_id CHG_Alignment_Base::GetHg_id(void) const
{
    if (!CanGetHg_id()) {
        ThrowUnassigned(0);
    }
    return m_Hg_id;
}

inline
void CHG_Alignment_Base::SetHg_id(CHG_Alignment_Base::THg_id value)
{
    m_Hg_id = value;
    m_set_State[0] |= 0x3;
}

inline
CHG_Alignment_Base::THg_id& CHG_Alignment_Base::SetHg_id(void)
{
#ifdef _DEBUG
    if (!IsSetHg_id()) {
        memset(&m_Hg_id,UnassignedByte(),sizeof(m_Hg_id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Hg_id;
}

inline
bool CHG_Alignment_Base::IsSetAlignment(void) const
{
    return m_Alignment.NotEmpty();
}

inline
bool CHG_Alignment_Base::CanGetAlignment(void) const
{
    return true;
}

inline
const CHG_Alignment_Base::TAlignment& CHG_Alignment_Base::GetAlignment(void) const
{
    if ( !m_Alignment ) {
        const_cast<CHG_Alignment_Base*>(this)->ResetAlignment();
    }
    return (*m_Alignment);
}

inline
CHG_Alignment_Base::TAlignment& CHG_Alignment_Base::SetAlignment(void)
{
    if ( !m_Alignment ) {
        ResetAlignment();
    }
    return (*m_Alignment);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_HOMOLOGENE_HG_ALIGNMENT_BASE_HPP
