/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Date_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'general.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENERAL_DATE_BASE_HPP
#define OBJECTS_GENERAL_DATE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate_std;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// StringStore is really a VisibleString.  It is used to define very
///   long strings which may need to be stored by the receiving program
///   in special structures, such as a ByteStore, but it's just a hint.
///   AsnTool stores StringStores in ByteStore structures.
/// OCTET STRINGs are also stored in ByteStores by AsnTool
/// 
/// typedef struct bsunit {             /* for building multiline strings 
/// Nlm_Handle str;            /* the string piece 
/// Nlm_Int2 len_avail,
/// len;
/// struct bsunit PNTR next; }       /* the next one 
/// Nlm_BSUnit, PNTR Nlm_BSUnitPtr;
/// 
/// typedef struct bytestore {
/// Nlm_Int4 seekptr,       /* current position 
/// totlen,             /* total stored data length in bytes 
/// chain_offset;       /* offset in ByteStore of first byte in curchain 
/// Nlm_BSUnitPtr chain,       /* chain of elements 
/// curchain;           /* the BSUnit containing seekptr 
/// } Nlm_ByteStore, PNTR Nlm_ByteStorePtr;
///
/// AsnTool incorporates this as a primitive type, so the definition
///   is here just for completeness
/// 
///  StringStore ::= [APPLICATION 1] IMPLICIT OCTET STRING
///
/// BigInt is really an INTEGER. It is used to warn the receiving code to expect
///   a value bigger than Int4 (actually Int8). It will be stored in DataVal.bigintvalue
///
///   Like StringStore, AsnTool incorporates it as a primitive. The definition would be:
///   BigInt ::= [APPLICATION 2] IMPLICIT INTEGER
///
/// Date is used to replace the (overly complex) UTCTtime, GeneralizedTime
///  of ASN.1
///  It stores only a date
///
class NCBI_GENERAL_EXPORT CDate_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDate_Base(void);
    // destructor
    virtual ~CDate_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Str,          ///< for those unparsed dates
        e_Std           ///< use this if you can
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 3 ///< == e_Std+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TStr;
    typedef CDate_std TStd;

    // getters
    // setters

    // typedef string TStr
    bool IsStr(void) const;
    const TStr& GetStr(void) const;
    TStr& SetStr(void);
    void SetStr(const TStr& value);

    // typedef CDate_std TStd
    bool IsStd(void) const;
    const TStd& GetStd(void) const;
    TStd& SetStd(void);
    void SetStd(TStd& value);


private:
    // copy constructor and assignment operator
    CDate_Base(const CDate_Base& );
    CDate_Base& operator=(const CDate_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CDate_Base::E_Choice CDate_Base::Which(void) const
{
    return m_choice;
}

inline
void CDate_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CDate_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CDate_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CDate_Base::IsStr(void) const
{
    return m_choice == e_Str;
}

inline
const CDate_Base::TStr& CDate_Base::GetStr(void) const
{
    CheckSelected(e_Str);
    return *m_string;
}

inline
CDate_Base::TStr& CDate_Base::SetStr(void)
{
    Select(e_Str, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CDate_Base::IsStd(void) const
{
    return m_choice == e_Std;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENERAL_DATE_BASE_HPP
