/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_term_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_TERM_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_TERM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZ2_EXPORT CEntrez2_term_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_term_Base(void);
    // destructor
    virtual ~CEntrez2_term_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TTerm;
    typedef NCBI_NS_NCBI::TEntrezId TTxid;
    typedef int TCount;
    typedef bool TIs_leaf_node;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_term,
        e_txid,
        e_count,
        e_is_leaf_node
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TTerm
    ///  Check whether the Term data member has been assigned a value.
    bool IsSetTerm(void) const;
    /// Check whether it is safe or not to call GetTerm method.
    bool CanGetTerm(void) const;
    void ResetTerm(void);
    const TTerm& GetTerm(void) const;
    void SetTerm(const TTerm& value);
    void SetTerm(TTerm&& value);
    TTerm& SetTerm(void);

    /// optional
    /// typedef NCBI_NS_NCBI::TEntrezId TTxid
    ///  Check whether the Txid data member has been assigned a value.
    bool IsSetTxid(void) const;
    /// Check whether it is safe or not to call GetTxid method.
    bool CanGetTxid(void) const;
    void ResetTxid(void);
    TTxid GetTxid(void) const;
    void SetTxid(TTxid value);
    TTxid& SetTxid(void);

    /// count of records with this term
    /// mandatory
    /// typedef int TCount
    ///  Check whether the Count data member has been assigned a value.
    bool IsSetCount(void) const;
    /// Check whether it is safe or not to call GetCount method.
    bool CanGetCount(void) const;
    void ResetCount(void);
    TCount GetCount(void) const;
    void SetCount(TCount value);
    TCount& SetCount(void);

    /// used for hierarchy only
    /// optional
    /// typedef bool TIs_leaf_node
    ///  Check whether the Is_leaf_node data member has been assigned a value.
    bool IsSetIs_leaf_node(void) const;
    /// Check whether it is safe or not to call GetIs_leaf_node method.
    bool CanGetIs_leaf_node(void) const;
    void ResetIs_leaf_node(void);
    TIs_leaf_node GetIs_leaf_node(void) const;
    void SetIs_leaf_node(TIs_leaf_node value);
    TIs_leaf_node& SetIs_leaf_node(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_term_Base(const CEntrez2_term_Base&);
    CEntrez2_term_Base& operator=(const CEntrez2_term_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Term;
    ncbi::TIntId m_Txid;
    int m_Count;
    bool m_Is_leaf_node;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_term_Base::IsSetTerm(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_term_Base::CanGetTerm(void) const
{
    return IsSetTerm();
}

inline
const CEntrez2_term_Base::TTerm& CEntrez2_term_Base::GetTerm(void) const
{
    if (!CanGetTerm()) {
        ThrowUnassigned(0);
    }
    return m_Term;
}

inline
void CEntrez2_term_Base::SetTerm(const CEntrez2_term_Base::TTerm& value)
{
    m_Term = value;
    m_set_State[0] |= 0x3;
}

inline
void CEntrez2_term_Base::SetTerm(CEntrez2_term_Base::TTerm&& value)
{
    m_Term = std::forward<CEntrez2_term_Base::TTerm>(value);
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_term_Base::TTerm& CEntrez2_term_Base::SetTerm(void)
{
#ifdef _DEBUG
    if (!IsSetTerm()) {
        m_Term = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Term;
}

inline
bool CEntrez2_term_Base::IsSetTxid(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_term_Base::CanGetTxid(void) const
{
    return IsSetTxid();
}

inline
void CEntrez2_term_Base::ResetTxid(void)
{
    m_Txid = 0;
    m_set_State[0] &= ~0xc;
}

inline
CEntrez2_term_Base::TTxid CEntrez2_term_Base::GetTxid(void) const
{
    if (!CanGetTxid()) {
        ThrowUnassigned(1);
    }
    return reinterpret_cast<const TTxid&>(m_Txid);
}

inline
void CEntrez2_term_Base::SetTxid(CEntrez2_term_Base::TTxid value)
{
    reinterpret_cast<TTxid&>(m_Txid) = value;
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_term_Base::TTxid& CEntrez2_term_Base::SetTxid(void)
{
#ifdef _DEBUG
    if (!IsSetTxid()) {
        memset(&m_Txid,UnassignedByte(),sizeof(m_Txid));
    }
#endif
    m_set_State[0] |= 0x4;
    return reinterpret_cast<TTxid&>(m_Txid);
}

inline
bool CEntrez2_term_Base::IsSetCount(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEntrez2_term_Base::CanGetCount(void) const
{
    return IsSetCount();
}

inline
void CEntrez2_term_Base::ResetCount(void)
{
    m_Count = 0;
    m_set_State[0] &= ~0x30;
}

inline
CEntrez2_term_Base::TCount CEntrez2_term_Base::GetCount(void) const
{
    if (!CanGetCount()) {
        ThrowUnassigned(2);
    }
    return m_Count;
}

inline
void CEntrez2_term_Base::SetCount(CEntrez2_term_Base::TCount value)
{
    m_Count = value;
    m_set_State[0] |= 0x30;
}

inline
CEntrez2_term_Base::TCount& CEntrez2_term_Base::SetCount(void)
{
#ifdef _DEBUG
    if (!IsSetCount()) {
        memset(&m_Count,UnassignedByte(),sizeof(m_Count));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Count;
}

inline
bool CEntrez2_term_Base::IsSetIs_leaf_node(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CEntrez2_term_Base::CanGetIs_leaf_node(void) const
{
    return IsSetIs_leaf_node();
}

inline
void CEntrez2_term_Base::ResetIs_leaf_node(void)
{
    m_Is_leaf_node = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CEntrez2_term_Base::TIs_leaf_node CEntrez2_term_Base::GetIs_leaf_node(void) const
{
    if (!CanGetIs_leaf_node()) {
        ThrowUnassigned(3);
    }
    return m_Is_leaf_node;
}

inline
void CEntrez2_term_Base::SetIs_leaf_node(CEntrez2_term_Base::TIs_leaf_node value)
{
    m_Is_leaf_node = value;
    m_set_State[0] |= 0xc0;
}

inline
CEntrez2_term_Base::TIs_leaf_node& CEntrez2_term_Base::SetIs_leaf_node(void)
{
#ifdef _DEBUG
    if (!IsSetIs_leaf_node()) {
        memset(&m_Is_leaf_node,UnassignedByte(),sizeof(m_Is_leaf_node));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Is_leaf_node;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_TERM_BASE_HPP
