/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_field_info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_FIELD_INFO_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_FIELD_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/entrez2/Entrez2_field_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// info about one field
class NCBI_ENTREZ2_EXPORT CEntrez2_field_info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_field_info_Base(void);
    // destructor
    virtual ~CEntrez2_field_info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CEntrez2_field_id TField_name;
    typedef string TField_menu;
    typedef string TField_descr;
    typedef int TTerm_count;
    typedef bool TIs_date;
    typedef bool TIs_numerical;
    typedef bool TSingle_token;
    typedef bool THierarchy_avail;
    typedef bool TIs_rangable;
    typedef bool TIs_truncatable;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_field_name,
        e_field_menu,
        e_field_descr,
        e_term_count,
        e_is_date,
        e_is_numerical,
        e_single_token,
        e_hierarchy_avail,
        e_is_rangable,
        e_is_truncatable
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// the internal name
    /// mandatory
    /// typedef CEntrez2_field_id TField_name
    ///  Check whether the Field_name data member has been assigned a value.
    bool IsSetField_name(void) const;
    /// Check whether it is safe or not to call GetField_name method.
    bool CanGetField_name(void) const;
    void ResetField_name(void);
    const TField_name& GetField_name(void) const;
    void SetField_name(const TField_name& value);
    TField_name& SetField_name(void);

    /// short string suitable for menu
    /// mandatory
    /// typedef string TField_menu
    ///  Check whether the Field_menu data member has been assigned a value.
    bool IsSetField_menu(void) const;
    /// Check whether it is safe or not to call GetField_menu method.
    bool CanGetField_menu(void) const;
    void ResetField_menu(void);
    const TField_menu& GetField_menu(void) const;
    void SetField_menu(const TField_menu& value);
    void SetField_menu(TField_menu&& value);
    TField_menu& SetField_menu(void);

    /// longer, explanatory name
    /// mandatory
    /// typedef string TField_descr
    ///  Check whether the Field_descr data member has been assigned a value.
    bool IsSetField_descr(void) const;
    /// Check whether it is safe or not to call GetField_descr method.
    bool CanGetField_descr(void) const;
    void ResetField_descr(void);
    const TField_descr& GetField_descr(void) const;
    void SetField_descr(const TField_descr& value);
    void SetField_descr(TField_descr&& value);
    TField_descr& SetField_descr(void);

    /// number of terms in field
    /// mandatory
    /// typedef int TTerm_count
    ///  Check whether the Term_count data member has been assigned a value.
    bool IsSetTerm_count(void) const;
    /// Check whether it is safe or not to call GetTerm_count method.
    bool CanGetTerm_count(void) const;
    void ResetTerm_count(void);
    TTerm_count GetTerm_count(void) const;
    void SetTerm_count(TTerm_count value);
    TTerm_count& SetTerm_count(void);

    /// optional
    /// typedef bool TIs_date
    ///  Check whether the Is_date data member has been assigned a value.
    bool IsSetIs_date(void) const;
    /// Check whether it is safe or not to call GetIs_date method.
    bool CanGetIs_date(void) const;
    void ResetIs_date(void);
    TIs_date GetIs_date(void) const;
    void SetIs_date(TIs_date value);
    TIs_date& SetIs_date(void);

    /// optional
    /// typedef bool TIs_numerical
    ///  Check whether the Is_numerical data member has been assigned a value.
    bool IsSetIs_numerical(void) const;
    /// Check whether it is safe or not to call GetIs_numerical method.
    bool CanGetIs_numerical(void) const;
    void ResetIs_numerical(void);
    TIs_numerical GetIs_numerical(void) const;
    void SetIs_numerical(TIs_numerical value);
    TIs_numerical& SetIs_numerical(void);

    /// optional
    /// typedef bool TSingle_token
    ///  Check whether the Single_token data member has been assigned a value.
    bool IsSetSingle_token(void) const;
    /// Check whether it is safe or not to call GetSingle_token method.
    bool CanGetSingle_token(void) const;
    void ResetSingle_token(void);
    TSingle_token GetSingle_token(void) const;
    void SetSingle_token(TSingle_token value);
    TSingle_token& SetSingle_token(void);

    /// optional
    /// typedef bool THierarchy_avail
    ///  Check whether the Hierarchy_avail data member has been assigned a value.
    bool IsSetHierarchy_avail(void) const;
    /// Check whether it is safe or not to call GetHierarchy_avail method.
    bool CanGetHierarchy_avail(void) const;
    void ResetHierarchy_avail(void);
    THierarchy_avail GetHierarchy_avail(void) const;
    void SetHierarchy_avail(THierarchy_avail value);
    THierarchy_avail& SetHierarchy_avail(void);

    /// optional
    /// typedef bool TIs_rangable
    ///  Check whether the Is_rangable data member has been assigned a value.
    bool IsSetIs_rangable(void) const;
    /// Check whether it is safe or not to call GetIs_rangable method.
    bool CanGetIs_rangable(void) const;
    void ResetIs_rangable(void);
    TIs_rangable GetIs_rangable(void) const;
    void SetIs_rangable(TIs_rangable value);
    TIs_rangable& SetIs_rangable(void);

    /// optional
    /// typedef bool TIs_truncatable
    ///  Check whether the Is_truncatable data member has been assigned a value.
    bool IsSetIs_truncatable(void) const;
    /// Check whether it is safe or not to call GetIs_truncatable method.
    bool CanGetIs_truncatable(void) const;
    void ResetIs_truncatable(void);
    TIs_truncatable GetIs_truncatable(void) const;
    void SetIs_truncatable(TIs_truncatable value);
    TIs_truncatable& SetIs_truncatable(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_field_info_Base(const CEntrez2_field_info_Base&);
    CEntrez2_field_info_Base& operator=(const CEntrez2_field_info_Base&);

    // data
    Uint4 m_set_State[1];
    CEntrez2_field_id m_Field_name;
    string m_Field_menu;
    string m_Field_descr;
    int m_Term_count;
    bool m_Is_date;
    bool m_Is_numerical;
    bool m_Single_token;
    bool m_Hierarchy_avail;
    bool m_Is_rangable;
    bool m_Is_truncatable;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_field_info_Base::IsSetField_name(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetField_name(void) const
{
    return IsSetField_name();
}

inline
const CEntrez2_field_info_Base::TField_name& CEntrez2_field_info_Base::GetField_name(void) const
{
    if (!CanGetField_name()) {
        ThrowUnassigned(0);
    }
    return m_Field_name;
}

inline
void CEntrez2_field_info_Base::SetField_name(const CEntrez2_field_info_Base::TField_name& value)
{
    m_Field_name = value;
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_field_info_Base::TField_name& CEntrez2_field_info_Base::SetField_name(void)
{
    m_set_State[0] |= 0x1;
    return m_Field_name;
}

inline
bool CEntrez2_field_info_Base::IsSetField_menu(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetField_menu(void) const
{
    return IsSetField_menu();
}

inline
const CEntrez2_field_info_Base::TField_menu& CEntrez2_field_info_Base::GetField_menu(void) const
{
    if (!CanGetField_menu()) {
        ThrowUnassigned(1);
    }
    return m_Field_menu;
}

inline
void CEntrez2_field_info_Base::SetField_menu(const CEntrez2_field_info_Base::TField_menu& value)
{
    m_Field_menu = value;
    m_set_State[0] |= 0xc;
}

inline
void CEntrez2_field_info_Base::SetField_menu(CEntrez2_field_info_Base::TField_menu&& value)
{
    m_Field_menu = std::forward<CEntrez2_field_info_Base::TField_menu>(value);
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_field_info_Base::TField_menu& CEntrez2_field_info_Base::SetField_menu(void)
{
#ifdef _DEBUG
    if (!IsSetField_menu()) {
        m_Field_menu = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Field_menu;
}

inline
bool CEntrez2_field_info_Base::IsSetField_descr(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetField_descr(void) const
{
    return IsSetField_descr();
}

inline
const CEntrez2_field_info_Base::TField_descr& CEntrez2_field_info_Base::GetField_descr(void) const
{
    if (!CanGetField_descr()) {
        ThrowUnassigned(2);
    }
    return m_Field_descr;
}

inline
void CEntrez2_field_info_Base::SetField_descr(const CEntrez2_field_info_Base::TField_descr& value)
{
    m_Field_descr = value;
    m_set_State[0] |= 0x30;
}

inline
void CEntrez2_field_info_Base::SetField_descr(CEntrez2_field_info_Base::TField_descr&& value)
{
    m_Field_descr = std::forward<CEntrez2_field_info_Base::TField_descr>(value);
    m_set_State[0] |= 0x30;
}

inline
CEntrez2_field_info_Base::TField_descr& CEntrez2_field_info_Base::SetField_descr(void)
{
#ifdef _DEBUG
    if (!IsSetField_descr()) {
        m_Field_descr = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Field_descr;
}

inline
bool CEntrez2_field_info_Base::IsSetTerm_count(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetTerm_count(void) const
{
    return IsSetTerm_count();
}

inline
void CEntrez2_field_info_Base::ResetTerm_count(void)
{
    m_Term_count = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CEntrez2_field_info_Base::TTerm_count CEntrez2_field_info_Base::GetTerm_count(void) const
{
    if (!CanGetTerm_count()) {
        ThrowUnassigned(3);
    }
    return m_Term_count;
}

inline
void CEntrez2_field_info_Base::SetTerm_count(CEntrez2_field_info_Base::TTerm_count value)
{
    m_Term_count = value;
    m_set_State[0] |= 0xc0;
}

inline
CEntrez2_field_info_Base::TTerm_count& CEntrez2_field_info_Base::SetTerm_count(void)
{
#ifdef _DEBUG
    if (!IsSetTerm_count()) {
        memset(&m_Term_count,UnassignedByte(),sizeof(m_Term_count));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Term_count;
}

inline
bool CEntrez2_field_info_Base::IsSetIs_date(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetIs_date(void) const
{
    return IsSetIs_date();
}

inline
void CEntrez2_field_info_Base::ResetIs_date(void)
{
    m_Is_date = 0;
    m_set_State[0] &= ~0x300;
}

inline
CEntrez2_field_info_Base::TIs_date CEntrez2_field_info_Base::GetIs_date(void) const
{
    if (!CanGetIs_date()) {
        ThrowUnassigned(4);
    }
    return m_Is_date;
}

inline
void CEntrez2_field_info_Base::SetIs_date(CEntrez2_field_info_Base::TIs_date value)
{
    m_Is_date = value;
    m_set_State[0] |= 0x300;
}

inline
CEntrez2_field_info_Base::TIs_date& CEntrez2_field_info_Base::SetIs_date(void)
{
#ifdef _DEBUG
    if (!IsSetIs_date()) {
        memset(&m_Is_date,UnassignedByte(),sizeof(m_Is_date));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Is_date;
}

inline
bool CEntrez2_field_info_Base::IsSetIs_numerical(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetIs_numerical(void) const
{
    return IsSetIs_numerical();
}

inline
void CEntrez2_field_info_Base::ResetIs_numerical(void)
{
    m_Is_numerical = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CEntrez2_field_info_Base::TIs_numerical CEntrez2_field_info_Base::GetIs_numerical(void) const
{
    if (!CanGetIs_numerical()) {
        ThrowUnassigned(5);
    }
    return m_Is_numerical;
}

inline
void CEntrez2_field_info_Base::SetIs_numerical(CEntrez2_field_info_Base::TIs_numerical value)
{
    m_Is_numerical = value;
    m_set_State[0] |= 0xc00;
}

inline
CEntrez2_field_info_Base::TIs_numerical& CEntrez2_field_info_Base::SetIs_numerical(void)
{
#ifdef _DEBUG
    if (!IsSetIs_numerical()) {
        memset(&m_Is_numerical,UnassignedByte(),sizeof(m_Is_numerical));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Is_numerical;
}

inline
bool CEntrez2_field_info_Base::IsSetSingle_token(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetSingle_token(void) const
{
    return IsSetSingle_token();
}

inline
void CEntrez2_field_info_Base::ResetSingle_token(void)
{
    m_Single_token = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CEntrez2_field_info_Base::TSingle_token CEntrez2_field_info_Base::GetSingle_token(void) const
{
    if (!CanGetSingle_token()) {
        ThrowUnassigned(6);
    }
    return m_Single_token;
}

inline
void CEntrez2_field_info_Base::SetSingle_token(CEntrez2_field_info_Base::TSingle_token value)
{
    m_Single_token = value;
    m_set_State[0] |= 0x3000;
}

inline
CEntrez2_field_info_Base::TSingle_token& CEntrez2_field_info_Base::SetSingle_token(void)
{
#ifdef _DEBUG
    if (!IsSetSingle_token()) {
        memset(&m_Single_token,UnassignedByte(),sizeof(m_Single_token));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Single_token;
}

inline
bool CEntrez2_field_info_Base::IsSetHierarchy_avail(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetHierarchy_avail(void) const
{
    return IsSetHierarchy_avail();
}

inline
void CEntrez2_field_info_Base::ResetHierarchy_avail(void)
{
    m_Hierarchy_avail = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CEntrez2_field_info_Base::THierarchy_avail CEntrez2_field_info_Base::GetHierarchy_avail(void) const
{
    if (!CanGetHierarchy_avail()) {
        ThrowUnassigned(7);
    }
    return m_Hierarchy_avail;
}

inline
void CEntrez2_field_info_Base::SetHierarchy_avail(CEntrez2_field_info_Base::THierarchy_avail value)
{
    m_Hierarchy_avail = value;
    m_set_State[0] |= 0xc000;
}

inline
CEntrez2_field_info_Base::THierarchy_avail& CEntrez2_field_info_Base::SetHierarchy_avail(void)
{
#ifdef _DEBUG
    if (!IsSetHierarchy_avail()) {
        memset(&m_Hierarchy_avail,UnassignedByte(),sizeof(m_Hierarchy_avail));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Hierarchy_avail;
}

inline
bool CEntrez2_field_info_Base::IsSetIs_rangable(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetIs_rangable(void) const
{
    return IsSetIs_rangable();
}

inline
void CEntrez2_field_info_Base::ResetIs_rangable(void)
{
    m_Is_rangable = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CEntrez2_field_info_Base::TIs_rangable CEntrez2_field_info_Base::GetIs_rangable(void) const
{
    if (!CanGetIs_rangable()) {
        ThrowUnassigned(8);
    }
    return m_Is_rangable;
}

inline
void CEntrez2_field_info_Base::SetIs_rangable(CEntrez2_field_info_Base::TIs_rangable value)
{
    m_Is_rangable = value;
    m_set_State[0] |= 0x30000;
}

inline
CEntrez2_field_info_Base::TIs_rangable& CEntrez2_field_info_Base::SetIs_rangable(void)
{
#ifdef _DEBUG
    if (!IsSetIs_rangable()) {
        memset(&m_Is_rangable,UnassignedByte(),sizeof(m_Is_rangable));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Is_rangable;
}

inline
bool CEntrez2_field_info_Base::IsSetIs_truncatable(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CEntrez2_field_info_Base::CanGetIs_truncatable(void) const
{
    return IsSetIs_truncatable();
}

inline
void CEntrez2_field_info_Base::ResetIs_truncatable(void)
{
    m_Is_truncatable = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CEntrez2_field_info_Base::TIs_truncatable CEntrez2_field_info_Base::GetIs_truncatable(void) const
{
    if (!CanGetIs_truncatable()) {
        ThrowUnassigned(9);
    }
    return m_Is_truncatable;
}

inline
void CEntrez2_field_info_Base::SetIs_truncatable(CEntrez2_field_info_Base::TIs_truncatable value)
{
    m_Is_truncatable = value;
    m_set_State[0] |= 0xc0000;
}

inline
CEntrez2_field_info_Base::TIs_truncatable& CEntrez2_field_info_Base::SetIs_truncatable(void)
{
#ifdef _DEBUG
    if (!IsSetIs_truncatable()) {
        memset(&m_Is_truncatable,UnassignedByte(),sizeof(m_Is_truncatable));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Is_truncatable;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_FIELD_INFO_BASE_HPP
