/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PrimarySequence_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_PRIMARYSEQUENCE_BASE_HPP
#define OBJECTS_DOCSUM_PRIMARYSEQUENCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMapLoc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_DOCSUM_EXPORT CPrimarySequence_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPrimarySequence_Base(void);
    // destructor
    virtual ~CPrimarySequence_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_source {
            eAttlist_source_submitter = 1,
            eAttlist_source_blastmb   = 2,
            eAttlist_source_xm        = 3,
            eAttlist_source_remap     = 4,
            eAttlist_source_hgvs      = 5
        };
        
        /// Access to EAttlist_source's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_source)(void);
        
        // types
        typedef int TDbSnpBuild;
        typedef int TGi;
        typedef EAttlist_source TSource;
        typedef string TAccession;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_dbSnpBuild,
            e_gi,
            e_source,
            e_accession
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef int TDbSnpBuild
        ///  Check whether the DbSnpBuild data member has been assigned a value.
        bool IsSetDbSnpBuild(void) const;
        /// Check whether it is safe or not to call GetDbSnpBuild method.
        bool CanGetDbSnpBuild(void) const;
        void ResetDbSnpBuild(void);
        TDbSnpBuild GetDbSnpBuild(void) const;
        void SetDbSnpBuild(TDbSnpBuild value);
        TDbSnpBuild& SetDbSnpBuild(void);
    
        /// mandatory
        /// typedef int TGi
        ///  Check whether the Gi data member has been assigned a value.
        bool IsSetGi(void) const;
        /// Check whether it is safe or not to call GetGi method.
        bool CanGetGi(void) const;
        void ResetGi(void);
        TGi GetGi(void) const;
        void SetGi(TGi value);
        TGi& SetGi(void);
    
        /// optional
        /// typedef EAttlist_source TSource
        ///  Check whether the Source data member has been assigned a value.
        bool IsSetSource(void) const;
        /// Check whether it is safe or not to call GetSource method.
        bool CanGetSource(void) const;
        void ResetSource(void);
        TSource GetSource(void) const;
        void SetSource(TSource value);
        TSource& SetSource(void);
    
        /// optional
        /// typedef string TAccession
        ///  Check whether the Accession data member has been assigned a value.
        bool IsSetAccession(void) const;
        /// Check whether it is safe or not to call GetAccession method.
        bool CanGetAccession(void) const;
        void ResetAccession(void);
        const TAccession& GetAccession(void) const;
        void SetAccession(const TAccession& value);
        void SetAccession(TAccession&& value);
        TAccession& SetAccession(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        int m_DbSnpBuild;
        int m_Gi;
        EAttlist_source m_Source;
        string m_Accession;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef list< CRef< CMapLoc > > TMapLoc;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_mapLoc
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef list< CRef< CMapLoc > > TMapLoc
    ///  Check whether the MapLoc data member has been assigned a value.
    bool IsSetMapLoc(void) const;
    /// Check whether it is safe or not to call GetMapLoc method.
    bool CanGetMapLoc(void) const;
    void ResetMapLoc(void);
    const TMapLoc& GetMapLoc(void) const;
    TMapLoc& SetMapLoc(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPrimarySequence_Base(const CPrimarySequence_Base&);
    CPrimarySequence_Base& operator=(const CPrimarySequence_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
    list< CRef< CMapLoc > > m_MapLoc;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPrimarySequence_Base::C_Attlist::IsSetDbSnpBuild(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPrimarySequence_Base::C_Attlist::CanGetDbSnpBuild(void) const
{
    return IsSetDbSnpBuild();
}

inline
void CPrimarySequence_Base::C_Attlist::ResetDbSnpBuild(void)
{
    m_DbSnpBuild = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPrimarySequence_Base::C_Attlist::TDbSnpBuild CPrimarySequence_Base::C_Attlist::GetDbSnpBuild(void) const
{
    if (!CanGetDbSnpBuild()) {
        ThrowUnassigned(0);
    }
    return m_DbSnpBuild;
}

inline
void CPrimarySequence_Base::C_Attlist::SetDbSnpBuild(CPrimarySequence_Base::C_Attlist::TDbSnpBuild value)
{
    m_DbSnpBuild = value;
    m_set_State[0] |= 0x3;
}

inline
CPrimarySequence_Base::C_Attlist::TDbSnpBuild& CPrimarySequence_Base::C_Attlist::SetDbSnpBuild(void)
{
#ifdef _DEBUG
    if (!IsSetDbSnpBuild()) {
        memset(&m_DbSnpBuild,UnassignedByte(),sizeof(m_DbSnpBuild));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_DbSnpBuild;
}

inline
bool CPrimarySequence_Base::C_Attlist::IsSetGi(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPrimarySequence_Base::C_Attlist::CanGetGi(void) const
{
    return IsSetGi();
}

inline
void CPrimarySequence_Base::C_Attlist::ResetGi(void)
{
    m_Gi = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPrimarySequence_Base::C_Attlist::TGi CPrimarySequence_Base::C_Attlist::GetGi(void) const
{
    if (!CanGetGi()) {
        ThrowUnassigned(1);
    }
    return m_Gi;
}

inline
void CPrimarySequence_Base::C_Attlist::SetGi(CPrimarySequence_Base::C_Attlist::TGi value)
{
    m_Gi = value;
    m_set_State[0] |= 0xc;
}

inline
CPrimarySequence_Base::C_Attlist::TGi& CPrimarySequence_Base::C_Attlist::SetGi(void)
{
#ifdef _DEBUG
    if (!IsSetGi()) {
        memset(&m_Gi,UnassignedByte(),sizeof(m_Gi));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Gi;
}

inline
bool CPrimarySequence_Base::C_Attlist::IsSetSource(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPrimarySequence_Base::C_Attlist::CanGetSource(void) const
{
    return IsSetSource();
}

inline
void CPrimarySequence_Base::C_Attlist::ResetSource(void)
{
    m_Source = (EAttlist_source)(0);
    m_set_State[0] &= ~0x30;
}

inline
CPrimarySequence_Base::C_Attlist::TSource CPrimarySequence_Base::C_Attlist::GetSource(void) const
{
    if (!CanGetSource()) {
        ThrowUnassigned(2);
    }
    return m_Source;
}

inline
void CPrimarySequence_Base::C_Attlist::SetSource(CPrimarySequence_Base::C_Attlist::TSource value)
{
    m_Source = value;
    m_set_State[0] |= 0x30;
}

inline
CPrimarySequence_Base::C_Attlist::TSource& CPrimarySequence_Base::C_Attlist::SetSource(void)
{
#ifdef _DEBUG
    if (!IsSetSource()) {
        memset(&m_Source,UnassignedByte(),sizeof(m_Source));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Source;
}

inline
bool CPrimarySequence_Base::C_Attlist::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPrimarySequence_Base::C_Attlist::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CPrimarySequence_Base::C_Attlist::TAccession& CPrimarySequence_Base::C_Attlist::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(3);
    }
    return m_Accession;
}

inline
void CPrimarySequence_Base::C_Attlist::SetAccession(const CPrimarySequence_Base::C_Attlist::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0xc0;
}

inline
void CPrimarySequence_Base::C_Attlist::SetAccession(CPrimarySequence_Base::C_Attlist::TAccession&& value)
{
    m_Accession = std::forward<CPrimarySequence_Base::C_Attlist::TAccession>(value);
    m_set_State[0] |= 0xc0;
}

inline
CPrimarySequence_Base::C_Attlist::TAccession& CPrimarySequence_Base::C_Attlist::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Accession;
}

inline
bool CPrimarySequence_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CPrimarySequence_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CPrimarySequence_Base::TAttlist& CPrimarySequence_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CPrimarySequence_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CPrimarySequence_Base::TAttlist& CPrimarySequence_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CPrimarySequence_Base::IsSetMapLoc(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPrimarySequence_Base::CanGetMapLoc(void) const
{
    return true;
}

inline
const CPrimarySequence_Base::TMapLoc& CPrimarySequence_Base::GetMapLoc(void) const
{
    return m_MapLoc;
}

inline
CPrimarySequence_Base::TMapLoc& CPrimarySequence_Base::SetMapLoc(void)
{
    m_set_State[0] |= 0x4;
    return m_MapLoc;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_PRIMARYSEQUENCE_BASE_HPP
