/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_style_table_item_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_STYLE_TABLE_ITEM_BASE_HPP
#define OBJECTS_CN3D_CN3D_STYLE_TABLE_ITEM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/cn3d/Cn3d_style_table_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCn3d_style_settings;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_CN3D_EXPORT CCn3d_style_table_item_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_style_table_item_Base(void);
    // destructor
    virtual ~CCn3d_style_table_item_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CCn3d_style_table_id TId;
    typedef CCn3d_style_settings TStyle;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_style
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CCn3d_style_table_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    TId& SetId(void);

    /// mandatory
    /// typedef CCn3d_style_settings TStyle
    ///  Check whether the Style data member has been assigned a value.
    bool IsSetStyle(void) const;
    /// Check whether it is safe or not to call GetStyle method.
    bool CanGetStyle(void) const;
    void ResetStyle(void);
    const TStyle& GetStyle(void) const;
    void SetStyle(TStyle& value);
    TStyle& SetStyle(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_style_table_item_Base(const CCn3d_style_table_item_Base&);
    CCn3d_style_table_item_Base& operator=(const CCn3d_style_table_item_Base&);

    // data
    Uint4 m_set_State[1];
    CCn3d_style_table_id m_Id;
    CRef< TStyle > m_Style;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_style_table_item_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_style_table_item_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CCn3d_style_table_item_Base::ResetId(void)
{
    m_Id = CCn3d_style_table_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CCn3d_style_table_item_Base::TId& CCn3d_style_table_item_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CCn3d_style_table_item_Base::SetId(const CCn3d_style_table_item_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CCn3d_style_table_item_Base::TId& CCn3d_style_table_item_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CCn3d_style_table_item_Base::IsSetStyle(void) const
{
    return m_Style.NotEmpty();
}

inline
bool CCn3d_style_table_item_Base::CanGetStyle(void) const
{
    return true;
}

inline
const CCn3d_style_table_item_Base::TStyle& CCn3d_style_table_item_Base::GetStyle(void) const
{
    if ( !m_Style ) {
        const_cast<CCn3d_style_table_item_Base*>(this)->ResetStyle();
    }
    return (*m_Style);
}

inline
CCn3d_style_table_item_Base::TStyle& CCn3d_style_table_item_Base::SetStyle(void)
{
    if ( !m_Style ) {
        ResetStyle();
    }
    return (*m_Style);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_STYLE_TABLE_ITEM_BASE_HPP
