/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_style_settings_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_STYLE_SETTINGS_BASE_HPP
#define OBJECTS_CN3D_CN3D_STYLE_SETTINGS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCn3d_backbone_label_style;
class CCn3d_backbone_style;
class CCn3d_color;
class CCn3d_general_style;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// rendering settings for Cn3D (mirrors StyleSettings class)
class NCBI_CN3D_EXPORT CCn3d_style_settings_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_style_settings_Base(void);
    // destructor
    virtual ~CCn3d_style_settings_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TName;
    typedef CCn3d_backbone_style TProtein_backbone;
    typedef CCn3d_backbone_style TNucleotide_backbone;
    typedef CCn3d_general_style TProtein_sidechains;
    typedef CCn3d_general_style TNucleotide_sidechains;
    typedef CCn3d_general_style THeterogens;
    typedef CCn3d_general_style TSolvents;
    typedef CCn3d_general_style TConnections;
    typedef CCn3d_general_style THelix_objects;
    typedef CCn3d_general_style TStrand_objects;
    typedef bool TVirtual_disulfides_on;
    typedef CCn3d_color TVirtual_disulfide_color;
    typedef bool THydrogens_on;
    typedef CCn3d_color TBackground_color;
    typedef int TScale_factor;
    typedef int TSpace_fill_proportion;
    typedef int TBall_radius;
    typedef int TStick_radius;
    typedef int TTube_radius;
    typedef int TTube_worm_radius;
    typedef int THelix_radius;
    typedef int TStrand_width;
    typedef int TStrand_thickness;
    typedef CCn3d_backbone_label_style TProtein_labels;
    typedef CCn3d_backbone_label_style TNucleotide_labels;
    typedef bool TIon_labels;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_protein_backbone,
        e_nucleotide_backbone,
        e_protein_sidechains,
        e_nucleotide_sidechains,
        e_heterogens,
        e_solvents,
        e_connections,
        e_helix_objects,
        e_strand_objects,
        e_virtual_disulfides_on,
        e_virtual_disulfide_color,
        e_hydrogens_on,
        e_background_color,
        e_scale_factor,
        e_space_fill_proportion,
        e_ball_radius,
        e_stick_radius,
        e_tube_radius,
        e_tube_worm_radius,
        e_helix_radius,
        e_strand_width,
        e_strand_thickness,
        e_protein_labels,
        e_nucleotide_labels,
        e_ion_labels
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 27> TmemberIndex;

    // getters
    // setters

    /// a name (for favorites)
    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// backbone styles
    /// mandatory
    /// typedef CCn3d_backbone_style TProtein_backbone
    ///  Check whether the Protein_backbone data member has been assigned a value.
    bool IsSetProtein_backbone(void) const;
    /// Check whether it is safe or not to call GetProtein_backbone method.
    bool CanGetProtein_backbone(void) const;
    void ResetProtein_backbone(void);
    const TProtein_backbone& GetProtein_backbone(void) const;
    void SetProtein_backbone(TProtein_backbone& value);
    TProtein_backbone& SetProtein_backbone(void);

    /// mandatory
    /// typedef CCn3d_backbone_style TNucleotide_backbone
    ///  Check whether the Nucleotide_backbone data member has been assigned a value.
    bool IsSetNucleotide_backbone(void) const;
    /// Check whether it is safe or not to call GetNucleotide_backbone method.
    bool CanGetNucleotide_backbone(void) const;
    void ResetNucleotide_backbone(void);
    const TNucleotide_backbone& GetNucleotide_backbone(void) const;
    void SetNucleotide_backbone(TNucleotide_backbone& value);
    TNucleotide_backbone& SetNucleotide_backbone(void);

    /// styles for other stuff
    /// mandatory
    /// typedef CCn3d_general_style TProtein_sidechains
    ///  Check whether the Protein_sidechains data member has been assigned a value.
    bool IsSetProtein_sidechains(void) const;
    /// Check whether it is safe or not to call GetProtein_sidechains method.
    bool CanGetProtein_sidechains(void) const;
    void ResetProtein_sidechains(void);
    const TProtein_sidechains& GetProtein_sidechains(void) const;
    void SetProtein_sidechains(TProtein_sidechains& value);
    TProtein_sidechains& SetProtein_sidechains(void);

    /// mandatory
    /// typedef CCn3d_general_style TNucleotide_sidechains
    ///  Check whether the Nucleotide_sidechains data member has been assigned a value.
    bool IsSetNucleotide_sidechains(void) const;
    /// Check whether it is safe or not to call GetNucleotide_sidechains method.
    bool CanGetNucleotide_sidechains(void) const;
    void ResetNucleotide_sidechains(void);
    const TNucleotide_sidechains& GetNucleotide_sidechains(void) const;
    void SetNucleotide_sidechains(TNucleotide_sidechains& value);
    TNucleotide_sidechains& SetNucleotide_sidechains(void);

    /// mandatory
    /// typedef CCn3d_general_style THeterogens
    ///  Check whether the Heterogens data member has been assigned a value.
    bool IsSetHeterogens(void) const;
    /// Check whether it is safe or not to call GetHeterogens method.
    bool CanGetHeterogens(void) const;
    void ResetHeterogens(void);
    const THeterogens& GetHeterogens(void) const;
    void SetHeterogens(THeterogens& value);
    THeterogens& SetHeterogens(void);

    /// mandatory
    /// typedef CCn3d_general_style TSolvents
    ///  Check whether the Solvents data member has been assigned a value.
    bool IsSetSolvents(void) const;
    /// Check whether it is safe or not to call GetSolvents method.
    bool CanGetSolvents(void) const;
    void ResetSolvents(void);
    const TSolvents& GetSolvents(void) const;
    void SetSolvents(TSolvents& value);
    TSolvents& SetSolvents(void);

    /// mandatory
    /// typedef CCn3d_general_style TConnections
    ///  Check whether the Connections data member has been assigned a value.
    bool IsSetConnections(void) const;
    /// Check whether it is safe or not to call GetConnections method.
    bool CanGetConnections(void) const;
    void ResetConnections(void);
    const TConnections& GetConnections(void) const;
    void SetConnections(TConnections& value);
    TConnections& SetConnections(void);

    /// mandatory
    /// typedef CCn3d_general_style THelix_objects
    ///  Check whether the Helix_objects data member has been assigned a value.
    bool IsSetHelix_objects(void) const;
    /// Check whether it is safe or not to call GetHelix_objects method.
    bool CanGetHelix_objects(void) const;
    void ResetHelix_objects(void);
    const THelix_objects& GetHelix_objects(void) const;
    void SetHelix_objects(THelix_objects& value);
    THelix_objects& SetHelix_objects(void);

    /// mandatory
    /// typedef CCn3d_general_style TStrand_objects
    ///  Check whether the Strand_objects data member has been assigned a value.
    bool IsSetStrand_objects(void) const;
    /// Check whether it is safe or not to call GetStrand_objects method.
    bool CanGetStrand_objects(void) const;
    void ResetStrand_objects(void);
    const TStrand_objects& GetStrand_objects(void) const;
    void SetStrand_objects(TStrand_objects& value);
    TStrand_objects& SetStrand_objects(void);

    /// virtual disulfides
    /// mandatory
    /// typedef bool TVirtual_disulfides_on
    ///  Check whether the Virtual_disulfides_on data member has been assigned a value.
    bool IsSetVirtual_disulfides_on(void) const;
    /// Check whether it is safe or not to call GetVirtual_disulfides_on method.
    bool CanGetVirtual_disulfides_on(void) const;
    void ResetVirtual_disulfides_on(void);
    TVirtual_disulfides_on GetVirtual_disulfides_on(void) const;
    void SetVirtual_disulfides_on(TVirtual_disulfides_on value);
    TVirtual_disulfides_on& SetVirtual_disulfides_on(void);

    /// mandatory
    /// typedef CCn3d_color TVirtual_disulfide_color
    ///  Check whether the Virtual_disulfide_color data member has been assigned a value.
    bool IsSetVirtual_disulfide_color(void) const;
    /// Check whether it is safe or not to call GetVirtual_disulfide_color method.
    bool CanGetVirtual_disulfide_color(void) const;
    void ResetVirtual_disulfide_color(void);
    const TVirtual_disulfide_color& GetVirtual_disulfide_color(void) const;
    void SetVirtual_disulfide_color(TVirtual_disulfide_color& value);
    TVirtual_disulfide_color& SetVirtual_disulfide_color(void);

    /// hydrogens
    /// mandatory
    /// typedef bool THydrogens_on
    ///  Check whether the Hydrogens_on data member has been assigned a value.
    bool IsSetHydrogens_on(void) const;
    /// Check whether it is safe or not to call GetHydrogens_on method.
    bool CanGetHydrogens_on(void) const;
    void ResetHydrogens_on(void);
    THydrogens_on GetHydrogens_on(void) const;
    void SetHydrogens_on(THydrogens_on value);
    THydrogens_on& SetHydrogens_on(void);

    /// background
    /// floating point parameters - scale-factor applies to all the following:
    /// mandatory
    /// typedef CCn3d_color TBackground_color
    ///  Check whether the Background_color data member has been assigned a value.
    bool IsSetBackground_color(void) const;
    /// Check whether it is safe or not to call GetBackground_color method.
    bool CanGetBackground_color(void) const;
    void ResetBackground_color(void);
    const TBackground_color& GetBackground_color(void) const;
    void SetBackground_color(TBackground_color& value);
    TBackground_color& SetBackground_color(void);

    /// mandatory
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// mandatory
    /// typedef int TSpace_fill_proportion
    ///  Check whether the Space_fill_proportion data member has been assigned a value.
    bool IsSetSpace_fill_proportion(void) const;
    /// Check whether it is safe or not to call GetSpace_fill_proportion method.
    bool CanGetSpace_fill_proportion(void) const;
    void ResetSpace_fill_proportion(void);
    TSpace_fill_proportion GetSpace_fill_proportion(void) const;
    void SetSpace_fill_proportion(TSpace_fill_proportion value);
    TSpace_fill_proportion& SetSpace_fill_proportion(void);

    /// mandatory
    /// typedef int TBall_radius
    ///  Check whether the Ball_radius data member has been assigned a value.
    bool IsSetBall_radius(void) const;
    /// Check whether it is safe or not to call GetBall_radius method.
    bool CanGetBall_radius(void) const;
    void ResetBall_radius(void);
    TBall_radius GetBall_radius(void) const;
    void SetBall_radius(TBall_radius value);
    TBall_radius& SetBall_radius(void);

    /// mandatory
    /// typedef int TStick_radius
    ///  Check whether the Stick_radius data member has been assigned a value.
    bool IsSetStick_radius(void) const;
    /// Check whether it is safe or not to call GetStick_radius method.
    bool CanGetStick_radius(void) const;
    void ResetStick_radius(void);
    TStick_radius GetStick_radius(void) const;
    void SetStick_radius(TStick_radius value);
    TStick_radius& SetStick_radius(void);

    /// mandatory
    /// typedef int TTube_radius
    ///  Check whether the Tube_radius data member has been assigned a value.
    bool IsSetTube_radius(void) const;
    /// Check whether it is safe or not to call GetTube_radius method.
    bool CanGetTube_radius(void) const;
    void ResetTube_radius(void);
    TTube_radius GetTube_radius(void) const;
    void SetTube_radius(TTube_radius value);
    TTube_radius& SetTube_radius(void);

    /// mandatory
    /// typedef int TTube_worm_radius
    ///  Check whether the Tube_worm_radius data member has been assigned a value.
    bool IsSetTube_worm_radius(void) const;
    /// Check whether it is safe or not to call GetTube_worm_radius method.
    bool CanGetTube_worm_radius(void) const;
    void ResetTube_worm_radius(void);
    TTube_worm_radius GetTube_worm_radius(void) const;
    void SetTube_worm_radius(TTube_worm_radius value);
    TTube_worm_radius& SetTube_worm_radius(void);

    /// mandatory
    /// typedef int THelix_radius
    ///  Check whether the Helix_radius data member has been assigned a value.
    bool IsSetHelix_radius(void) const;
    /// Check whether it is safe or not to call GetHelix_radius method.
    bool CanGetHelix_radius(void) const;
    void ResetHelix_radius(void);
    THelix_radius GetHelix_radius(void) const;
    void SetHelix_radius(THelix_radius value);
    THelix_radius& SetHelix_radius(void);

    /// mandatory
    /// typedef int TStrand_width
    ///  Check whether the Strand_width data member has been assigned a value.
    bool IsSetStrand_width(void) const;
    /// Check whether it is safe or not to call GetStrand_width method.
    bool CanGetStrand_width(void) const;
    void ResetStrand_width(void);
    TStrand_width GetStrand_width(void) const;
    void SetStrand_width(TStrand_width value);
    TStrand_width& SetStrand_width(void);

    /// mandatory
    /// typedef int TStrand_thickness
    ///  Check whether the Strand_thickness data member has been assigned a value.
    bool IsSetStrand_thickness(void) const;
    /// Check whether it is safe or not to call GetStrand_thickness method.
    bool CanGetStrand_thickness(void) const;
    void ResetStrand_thickness(void);
    TStrand_thickness GetStrand_thickness(void) const;
    void SetStrand_thickness(TStrand_thickness value);
    TStrand_thickness& SetStrand_thickness(void);

    /// backbone labels (no labels if not present)
    /// optional
    /// typedef CCn3d_backbone_label_style TProtein_labels
    ///  Check whether the Protein_labels data member has been assigned a value.
    bool IsSetProtein_labels(void) const;
    /// Check whether it is safe or not to call GetProtein_labels method.
    bool CanGetProtein_labels(void) const;
    void ResetProtein_labels(void);
    const TProtein_labels& GetProtein_labels(void) const;
    void SetProtein_labels(TProtein_labels& value);
    TProtein_labels& SetProtein_labels(void);

    /// optional
    /// typedef CCn3d_backbone_label_style TNucleotide_labels
    ///  Check whether the Nucleotide_labels data member has been assigned a value.
    bool IsSetNucleotide_labels(void) const;
    /// Check whether it is safe or not to call GetNucleotide_labels method.
    bool CanGetNucleotide_labels(void) const;
    void ResetNucleotide_labels(void);
    const TNucleotide_labels& GetNucleotide_labels(void) const;
    void SetNucleotide_labels(TNucleotide_labels& value);
    TNucleotide_labels& SetNucleotide_labels(void);

    /// ion labels
    /// optional
    /// typedef bool TIon_labels
    ///  Check whether the Ion_labels data member has been assigned a value.
    bool IsSetIon_labels(void) const;
    /// Check whether it is safe or not to call GetIon_labels method.
    bool CanGetIon_labels(void) const;
    void ResetIon_labels(void);
    TIon_labels GetIon_labels(void) const;
    void SetIon_labels(TIon_labels value);
    TIon_labels& SetIon_labels(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_style_settings_Base(const CCn3d_style_settings_Base&);
    CCn3d_style_settings_Base& operator=(const CCn3d_style_settings_Base&);

    // data
    Uint4 m_set_State[2];
    string m_Name;
    CRef< TProtein_backbone > m_Protein_backbone;
    CRef< TNucleotide_backbone > m_Nucleotide_backbone;
    CRef< TProtein_sidechains > m_Protein_sidechains;
    CRef< TNucleotide_sidechains > m_Nucleotide_sidechains;
    CRef< THeterogens > m_Heterogens;
    CRef< TSolvents > m_Solvents;
    CRef< TConnections > m_Connections;
    CRef< THelix_objects > m_Helix_objects;
    CRef< TStrand_objects > m_Strand_objects;
    bool m_Virtual_disulfides_on;
    CRef< TVirtual_disulfide_color > m_Virtual_disulfide_color;
    bool m_Hydrogens_on;
    CRef< TBackground_color > m_Background_color;
    int m_Scale_factor;
    int m_Space_fill_proportion;
    int m_Ball_radius;
    int m_Stick_radius;
    int m_Tube_radius;
    int m_Tube_worm_radius;
    int m_Helix_radius;
    int m_Strand_width;
    int m_Strand_thickness;
    CRef< TProtein_labels > m_Protein_labels;
    CRef< TNucleotide_labels > m_Nucleotide_labels;
    bool m_Ion_labels;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_style_settings_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CCn3d_style_settings_Base::TName& CCn3d_style_settings_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CCn3d_style_settings_Base::SetName(const CCn3d_style_settings_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CCn3d_style_settings_Base::SetName(CCn3d_style_settings_Base::TName&& value)
{
    m_Name = std::forward<CCn3d_style_settings_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CCn3d_style_settings_Base::TName& CCn3d_style_settings_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CCn3d_style_settings_Base::IsSetProtein_backbone(void) const
{
    return m_Protein_backbone.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetProtein_backbone(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::TProtein_backbone& CCn3d_style_settings_Base::GetProtein_backbone(void) const
{
    if ( !m_Protein_backbone ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetProtein_backbone();
    }
    return (*m_Protein_backbone);
}

inline
CCn3d_style_settings_Base::TProtein_backbone& CCn3d_style_settings_Base::SetProtein_backbone(void)
{
    if ( !m_Protein_backbone ) {
        ResetProtein_backbone();
    }
    return (*m_Protein_backbone);
}

inline
bool CCn3d_style_settings_Base::IsSetNucleotide_backbone(void) const
{
    return m_Nucleotide_backbone.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetNucleotide_backbone(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::TNucleotide_backbone& CCn3d_style_settings_Base::GetNucleotide_backbone(void) const
{
    if ( !m_Nucleotide_backbone ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetNucleotide_backbone();
    }
    return (*m_Nucleotide_backbone);
}

inline
CCn3d_style_settings_Base::TNucleotide_backbone& CCn3d_style_settings_Base::SetNucleotide_backbone(void)
{
    if ( !m_Nucleotide_backbone ) {
        ResetNucleotide_backbone();
    }
    return (*m_Nucleotide_backbone);
}

inline
bool CCn3d_style_settings_Base::IsSetProtein_sidechains(void) const
{
    return m_Protein_sidechains.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetProtein_sidechains(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::TProtein_sidechains& CCn3d_style_settings_Base::GetProtein_sidechains(void) const
{
    if ( !m_Protein_sidechains ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetProtein_sidechains();
    }
    return (*m_Protein_sidechains);
}

inline
CCn3d_style_settings_Base::TProtein_sidechains& CCn3d_style_settings_Base::SetProtein_sidechains(void)
{
    if ( !m_Protein_sidechains ) {
        ResetProtein_sidechains();
    }
    return (*m_Protein_sidechains);
}

inline
bool CCn3d_style_settings_Base::IsSetNucleotide_sidechains(void) const
{
    return m_Nucleotide_sidechains.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetNucleotide_sidechains(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::TNucleotide_sidechains& CCn3d_style_settings_Base::GetNucleotide_sidechains(void) const
{
    if ( !m_Nucleotide_sidechains ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetNucleotide_sidechains();
    }
    return (*m_Nucleotide_sidechains);
}

inline
CCn3d_style_settings_Base::TNucleotide_sidechains& CCn3d_style_settings_Base::SetNucleotide_sidechains(void)
{
    if ( !m_Nucleotide_sidechains ) {
        ResetNucleotide_sidechains();
    }
    return (*m_Nucleotide_sidechains);
}

inline
bool CCn3d_style_settings_Base::IsSetHeterogens(void) const
{
    return m_Heterogens.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetHeterogens(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::THeterogens& CCn3d_style_settings_Base::GetHeterogens(void) const
{
    if ( !m_Heterogens ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetHeterogens();
    }
    return (*m_Heterogens);
}

inline
CCn3d_style_settings_Base::THeterogens& CCn3d_style_settings_Base::SetHeterogens(void)
{
    if ( !m_Heterogens ) {
        ResetHeterogens();
    }
    return (*m_Heterogens);
}

inline
bool CCn3d_style_settings_Base::IsSetSolvents(void) const
{
    return m_Solvents.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetSolvents(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::TSolvents& CCn3d_style_settings_Base::GetSolvents(void) const
{
    if ( !m_Solvents ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetSolvents();
    }
    return (*m_Solvents);
}

inline
CCn3d_style_settings_Base::TSolvents& CCn3d_style_settings_Base::SetSolvents(void)
{
    if ( !m_Solvents ) {
        ResetSolvents();
    }
    return (*m_Solvents);
}

inline
bool CCn3d_style_settings_Base::IsSetConnections(void) const
{
    return m_Connections.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetConnections(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::TConnections& CCn3d_style_settings_Base::GetConnections(void) const
{
    if ( !m_Connections ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetConnections();
    }
    return (*m_Connections);
}

inline
CCn3d_style_settings_Base::TConnections& CCn3d_style_settings_Base::SetConnections(void)
{
    if ( !m_Connections ) {
        ResetConnections();
    }
    return (*m_Connections);
}

inline
bool CCn3d_style_settings_Base::IsSetHelix_objects(void) const
{
    return m_Helix_objects.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetHelix_objects(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::THelix_objects& CCn3d_style_settings_Base::GetHelix_objects(void) const
{
    if ( !m_Helix_objects ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetHelix_objects();
    }
    return (*m_Helix_objects);
}

inline
CCn3d_style_settings_Base::THelix_objects& CCn3d_style_settings_Base::SetHelix_objects(void)
{
    if ( !m_Helix_objects ) {
        ResetHelix_objects();
    }
    return (*m_Helix_objects);
}

inline
bool CCn3d_style_settings_Base::IsSetStrand_objects(void) const
{
    return m_Strand_objects.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetStrand_objects(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::TStrand_objects& CCn3d_style_settings_Base::GetStrand_objects(void) const
{
    if ( !m_Strand_objects ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetStrand_objects();
    }
    return (*m_Strand_objects);
}

inline
CCn3d_style_settings_Base::TStrand_objects& CCn3d_style_settings_Base::SetStrand_objects(void)
{
    if ( !m_Strand_objects ) {
        ResetStrand_objects();
    }
    return (*m_Strand_objects);
}

inline
bool CCn3d_style_settings_Base::IsSetVirtual_disulfides_on(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetVirtual_disulfides_on(void) const
{
    return IsSetVirtual_disulfides_on();
}

inline
void CCn3d_style_settings_Base::ResetVirtual_disulfides_on(void)
{
    m_Virtual_disulfides_on = 0;
    m_set_State[0] &= ~0x300000;
}

inline
CCn3d_style_settings_Base::TVirtual_disulfides_on CCn3d_style_settings_Base::GetVirtual_disulfides_on(void) const
{
    if (!CanGetVirtual_disulfides_on()) {
        ThrowUnassigned(10);
    }
    return m_Virtual_disulfides_on;
}

inline
void CCn3d_style_settings_Base::SetVirtual_disulfides_on(CCn3d_style_settings_Base::TVirtual_disulfides_on value)
{
    m_Virtual_disulfides_on = value;
    m_set_State[0] |= 0x300000;
}

inline
CCn3d_style_settings_Base::TVirtual_disulfides_on& CCn3d_style_settings_Base::SetVirtual_disulfides_on(void)
{
#ifdef _DEBUG
    if (!IsSetVirtual_disulfides_on()) {
        memset(&m_Virtual_disulfides_on,UnassignedByte(),sizeof(m_Virtual_disulfides_on));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Virtual_disulfides_on;
}

inline
bool CCn3d_style_settings_Base::IsSetVirtual_disulfide_color(void) const
{
    return m_Virtual_disulfide_color.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetVirtual_disulfide_color(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::TVirtual_disulfide_color& CCn3d_style_settings_Base::GetVirtual_disulfide_color(void) const
{
    if ( !m_Virtual_disulfide_color ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetVirtual_disulfide_color();
    }
    return (*m_Virtual_disulfide_color);
}

inline
CCn3d_style_settings_Base::TVirtual_disulfide_color& CCn3d_style_settings_Base::SetVirtual_disulfide_color(void)
{
    if ( !m_Virtual_disulfide_color ) {
        ResetVirtual_disulfide_color();
    }
    return (*m_Virtual_disulfide_color);
}

inline
bool CCn3d_style_settings_Base::IsSetHydrogens_on(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetHydrogens_on(void) const
{
    return IsSetHydrogens_on();
}

inline
void CCn3d_style_settings_Base::ResetHydrogens_on(void)
{
    m_Hydrogens_on = 0;
    m_set_State[0] &= ~0x3000000;
}

inline
CCn3d_style_settings_Base::THydrogens_on CCn3d_style_settings_Base::GetHydrogens_on(void) const
{
    if (!CanGetHydrogens_on()) {
        ThrowUnassigned(12);
    }
    return m_Hydrogens_on;
}

inline
void CCn3d_style_settings_Base::SetHydrogens_on(CCn3d_style_settings_Base::THydrogens_on value)
{
    m_Hydrogens_on = value;
    m_set_State[0] |= 0x3000000;
}

inline
CCn3d_style_settings_Base::THydrogens_on& CCn3d_style_settings_Base::SetHydrogens_on(void)
{
#ifdef _DEBUG
    if (!IsSetHydrogens_on()) {
        memset(&m_Hydrogens_on,UnassignedByte(),sizeof(m_Hydrogens_on));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Hydrogens_on;
}

inline
bool CCn3d_style_settings_Base::IsSetBackground_color(void) const
{
    return m_Background_color.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetBackground_color(void) const
{
    return true;
}

inline
const CCn3d_style_settings_Base::TBackground_color& CCn3d_style_settings_Base::GetBackground_color(void) const
{
    if ( !m_Background_color ) {
        const_cast<CCn3d_style_settings_Base*>(this)->ResetBackground_color();
    }
    return (*m_Background_color);
}

inline
CCn3d_style_settings_Base::TBackground_color& CCn3d_style_settings_Base::SetBackground_color(void)
{
    if ( !m_Background_color ) {
        ResetBackground_color();
    }
    return (*m_Background_color);
}

inline
bool CCn3d_style_settings_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetScale_factor(void) const
{
    return IsSetScale_factor();
}

inline
void CCn3d_style_settings_Base::ResetScale_factor(void)
{
    m_Scale_factor = 0;
    m_set_State[0] &= ~0x30000000;
}

inline
CCn3d_style_settings_Base::TScale_factor CCn3d_style_settings_Base::GetScale_factor(void) const
{
    if (!CanGetScale_factor()) {
        ThrowUnassigned(14);
    }
    return m_Scale_factor;
}

inline
void CCn3d_style_settings_Base::SetScale_factor(CCn3d_style_settings_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0x30000000;
}

inline
CCn3d_style_settings_Base::TScale_factor& CCn3d_style_settings_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Scale_factor;
}

inline
bool CCn3d_style_settings_Base::IsSetSpace_fill_proportion(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetSpace_fill_proportion(void) const
{
    return IsSetSpace_fill_proportion();
}

inline
void CCn3d_style_settings_Base::ResetSpace_fill_proportion(void)
{
    m_Space_fill_proportion = 0;
    m_set_State[0] &= ~0xc0000000;
}

inline
CCn3d_style_settings_Base::TSpace_fill_proportion CCn3d_style_settings_Base::GetSpace_fill_proportion(void) const
{
    if (!CanGetSpace_fill_proportion()) {
        ThrowUnassigned(15);
    }
    return m_Space_fill_proportion;
}

inline
void CCn3d_style_settings_Base::SetSpace_fill_proportion(CCn3d_style_settings_Base::TSpace_fill_proportion value)
{
    m_Space_fill_proportion = value;
    m_set_State[0] |= 0xc0000000;
}

inline
CCn3d_style_settings_Base::TSpace_fill_proportion& CCn3d_style_settings_Base::SetSpace_fill_proportion(void)
{
#ifdef _DEBUG
    if (!IsSetSpace_fill_proportion()) {
        memset(&m_Space_fill_proportion,UnassignedByte(),sizeof(m_Space_fill_proportion));
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Space_fill_proportion;
}

inline
bool CCn3d_style_settings_Base::IsSetBall_radius(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetBall_radius(void) const
{
    return IsSetBall_radius();
}

inline
void CCn3d_style_settings_Base::ResetBall_radius(void)
{
    m_Ball_radius = 0;
    m_set_State[1] &= ~0x3;
}

inline
CCn3d_style_settings_Base::TBall_radius CCn3d_style_settings_Base::GetBall_radius(void) const
{
    if (!CanGetBall_radius()) {
        ThrowUnassigned(16);
    }
    return m_Ball_radius;
}

inline
void CCn3d_style_settings_Base::SetBall_radius(CCn3d_style_settings_Base::TBall_radius value)
{
    m_Ball_radius = value;
    m_set_State[1] |= 0x3;
}

inline
CCn3d_style_settings_Base::TBall_radius& CCn3d_style_settings_Base::SetBall_radius(void)
{
#ifdef _DEBUG
    if (!IsSetBall_radius()) {
        memset(&m_Ball_radius,UnassignedByte(),sizeof(m_Ball_radius));
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Ball_radius;
}

inline
bool CCn3d_style_settings_Base::IsSetStick_radius(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetStick_radius(void) const
{
    return IsSetStick_radius();
}

inline
void CCn3d_style_settings_Base::ResetStick_radius(void)
{
    m_Stick_radius = 0;
    m_set_State[1] &= ~0xc;
}

inline
CCn3d_style_settings_Base::TStick_radius CCn3d_style_settings_Base::GetStick_radius(void) const
{
    if (!CanGetStick_radius()) {
        ThrowUnassigned(17);
    }
    return m_Stick_radius;
}

inline
void CCn3d_style_settings_Base::SetStick_radius(CCn3d_style_settings_Base::TStick_radius value)
{
    m_Stick_radius = value;
    m_set_State[1] |= 0xc;
}

inline
CCn3d_style_settings_Base::TStick_radius& CCn3d_style_settings_Base::SetStick_radius(void)
{
#ifdef _DEBUG
    if (!IsSetStick_radius()) {
        memset(&m_Stick_radius,UnassignedByte(),sizeof(m_Stick_radius));
    }
#endif
    m_set_State[1] |= 0x4;
    return m_Stick_radius;
}

inline
bool CCn3d_style_settings_Base::IsSetTube_radius(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetTube_radius(void) const
{
    return IsSetTube_radius();
}

inline
void CCn3d_style_settings_Base::ResetTube_radius(void)
{
    m_Tube_radius = 0;
    m_set_State[1] &= ~0x30;
}

inline
CCn3d_style_settings_Base::TTube_radius CCn3d_style_settings_Base::GetTube_radius(void) const
{
    if (!CanGetTube_radius()) {
        ThrowUnassigned(18);
    }
    return m_Tube_radius;
}

inline
void CCn3d_style_settings_Base::SetTube_radius(CCn3d_style_settings_Base::TTube_radius value)
{
    m_Tube_radius = value;
    m_set_State[1] |= 0x30;
}

inline
CCn3d_style_settings_Base::TTube_radius& CCn3d_style_settings_Base::SetTube_radius(void)
{
#ifdef _DEBUG
    if (!IsSetTube_radius()) {
        memset(&m_Tube_radius,UnassignedByte(),sizeof(m_Tube_radius));
    }
#endif
    m_set_State[1] |= 0x10;
    return m_Tube_radius;
}

inline
bool CCn3d_style_settings_Base::IsSetTube_worm_radius(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetTube_worm_radius(void) const
{
    return IsSetTube_worm_radius();
}

inline
void CCn3d_style_settings_Base::ResetTube_worm_radius(void)
{
    m_Tube_worm_radius = 0;
    m_set_State[1] &= ~0xc0;
}

inline
CCn3d_style_settings_Base::TTube_worm_radius CCn3d_style_settings_Base::GetTube_worm_radius(void) const
{
    if (!CanGetTube_worm_radius()) {
        ThrowUnassigned(19);
    }
    return m_Tube_worm_radius;
}

inline
void CCn3d_style_settings_Base::SetTube_worm_radius(CCn3d_style_settings_Base::TTube_worm_radius value)
{
    m_Tube_worm_radius = value;
    m_set_State[1] |= 0xc0;
}

inline
CCn3d_style_settings_Base::TTube_worm_radius& CCn3d_style_settings_Base::SetTube_worm_radius(void)
{
#ifdef _DEBUG
    if (!IsSetTube_worm_radius()) {
        memset(&m_Tube_worm_radius,UnassignedByte(),sizeof(m_Tube_worm_radius));
    }
#endif
    m_set_State[1] |= 0x40;
    return m_Tube_worm_radius;
}

inline
bool CCn3d_style_settings_Base::IsSetHelix_radius(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetHelix_radius(void) const
{
    return IsSetHelix_radius();
}

inline
void CCn3d_style_settings_Base::ResetHelix_radius(void)
{
    m_Helix_radius = 0;
    m_set_State[1] &= ~0x300;
}

inline
CCn3d_style_settings_Base::THelix_radius CCn3d_style_settings_Base::GetHelix_radius(void) const
{
    if (!CanGetHelix_radius()) {
        ThrowUnassigned(20);
    }
    return m_Helix_radius;
}

inline
void CCn3d_style_settings_Base::SetHelix_radius(CCn3d_style_settings_Base::THelix_radius value)
{
    m_Helix_radius = value;
    m_set_State[1] |= 0x300;
}

inline
CCn3d_style_settings_Base::THelix_radius& CCn3d_style_settings_Base::SetHelix_radius(void)
{
#ifdef _DEBUG
    if (!IsSetHelix_radius()) {
        memset(&m_Helix_radius,UnassignedByte(),sizeof(m_Helix_radius));
    }
#endif
    m_set_State[1] |= 0x100;
    return m_Helix_radius;
}

inline
bool CCn3d_style_settings_Base::IsSetStrand_width(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetStrand_width(void) const
{
    return IsSetStrand_width();
}

inline
void CCn3d_style_settings_Base::ResetStrand_width(void)
{
    m_Strand_width = 0;
    m_set_State[1] &= ~0xc00;
}

inline
CCn3d_style_settings_Base::TStrand_width CCn3d_style_settings_Base::GetStrand_width(void) const
{
    if (!CanGetStrand_width()) {
        ThrowUnassigned(21);
    }
    return m_Strand_width;
}

inline
void CCn3d_style_settings_Base::SetStrand_width(CCn3d_style_settings_Base::TStrand_width value)
{
    m_Strand_width = value;
    m_set_State[1] |= 0xc00;
}

inline
CCn3d_style_settings_Base::TStrand_width& CCn3d_style_settings_Base::SetStrand_width(void)
{
#ifdef _DEBUG
    if (!IsSetStrand_width()) {
        memset(&m_Strand_width,UnassignedByte(),sizeof(m_Strand_width));
    }
#endif
    m_set_State[1] |= 0x400;
    return m_Strand_width;
}

inline
bool CCn3d_style_settings_Base::IsSetStrand_thickness(void) const
{
    return ((m_set_State[1] & 0x3000) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetStrand_thickness(void) const
{
    return IsSetStrand_thickness();
}

inline
void CCn3d_style_settings_Base::ResetStrand_thickness(void)
{
    m_Strand_thickness = 0;
    m_set_State[1] &= ~0x3000;
}

inline
CCn3d_style_settings_Base::TStrand_thickness CCn3d_style_settings_Base::GetStrand_thickness(void) const
{
    if (!CanGetStrand_thickness()) {
        ThrowUnassigned(22);
    }
    return m_Strand_thickness;
}

inline
void CCn3d_style_settings_Base::SetStrand_thickness(CCn3d_style_settings_Base::TStrand_thickness value)
{
    m_Strand_thickness = value;
    m_set_State[1] |= 0x3000;
}

inline
CCn3d_style_settings_Base::TStrand_thickness& CCn3d_style_settings_Base::SetStrand_thickness(void)
{
#ifdef _DEBUG
    if (!IsSetStrand_thickness()) {
        memset(&m_Strand_thickness,UnassignedByte(),sizeof(m_Strand_thickness));
    }
#endif
    m_set_State[1] |= 0x1000;
    return m_Strand_thickness;
}

inline
bool CCn3d_style_settings_Base::IsSetProtein_labels(void) const
{
    return m_Protein_labels.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetProtein_labels(void) const
{
    return IsSetProtein_labels();
}

inline
const CCn3d_style_settings_Base::TProtein_labels& CCn3d_style_settings_Base::GetProtein_labels(void) const
{
    if (!CanGetProtein_labels()) {
        ThrowUnassigned(23);
    }
    return (*m_Protein_labels);
}

inline
bool CCn3d_style_settings_Base::IsSetNucleotide_labels(void) const
{
    return m_Nucleotide_labels.NotEmpty();
}

inline
bool CCn3d_style_settings_Base::CanGetNucleotide_labels(void) const
{
    return IsSetNucleotide_labels();
}

inline
const CCn3d_style_settings_Base::TNucleotide_labels& CCn3d_style_settings_Base::GetNucleotide_labels(void) const
{
    if (!CanGetNucleotide_labels()) {
        ThrowUnassigned(24);
    }
    return (*m_Nucleotide_labels);
}

inline
bool CCn3d_style_settings_Base::IsSetIon_labels(void) const
{
    return ((m_set_State[1] & 0xc0000) != 0);
}

inline
bool CCn3d_style_settings_Base::CanGetIon_labels(void) const
{
    return IsSetIon_labels();
}

inline
void CCn3d_style_settings_Base::ResetIon_labels(void)
{
    m_Ion_labels = 0;
    m_set_State[1] &= ~0xc0000;
}

inline
CCn3d_style_settings_Base::TIon_labels CCn3d_style_settings_Base::GetIon_labels(void) const
{
    if (!CanGetIon_labels()) {
        ThrowUnassigned(25);
    }
    return m_Ion_labels;
}

inline
void CCn3d_style_settings_Base::SetIon_labels(CCn3d_style_settings_Base::TIon_labels value)
{
    m_Ion_labels = value;
    m_set_State[1] |= 0xc0000;
}

inline
CCn3d_style_settings_Base::TIon_labels& CCn3d_style_settings_Base::SetIon_labels(void)
{
#ifdef _DEBUG
    if (!IsSetIon_labels()) {
        memset(&m_Ion_labels,UnassignedByte(),sizeof(m_Ion_labels));
    }
#endif
    m_set_State[1] |= 0x40000;
    return m_Ion_labels;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_STYLE_SETTINGS_BASE_HPP
