/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Sequence_tree_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_SEQUENCE_TREE_BASE_HPP
#define OBJECTS_CDD_SEQUENCE_TREE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAlgorithm_type;
class CSeqTree_node;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// record sequence trees generated by a suitable algorithm.
class NCBI_CDD_EXPORT CSequence_tree_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSequence_tree_Base(void);
    // destructor
    virtual ~CSequence_tree_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TCdAccession;
    typedef CAlgorithm_type TAlgorithm;
    typedef bool TIsAnnotated;
    typedef CSeqTree_node TRoot;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_cdAccession,
        e_algorithm,
        e_isAnnotated,
        e_root
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TCdAccession
    ///  Check whether the CdAccession data member has been assigned a value.
    bool IsSetCdAccession(void) const;
    /// Check whether it is safe or not to call GetCdAccession method.
    bool CanGetCdAccession(void) const;
    void ResetCdAccession(void);
    const TCdAccession& GetCdAccession(void) const;
    void SetCdAccession(const TCdAccession& value);
    void SetCdAccession(TCdAccession&& value);
    TCdAccession& SetCdAccession(void);

    /// mandatory
    /// typedef CAlgorithm_type TAlgorithm
    ///  Check whether the Algorithm data member has been assigned a value.
    bool IsSetAlgorithm(void) const;
    /// Check whether it is safe or not to call GetAlgorithm method.
    bool CanGetAlgorithm(void) const;
    void ResetAlgorithm(void);
    const TAlgorithm& GetAlgorithm(void) const;
    void SetAlgorithm(TAlgorithm& value);
    TAlgorithm& SetAlgorithm(void);

    /// optional with default false
    /// typedef bool TIsAnnotated
    ///  Check whether the IsAnnotated data member has been assigned a value.
    bool IsSetIsAnnotated(void) const;
    /// Check whether it is safe or not to call GetIsAnnotated method.
    bool CanGetIsAnnotated(void) const;
    void ResetIsAnnotated(void);
    void SetDefaultIsAnnotated(void);
    TIsAnnotated GetIsAnnotated(void) const;
    void SetIsAnnotated(TIsAnnotated value);
    TIsAnnotated& SetIsAnnotated(void);

    /// mandatory
    /// typedef CSeqTree_node TRoot
    ///  Check whether the Root data member has been assigned a value.
    bool IsSetRoot(void) const;
    /// Check whether it is safe or not to call GetRoot method.
    bool CanGetRoot(void) const;
    void ResetRoot(void);
    const TRoot& GetRoot(void) const;
    void SetRoot(TRoot& value);
    TRoot& SetRoot(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSequence_tree_Base(const CSequence_tree_Base&);
    CSequence_tree_Base& operator=(const CSequence_tree_Base&);

    // data
    Uint4 m_set_State[1];
    string m_CdAccession;
    CRef< TAlgorithm > m_Algorithm;
    bool m_IsAnnotated;
    CRef< TRoot > m_Root;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSequence_tree_Base::IsSetCdAccession(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSequence_tree_Base::CanGetCdAccession(void) const
{
    return IsSetCdAccession();
}

inline
const CSequence_tree_Base::TCdAccession& CSequence_tree_Base::GetCdAccession(void) const
{
    if (!CanGetCdAccession()) {
        ThrowUnassigned(0);
    }
    return m_CdAccession;
}

inline
void CSequence_tree_Base::SetCdAccession(const CSequence_tree_Base::TCdAccession& value)
{
    m_CdAccession = value;
    m_set_State[0] |= 0x3;
}

inline
void CSequence_tree_Base::SetCdAccession(CSequence_tree_Base::TCdAccession&& value)
{
    m_CdAccession = std::forward<CSequence_tree_Base::TCdAccession>(value);
    m_set_State[0] |= 0x3;
}

inline
CSequence_tree_Base::TCdAccession& CSequence_tree_Base::SetCdAccession(void)
{
#ifdef _DEBUG
    if (!IsSetCdAccession()) {
        m_CdAccession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_CdAccession;
}

inline
bool CSequence_tree_Base::IsSetAlgorithm(void) const
{
    return m_Algorithm.NotEmpty();
}

inline
bool CSequence_tree_Base::CanGetAlgorithm(void) const
{
    return true;
}

inline
const CSequence_tree_Base::TAlgorithm& CSequence_tree_Base::GetAlgorithm(void) const
{
    if ( !m_Algorithm ) {
        const_cast<CSequence_tree_Base*>(this)->ResetAlgorithm();
    }
    return (*m_Algorithm);
}

inline
CSequence_tree_Base::TAlgorithm& CSequence_tree_Base::SetAlgorithm(void)
{
    if ( !m_Algorithm ) {
        ResetAlgorithm();
    }
    return (*m_Algorithm);
}

inline
bool CSequence_tree_Base::IsSetIsAnnotated(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSequence_tree_Base::CanGetIsAnnotated(void) const
{
    return true;
}

inline
void CSequence_tree_Base::ResetIsAnnotated(void)
{
    m_IsAnnotated = false;
    m_set_State[0] &= ~0x30;
}

inline
void CSequence_tree_Base::SetDefaultIsAnnotated(void)
{
    ResetIsAnnotated();
}

inline
CSequence_tree_Base::TIsAnnotated CSequence_tree_Base::GetIsAnnotated(void) const
{
    return m_IsAnnotated;
}

inline
void CSequence_tree_Base::SetIsAnnotated(CSequence_tree_Base::TIsAnnotated value)
{
    m_IsAnnotated = value;
    m_set_State[0] |= 0x30;
}

inline
CSequence_tree_Base::TIsAnnotated& CSequence_tree_Base::SetIsAnnotated(void)
{
#ifdef _DEBUG
    if (!IsSetIsAnnotated()) {
        memset(&m_IsAnnotated,UnassignedByte(),sizeof(m_IsAnnotated));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_IsAnnotated;
}

inline
bool CSequence_tree_Base::IsSetRoot(void) const
{
    return m_Root.NotEmpty();
}

inline
bool CSequence_tree_Base::CanGetRoot(void) const
{
    return true;
}

inline
const CSequence_tree_Base::TRoot& CSequence_tree_Base::GetRoot(void) const
{
    if ( !m_Root ) {
        const_cast<CSequence_tree_Base*>(this)->ResetRoot();
    }
    return (*m_Root);
}

inline
CSequence_tree_Base::TRoot& CSequence_tree_Base::SetRoot(void)
{
    if ( !m_Root ) {
        ResetRoot();
    }
    return (*m_Root);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_SEQUENCE_TREE_BASE_HPP
