/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqTree_node_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_SEQTREE_NODE_BASE_HPP
#define OBJECTS_CDD_SEQTREE_NODE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CNode_annotation;
class CSeqTree_node;
class CSeq_interval;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_CDD_EXPORT CSeqTree_node_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqTree_node_Base(void);
    // destructor
    virtual ~CSeqTree_node_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_CDD_EXPORT C_Children : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Children(void);
        // destructor
        ~C_Children(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_CDD_EXPORT C_Footprint : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Footprint(void);
            // destructor
            ~C_Footprint(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef CSeq_interval TSeqRange;
            typedef int TRowId;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_seqRange,
                e_rowId
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef CSeq_interval TSeqRange
            ///  Check whether the SeqRange data member has been assigned a value.
            bool IsSetSeqRange(void) const;
            /// Check whether it is safe or not to call GetSeqRange method.
            bool CanGetSeqRange(void) const;
            void ResetSeqRange(void);
            const TSeqRange& GetSeqRange(void) const;
            void SetSeqRange(TSeqRange& value);
            TSeqRange& SetSeqRange(void);
        
            /// optional
            /// typedef int TRowId
            ///  Check whether the RowId data member has been assigned a value.
            bool IsSetRowId(void) const;
            /// Check whether it is safe or not to call GetRowId method.
            bool CanGetRowId(void) const;
            void ResetRowId(void);
            TRowId GetRowId(void) const;
            void SetRowId(TRowId value);
            TRowId& SetRowId(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Footprint(const C_Footprint&);
            C_Footprint& operator=(const C_Footprint&);
        
            // data
            Uint4 m_set_State[1];
            CRef< TSeqRange > m_SeqRange;
            int m_RowId;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Children,
            e_Footprint
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Footprint+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef list< CRef< CSeqTree_node > > TChildren;
        typedef C_Footprint TFootprint;
    
        // getters
        // setters
    
        // typedef list< CRef< CSeqTree_node > > TChildren
        bool IsChildren(void) const;
        const TChildren& GetChildren(void) const;
        TChildren& SetChildren(void);
    
        // typedef C_Footprint TFootprint
        bool IsFootprint(void) const;
        const TFootprint& GetFootprint(void) const;
        TFootprint& SetFootprint(void);
        void SetFootprint(TFootprint& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Children(const C_Children& );
        C_Children& operator=(const C_Children& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<TChildren> m_Children;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef bool TIsAnnotated;
    typedef string TName;
    typedef double TDistance;
    typedef C_Children TChildren;
    typedef CNode_annotation TAnnotation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_isAnnotated,
        e_name,
        e_distance,
        e_children,
        e_annotation
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// optional with default false
    /// typedef bool TIsAnnotated
    ///  Check whether the IsAnnotated data member has been assigned a value.
    bool IsSetIsAnnotated(void) const;
    /// Check whether it is safe or not to call GetIsAnnotated method.
    bool CanGetIsAnnotated(void) const;
    void ResetIsAnnotated(void);
    void SetDefaultIsAnnotated(void);
    TIsAnnotated GetIsAnnotated(void) const;
    void SetIsAnnotated(TIsAnnotated value);
    TIsAnnotated& SetIsAnnotated(void);

    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef double TDistance
    ///  Check whether the Distance data member has been assigned a value.
    bool IsSetDistance(void) const;
    /// Check whether it is safe or not to call GetDistance method.
    bool CanGetDistance(void) const;
    void ResetDistance(void);
    TDistance GetDistance(void) const;
    void SetDistance(TDistance value);
    TDistance& SetDistance(void);

    /// mandatory
    /// typedef C_Children TChildren
    ///  Check whether the Children data member has been assigned a value.
    bool IsSetChildren(void) const;
    /// Check whether it is safe or not to call GetChildren method.
    bool CanGetChildren(void) const;
    void ResetChildren(void);
    const TChildren& GetChildren(void) const;
    void SetChildren(TChildren& value);
    TChildren& SetChildren(void);

    /// optional
    /// typedef CNode_annotation TAnnotation
    ///  Check whether the Annotation data member has been assigned a value.
    bool IsSetAnnotation(void) const;
    /// Check whether it is safe or not to call GetAnnotation method.
    bool CanGetAnnotation(void) const;
    void ResetAnnotation(void);
    const TAnnotation& GetAnnotation(void) const;
    void SetAnnotation(TAnnotation& value);
    TAnnotation& SetAnnotation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqTree_node_Base(const CSeqTree_node_Base&);
    CSeqTree_node_Base& operator=(const CSeqTree_node_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_IsAnnotated;
    string m_Name;
    double m_Distance;
    CRef< TChildren > m_Children;
    CRef< TAnnotation > m_Annotation;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeqTree_node_Base::C_Children::C_Footprint::IsSetSeqRange(void) const
{
    return m_SeqRange.NotEmpty();
}

inline
bool CSeqTree_node_Base::C_Children::C_Footprint::CanGetSeqRange(void) const
{
    return true;
}

inline
const CSeqTree_node_Base::C_Children::C_Footprint::TSeqRange& CSeqTree_node_Base::C_Children::C_Footprint::GetSeqRange(void) const
{
    if ( !m_SeqRange ) {
        const_cast<C_Footprint*>(this)->ResetSeqRange();
    }
    return (*m_SeqRange);
}

inline
CSeqTree_node_Base::C_Children::C_Footprint::TSeqRange& CSeqTree_node_Base::C_Children::C_Footprint::SetSeqRange(void)
{
    if ( !m_SeqRange ) {
        ResetSeqRange();
    }
    return (*m_SeqRange);
}

inline
bool CSeqTree_node_Base::C_Children::C_Footprint::IsSetRowId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeqTree_node_Base::C_Children::C_Footprint::CanGetRowId(void) const
{
    return IsSetRowId();
}

inline
void CSeqTree_node_Base::C_Children::C_Footprint::ResetRowId(void)
{
    m_RowId = 0;
    m_set_State[0] &= ~0xc;
}

inline
CSeqTree_node_Base::C_Children::C_Footprint::TRowId CSeqTree_node_Base::C_Children::C_Footprint::GetRowId(void) const
{
    if (!CanGetRowId()) {
        ThrowUnassigned(1);
    }
    return m_RowId;
}

inline
void CSeqTree_node_Base::C_Children::C_Footprint::SetRowId(CSeqTree_node_Base::C_Children::C_Footprint::TRowId value)
{
    m_RowId = value;
    m_set_State[0] |= 0xc;
}

inline
CSeqTree_node_Base::C_Children::C_Footprint::TRowId& CSeqTree_node_Base::C_Children::C_Footprint::SetRowId(void)
{
#ifdef _DEBUG
    if (!IsSetRowId()) {
        memset(&m_RowId,UnassignedByte(),sizeof(m_RowId));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_RowId;
}

inline
CSeqTree_node_Base::C_Children::E_Choice CSeqTree_node_Base::C_Children::Which(void) const
{
    return m_choice;
}

inline
void CSeqTree_node_Base::C_Children::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeqTree_node_Base::C_Children::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeqTree_node_Base::C_Children::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeqTree_node_Base::C_Children::IsChildren(void) const
{
    return m_choice == e_Children;
}

inline
const CSeqTree_node_Base::C_Children::TChildren& CSeqTree_node_Base::C_Children::GetChildren(void) const
{
    CheckSelected(e_Children);
    return *m_Children;
}

inline
CSeqTree_node_Base::C_Children::TChildren& CSeqTree_node_Base::C_Children::SetChildren(void)
{
    Select(e_Children, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Children;
}

inline
bool CSeqTree_node_Base::C_Children::IsFootprint(void) const
{
    return m_choice == e_Footprint;
}

inline
bool CSeqTree_node_Base::IsSetIsAnnotated(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeqTree_node_Base::CanGetIsAnnotated(void) const
{
    return true;
}

inline
void CSeqTree_node_Base::ResetIsAnnotated(void)
{
    m_IsAnnotated = false;
    m_set_State[0] &= ~0x3;
}

inline
void CSeqTree_node_Base::SetDefaultIsAnnotated(void)
{
    ResetIsAnnotated();
}

inline
CSeqTree_node_Base::TIsAnnotated CSeqTree_node_Base::GetIsAnnotated(void) const
{
    return m_IsAnnotated;
}

inline
void CSeqTree_node_Base::SetIsAnnotated(CSeqTree_node_Base::TIsAnnotated value)
{
    m_IsAnnotated = value;
    m_set_State[0] |= 0x3;
}

inline
CSeqTree_node_Base::TIsAnnotated& CSeqTree_node_Base::SetIsAnnotated(void)
{
#ifdef _DEBUG
    if (!IsSetIsAnnotated()) {
        memset(&m_IsAnnotated,UnassignedByte(),sizeof(m_IsAnnotated));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_IsAnnotated;
}

inline
bool CSeqTree_node_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeqTree_node_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CSeqTree_node_Base::TName& CSeqTree_node_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CSeqTree_node_Base::SetName(const CSeqTree_node_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CSeqTree_node_Base::SetName(CSeqTree_node_Base::TName&& value)
{
    m_Name = std::forward<CSeqTree_node_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CSeqTree_node_Base::TName& CSeqTree_node_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CSeqTree_node_Base::IsSetDistance(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeqTree_node_Base::CanGetDistance(void) const
{
    return IsSetDistance();
}

inline
void CSeqTree_node_Base::ResetDistance(void)
{
    m_Distance = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSeqTree_node_Base::TDistance CSeqTree_node_Base::GetDistance(void) const
{
    if (!CanGetDistance()) {
        ThrowUnassigned(2);
    }
    return m_Distance;
}

inline
void CSeqTree_node_Base::SetDistance(CSeqTree_node_Base::TDistance value)
{
    m_Distance = value;
    m_set_State[0] |= 0x30;
}

inline
CSeqTree_node_Base::TDistance& CSeqTree_node_Base::SetDistance(void)
{
#ifdef _DEBUG
    if (!IsSetDistance()) {
        memset(&m_Distance,UnassignedByte(),sizeof(m_Distance));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Distance;
}

inline
bool CSeqTree_node_Base::IsSetChildren(void) const
{
    return m_Children.NotEmpty();
}

inline
bool CSeqTree_node_Base::CanGetChildren(void) const
{
    return true;
}

inline
const CSeqTree_node_Base::TChildren& CSeqTree_node_Base::GetChildren(void) const
{
    if ( !m_Children ) {
        const_cast<CSeqTree_node_Base*>(this)->ResetChildren();
    }
    return (*m_Children);
}

inline
CSeqTree_node_Base::TChildren& CSeqTree_node_Base::SetChildren(void)
{
    if ( !m_Children ) {
        ResetChildren();
    }
    return (*m_Children);
}

inline
bool CSeqTree_node_Base::IsSetAnnotation(void) const
{
    return m_Annotation.NotEmpty();
}

inline
bool CSeqTree_node_Base::CanGetAnnotation(void) const
{
    return IsSetAnnotation();
}

inline
const CSeqTree_node_Base::TAnnotation& CSeqTree_node_Base::GetAnnotation(void) const
{
    if (!CanGetAnnotation()) {
        ThrowUnassigned(4);
    }
    return (*m_Annotation);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_SEQTREE_NODE_BASE_HPP
