/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cdd_pref_nodes_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_CDD_PREF_NODES_BASE_HPP
#define OBJECTS_CDD_CDD_PREF_NODES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCdd_org_ref_set;
class CCdd_pref_node_descr_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_CDD_EXPORT CCdd_pref_nodes_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCdd_pref_nodes_Base(void);
    // destructor
    virtual ~CCdd_pref_nodes_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CCdd_org_ref_set TPreferred_nodes;
    typedef CCdd_org_ref_set TModel_organisms;
    typedef CCdd_org_ref_set TOptional_nodes;
    typedef CCdd_pref_node_descr_set TDescription;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_preferred_nodes,
        e_model_organisms,
        e_optional_nodes,
        e_description
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CCdd_org_ref_set TPreferred_nodes
    ///  Check whether the Preferred_nodes data member has been assigned a value.
    bool IsSetPreferred_nodes(void) const;
    /// Check whether it is safe or not to call GetPreferred_nodes method.
    bool CanGetPreferred_nodes(void) const;
    void ResetPreferred_nodes(void);
    const TPreferred_nodes& GetPreferred_nodes(void) const;
    void SetPreferred_nodes(TPreferred_nodes& value);
    TPreferred_nodes& SetPreferred_nodes(void);

    /// optional
    /// typedef CCdd_org_ref_set TModel_organisms
    ///  Check whether the Model_organisms data member has been assigned a value.
    bool IsSetModel_organisms(void) const;
    /// Check whether it is safe or not to call GetModel_organisms method.
    bool CanGetModel_organisms(void) const;
    void ResetModel_organisms(void);
    const TModel_organisms& GetModel_organisms(void) const;
    void SetModel_organisms(TModel_organisms& value);
    TModel_organisms& SetModel_organisms(void);

    /// optional
    /// typedef CCdd_org_ref_set TOptional_nodes
    ///  Check whether the Optional_nodes data member has been assigned a value.
    bool IsSetOptional_nodes(void) const;
    /// Check whether it is safe or not to call GetOptional_nodes method.
    bool CanGetOptional_nodes(void) const;
    void ResetOptional_nodes(void);
    const TOptional_nodes& GetOptional_nodes(void) const;
    void SetOptional_nodes(TOptional_nodes& value);
    TOptional_nodes& SetOptional_nodes(void);

    /// optional
    /// typedef CCdd_pref_node_descr_set TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(TDescription& value);
    TDescription& SetDescription(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCdd_pref_nodes_Base(const CCdd_pref_nodes_Base&);
    CCdd_pref_nodes_Base& operator=(const CCdd_pref_nodes_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TPreferred_nodes > m_Preferred_nodes;
    CRef< TModel_organisms > m_Model_organisms;
    CRef< TOptional_nodes > m_Optional_nodes;
    CRef< TDescription > m_Description;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCdd_pref_nodes_Base::IsSetPreferred_nodes(void) const
{
    return m_Preferred_nodes.NotEmpty();
}

inline
bool CCdd_pref_nodes_Base::CanGetPreferred_nodes(void) const
{
    return true;
}

inline
const CCdd_pref_nodes_Base::TPreferred_nodes& CCdd_pref_nodes_Base::GetPreferred_nodes(void) const
{
    if ( !m_Preferred_nodes ) {
        const_cast<CCdd_pref_nodes_Base*>(this)->ResetPreferred_nodes();
    }
    return (*m_Preferred_nodes);
}

inline
CCdd_pref_nodes_Base::TPreferred_nodes& CCdd_pref_nodes_Base::SetPreferred_nodes(void)
{
    if ( !m_Preferred_nodes ) {
        ResetPreferred_nodes();
    }
    return (*m_Preferred_nodes);
}

inline
bool CCdd_pref_nodes_Base::IsSetModel_organisms(void) const
{
    return m_Model_organisms.NotEmpty();
}

inline
bool CCdd_pref_nodes_Base::CanGetModel_organisms(void) const
{
    return IsSetModel_organisms();
}

inline
const CCdd_pref_nodes_Base::TModel_organisms& CCdd_pref_nodes_Base::GetModel_organisms(void) const
{
    if (!CanGetModel_organisms()) {
        ThrowUnassigned(1);
    }
    return (*m_Model_organisms);
}

inline
bool CCdd_pref_nodes_Base::IsSetOptional_nodes(void) const
{
    return m_Optional_nodes.NotEmpty();
}

inline
bool CCdd_pref_nodes_Base::CanGetOptional_nodes(void) const
{
    return IsSetOptional_nodes();
}

inline
const CCdd_pref_nodes_Base::TOptional_nodes& CCdd_pref_nodes_Base::GetOptional_nodes(void) const
{
    if (!CanGetOptional_nodes()) {
        ThrowUnassigned(2);
    }
    return (*m_Optional_nodes);
}

inline
bool CCdd_pref_nodes_Base::IsSetDescription(void) const
{
    return m_Description.NotEmpty();
}

inline
bool CCdd_pref_nodes_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CCdd_pref_nodes_Base::TDescription& CCdd_pref_nodes_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(3);
    }
    return (*m_Description);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_CDD_PREF_NODES_BASE_HPP
