/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cdd_org_ref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_CDD_ORG_REF_BASE_HPP
#define OBJECTS_CDD_CDD_ORG_REF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class COrg_ref;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// dealing with lists of preferred tax-nodes 
class NCBI_CDD_EXPORT CCdd_org_ref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCdd_org_ref_Base(void);
    // destructor
    virtual ~CCdd_org_ref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef COrg_ref TReference;
    typedef bool TActive;
    typedef int TParent_tax_id;
    typedef string TRank;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_reference,
        e_active,
        e_parent_tax_id,
        e_rank
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef COrg_ref TReference
    ///  Check whether the Reference data member has been assigned a value.
    bool IsSetReference(void) const;
    /// Check whether it is safe or not to call GetReference method.
    bool CanGetReference(void) const;
    void ResetReference(void);
    const TReference& GetReference(void) const;
    void SetReference(TReference& value);
    TReference& SetReference(void);

    /// optional with default true
    /// typedef bool TActive
    ///  Check whether the Active data member has been assigned a value.
    bool IsSetActive(void) const;
    /// Check whether it is safe or not to call GetActive method.
    bool CanGetActive(void) const;
    void ResetActive(void);
    void SetDefaultActive(void);
    TActive GetActive(void) const;
    void SetActive(TActive value);
    TActive& SetActive(void);

    /// optional
    /// typedef int TParent_tax_id
    ///  Check whether the Parent_tax_id data member has been assigned a value.
    bool IsSetParent_tax_id(void) const;
    /// Check whether it is safe or not to call GetParent_tax_id method.
    bool CanGetParent_tax_id(void) const;
    void ResetParent_tax_id(void);
    TParent_tax_id GetParent_tax_id(void) const;
    void SetParent_tax_id(TParent_tax_id value);
    TParent_tax_id& SetParent_tax_id(void);

    /// optional
    /// typedef string TRank
    ///  Check whether the Rank data member has been assigned a value.
    bool IsSetRank(void) const;
    /// Check whether it is safe or not to call GetRank method.
    bool CanGetRank(void) const;
    void ResetRank(void);
    const TRank& GetRank(void) const;
    void SetRank(const TRank& value);
    void SetRank(TRank&& value);
    TRank& SetRank(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCdd_org_ref_Base(const CCdd_org_ref_Base&);
    CCdd_org_ref_Base& operator=(const CCdd_org_ref_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TReference > m_Reference;
    bool m_Active;
    int m_Parent_tax_id;
    string m_Rank;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCdd_org_ref_Base::IsSetReference(void) const
{
    return m_Reference.NotEmpty();
}

inline
bool CCdd_org_ref_Base::CanGetReference(void) const
{
    return true;
}

inline
const CCdd_org_ref_Base::TReference& CCdd_org_ref_Base::GetReference(void) const
{
    if ( !m_Reference ) {
        const_cast<CCdd_org_ref_Base*>(this)->ResetReference();
    }
    return (*m_Reference);
}

inline
CCdd_org_ref_Base::TReference& CCdd_org_ref_Base::SetReference(void)
{
    if ( !m_Reference ) {
        ResetReference();
    }
    return (*m_Reference);
}

inline
bool CCdd_org_ref_Base::IsSetActive(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCdd_org_ref_Base::CanGetActive(void) const
{
    return true;
}

inline
void CCdd_org_ref_Base::ResetActive(void)
{
    m_Active = true;
    m_set_State[0] &= ~0xc;
}

inline
void CCdd_org_ref_Base::SetDefaultActive(void)
{
    ResetActive();
}

inline
CCdd_org_ref_Base::TActive CCdd_org_ref_Base::GetActive(void) const
{
    return m_Active;
}

inline
void CCdd_org_ref_Base::SetActive(CCdd_org_ref_Base::TActive value)
{
    m_Active = value;
    m_set_State[0] |= 0xc;
}

inline
CCdd_org_ref_Base::TActive& CCdd_org_ref_Base::SetActive(void)
{
#ifdef _DEBUG
    if (!IsSetActive()) {
        memset(&m_Active,UnassignedByte(),sizeof(m_Active));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Active;
}

inline
bool CCdd_org_ref_Base::IsSetParent_tax_id(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCdd_org_ref_Base::CanGetParent_tax_id(void) const
{
    return IsSetParent_tax_id();
}

inline
void CCdd_org_ref_Base::ResetParent_tax_id(void)
{
    m_Parent_tax_id = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCdd_org_ref_Base::TParent_tax_id CCdd_org_ref_Base::GetParent_tax_id(void) const
{
    if (!CanGetParent_tax_id()) {
        ThrowUnassigned(2);
    }
    return m_Parent_tax_id;
}

inline
void CCdd_org_ref_Base::SetParent_tax_id(CCdd_org_ref_Base::TParent_tax_id value)
{
    m_Parent_tax_id = value;
    m_set_State[0] |= 0x30;
}

inline
CCdd_org_ref_Base::TParent_tax_id& CCdd_org_ref_Base::SetParent_tax_id(void)
{
#ifdef _DEBUG
    if (!IsSetParent_tax_id()) {
        memset(&m_Parent_tax_id,UnassignedByte(),sizeof(m_Parent_tax_id));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Parent_tax_id;
}

inline
bool CCdd_org_ref_Base::IsSetRank(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCdd_org_ref_Base::CanGetRank(void) const
{
    return IsSetRank();
}

inline
const CCdd_org_ref_Base::TRank& CCdd_org_ref_Base::GetRank(void) const
{
    if (!CanGetRank()) {
        ThrowUnassigned(3);
    }
    return m_Rank;
}

inline
void CCdd_org_ref_Base::SetRank(const CCdd_org_ref_Base::TRank& value)
{
    m_Rank = value;
    m_set_State[0] |= 0xc0;
}

inline
void CCdd_org_ref_Base::SetRank(CCdd_org_ref_Base::TRank&& value)
{
    m_Rank = std::forward<CCdd_org_ref_Base::TRank>(value);
    m_set_State[0] |= 0xc0;
}

inline
CCdd_org_ref_Base::TRank& CCdd_org_ref_Base::SetRank(void)
{
#ifdef _DEBUG
    if (!IsSetRank()) {
        m_Rank = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Rank;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_CDD_ORG_REF_BASE_HPP
