/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cdd_book_ref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_CDD_BOOK_REF_BASE_HPP
#define OBJECTS_CDD_CDD_BOOK_REF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// record a link to Entrez Books
class NCBI_CDD_EXPORT CCdd_book_ref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCdd_book_ref_Base(void);
    // destructor
    virtual ~CCdd_book_ref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ETextelement {
        eTextelement_unassigned =   0,  ///< type of element 
        eTextelement_section    =   1,  ///< a section or paragraph
        eTextelement_figgrp     =   2,  ///< a figure or set of figures
        eTextelement_table      =   3,  ///< a table
        eTextelement_chapter    =   4,  ///< a whole chapter
        eTextelement_biblist    =   5,  ///< a lisf of references
        eTextelement_box        =   6,  ///< an inserted box
        eTextelement_glossary   =   7,  ///< glossary
        eTextelement_appendix   =   8,  ///< appendix
        eTextelement_other      = 255
    };
    
    /// Access to ETextelement's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ETextelement)(void);
    
    // types
    typedef string TBookname;
    typedef ETextelement TTextelement;
    typedef int TElementid;
    typedef int TSubelementid;
    typedef string TCelementid;
    typedef string TCsubelementid;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_bookname,
        e_textelement,
        e_elementid,
        e_subelementid,
        e_celementid,
        e_csubelementid
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// abbreviated book title
    /// mandatory
    /// typedef string TBookname
    ///  Check whether the Bookname data member has been assigned a value.
    bool IsSetBookname(void) const;
    /// Check whether it is safe or not to call GetBookname method.
    bool CanGetBookname(void) const;
    void ResetBookname(void);
    const TBookname& GetBookname(void) const;
    void SetBookname(const TBookname& value);
    void SetBookname(TBookname&& value);
    TBookname& SetBookname(void);

    /// mandatory
    /// typedef ETextelement TTextelement
    ///  Check whether the Textelement data member has been assigned a value.
    bool IsSetTextelement(void) const;
    /// Check whether it is safe or not to call GetTextelement method.
    bool CanGetTextelement(void) const;
    void ResetTextelement(void);
    TTextelement GetTextelement(void) const;
    void SetTextelement(TTextelement value);
    TTextelement& SetTextelement(void);

    /// numerical address of the text-element
    /// optional
    /// typedef int TElementid
    ///  Check whether the Elementid data member has been assigned a value.
    bool IsSetElementid(void) const;
    /// Check whether it is safe or not to call GetElementid method.
    bool CanGetElementid(void) const;
    void ResetElementid(void);
    TElementid GetElementid(void) const;
    void SetElementid(TElementid value);
    TElementid& SetElementid(void);

    /// exact address, used with section
    /// optional
    /// typedef int TSubelementid
    ///  Check whether the Subelementid data member has been assigned a value.
    bool IsSetSubelementid(void) const;
    /// Check whether it is safe or not to call GetSubelementid method.
    bool CanGetSubelementid(void) const;
    void ResetSubelementid(void);
    TSubelementid GetSubelementid(void) const;
    void SetSubelementid(TSubelementid value);
    TSubelementid& SetSubelementid(void);

    /// address of the text element, if character string
    /// optional
    /// typedef string TCelementid
    ///  Check whether the Celementid data member has been assigned a value.
    bool IsSetCelementid(void) const;
    /// Check whether it is safe or not to call GetCelementid method.
    bool CanGetCelementid(void) const;
    void ResetCelementid(void);
    const TCelementid& GetCelementid(void) const;
    void SetCelementid(const TCelementid& value);
    void SetCelementid(TCelementid&& value);
    TCelementid& SetCelementid(void);

    /// exact address, if character string
    /// optional
    /// typedef string TCsubelementid
    ///  Check whether the Csubelementid data member has been assigned a value.
    bool IsSetCsubelementid(void) const;
    /// Check whether it is safe or not to call GetCsubelementid method.
    bool CanGetCsubelementid(void) const;
    void ResetCsubelementid(void);
    const TCsubelementid& GetCsubelementid(void) const;
    void SetCsubelementid(const TCsubelementid& value);
    void SetCsubelementid(TCsubelementid&& value);
    TCsubelementid& SetCsubelementid(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCdd_book_ref_Base(const CCdd_book_ref_Base&);
    CCdd_book_ref_Base& operator=(const CCdd_book_ref_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Bookname;
    ETextelement m_Textelement;
    int m_Elementid;
    int m_Subelementid;
    string m_Celementid;
    string m_Csubelementid;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCdd_book_ref_Base::IsSetBookname(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCdd_book_ref_Base::CanGetBookname(void) const
{
    return IsSetBookname();
}

inline
const CCdd_book_ref_Base::TBookname& CCdd_book_ref_Base::GetBookname(void) const
{
    if (!CanGetBookname()) {
        ThrowUnassigned(0);
    }
    return m_Bookname;
}

inline
void CCdd_book_ref_Base::SetBookname(const CCdd_book_ref_Base::TBookname& value)
{
    m_Bookname = value;
    m_set_State[0] |= 0x3;
}

inline
void CCdd_book_ref_Base::SetBookname(CCdd_book_ref_Base::TBookname&& value)
{
    m_Bookname = std::forward<CCdd_book_ref_Base::TBookname>(value);
    m_set_State[0] |= 0x3;
}

inline
CCdd_book_ref_Base::TBookname& CCdd_book_ref_Base::SetBookname(void)
{
#ifdef _DEBUG
    if (!IsSetBookname()) {
        m_Bookname = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Bookname;
}

inline
bool CCdd_book_ref_Base::IsSetTextelement(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCdd_book_ref_Base::CanGetTextelement(void) const
{
    return IsSetTextelement();
}

inline
void CCdd_book_ref_Base::ResetTextelement(void)
{
    m_Textelement = (ETextelement)(0);
    m_set_State[0] &= ~0xc;
}

inline
CCdd_book_ref_Base::TTextelement CCdd_book_ref_Base::GetTextelement(void) const
{
    if (!CanGetTextelement()) {
        ThrowUnassigned(1);
    }
    return m_Textelement;
}

inline
void CCdd_book_ref_Base::SetTextelement(CCdd_book_ref_Base::TTextelement value)
{
    m_Textelement = value;
    m_set_State[0] |= 0xc;
}

inline
CCdd_book_ref_Base::TTextelement& CCdd_book_ref_Base::SetTextelement(void)
{
#ifdef _DEBUG
    if (!IsSetTextelement()) {
        memset(&m_Textelement,UnassignedByte(),sizeof(m_Textelement));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Textelement;
}

inline
bool CCdd_book_ref_Base::IsSetElementid(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCdd_book_ref_Base::CanGetElementid(void) const
{
    return IsSetElementid();
}

inline
void CCdd_book_ref_Base::ResetElementid(void)
{
    m_Elementid = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCdd_book_ref_Base::TElementid CCdd_book_ref_Base::GetElementid(void) const
{
    if (!CanGetElementid()) {
        ThrowUnassigned(2);
    }
    return m_Elementid;
}

inline
void CCdd_book_ref_Base::SetElementid(CCdd_book_ref_Base::TElementid value)
{
    m_Elementid = value;
    m_set_State[0] |= 0x30;
}

inline
CCdd_book_ref_Base::TElementid& CCdd_book_ref_Base::SetElementid(void)
{
#ifdef _DEBUG
    if (!IsSetElementid()) {
        memset(&m_Elementid,UnassignedByte(),sizeof(m_Elementid));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Elementid;
}

inline
bool CCdd_book_ref_Base::IsSetSubelementid(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCdd_book_ref_Base::CanGetSubelementid(void) const
{
    return IsSetSubelementid();
}

inline
void CCdd_book_ref_Base::ResetSubelementid(void)
{
    m_Subelementid = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CCdd_book_ref_Base::TSubelementid CCdd_book_ref_Base::GetSubelementid(void) const
{
    if (!CanGetSubelementid()) {
        ThrowUnassigned(3);
    }
    return m_Subelementid;
}

inline
void CCdd_book_ref_Base::SetSubelementid(CCdd_book_ref_Base::TSubelementid value)
{
    m_Subelementid = value;
    m_set_State[0] |= 0xc0;
}

inline
CCdd_book_ref_Base::TSubelementid& CCdd_book_ref_Base::SetSubelementid(void)
{
#ifdef _DEBUG
    if (!IsSetSubelementid()) {
        memset(&m_Subelementid,UnassignedByte(),sizeof(m_Subelementid));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Subelementid;
}

inline
bool CCdd_book_ref_Base::IsSetCelementid(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCdd_book_ref_Base::CanGetCelementid(void) const
{
    return IsSetCelementid();
}

inline
const CCdd_book_ref_Base::TCelementid& CCdd_book_ref_Base::GetCelementid(void) const
{
    if (!CanGetCelementid()) {
        ThrowUnassigned(4);
    }
    return m_Celementid;
}

inline
void CCdd_book_ref_Base::SetCelementid(const CCdd_book_ref_Base::TCelementid& value)
{
    m_Celementid = value;
    m_set_State[0] |= 0x300;
}

inline
void CCdd_book_ref_Base::SetCelementid(CCdd_book_ref_Base::TCelementid&& value)
{
    m_Celementid = std::forward<CCdd_book_ref_Base::TCelementid>(value);
    m_set_State[0] |= 0x300;
}

inline
CCdd_book_ref_Base::TCelementid& CCdd_book_ref_Base::SetCelementid(void)
{
#ifdef _DEBUG
    if (!IsSetCelementid()) {
        m_Celementid = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Celementid;
}

inline
bool CCdd_book_ref_Base::IsSetCsubelementid(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CCdd_book_ref_Base::CanGetCsubelementid(void) const
{
    return IsSetCsubelementid();
}

inline
const CCdd_book_ref_Base::TCsubelementid& CCdd_book_ref_Base::GetCsubelementid(void) const
{
    if (!CanGetCsubelementid()) {
        ThrowUnassigned(5);
    }
    return m_Csubelementid;
}

inline
void CCdd_book_ref_Base::SetCsubelementid(const CCdd_book_ref_Base::TCsubelementid& value)
{
    m_Csubelementid = value;
    m_set_State[0] |= 0xc00;
}

inline
void CCdd_book_ref_Base::SetCsubelementid(CCdd_book_ref_Base::TCsubelementid&& value)
{
    m_Csubelementid = std::forward<CCdd_book_ref_Base::TCsubelementid>(value);
    m_set_State[0] |= 0xc00;
}

inline
CCdd_book_ref_Base::TCsubelementid& CCdd_book_ref_Base::SetCsubelementid(void)
{
#ifdef _DEBUG
    if (!IsSetCsubelementid()) {
        m_Csubelementid = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Csubelementid;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_CDD_BOOK_REF_BASE_HPP
