/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Align_annot_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_ALIGN_ANNOT_BASE_HPP
#define OBJECTS_CDD_ALIGN_ANNOT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CFeature_evidence;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_CDD_EXPORT CAlign_annot_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAlign_annot_Base(void);
    // destructor
    virtual ~CAlign_annot_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_loc TLocation;
    typedef string TDescription;
    typedef list< CRef< CFeature_evidence > > TEvidence;
    typedef int TType;
    typedef list< string > TAliases;
    typedef string TMotif;
    typedef int TMotifuse;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_location,
        e_description,
        e_evidence,
        e_type,
        e_aliases,
        e_motif,
        e_motifuse
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// points to a location in one of the
    /// aligned sequences, usually the
    /// master/representative
    /// mandatory
    /// typedef CSeq_loc TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(TLocation& value);
    TLocation& SetLocation(void);

    /// to hold descriptions/names like
    /// "Heme binding site" or "catalytic
    /// triad" etc., something that should
    /// be used for labels in visualization
    /// optional
    /// typedef string TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// evidence we can
    /// compute with
    /// optional
    /// typedef list< CRef< CFeature_evidence > > TEvidence
    ///  Check whether the Evidence data member has been assigned a value.
    bool IsSetEvidence(void) const;
    /// Check whether it is safe or not to call GetEvidence method.
    bool CanGetEvidence(void) const;
    void ResetEvidence(void);
    const TEvidence& GetEvidence(void) const;
    TEvidence& SetEvidence(void);

    /// for typing annotated features
    /// 0 .. no type assigned
    /// 1 .. active site
    /// 2 .. polypeptide binding site
    /// 3 .. nucleic acid binding site
    /// 4 .. ion binding site
    /// 5 .. chemical binding site
    /// 6 .. posttranslational modification site
    /// 7 .. structural motif
    /// optional
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// adding more names for indexing
    /// optional
    /// typedef list< string > TAliases
    ///  Check whether the Aliases data member has been assigned a value.
    bool IsSetAliases(void) const;
    /// Check whether it is safe or not to call GetAliases method.
    bool CanGetAliases(void) const;
    void ResetAliases(void);
    const TAliases& GetAliases(void) const;
    TAliases& SetAliases(void);

    /// to validate mapping of sites
    /// optional
    /// typedef string TMotif
    ///  Check whether the Motif data member has been assigned a value.
    bool IsSetMotif(void) const;
    /// Check whether it is safe or not to call GetMotif method.
    bool CanGetMotif(void) const;
    void ResetMotif(void);
    const TMotif& GetMotif(void) const;
    void SetMotif(const TMotif& value);
    void SetMotif(TMotif&& value);
    TMotif& SetMotif(void);

    /// 0 for validation,
    /// 1 for motif somewhere in seqloc
    /// 2 for multiple motifs in seqloc
    /// optional
    /// typedef int TMotifuse
    ///  Check whether the Motifuse data member has been assigned a value.
    bool IsSetMotifuse(void) const;
    /// Check whether it is safe or not to call GetMotifuse method.
    bool CanGetMotifuse(void) const;
    void ResetMotifuse(void);
    TMotifuse GetMotifuse(void) const;
    void SetMotifuse(TMotifuse value);
    TMotifuse& SetMotifuse(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAlign_annot_Base(const CAlign_annot_Base&);
    CAlign_annot_Base& operator=(const CAlign_annot_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TLocation > m_Location;
    string m_Description;
    list< CRef< CFeature_evidence > > m_Evidence;
    int m_Type;
    list< string > m_Aliases;
    string m_Motif;
    int m_Motifuse;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAlign_annot_Base::IsSetLocation(void) const
{
    return m_Location.NotEmpty();
}

inline
bool CAlign_annot_Base::CanGetLocation(void) const
{
    return true;
}

inline
const CAlign_annot_Base::TLocation& CAlign_annot_Base::GetLocation(void) const
{
    if ( !m_Location ) {
        const_cast<CAlign_annot_Base*>(this)->ResetLocation();
    }
    return (*m_Location);
}

inline
CAlign_annot_Base::TLocation& CAlign_annot_Base::SetLocation(void)
{
    if ( !m_Location ) {
        ResetLocation();
    }
    return (*m_Location);
}

inline
bool CAlign_annot_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAlign_annot_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CAlign_annot_Base::TDescription& CAlign_annot_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(1);
    }
    return m_Description;
}

inline
void CAlign_annot_Base::SetDescription(const CAlign_annot_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0xc;
}

inline
void CAlign_annot_Base::SetDescription(CAlign_annot_Base::TDescription&& value)
{
    m_Description = std::forward<CAlign_annot_Base::TDescription>(value);
    m_set_State[0] |= 0xc;
}

inline
CAlign_annot_Base::TDescription& CAlign_annot_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Description;
}

inline
bool CAlign_annot_Base::IsSetEvidence(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAlign_annot_Base::CanGetEvidence(void) const
{
    return true;
}

inline
const CAlign_annot_Base::TEvidence& CAlign_annot_Base::GetEvidence(void) const
{
    return m_Evidence;
}

inline
CAlign_annot_Base::TEvidence& CAlign_annot_Base::SetEvidence(void)
{
    m_set_State[0] |= 0x10;
    return m_Evidence;
}

inline
bool CAlign_annot_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAlign_annot_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CAlign_annot_Base::ResetType(void)
{
    m_Type = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CAlign_annot_Base::TType CAlign_annot_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(3);
    }
    return m_Type;
}

inline
void CAlign_annot_Base::SetType(CAlign_annot_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc0;
}

inline
CAlign_annot_Base::TType& CAlign_annot_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Type;
}

inline
bool CAlign_annot_Base::IsSetAliases(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAlign_annot_Base::CanGetAliases(void) const
{
    return true;
}

inline
const CAlign_annot_Base::TAliases& CAlign_annot_Base::GetAliases(void) const
{
    return m_Aliases;
}

inline
CAlign_annot_Base::TAliases& CAlign_annot_Base::SetAliases(void)
{
    m_set_State[0] |= 0x100;
    return m_Aliases;
}

inline
bool CAlign_annot_Base::IsSetMotif(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAlign_annot_Base::CanGetMotif(void) const
{
    return IsSetMotif();
}

inline
const CAlign_annot_Base::TMotif& CAlign_annot_Base::GetMotif(void) const
{
    if (!CanGetMotif()) {
        ThrowUnassigned(5);
    }
    return m_Motif;
}

inline
void CAlign_annot_Base::SetMotif(const CAlign_annot_Base::TMotif& value)
{
    m_Motif = value;
    m_set_State[0] |= 0xc00;
}

inline
void CAlign_annot_Base::SetMotif(CAlign_annot_Base::TMotif&& value)
{
    m_Motif = std::forward<CAlign_annot_Base::TMotif>(value);
    m_set_State[0] |= 0xc00;
}

inline
CAlign_annot_Base::TMotif& CAlign_annot_Base::SetMotif(void)
{
#ifdef _DEBUG
    if (!IsSetMotif()) {
        m_Motif = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Motif;
}

inline
bool CAlign_annot_Base::IsSetMotifuse(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CAlign_annot_Base::CanGetMotifuse(void) const
{
    return IsSetMotifuse();
}

inline
void CAlign_annot_Base::ResetMotifuse(void)
{
    m_Motifuse = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CAlign_annot_Base::TMotifuse CAlign_annot_Base::GetMotifuse(void) const
{
    if (!CanGetMotifuse()) {
        ThrowUnassigned(6);
    }
    return m_Motifuse;
}

inline
void CAlign_annot_Base::SetMotifuse(CAlign_annot_Base::TMotifuse value)
{
    m_Motifuse = value;
    m_set_State[0] |= 0x3000;
}

inline
CAlign_annot_Base::TMotifuse& CAlign_annot_Base::SetMotifuse(void)
{
#ifdef _DEBUG
    if (!IsSetMotifuse()) {
        memset(&m_Motifuse,UnassignedByte(),sizeof(m_Motifuse));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Motifuse;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_ALIGN_ANNOT_BASE_HPP
