/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Algorithm_type_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_ALGORITHM_TYPE_BASE_HPP
#define OBJECTS_CDD_ALGORITHM_TYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_CDD_EXPORT CAlgorithm_type_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAlgorithm_type_Base(void);
    // destructor
    virtual ~CAlgorithm_type_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EScoring_Scheme {
        eScoring_Scheme_unassigned           =   0,
        eScoring_Scheme_percent_id           =   1,
        eScoring_Scheme_kimura_corrected     =   2,
        eScoring_Scheme_aligned_score        =   3,
        eScoring_Scheme_aligned_score_ext    =   4,
        eScoring_Scheme_aligned_score_filled =   5,
        eScoring_Scheme_blast_footprint      =   6,
        eScoring_Scheme_blast_full           =   7,
        eScoring_Scheme_hybrid_aligned_score =   8,
        eScoring_Scheme_other                = 255
    };
    
    /// Access to EScoring_Scheme's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EScoring_Scheme)(void);
    
    enum EClustering_Method {
        eClustering_Method_unassigned             =   0,
        eClustering_Method_single_linkage         =   1,
        eClustering_Method_neighbor_joining       =   2,
        eClustering_Method_fast_minimum_evolution =   3,
        eClustering_Method_other                  = 255
    };
    
    /// Access to EClustering_Method's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EClustering_Method)(void);
    
    enum EScore_Matrix {
        eScore_Matrix_unassigned =   0,
        eScore_Matrix_blosum45   =   1,
        eScore_Matrix_blosum62   =   2,
        eScore_Matrix_blosum80   =   3,
        eScore_Matrix_pam30      =   4,
        eScore_Matrix_pam70      =   5,
        eScore_Matrix_pam250     =   6,
        eScore_Matrix_other      = 255
    };
    
    /// Access to EScore_Matrix's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EScore_Matrix)(void);
    
    enum ETree_scope {
        eTree_scope_allDescendants        =   0,
        eTree_scope_immediateChildrenOnly =   1,
        eTree_scope_selfOnly              =   2,
        eTree_scope_other                 = 255
    };
    
    /// Access to ETree_scope's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ETree_scope)(void);
    
    enum EColoring_scope {
        eColoring_scope_allDescendants        =   0,
        eColoring_scope_immediateChildrenOnly =   1,
        eColoring_scope_other                 = 255
    };
    
    /// Access to EColoring_scope's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EColoring_scope)(void);
    
    // types
    typedef int TScoring_Scheme;
    typedef int TClustering_Method;
    typedef int TScore_Matrix;
    typedef int TGapOpen;
    typedef int TGapExtend;
    typedef int TGapScaleFactor;
    typedef int TNTerminalExt;
    typedef int TCTerminalExt;
    typedef int TTree_scope;
    typedef int TColoring_scope;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_scoring_Scheme,
        e_clustering_Method,
        e_score_Matrix,
        e_gapOpen,
        e_gapExtend,
        e_gapScaleFactor,
        e_nTerminalExt,
        e_cTerminalExt,
        e_tree_scope,
        e_coloring_scope
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TScoring_Scheme
    ///  Check whether the Scoring_Scheme data member has been assigned a value.
    bool IsSetScoring_Scheme(void) const;
    /// Check whether it is safe or not to call GetScoring_Scheme method.
    bool CanGetScoring_Scheme(void) const;
    void ResetScoring_Scheme(void);
    TScoring_Scheme GetScoring_Scheme(void) const;
    void SetScoring_Scheme(TScoring_Scheme value);
    TScoring_Scheme& SetScoring_Scheme(void);

    /// mandatory
    /// typedef int TClustering_Method
    ///  Check whether the Clustering_Method data member has been assigned a value.
    bool IsSetClustering_Method(void) const;
    /// Check whether it is safe or not to call GetClustering_Method method.
    bool CanGetClustering_Method(void) const;
    void ResetClustering_Method(void);
    TClustering_Method GetClustering_Method(void) const;
    void SetClustering_Method(TClustering_Method value);
    TClustering_Method& SetClustering_Method(void);

    /// optional
    /// typedef int TScore_Matrix
    ///  Check whether the Score_Matrix data member has been assigned a value.
    bool IsSetScore_Matrix(void) const;
    /// Check whether it is safe or not to call GetScore_Matrix method.
    bool CanGetScore_Matrix(void) const;
    void ResetScore_Matrix(void);
    TScore_Matrix GetScore_Matrix(void) const;
    void SetScore_Matrix(TScore_Matrix value);
    TScore_Matrix& SetScore_Matrix(void);

    /// optional
    /// typedef int TGapOpen
    ///  Check whether the GapOpen data member has been assigned a value.
    bool IsSetGapOpen(void) const;
    /// Check whether it is safe or not to call GetGapOpen method.
    bool CanGetGapOpen(void) const;
    void ResetGapOpen(void);
    TGapOpen GetGapOpen(void) const;
    void SetGapOpen(TGapOpen value);
    TGapOpen& SetGapOpen(void);

    /// optional
    /// typedef int TGapExtend
    ///  Check whether the GapExtend data member has been assigned a value.
    bool IsSetGapExtend(void) const;
    /// Check whether it is safe or not to call GetGapExtend method.
    bool CanGetGapExtend(void) const;
    void ResetGapExtend(void);
    TGapExtend GetGapExtend(void) const;
    void SetGapExtend(TGapExtend value);
    TGapExtend& SetGapExtend(void);

    /// optional
    /// typedef int TGapScaleFactor
    ///  Check whether the GapScaleFactor data member has been assigned a value.
    bool IsSetGapScaleFactor(void) const;
    /// Check whether it is safe or not to call GetGapScaleFactor method.
    bool CanGetGapScaleFactor(void) const;
    void ResetGapScaleFactor(void);
    TGapScaleFactor GetGapScaleFactor(void) const;
    void SetGapScaleFactor(TGapScaleFactor value);
    TGapScaleFactor& SetGapScaleFactor(void);

    /// optional
    /// typedef int TNTerminalExt
    ///  Check whether the NTerminalExt data member has been assigned a value.
    bool IsSetNTerminalExt(void) const;
    /// Check whether it is safe or not to call GetNTerminalExt method.
    bool CanGetNTerminalExt(void) const;
    void ResetNTerminalExt(void);
    TNTerminalExt GetNTerminalExt(void) const;
    void SetNTerminalExt(TNTerminalExt value);
    TNTerminalExt& SetNTerminalExt(void);

    /// optional
    /// typedef int TCTerminalExt
    ///  Check whether the CTerminalExt data member has been assigned a value.
    bool IsSetCTerminalExt(void) const;
    /// Check whether it is safe or not to call GetCTerminalExt method.
    bool CanGetCTerminalExt(void) const;
    void ResetCTerminalExt(void);
    TCTerminalExt GetCTerminalExt(void) const;
    void SetCTerminalExt(TCTerminalExt value);
    TCTerminalExt& SetCTerminalExt(void);

    /// optional
    /// typedef int TTree_scope
    ///  Check whether the Tree_scope data member has been assigned a value.
    bool IsSetTree_scope(void) const;
    /// Check whether it is safe or not to call GetTree_scope method.
    bool CanGetTree_scope(void) const;
    void ResetTree_scope(void);
    TTree_scope GetTree_scope(void) const;
    void SetTree_scope(TTree_scope value);
    TTree_scope& SetTree_scope(void);

    /// optional
    /// typedef int TColoring_scope
    ///  Check whether the Coloring_scope data member has been assigned a value.
    bool IsSetColoring_scope(void) const;
    /// Check whether it is safe or not to call GetColoring_scope method.
    bool CanGetColoring_scope(void) const;
    void ResetColoring_scope(void);
    TColoring_scope GetColoring_scope(void) const;
    void SetColoring_scope(TColoring_scope value);
    TColoring_scope& SetColoring_scope(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAlgorithm_type_Base(const CAlgorithm_type_Base&);
    CAlgorithm_type_Base& operator=(const CAlgorithm_type_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Scoring_Scheme;
    int m_Clustering_Method;
    int m_Score_Matrix;
    int m_GapOpen;
    int m_GapExtend;
    int m_GapScaleFactor;
    int m_NTerminalExt;
    int m_CTerminalExt;
    int m_Tree_scope;
    int m_Coloring_scope;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAlgorithm_type_Base::IsSetScoring_Scheme(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetScoring_Scheme(void) const
{
    return IsSetScoring_Scheme();
}

inline
void CAlgorithm_type_Base::ResetScoring_Scheme(void)
{
    m_Scoring_Scheme = (EScoring_Scheme)(0);
    m_set_State[0] &= ~0x3;
}

inline
CAlgorithm_type_Base::TScoring_Scheme CAlgorithm_type_Base::GetScoring_Scheme(void) const
{
    if (!CanGetScoring_Scheme()) {
        ThrowUnassigned(0);
    }
    return m_Scoring_Scheme;
}

inline
void CAlgorithm_type_Base::SetScoring_Scheme(CAlgorithm_type_Base::TScoring_Scheme value)
{
    m_Scoring_Scheme = value;
    m_set_State[0] |= 0x3;
}

inline
CAlgorithm_type_Base::TScoring_Scheme& CAlgorithm_type_Base::SetScoring_Scheme(void)
{
#ifdef _DEBUG
    if (!IsSetScoring_Scheme()) {
        memset(&m_Scoring_Scheme,UnassignedByte(),sizeof(m_Scoring_Scheme));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Scoring_Scheme;
}

inline
bool CAlgorithm_type_Base::IsSetClustering_Method(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetClustering_Method(void) const
{
    return IsSetClustering_Method();
}

inline
void CAlgorithm_type_Base::ResetClustering_Method(void)
{
    m_Clustering_Method = (EClustering_Method)(0);
    m_set_State[0] &= ~0xc;
}

inline
CAlgorithm_type_Base::TClustering_Method CAlgorithm_type_Base::GetClustering_Method(void) const
{
    if (!CanGetClustering_Method()) {
        ThrowUnassigned(1);
    }
    return m_Clustering_Method;
}

inline
void CAlgorithm_type_Base::SetClustering_Method(CAlgorithm_type_Base::TClustering_Method value)
{
    m_Clustering_Method = value;
    m_set_State[0] |= 0xc;
}

inline
CAlgorithm_type_Base::TClustering_Method& CAlgorithm_type_Base::SetClustering_Method(void)
{
#ifdef _DEBUG
    if (!IsSetClustering_Method()) {
        memset(&m_Clustering_Method,UnassignedByte(),sizeof(m_Clustering_Method));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Clustering_Method;
}

inline
bool CAlgorithm_type_Base::IsSetScore_Matrix(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetScore_Matrix(void) const
{
    return IsSetScore_Matrix();
}

inline
void CAlgorithm_type_Base::ResetScore_Matrix(void)
{
    m_Score_Matrix = (EScore_Matrix)(0);
    m_set_State[0] &= ~0x30;
}

inline
CAlgorithm_type_Base::TScore_Matrix CAlgorithm_type_Base::GetScore_Matrix(void) const
{
    if (!CanGetScore_Matrix()) {
        ThrowUnassigned(2);
    }
    return m_Score_Matrix;
}

inline
void CAlgorithm_type_Base::SetScore_Matrix(CAlgorithm_type_Base::TScore_Matrix value)
{
    m_Score_Matrix = value;
    m_set_State[0] |= 0x30;
}

inline
CAlgorithm_type_Base::TScore_Matrix& CAlgorithm_type_Base::SetScore_Matrix(void)
{
#ifdef _DEBUG
    if (!IsSetScore_Matrix()) {
        memset(&m_Score_Matrix,UnassignedByte(),sizeof(m_Score_Matrix));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Score_Matrix;
}

inline
bool CAlgorithm_type_Base::IsSetGapOpen(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetGapOpen(void) const
{
    return IsSetGapOpen();
}

inline
void CAlgorithm_type_Base::ResetGapOpen(void)
{
    m_GapOpen = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CAlgorithm_type_Base::TGapOpen CAlgorithm_type_Base::GetGapOpen(void) const
{
    if (!CanGetGapOpen()) {
        ThrowUnassigned(3);
    }
    return m_GapOpen;
}

inline
void CAlgorithm_type_Base::SetGapOpen(CAlgorithm_type_Base::TGapOpen value)
{
    m_GapOpen = value;
    m_set_State[0] |= 0xc0;
}

inline
CAlgorithm_type_Base::TGapOpen& CAlgorithm_type_Base::SetGapOpen(void)
{
#ifdef _DEBUG
    if (!IsSetGapOpen()) {
        memset(&m_GapOpen,UnassignedByte(),sizeof(m_GapOpen));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_GapOpen;
}

inline
bool CAlgorithm_type_Base::IsSetGapExtend(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetGapExtend(void) const
{
    return IsSetGapExtend();
}

inline
void CAlgorithm_type_Base::ResetGapExtend(void)
{
    m_GapExtend = 0;
    m_set_State[0] &= ~0x300;
}

inline
CAlgorithm_type_Base::TGapExtend CAlgorithm_type_Base::GetGapExtend(void) const
{
    if (!CanGetGapExtend()) {
        ThrowUnassigned(4);
    }
    return m_GapExtend;
}

inline
void CAlgorithm_type_Base::SetGapExtend(CAlgorithm_type_Base::TGapExtend value)
{
    m_GapExtend = value;
    m_set_State[0] |= 0x300;
}

inline
CAlgorithm_type_Base::TGapExtend& CAlgorithm_type_Base::SetGapExtend(void)
{
#ifdef _DEBUG
    if (!IsSetGapExtend()) {
        memset(&m_GapExtend,UnassignedByte(),sizeof(m_GapExtend));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_GapExtend;
}

inline
bool CAlgorithm_type_Base::IsSetGapScaleFactor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetGapScaleFactor(void) const
{
    return IsSetGapScaleFactor();
}

inline
void CAlgorithm_type_Base::ResetGapScaleFactor(void)
{
    m_GapScaleFactor = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CAlgorithm_type_Base::TGapScaleFactor CAlgorithm_type_Base::GetGapScaleFactor(void) const
{
    if (!CanGetGapScaleFactor()) {
        ThrowUnassigned(5);
    }
    return m_GapScaleFactor;
}

inline
void CAlgorithm_type_Base::SetGapScaleFactor(CAlgorithm_type_Base::TGapScaleFactor value)
{
    m_GapScaleFactor = value;
    m_set_State[0] |= 0xc00;
}

inline
CAlgorithm_type_Base::TGapScaleFactor& CAlgorithm_type_Base::SetGapScaleFactor(void)
{
#ifdef _DEBUG
    if (!IsSetGapScaleFactor()) {
        memset(&m_GapScaleFactor,UnassignedByte(),sizeof(m_GapScaleFactor));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_GapScaleFactor;
}

inline
bool CAlgorithm_type_Base::IsSetNTerminalExt(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetNTerminalExt(void) const
{
    return IsSetNTerminalExt();
}

inline
void CAlgorithm_type_Base::ResetNTerminalExt(void)
{
    m_NTerminalExt = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CAlgorithm_type_Base::TNTerminalExt CAlgorithm_type_Base::GetNTerminalExt(void) const
{
    if (!CanGetNTerminalExt()) {
        ThrowUnassigned(6);
    }
    return m_NTerminalExt;
}

inline
void CAlgorithm_type_Base::SetNTerminalExt(CAlgorithm_type_Base::TNTerminalExt value)
{
    m_NTerminalExt = value;
    m_set_State[0] |= 0x3000;
}

inline
CAlgorithm_type_Base::TNTerminalExt& CAlgorithm_type_Base::SetNTerminalExt(void)
{
#ifdef _DEBUG
    if (!IsSetNTerminalExt()) {
        memset(&m_NTerminalExt,UnassignedByte(),sizeof(m_NTerminalExt));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_NTerminalExt;
}

inline
bool CAlgorithm_type_Base::IsSetCTerminalExt(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetCTerminalExt(void) const
{
    return IsSetCTerminalExt();
}

inline
void CAlgorithm_type_Base::ResetCTerminalExt(void)
{
    m_CTerminalExt = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CAlgorithm_type_Base::TCTerminalExt CAlgorithm_type_Base::GetCTerminalExt(void) const
{
    if (!CanGetCTerminalExt()) {
        ThrowUnassigned(7);
    }
    return m_CTerminalExt;
}

inline
void CAlgorithm_type_Base::SetCTerminalExt(CAlgorithm_type_Base::TCTerminalExt value)
{
    m_CTerminalExt = value;
    m_set_State[0] |= 0xc000;
}

inline
CAlgorithm_type_Base::TCTerminalExt& CAlgorithm_type_Base::SetCTerminalExt(void)
{
#ifdef _DEBUG
    if (!IsSetCTerminalExt()) {
        memset(&m_CTerminalExt,UnassignedByte(),sizeof(m_CTerminalExt));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_CTerminalExt;
}

inline
bool CAlgorithm_type_Base::IsSetTree_scope(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetTree_scope(void) const
{
    return IsSetTree_scope();
}

inline
void CAlgorithm_type_Base::ResetTree_scope(void)
{
    m_Tree_scope = (ETree_scope)(0);
    m_set_State[0] &= ~0x30000;
}

inline
CAlgorithm_type_Base::TTree_scope CAlgorithm_type_Base::GetTree_scope(void) const
{
    if (!CanGetTree_scope()) {
        ThrowUnassigned(8);
    }
    return m_Tree_scope;
}

inline
void CAlgorithm_type_Base::SetTree_scope(CAlgorithm_type_Base::TTree_scope value)
{
    m_Tree_scope = value;
    m_set_State[0] |= 0x30000;
}

inline
CAlgorithm_type_Base::TTree_scope& CAlgorithm_type_Base::SetTree_scope(void)
{
#ifdef _DEBUG
    if (!IsSetTree_scope()) {
        memset(&m_Tree_scope,UnassignedByte(),sizeof(m_Tree_scope));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Tree_scope;
}

inline
bool CAlgorithm_type_Base::IsSetColoring_scope(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CAlgorithm_type_Base::CanGetColoring_scope(void) const
{
    return IsSetColoring_scope();
}

inline
void CAlgorithm_type_Base::ResetColoring_scope(void)
{
    m_Coloring_scope = (EColoring_scope)(0);
    m_set_State[0] &= ~0xc0000;
}

inline
CAlgorithm_type_Base::TColoring_scope CAlgorithm_type_Base::GetColoring_scope(void) const
{
    if (!CanGetColoring_scope()) {
        ThrowUnassigned(9);
    }
    return m_Coloring_scope;
}

inline
void CAlgorithm_type_Base::SetColoring_scope(CAlgorithm_type_Base::TColoring_scope value)
{
    m_Coloring_scope = value;
    m_set_State[0] |= 0xc0000;
}

inline
CAlgorithm_type_Base::TColoring_scope& CAlgorithm_type_Base::SetColoring_scope(void)
{
#ifdef _DEBUG
    if (!IsSetColoring_scope()) {
        memset(&m_Coloring_scope,UnassignedByte(),sizeof(m_Coloring_scope));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Coloring_scope;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_ALGORITHM_TYPE_BASE_HPP
