/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BlastOutput2_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastxml2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTXML2_BLASTOUTPUT2_BASE_HPP
#define OBJECTS_BLASTXML2_BLASTOUTPUT2_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_blastxml2_SCOPE
#  define BEGIN_blastxml2_SCOPE BEGIN_SCOPE(blastxml2)
#  define END_blastxml2_SCOPE END_SCOPE(blastxml2)
#endif
BEGIN_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::


// forward declarations
class CErr;
class CReport;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTXML2_EXPORT CBlastOutput2_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlastOutput2_Base(void);
    // destructor
    virtual ~CBlastOutput2_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CReport TReport;
    typedef CErr TError;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_report,
        e_error
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CReport TReport
    ///  Check whether the Report data member has been assigned a value.
    bool IsSetReport(void) const;
    /// Check whether it is safe or not to call GetReport method.
    bool CanGetReport(void) const;
    void ResetReport(void);
    const TReport& GetReport(void) const;
    void SetReport(TReport& value);
    TReport& SetReport(void);

    /// optional
    /// typedef CErr TError
    ///  Check whether the Error data member has been assigned a value.
    bool IsSetError(void) const;
    /// Check whether it is safe or not to call GetError method.
    bool CanGetError(void) const;
    void ResetError(void);
    const TError& GetError(void) const;
    void SetError(TError& value);
    TError& SetError(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlastOutput2_Base(const CBlastOutput2_Base&);
    CBlastOutput2_Base& operator=(const CBlastOutput2_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TReport > m_Report;
    CRef< TError > m_Error;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlastOutput2_Base::IsSetReport(void) const
{
    return m_Report.NotEmpty();
}

inline
bool CBlastOutput2_Base::CanGetReport(void) const
{
    return IsSetReport();
}

inline
const CBlastOutput2_Base::TReport& CBlastOutput2_Base::GetReport(void) const
{
    if (!CanGetReport()) {
        ThrowUnassigned(0);
    }
    return (*m_Report);
}

inline
bool CBlastOutput2_Base::IsSetError(void) const
{
    return m_Error.NotEmpty();
}

inline
bool CBlastOutput2_Base::CanGetError(void) const
{
    return IsSetError();
}

inline
const CBlastOutput2_Base::TError& CBlastOutput2_Base::GetError(void) const
{
    if (!CanGetError()) {
        ThrowUnassigned(1);
    }
    return (*m_Error);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTXML2_BLASTOUTPUT2_BASE_HPP
