/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_range_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_RANGE_BASE_HPP
#define OBJECTS_BLAST_BLAST4_RANGE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Range on a sequence - zero offset
class NCBI_BLAST_EXPORT CBlast4_range_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_range_Base(void);
    // destructor
    virtual ~CBlast4_range_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TStart;
    typedef int TEnd;
    typedef int TStrand;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_start,
        e_end,
        e_strand
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int TStart
    ///  Check whether the Start data member has been assigned a value.
    bool IsSetStart(void) const;
    /// Check whether it is safe or not to call GetStart method.
    bool CanGetStart(void) const;
    void ResetStart(void);
    TStart GetStart(void) const;
    void SetStart(TStart value);
    TStart& SetStart(void);

    /// optional
    /// typedef int TEnd
    ///  Check whether the End data member has been assigned a value.
    bool IsSetEnd(void) const;
    /// Check whether it is safe or not to call GetEnd method.
    bool CanGetEnd(void) const;
    void ResetEnd(void);
    TEnd GetEnd(void) const;
    void SetEnd(TEnd value);
    TEnd& SetEnd(void);

    /// The frame of the range (absent for proteins; -1/1 for nucleotides;
    /// -1,-2,-3,1,2,3 for translated sequences)
    /// optional
    /// typedef int TStrand
    ///  Check whether the Strand data member has been assigned a value.
    bool IsSetStrand(void) const;
    /// Check whether it is safe or not to call GetStrand method.
    bool CanGetStrand(void) const;
    void ResetStrand(void);
    TStrand GetStrand(void) const;
    void SetStrand(TStrand value);
    TStrand& SetStrand(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_range_Base(const CBlast4_range_Base&);
    CBlast4_range_Base& operator=(const CBlast4_range_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Start;
    int m_End;
    int m_Strand;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_range_Base::IsSetStart(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_range_Base::CanGetStart(void) const
{
    return IsSetStart();
}

inline
void CBlast4_range_Base::ResetStart(void)
{
    m_Start = 0;
    m_set_State[0] &= ~0x3;
}

inline
CBlast4_range_Base::TStart CBlast4_range_Base::GetStart(void) const
{
    if (!CanGetStart()) {
        ThrowUnassigned(0);
    }
    return m_Start;
}

inline
void CBlast4_range_Base::SetStart(CBlast4_range_Base::TStart value)
{
    m_Start = value;
    m_set_State[0] |= 0x3;
}

inline
CBlast4_range_Base::TStart& CBlast4_range_Base::SetStart(void)
{
#ifdef _DEBUG
    if (!IsSetStart()) {
        memset(&m_Start,UnassignedByte(),sizeof(m_Start));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Start;
}

inline
bool CBlast4_range_Base::IsSetEnd(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_range_Base::CanGetEnd(void) const
{
    return IsSetEnd();
}

inline
void CBlast4_range_Base::ResetEnd(void)
{
    m_End = 0;
    m_set_State[0] &= ~0xc;
}

inline
CBlast4_range_Base::TEnd CBlast4_range_Base::GetEnd(void) const
{
    if (!CanGetEnd()) {
        ThrowUnassigned(1);
    }
    return m_End;
}

inline
void CBlast4_range_Base::SetEnd(CBlast4_range_Base::TEnd value)
{
    m_End = value;
    m_set_State[0] |= 0xc;
}

inline
CBlast4_range_Base::TEnd& CBlast4_range_Base::SetEnd(void)
{
#ifdef _DEBUG
    if (!IsSetEnd()) {
        memset(&m_End,UnassignedByte(),sizeof(m_End));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_End;
}

inline
bool CBlast4_range_Base::IsSetStrand(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast4_range_Base::CanGetStrand(void) const
{
    return IsSetStrand();
}

inline
void CBlast4_range_Base::ResetStrand(void)
{
    m_Strand = 0;
    m_set_State[0] &= ~0x30;
}

inline
CBlast4_range_Base::TStrand CBlast4_range_Base::GetStrand(void) const
{
    if (!CanGetStrand()) {
        ThrowUnassigned(2);
    }
    return m_Strand;
}

inline
void CBlast4_range_Base::SetStrand(CBlast4_range_Base::TStrand value)
{
    m_Strand = value;
    m_set_State[0] |= 0x30;
}

inline
CBlast4_range_Base::TStrand& CBlast4_range_Base::SetStrand(void)
{
#ifdef _DEBUG
    if (!IsSetStrand()) {
        memset(&m_Strand,UnassignedByte(),sizeof(m_Strand));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Strand;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_RANGE_BASE_HPP
