/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_cutoff_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_CUTOFF_BASE_HPP
#define OBJECTS_BLAST_BLAST4_CUTOFF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///  
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///  Other types in alphabetical order
///
///  
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
///
class NCBI_BLAST_EXPORT CBlast4_cutoff_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_cutoff_Base(void);
    // destructor
    virtual ~CBlast4_cutoff_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_E_value,
        e_Raw_score
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 3 ///< == e_Raw_score+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef double TE_value;
    typedef int TRaw_score;

    // getters
    // setters

    // typedef double TE_value
    bool IsE_value(void) const;
    TE_value GetE_value(void) const;
    TE_value& SetE_value(void);
    void SetE_value(TE_value value);

    // typedef int TRaw_score
    bool IsRaw_score(void) const;
    TRaw_score GetRaw_score(void) const;
    TRaw_score& SetRaw_score(void);
    void SetRaw_score(TRaw_score value);


private:
    // copy constructor and assignment operator
    CBlast4_cutoff_Base(const CBlast4_cutoff_Base& );
    CBlast4_cutoff_Base& operator=(const CBlast4_cutoff_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TE_value m_E_value;
        TRaw_score m_Raw_score;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CBlast4_cutoff_Base::E_Choice CBlast4_cutoff_Base::Which(void) const
{
    return m_choice;
}

inline
void CBlast4_cutoff_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBlast4_cutoff_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBlast4_cutoff_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBlast4_cutoff_Base::IsE_value(void) const
{
    return m_choice == e_E_value;
}

inline
CBlast4_cutoff_Base::TE_value CBlast4_cutoff_Base::GetE_value(void) const
{
    CheckSelected(e_E_value);
    return m_E_value;
}

inline
CBlast4_cutoff_Base::TE_value& CBlast4_cutoff_Base::SetE_value(void)
{
    Select(e_E_value, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_E_value;
}

inline
void CBlast4_cutoff_Base::SetE_value(CBlast4_cutoff_Base::TE_value value)
{
    Select(e_E_value, NCBI_NS_NCBI::eDoNotResetVariant);
    m_E_value = value;
}

inline
bool CBlast4_cutoff_Base::IsRaw_score(void) const
{
    return m_choice == e_Raw_score;
}

inline
CBlast4_cutoff_Base::TRaw_score CBlast4_cutoff_Base::GetRaw_score(void) const
{
    CheckSelected(e_Raw_score);
    return m_Raw_score;
}

inline
CBlast4_cutoff_Base::TRaw_score& CBlast4_cutoff_Base::SetRaw_score(void)
{
    Select(e_Raw_score, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Raw_score;
}

inline
void CBlast4_cutoff_Base::SetRaw_score(CBlast4_cutoff_Base::TRaw_score value)
{
    Select(e_Raw_score, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Raw_score = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_CUTOFF_BASE_HPP
