/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blas_get_searc_resul_reply_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAS_GET_SEARC_RESUL_REPLY_BASE_HPP
#define OBJECTS_BLAST_BLAS_GET_SEARC_RESUL_REPLY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast4_ka_block;
class CBlast4_mask;
class CBlast4_phi_alignments;
class CBlast4_simple_results;
class CPssmWithParameters;
class CSeq_align_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_get_search_results_reply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_get_search_results_reply_Base(void);
    // destructor
    virtual ~CBlast4_get_search_results_reply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_align_set TAlignments;
    typedef CBlast4_phi_alignments TPhi_alignments;
    typedef list< CRef< CBlast4_mask > > TMasks;
    typedef list< CRef< CBlast4_ka_block > > TKa_blocks;
    typedef list< string > TSearch_stats;
    typedef CPssmWithParameters TPssm;
    typedef CBlast4_simple_results TSimple_results;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_alignments,
        e_phi_alignments,
        e_masks,
        e_ka_blocks,
        e_search_stats,
        e_pssm,
        e_simple_results
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CSeq_align_set TAlignments
    ///  Check whether the Alignments data member has been assigned a value.
    bool IsSetAlignments(void) const;
    /// Check whether it is safe or not to call GetAlignments method.
    bool CanGetAlignments(void) const;
    void ResetAlignments(void);
    const TAlignments& GetAlignments(void) const;
    void SetAlignments(TAlignments& value);
    TAlignments& SetAlignments(void);

    /// optional
    /// typedef CBlast4_phi_alignments TPhi_alignments
    ///  Check whether the Phi_alignments data member has been assigned a value.
    bool IsSetPhi_alignments(void) const;
    /// Check whether it is safe or not to call GetPhi_alignments method.
    bool CanGetPhi_alignments(void) const;
    void ResetPhi_alignments(void);
    const TPhi_alignments& GetPhi_alignments(void) const;
    void SetPhi_alignments(TPhi_alignments& value);
    TPhi_alignments& SetPhi_alignments(void);

    /// Masking locations for the query sequence(s). Each element of this set
    /// corresponds to a single query's translation frame as appropriate.
    /// optional
    /// typedef list< CRef< CBlast4_mask > > TMasks
    ///  Check whether the Masks data member has been assigned a value.
    bool IsSetMasks(void) const;
    /// Check whether it is safe or not to call GetMasks method.
    bool CanGetMasks(void) const;
    void ResetMasks(void);
    const TMasks& GetMasks(void) const;
    TMasks& SetMasks(void);

    /// optional
    /// typedef list< CRef< CBlast4_ka_block > > TKa_blocks
    ///  Check whether the Ka_blocks data member has been assigned a value.
    bool IsSetKa_blocks(void) const;
    /// Check whether it is safe or not to call GetKa_blocks method.
    bool CanGetKa_blocks(void) const;
    void ResetKa_blocks(void);
    const TKa_blocks& GetKa_blocks(void) const;
    TKa_blocks& SetKa_blocks(void);

    /// optional
    /// typedef list< string > TSearch_stats
    ///  Check whether the Search_stats data member has been assigned a value.
    bool IsSetSearch_stats(void) const;
    /// Check whether it is safe or not to call GetSearch_stats method.
    bool CanGetSearch_stats(void) const;
    void ResetSearch_stats(void);
    const TSearch_stats& GetSearch_stats(void) const;
    TSearch_stats& SetSearch_stats(void);

    /// optional
    /// typedef CPssmWithParameters TPssm
    ///  Check whether the Pssm data member has been assigned a value.
    bool IsSetPssm(void) const;
    /// Check whether it is safe or not to call GetPssm method.
    bool CanGetPssm(void) const;
    void ResetPssm(void);
    const TPssm& GetPssm(void) const;
    void SetPssm(TPssm& value);
    TPssm& SetPssm(void);

    /// optional
    /// typedef CBlast4_simple_results TSimple_results
    ///  Check whether the Simple_results data member has been assigned a value.
    bool IsSetSimple_results(void) const;
    /// Check whether it is safe or not to call GetSimple_results method.
    bool CanGetSimple_results(void) const;
    void ResetSimple_results(void);
    const TSimple_results& GetSimple_results(void) const;
    void SetSimple_results(TSimple_results& value);
    TSimple_results& SetSimple_results(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_get_search_results_reply_Base(const CBlast4_get_search_results_reply_Base&);
    CBlast4_get_search_results_reply_Base& operator=(const CBlast4_get_search_results_reply_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAlignments > m_Alignments;
    CRef< TPhi_alignments > m_Phi_alignments;
    list< CRef< CBlast4_mask > > m_Masks;
    list< CRef< CBlast4_ka_block > > m_Ka_blocks;
    list< string > m_Search_stats;
    CRef< TPssm > m_Pssm;
    CRef< TSimple_results > m_Simple_results;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_get_search_results_reply_Base::IsSetAlignments(void) const
{
    return m_Alignments.NotEmpty();
}

inline
bool CBlast4_get_search_results_reply_Base::CanGetAlignments(void) const
{
    return IsSetAlignments();
}

inline
const CBlast4_get_search_results_reply_Base::TAlignments& CBlast4_get_search_results_reply_Base::GetAlignments(void) const
{
    if (!CanGetAlignments()) {
        ThrowUnassigned(0);
    }
    return (*m_Alignments);
}

inline
bool CBlast4_get_search_results_reply_Base::IsSetPhi_alignments(void) const
{
    return m_Phi_alignments.NotEmpty();
}

inline
bool CBlast4_get_search_results_reply_Base::CanGetPhi_alignments(void) const
{
    return IsSetPhi_alignments();
}

inline
const CBlast4_get_search_results_reply_Base::TPhi_alignments& CBlast4_get_search_results_reply_Base::GetPhi_alignments(void) const
{
    if (!CanGetPhi_alignments()) {
        ThrowUnassigned(1);
    }
    return (*m_Phi_alignments);
}

inline
bool CBlast4_get_search_results_reply_Base::IsSetMasks(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast4_get_search_results_reply_Base::CanGetMasks(void) const
{
    return true;
}

inline
const CBlast4_get_search_results_reply_Base::TMasks& CBlast4_get_search_results_reply_Base::GetMasks(void) const
{
    return m_Masks;
}

inline
CBlast4_get_search_results_reply_Base::TMasks& CBlast4_get_search_results_reply_Base::SetMasks(void)
{
    m_set_State[0] |= 0x10;
    return m_Masks;
}

inline
bool CBlast4_get_search_results_reply_Base::IsSetKa_blocks(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBlast4_get_search_results_reply_Base::CanGetKa_blocks(void) const
{
    return true;
}

inline
const CBlast4_get_search_results_reply_Base::TKa_blocks& CBlast4_get_search_results_reply_Base::GetKa_blocks(void) const
{
    return m_Ka_blocks;
}

inline
CBlast4_get_search_results_reply_Base::TKa_blocks& CBlast4_get_search_results_reply_Base::SetKa_blocks(void)
{
    m_set_State[0] |= 0x40;
    return m_Ka_blocks;
}

inline
bool CBlast4_get_search_results_reply_Base::IsSetSearch_stats(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBlast4_get_search_results_reply_Base::CanGetSearch_stats(void) const
{
    return true;
}

inline
const CBlast4_get_search_results_reply_Base::TSearch_stats& CBlast4_get_search_results_reply_Base::GetSearch_stats(void) const
{
    return m_Search_stats;
}

inline
CBlast4_get_search_results_reply_Base::TSearch_stats& CBlast4_get_search_results_reply_Base::SetSearch_stats(void)
{
    m_set_State[0] |= 0x100;
    return m_Search_stats;
}

inline
bool CBlast4_get_search_results_reply_Base::IsSetPssm(void) const
{
    return m_Pssm.NotEmpty();
}

inline
bool CBlast4_get_search_results_reply_Base::CanGetPssm(void) const
{
    return IsSetPssm();
}

inline
const CBlast4_get_search_results_reply_Base::TPssm& CBlast4_get_search_results_reply_Base::GetPssm(void) const
{
    if (!CanGetPssm()) {
        ThrowUnassigned(5);
    }
    return (*m_Pssm);
}

inline
bool CBlast4_get_search_results_reply_Base::IsSetSimple_results(void) const
{
    return m_Simple_results.NotEmpty();
}

inline
bool CBlast4_get_search_results_reply_Base::CanGetSimple_results(void) const
{
    return IsSetSimple_results();
}

inline
const CBlast4_get_search_results_reply_Base::TSimple_results& CBlast4_get_search_results_reply_Base::GetSimple_results(void) const
{
    if (!CanGetSimple_results()) {
        ThrowUnassigned(6);
    }
    return (*m_Simple_results);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAS_GET_SEARC_RESUL_REPLY_BASE_HPP
