/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Node_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biotree.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIOTREE_NODE_BASE_HPP
#define OBJECTS_BIOTREE_NODE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CNodeFeatureSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BIOTREE_EXPORT CNode_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CNode_Base(void);
    // destructor
    virtual ~CNode_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TId;
    typedef int TParent;
    typedef CNodeFeatureSet TFeatures;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_parent,
        e_features
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// node uid
    /// mandatory
    /// typedef int TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    TId GetId(void) const;
    void SetId(TId value);
    TId& SetId(void);

    /// parent node id
    /// optional
    /// typedef int TParent
    ///  Check whether the Parent data member has been assigned a value.
    bool IsSetParent(void) const;
    /// Check whether it is safe or not to call GetParent method.
    bool CanGetParent(void) const;
    void ResetParent(void);
    TParent GetParent(void) const;
    void SetParent(TParent value);
    TParent& SetParent(void);

    /// optional
    /// typedef CNodeFeatureSet TFeatures
    ///  Check whether the Features data member has been assigned a value.
    bool IsSetFeatures(void) const;
    /// Check whether it is safe or not to call GetFeatures method.
    bool CanGetFeatures(void) const;
    void ResetFeatures(void);
    const TFeatures& GetFeatures(void) const;
    void SetFeatures(TFeatures& value);
    TFeatures& SetFeatures(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CNode_Base(const CNode_Base&);
    CNode_Base& operator=(const CNode_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Id;
    int m_Parent;
    CRef< TFeatures > m_Features;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CNode_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CNode_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CNode_Base::ResetId(void)
{
    m_Id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CNode_Base::TId CNode_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CNode_Base::SetId(CNode_Base::TId value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CNode_Base::TId& CNode_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        memset(&m_Id,UnassignedByte(),sizeof(m_Id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CNode_Base::IsSetParent(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CNode_Base::CanGetParent(void) const
{
    return IsSetParent();
}

inline
void CNode_Base::ResetParent(void)
{
    m_Parent = 0;
    m_set_State[0] &= ~0xc;
}

inline
CNode_Base::TParent CNode_Base::GetParent(void) const
{
    if (!CanGetParent()) {
        ThrowUnassigned(1);
    }
    return m_Parent;
}

inline
void CNode_Base::SetParent(CNode_Base::TParent value)
{
    m_Parent = value;
    m_set_State[0] |= 0xc;
}

inline
CNode_Base::TParent& CNode_Base::SetParent(void)
{
#ifdef _DEBUG
    if (!IsSetParent()) {
        memset(&m_Parent,UnassignedByte(),sizeof(m_Parent));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Parent;
}

inline
bool CNode_Base::IsSetFeatures(void) const
{
    return m_Features.NotEmpty();
}

inline
bool CNode_Base::CanGetFeatures(void) const
{
    return IsSetFeatures();
}

inline
const CNode_Base::TFeatures& CNode_Base::GetFeatures(void) const
{
    if (!CanGetFeatures()) {
        ThrowUnassigned(2);
    }
    return (*m_Features);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIOTREE_NODE_BASE_HPP
