/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file NodeFeature_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biotree.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIOTREE_NODEFEATURE_BASE_HPP
#define OBJECTS_BIOTREE_NODEFEATURE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BIOTREE_EXPORT CNodeFeature_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CNodeFeature_Base(void);
    // destructor
    virtual ~CNodeFeature_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TFeatureid;
    typedef CStringUTF8 TValue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_featureid,
        e_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TFeatureid
    ///  Check whether the Featureid data member has been assigned a value.
    bool IsSetFeatureid(void) const;
    /// Check whether it is safe or not to call GetFeatureid method.
    bool CanGetFeatureid(void) const;
    void ResetFeatureid(void);
    TFeatureid GetFeatureid(void) const;
    void SetFeatureid(TFeatureid value);
    TFeatureid& SetFeatureid(void);

    /// mandatory
    /// typedef CStringUTF8 TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(const TValue& value);
    void SetValue(TValue&& value);
    TValue& SetValue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CNodeFeature_Base(const CNodeFeature_Base&);
    CNodeFeature_Base& operator=(const CNodeFeature_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Featureid;
    CStringUTF8 m_Value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CNodeFeature_Base::IsSetFeatureid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CNodeFeature_Base::CanGetFeatureid(void) const
{
    return IsSetFeatureid();
}

inline
void CNodeFeature_Base::ResetFeatureid(void)
{
    m_Featureid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CNodeFeature_Base::TFeatureid CNodeFeature_Base::GetFeatureid(void) const
{
    if (!CanGetFeatureid()) {
        ThrowUnassigned(0);
    }
    return m_Featureid;
}

inline
void CNodeFeature_Base::SetFeatureid(CNodeFeature_Base::TFeatureid value)
{
    m_Featureid = value;
    m_set_State[0] |= 0x3;
}

inline
CNodeFeature_Base::TFeatureid& CNodeFeature_Base::SetFeatureid(void)
{
#ifdef _DEBUG
    if (!IsSetFeatureid()) {
        memset(&m_Featureid,UnassignedByte(),sizeof(m_Featureid));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Featureid;
}

inline
bool CNodeFeature_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CNodeFeature_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
const CNodeFeature_Base::TValue& CNodeFeature_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
void CNodeFeature_Base::SetValue(const CNodeFeature_Base::TValue& value)
{
    m_Value = value;
    m_set_State[0] |= 0xc;
}

inline
void CNodeFeature_Base::SetValue(CNodeFeature_Base::TValue&& value)
{
    m_Value = std::forward<CNodeFeature_Base::TValue>(value);
    m_set_State[0] |= 0xc;
}

inline
CNodeFeature_Base::TValue& CNodeFeature_Base::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        m_Value = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIOTREE_NODEFEATURE_BASE_HPP
